/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.common.HttpMethod;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Webhook {
    private String address;
    @JsonProperty(value="http_method")
    private HttpMethod method;

    private Webhook() {
    }

    public Webhook(String address, HttpMethod method) {
        this.address = address;
        this.method = method;
    }

    public String getAddress() {
        return this.address;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public static enum Type {
        ANSWER("answer_url"),
        EVENT("event_url"),
        INBOUND("inbound_url"),
        STATUS("status_url"),
        UNKNOWN("unknown");

        private String name;
        private static final Map<String, Type> TYPE_INDEX;

        private Type(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        @JsonCreator
        public static Type fromName(String name) {
            Type foundType = TYPE_INDEX.get(name.toLowerCase());
            return foundType != null ? foundType : UNKNOWN;
        }

        static {
            TYPE_INDEX = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                TYPE_INDEX.put(type.name, type);
            }
        }
    }
}

