/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.MD5Util;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class RequestSigning {
    public static final int MAX_ALLOWABLE_TIME_DELTA = 300000;
    public static final String PARAM_SIGNATURE = "sig";
    public static final String PARAM_TIMESTAMP = "timestamp";
    private static Log log = LogFactory.getLog(RequestSigning.class);

    public static void constructSignatureForRequestParameters(List<NameValuePair> params, String secretKey) {
        RequestSigning.constructSignatureForRequestParameters(params, secretKey, System.currentTimeMillis() / 1000L);
    }

    /*
     * WARNING - void declaration
     */
    protected static void constructSignatureForRequestParameters(List<NameValuePair> params, String secretKey, long currentTimeSeconds) {
        void var7_13;
        params.add((NameValuePair)new BasicNameValuePair(PARAM_TIMESTAMP, Long.toString(currentTimeSeconds)));
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        for (NameValuePair nameValuePair : params) {
            String string = nameValuePair.getName();
            String value = nameValuePair.getValue();
            if (string.equals(PARAM_SIGNATURE)) continue;
            if (value == null) {
                value = "";
            }
            if (value.trim().equals("")) continue;
            sortedParams.put(string, value);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : sortedParams.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            sb.append("&").append(RequestSigning.clean(name)).append("=").append(RequestSigning.clean(value));
        }
        sb.append(secretKey);
        String string = sb.toString();
        String string2 = "no signature";
        try {
            String string3 = MD5Util.calculateMd5(string);
        }
        catch (Exception e) {
            log.error((Object)"error...", (Throwable)e);
        }
        log.debug((Object)("SECURITY-KEY-GENERATION -- String [ " + string + " ] Signature [ " + (String)var7_13 + " ] "));
        params.add((NameValuePair)new BasicNameValuePair(PARAM_SIGNATURE, (String)var7_13));
    }

    public static boolean verifyRequestSignature(HttpServletRequest request, String secretKey) {
        return RequestSigning.verifyRequestSignature(request, secretKey, System.currentTimeMillis());
    }

    protected static boolean verifyRequestSignature(HttpServletRequest request, String secretKey, long currentTimeMillis) {
        String string;
        String suppliedSignature = request.getParameter(PARAM_SIGNATURE);
        if (suppliedSignature == null) {
            return false;
        }
        String timeString = request.getParameter(PARAM_TIMESTAMP);
        long time = -1L;
        try {
            if (timeString != null) {
                time = Long.parseLong(timeString) * 1000L;
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error parsing 'time' parameter [ " + timeString + " ]"), (Throwable)e);
            time = 0L;
        }
        long diff = currentTimeMillis - time;
        if (diff > 300000L || diff < -300000L) {
            log.warn((Object)("SECURITY-KEY-VERIFICATION -- BAD-TIMESTAMP ... Timestamp [ " + time + " ] delta [ " + diff + " ] max allowed delta [ " + -300000 + " ] "));
            return false;
        }
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String string2 = (String)entry.getKey();
            String value = ((String[])entry.getValue())[0];
            log.info((Object)("" + string2 + " = " + value));
            if (string2.equals(PARAM_SIGNATURE) || value == null || value.trim().equals("")) continue;
            sortedParams.put(string2, value);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : sortedParams.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            sb.append("&").append(RequestSigning.clean(name)).append("=").append(RequestSigning.clean(value));
        }
        sb.append(secretKey);
        String string3 = sb.toString();
        try {
            string = MD5Util.calculateMd5(string3);
        }
        catch (Exception e) {
            log.error((Object)"error...", (Throwable)e);
            return false;
        }
        log.info((Object)("SECURITY-KEY-VERIFICATION -- String [ " + string3 + " ] Signature [ " + string + " ] SUPPLIED SIGNATURE [ " + suppliedSignature + " ] "));
        try {
            if (!MessageDigest.isEqual(string.getBytes("UTF-8"), suppliedSignature.getBytes("UTF-8"))) {
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new VonageUnexpectedException("Failed to decode signature as UTF-8", e);
        }
        return true;
    }

    public static String clean(String str) {
        return str == null ? null : str.replaceAll("[=&]", "_");
    }
}

