/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

public class HttpConfig {
    private static final String DEFAULT_API_BASE_URI = "https://api.nexmo.com";
    private static final String DEFAULT_REST_BASE_URI = "https://rest.nexmo.com";
    private static final String DEFAULT_SNS_BASE_URI = "https://sns.nexmo.com";
    private String apiBaseUri;
    private String restBaseUri;
    private String snsBaseUri;

    private HttpConfig(Builder builder) {
        this.apiBaseUri = builder.apiBaseUri;
        this.restBaseUri = builder.restBaseUri;
        this.snsBaseUri = builder.snsBaseUri;
    }

    public String getApiBaseUri() {
        return this.apiBaseUri;
    }

    public String getRestBaseUri() {
        return this.restBaseUri;
    }

    public String getSnsBaseUri() {
        return this.snsBaseUri;
    }

    public boolean isDefaultApiBaseUri() {
        return DEFAULT_API_BASE_URI.equals(this.apiBaseUri);
    }

    public boolean isDefaultRestBaseUri() {
        return DEFAULT_REST_BASE_URI.equals(this.restBaseUri);
    }

    public boolean isDefaultSnsBaseUri() {
        return DEFAULT_SNS_BASE_URI.equals(this.snsBaseUri);
    }

    public String getVersionedApiBaseUri(String version) {
        return this.appendVersionToUri(this.apiBaseUri, version);
    }

    public String getVersionedRestBaseUri(String version) {
        return this.appendVersionToUri(this.restBaseUri, version);
    }

    public String getVersionedSnsBaseUri(String version) {
        return this.appendVersionToUri(this.snsBaseUri, version);
    }

    private String appendVersionToUri(String uri, String version) {
        return uri + "/" + version;
    }

    public static HttpConfig defaultConfig() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String apiBaseUri = "https://api.nexmo.com";
        private String restBaseUri = "https://rest.nexmo.com";
        private String snsBaseUri = "https://sns.nexmo.com";

        public Builder apiBaseUri(String apiBaseUri) {
            this.apiBaseUri = this.sanitizeUri(apiBaseUri);
            return this;
        }

        public Builder restBaseUri(String restBaseUri) {
            this.restBaseUri = this.sanitizeUri(restBaseUri);
            return this;
        }

        public Builder snsBaseUri(String snsBaseUri) {
            this.snsBaseUri = this.sanitizeUri(snsBaseUri);
            return this;
        }

        public Builder baseUri(String baseUri) {
            String sanitizedUri;
            this.apiBaseUri = sanitizedUri = this.sanitizeUri(baseUri);
            this.restBaseUri = sanitizedUri;
            this.snsBaseUri = sanitizedUri;
            return this;
        }

        public HttpConfig build() {
            return new HttpConfig(this);
        }

        private String sanitizeUri(String uri) {
            if (uri != null && uri.endsWith("/")) {
                return uri.substring(0, uri.length() - 1);
            }
            return uri;
        }
    }
}

