/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.util;

import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;

public class EncodeUtil {
    private static LZ4Factory factory = LZ4Factory.fastestInstance();

    public static byte[] lz4Decompress(byte[] data, int bodyRawSize) {
        if (data == null || data.length == 0) {
            return null;
        }
        int compressedLength = data.length;
        LZ4SafeDecompressor lz4SafeDecompressor = factory.safeDecompressor();
        byte[] restored = new byte[bodyRawSize];
        int decompressedLength = lz4SafeDecompressor.decompress(data, 0, compressedLength, restored, 0);
        byte[] result = new byte[decompressedLength];
        System.arraycopy(restored, 0, result, 0, decompressedLength);
        return result;
    }

    public static byte[] lz4Compress(byte[] data) {
        int decompressedLength = data.length;
        LZ4Compressor compressor = factory.fastCompressor();
        int maxCompressedLength = compressor.maxCompressedLength(decompressedLength);
        byte[] compressed = new byte[maxCompressedLength];
        int compressedLength = compressor.compress(data, 0, decompressedLength, compressed, 0, maxCompressedLength);
        byte[] result = new byte[compressedLength];
        System.arraycopy(compressed, 0, result, 0, compressedLength);
        return result;
    }

    public static byte[] decompress(byte[] data, int bodyRawSize, String compressType) throws Exception {
        switch (compressType) {
            case "lz4": {
                return EncodeUtil.lz4Decompress(data, bodyRawSize);
            }
            case "zlib": {
                return EncodeUtil.zlibDecompress(data);
            }
        }
        return data;
    }

    public static byte[] compressLog(byte[] body, String compressType) {
        if ("lz4".equalsIgnoreCase(compressType)) {
            return EncodeUtil.lz4Compress(body);
        }
        if ("zlib".equalsIgnoreCase(compressType)) {
            return EncodeUtil.zlibCompress(body);
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] zlibCompress(byte[] data) {
        Deflater deflater = new Deflater();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        try {
            deflater.setInput(data);
            deflater.finish();
            byte[] buffer = new byte[4096];
            while (!deflater.finished()) {
                int compressedSize = deflater.deflate(buffer);
                outputStream.write(buffer, 0, compressedSize);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            deflater.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlibDecompress(byte[] data) throws DataFormatException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        Inflater decompressor = new Inflater();
        try {
            decompressor.setInput(data);
            byte[] buf = new byte[4096];
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            decompressor.end();
        }
    }
}

