/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.stream.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.stream.CommonPo;
import com.volcengine.model.stream.log.ClickLogRequest;
import com.volcengine.model.stream.log.DislikeLogRequest;
import com.volcengine.model.stream.log.FavouriteLogRequest;
import com.volcengine.model.stream.log.FollowCardLogRequest;
import com.volcengine.model.stream.log.FollowLogRequest;
import com.volcengine.model.stream.log.LogResponse;
import com.volcengine.model.stream.log.MultiShowLogRequest;
import com.volcengine.model.stream.log.ProductClickLogRequest;
import com.volcengine.model.stream.log.ProductShowLogRequest;
import com.volcengine.model.stream.log.PushLogRequest;
import com.volcengine.model.stream.log.ShareLogRequest;
import com.volcengine.model.stream.log.SingleShowLogRequest;
import com.volcengine.model.stream.log.StayLogRequest;
import com.volcengine.model.stream.log.VerifyLogRequest;
import com.volcengine.model.stream.log.VideoOverAutoLogRequest;
import com.volcengine.model.stream.log.VideoOverDrawLogRequest;
import com.volcengine.model.stream.log.VideoOverLogRequest;
import com.volcengine.model.stream.log.VideoPlayAutoLogRequest;
import com.volcengine.model.stream.log.VideoPlayDrawLogRequest;
import com.volcengine.model.stream.log.VideoPlayLogRequest;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.stream.LogConfig;
import com.volcengine.service.stream.LogService;
import com.volcengine.service.stream.MonitorService;
import com.volcengine.service.stream.impl.MonitorServiceImpl;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;

public class LogServiceImpl
extends BaseServiceImpl
implements LogService {
    static HttpHost Mproxy;
    boolean needMonitor = true;
    private static volatile LogServiceImpl instance;

    private LogServiceImpl() {
        super(LogConfig.serviceInfo, LogConfig.apiInfoList);
    }

    private LogServiceImpl(HttpHost proxy) {
        super(LogConfig.serviceInfo, proxy, LogConfig.apiInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogService getInstance() {
        if (instance != null) return instance;
        Class<LogServiceImpl> clazz = LogServiceImpl.class;
        synchronized (LogServiceImpl.class) {
            if (instance != null) return instance;
            instance = new LogServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogService getInstance(HttpHost proxy) {
        if (instance != null) return instance;
        Class<LogServiceImpl> clazz = LogServiceImpl.class;
        synchronized (LogServiceImpl.class) {
            if (instance != null) return instance;
            instance = new LogServiceImpl(proxy);
            Mproxy = proxy;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void SetNeedMonitor(boolean open) {
        this.needMonitor = open;
    }

    @Override
    public LogResponse clickLog(ClickLogRequest clickLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(clickLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("ClickLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, clickLogRequest.getPartner(), clickLogRequest.getCategory(), clickLogRequest.getAccessToken(), "ClickLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse stayLog(StayLogRequest stayLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(stayLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("StayLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, stayLogRequest.getPartner(), stayLogRequest.getCategory(), stayLogRequest.getAccessToken(), "StayLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse videoPlayLog(VideoPlayLogRequest videoPlayLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(videoPlayLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("VideoPlayLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, videoPlayLogRequest.getPartner(), videoPlayLogRequest.getCategory(), videoPlayLogRequest.getAccessToken(), "VideoPlayLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse videoOverLog(VideoOverLogRequest videoOverLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(videoOverLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("VideoOverLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, videoOverLogRequest.getPartner(), videoOverLogRequest.getCategory(), videoOverLogRequest.getAccessToken(), "VideoOverLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse singleShowLog(SingleShowLogRequest singleShowLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(singleShowLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("SingleShowLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, singleShowLogRequest.getPartner(), singleShowLogRequest.getCategory(), singleShowLogRequest.getAccessToken(), "SingleShowLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse multiShowLog(MultiShowLogRequest multiShowLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        List<NameValuePair> nameValuePairList = Utils.mapToPairList(Utils.paramsToMap(multiShowLogRequest));
        String jsonBody = "";
        for (NameValuePair nameValuePair : nameValuePairList) {
            if (!nameValuePair.getName().equals("Body")) continue;
            jsonBody = nameValuePair.getValue();
        }
        jsonBody = "[" + URLDecoder.decode(jsonBody, "UTF-8") + "]";
        nameValuePairList.removeIf(n -> n.getName().equals("Body"));
        RawResponse response = this.json("MultiShowLog", nameValuePairList, jsonBody);
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, multiShowLogRequest.getPartner(), "", multiShowLogRequest.getAccessToken(), "MultiShowLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse shareLog(ShareLogRequest shareLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(shareLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("ShareLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, shareLogRequest.getPartner(), shareLogRequest.getCategory(), shareLogRequest.getAccessToken(), "ShareLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse favouriteLog(FavouriteLogRequest favouriteLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(favouriteLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("FavouriteLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, favouriteLogRequest.getPartner(), favouriteLogRequest.getCategory(), favouriteLogRequest.getAccessToken(), "FavouriteLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse verifyLog(VerifyLogRequest verifyLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(verifyLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("VerifyLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, verifyLogRequest.getPartner(), "", verifyLogRequest.getAccessToken(), "VerifyLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse followLog(FollowLogRequest followLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        List<NameValuePair> nameValuePairList = Utils.mapToPairList(Utils.paramsToMap(followLogRequest));
        String jsonBody = "";
        for (NameValuePair nameValuePair : nameValuePairList) {
            if (!nameValuePair.getName().equals("Body")) continue;
            jsonBody = nameValuePair.getValue();
            break;
        }
        jsonBody = URLDecoder.decode(jsonBody, "UTF-8");
        nameValuePairList.removeIf(n -> n.getName().equals("Body"));
        RawResponse response = this.json("FollowLog", nameValuePairList, jsonBody);
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, followLogRequest.getPartner(), "", followLogRequest.getAccessToken(), "FollowLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse unfollowLog(FollowLogRequest unfollowLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        List<NameValuePair> nameValuePairList = Utils.mapToPairList(Utils.paramsToMap(unfollowLogRequest));
        String jsonBody = "";
        for (NameValuePair nameValuePair : nameValuePairList) {
            if (!nameValuePair.getName().equals("Body")) continue;
            jsonBody = nameValuePair.getValue();
        }
        jsonBody = URLDecoder.decode(jsonBody, "UTF-8");
        nameValuePairList.removeIf(n -> n.getName().equals("Body"));
        RawResponse response = this.json("UnfollowLog", nameValuePairList, jsonBody);
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, unfollowLogRequest.getPartner(), "", unfollowLogRequest.getAccessToken(), "UnfollowLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse followCardLog(FollowCardLogRequest followCardLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        List<NameValuePair> nameValuePairList = Utils.mapToPairList(Utils.paramsToMap(followCardLogRequest));
        String jsonBody = "";
        for (NameValuePair nameValuePair : nameValuePairList) {
            if (!nameValuePair.getName().equals("Body")) continue;
            jsonBody = nameValuePair.getValue();
        }
        jsonBody = URLDecoder.decode(jsonBody, "UTF-8");
        nameValuePairList.removeIf(n -> n.getName().equals("Body"));
        RawResponse response = this.json("FollowCardLog", nameValuePairList, jsonBody);
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, followCardLogRequest.getPartner(), "", followCardLogRequest.getAccessToken(), "FollowCardLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse dislikeLog(DislikeLogRequest dislikeLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        List<NameValuePair> nameValuePairList = Utils.mapToPairList(Utils.paramsToMap(dislikeLogRequest));
        String jsonBody = "";
        for (NameValuePair nameValuePair : nameValuePairList) {
            if (!nameValuePair.getName().equals("Body")) continue;
            jsonBody = nameValuePair.getValue();
            break;
        }
        jsonBody = "[" + URLDecoder.decode(jsonBody, "UTF-8") + "]";
        nameValuePairList.removeIf(n -> n.getName().equals("Body"));
        RawResponse response = this.json("DislikeLog", nameValuePairList, jsonBody);
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, dislikeLogRequest.getPartner(), "", dislikeLogRequest.getAccessToken(), "DislikeLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse videoPlayDrawLog(VideoPlayDrawLogRequest videoPlayDrawLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(videoPlayDrawLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("VideoPlayDrawLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, videoPlayDrawLogRequest.getPartner(), videoPlayDrawLogRequest.getCategory(), videoPlayDrawLogRequest.getAccessToken(), "VideoPlayDrawLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse videoOverDrawLog(VideoOverDrawLogRequest videoOverDrawLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(videoOverDrawLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("VideoOverDrawLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, videoOverDrawLogRequest.getPartner(), videoOverDrawLogRequest.getCategory(), videoOverDrawLogRequest.getAccessToken(), "VideoOverDrawLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse productShowLog(ProductShowLogRequest productShowLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(productShowLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("ProductShowLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, productShowLogRequest.getPartner(), productShowLogRequest.getCategory(), productShowLogRequest.getAccessToken(), "ProductShowLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse pushLog(PushLogRequest pushLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(pushLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("PushLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, pushLogRequest.getPartner(), pushLogRequest.getCategory(), pushLogRequest.getAccessToken(), "PushLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse productClickLog(ProductClickLogRequest productClickLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(productClickLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("ProductClickLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, productClickLogRequest.getPartner(), productClickLogRequest.getCategory(), productClickLogRequest.getAccessToken(), "ProductClickLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse videoPlayAutoLog(VideoPlayAutoLogRequest videoPlayAutoLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(videoPlayAutoLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("VideoPlayAutoLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, videoPlayAutoLogRequest.getPartner(), videoPlayAutoLogRequest.getCategory(), videoPlayAutoLogRequest.getAccessToken(), "VideoPlayAutoLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LogResponse videoOverAutoLog(VideoOverAutoLogRequest videoOverAutoLogRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(videoOverAutoLogRequest);
        Map<String, String> paramsMap = this.paramsFilter(requestMap);
        RawResponse response = this.post("VideoOverAutoLog", Utils.mapToPairList(requestMap), Utils.mapToPairList(paramsMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, videoOverAutoLogRequest.getPartner(), videoOverAutoLogRequest.getCategory(), videoOverAutoLogRequest.getAccessToken(), "VideoOverAutoLog", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LogResponse)JSON.parseObject((byte[])response.getData(), LogResponse.class, (Feature[])new Feature[0]);
    }

    private Map<String, String> paramsFilter(Map<String, String> requestMap) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (String s : requestMap.keySet()) {
            paramsMap.put(s, requestMap.get(s));
        }
        paramsMap.remove("Timestamp");
        paramsMap.remove("Partner");
        paramsMap.remove("AccessToken");
        return paramsMap;
    }

    private LogResponse GenNoReqIdResponse(String action) {
        CommonPo.ResponseMetadata.Error error = new CommonPo.ResponseMetadata.Error();
        error.setCode("params invalid");
        error.setCodeN(22L);
        error.setMessage("need reqId.");
        CommonPo.ResponseMetadata responseMetadata = new CommonPo.ResponseMetadata();
        responseMetadata.setAction(action);
        responseMetadata.setRegion("cn-north-1");
        responseMetadata.setRequestId("");
        responseMetadata.setService("content");
        responseMetadata.setVersion("2021-01-01");
        responseMetadata.setError(error);
        LogResponse logResponse = new LogResponse();
        logResponse.setResponseMetadata(responseMetadata);
        return logResponse;
    }

    private void sendToMonitor(LogService logService, String partner, String category, String accessToken, String action, int httpCode, int topRespCode, byte[] respData, long latency) {
        if (this.needMonitor) {
            MonitorService monitorService = MonitorServiceImpl.getInstance(logService.getAccessKey(), logService.getSecretKey(), Mproxy);
            monitorService.monitor(partner, category, accessToken, action, httpCode, topRespCode, respData, latency);
        }
    }

    static {
        instance = null;
    }
}

