/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.tls.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.volcengine.model.tls.FullTextInfo;
import com.volcengine.model.tls.KeyValueInfo;
import com.volcengine.model.tls.ValueInfo;
import com.volcengine.model.tls.exception.LogException;
import com.volcengine.model.tls.response.CommonResponse;
import com.volcengine.model.tls.util.StringUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;

public class DescribeIndexResponse
extends CommonResponse {
    @JSONField(name="TopicId")
    String topicId;
    @JSONField(name="FullText")
    FullTextInfo fullTextInfo;
    @JSONField(name="KeyValue")
    List<KeyValueInfo> keyValue;
    @JSONField(name="CreateTime")
    String createTime;
    @JSONField(name="ModifyTime")
    String modifyTime;

    public DescribeIndexResponse(Header[] headers) {
        super(headers);
    }

    @Override
    public DescribeIndexResponse deSerialize(byte[] data, Class clazz) throws LogException {
        DescribeIndexResponse response = (DescribeIndexResponse)super.deSerialize(data, clazz);
        this.setTopicId(response.getTopicId());
        FullTextInfo fullTextInfo = response.getFullTextInfo();
        if (fullTextInfo != null && StringUtils.isNotEmpty((CharSequence)fullTextInfo.getDelimiter())) {
            String delimiter = fullTextInfo.getDelimiter();
            fullTextInfo.setDelimiter(StringUtil.replaceWhiteSpaceCharacter(delimiter));
        }
        this.setFullTextInfo(fullTextInfo);
        List<KeyValueInfo> keyValue = response.getKeyValue();
        if (keyValue != null && keyValue.size() > 0) {
            for (KeyValueInfo kv : keyValue) {
                ValueInfo value = kv.getValue();
                if (value == null || !StringUtils.isNotEmpty((CharSequence)value.getDelimiter())) continue;
                String delimiter = value.getDelimiter();
                value.setDelimiter(StringUtil.replaceWhiteSpaceCharacter(delimiter));
            }
        }
        this.setKeyValue(keyValue);
        this.setCreateTime(response.getCreateTime());
        this.setModifyTime(response.getModifyTime());
        return this;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public FullTextInfo getFullTextInfo() {
        return this.fullTextInfo;
    }

    public List<KeyValueInfo> getKeyValue() {
        return this.keyValue;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getModifyTime() {
        return this.modifyTime;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public void setFullTextInfo(FullTextInfo fullTextInfo) {
        this.fullTextInfo = fullTextInfo;
    }

    public void setKeyValue(List<KeyValueInfo> keyValue) {
        this.keyValue = keyValue;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(String modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DescribeIndexResponse)) {
            return false;
        }
        DescribeIndexResponse other = (DescribeIndexResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$topicId = this.getTopicId();
        String other$topicId = other.getTopicId();
        if (this$topicId == null ? other$topicId != null : !this$topicId.equals(other$topicId)) {
            return false;
        }
        FullTextInfo this$fullTextInfo = this.getFullTextInfo();
        FullTextInfo other$fullTextInfo = other.getFullTextInfo();
        if (this$fullTextInfo == null ? other$fullTextInfo != null : !((Object)this$fullTextInfo).equals(other$fullTextInfo)) {
            return false;
        }
        List<KeyValueInfo> this$keyValue = this.getKeyValue();
        List<KeyValueInfo> other$keyValue = other.getKeyValue();
        if (this$keyValue == null ? other$keyValue != null : !((Object)this$keyValue).equals(other$keyValue)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$modifyTime = this.getModifyTime();
        String other$modifyTime = other.getModifyTime();
        return !(this$modifyTime == null ? other$modifyTime != null : !this$modifyTime.equals(other$modifyTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DescribeIndexResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $topicId = this.getTopicId();
        result = result * 59 + ($topicId == null ? 43 : $topicId.hashCode());
        FullTextInfo $fullTextInfo = this.getFullTextInfo();
        result = result * 59 + ($fullTextInfo == null ? 43 : ((Object)$fullTextInfo).hashCode());
        List<KeyValueInfo> $keyValue = this.getKeyValue();
        result = result * 59 + ($keyValue == null ? 43 : ((Object)$keyValue).hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : $modifyTime.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DescribeIndexResponse(super=" + super.toString() + ", topicId=" + this.getTopicId() + ", fullTextInfo=" + this.getFullTextInfo() + ", keyValue=" + this.getKeyValue() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ")";
    }

    public DescribeIndexResponse() {
    }
}

