/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.maas.v2.impl.audio;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.volcengine.model.maas.api.v2.SpeechReq;
import com.volcengine.service.maas.MaasException;
import com.volcengine.service.maas.response.BinaryResponseContent;
import com.volcengine.service.maas.v2.impl.MaasServiceImpl;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;

public class Speech {
    private MaasServiceImpl service;

    public Speech(MaasServiceImpl service) {
        this.service = service;
    }

    public BinaryResponseContent create(String endpointId, SpeechReq req) throws MaasException {
        InputStream is;
        HttpResponse response;
        String logId = "";
        String apikey = this.service.getApikey();
        try {
            response = this.service.jsonWithHttpResponse(endpointId, "audio.speech", new ObjectMapper().writeValueAsString((Object)req), apikey);
            logId = response.getFirstHeader("x-tt-logid").getValue();
        }
        catch (Exception e) {
            throw new MaasException(e, logId);
        }
        try {
            is = response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new MaasException(e, logId);
        }
        return new BinaryResponseContent(is, logId);
    }
}

