/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.tls.producer;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Iterables;
import com.volcengine.model.tls.pb.PutLogRequest;
import com.volcengine.model.tls.producer.Attempt;
import com.volcengine.model.tls.producer.CallBack;
import com.volcengine.model.tls.producer.ProducerConfig;
import com.volcengine.model.tls.producer.Result;
import com.volcengine.service.tls.RetryManager;
import com.volcengine.service.tls.SendBatchTask;
import com.volcengine.service.tls.TLSLogClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchLog
implements Delayed {
    BatchKey batchKey;
    int currentBatchSize;
    int currentBatchCount;
    List<CallBack> callBackList = new ArrayList<CallBack>();
    PutLogRequest.LogGroupList logGroupList = PutLogRequest.LogGroupList.newBuilder().build();
    ProducerConfig producerConfig;
    EvictingQueue<Attempt> reservedAttempts;
    int attemptCount;
    long createMs;
    long nextRetryMs;
    private static final Log LOG = LogFactory.getLog(BatchLog.class);

    private BatchLog() {
    }

    public BatchLog(BatchKey batchKey, ProducerConfig producerConfig) {
        this.batchKey = batchKey;
        this.currentBatchSize = 0;
        this.currentBatchCount = 0;
        this.producerConfig = producerConfig;
        this.attemptCount = 0;
        this.reservedAttempts = EvictingQueue.create((int)producerConfig.getMaxReservedAttempts());
        this.createMs = System.currentTimeMillis();
    }

    public boolean tryAdd(PutLogRequest.LogGroup logGroup, int batchSize, CallBack callBack) {
        int currentBatchCount = this.getCurrentBatchCount();
        int currentBatchSize = this.getCurrentBatchSize();
        if (logGroup.getLogsList().size() + currentBatchCount > 40960 || batchSize + currentBatchSize > 0xA00000) {
            return false;
        }
        PutLogRequest.LogGroupList.Builder builder = PutLogRequest.LogGroupList.newBuilder().addLogGroups(logGroup);
        if (this.logGroupList.getLogGroupsList().size() > 0) {
            builder.addAllLogGroups(this.logGroupList.getLogGroupsList());
        }
        this.logGroupList = builder.build();
        if (callBack != null) {
            this.getCallBackList().add(callBack);
        }
        this.setCurrentBatchCount(currentBatchCount + logGroup.getLogsList().size());
        this.setCurrentBatchSize(currentBatchSize + batchSize);
        return true;
    }

    public boolean fullAndSendBatchRequest() {
        return this.currentBatchCount >= this.producerConfig.getMaxBatchCount() || this.currentBatchSize >= this.producerConfig.getMaxBatchSizeBytes();
    }

    public synchronized void addAttempt(Attempt attempt) {
        this.reservedAttempts.add((Object)attempt);
        ++this.attemptCount;
    }

    public synchronized void fireCallbacks() {
        ArrayList<Attempt> attempts = new ArrayList<Attempt>((Collection<Attempt>)this.reservedAttempts);
        if (attempts.size() == 0) {
            LOG.error((Object)String.format("batch log %s fire call back failed ", this.batchKey.toString()));
            return;
        }
        Attempt attempt = (Attempt)Iterables.getLast(attempts);
        Result result = new Result(attempt.isSuccess(), attempts, this.attemptCount);
        this.fireCallbacks(result);
    }

    private void fireCallbacks(Result result) {
        for (CallBack callBack : this.callBackList) {
            callBack.onComplete(result);
        }
    }

    @Override
    public int compareTo(@Nonnull Delayed o) {
        return (int)(this.nextRetryMs - ((BatchLog)o).getNextRetryMs());
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.nextRetryMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "BatchLog{batchKey=" + this.batchKey + ", currentBatchSize=" + this.currentBatchSize + ", currentBatchCount=" + this.currentBatchCount + ", reservedAttempts=" + this.reservedAttempts + ", attemptCount=" + this.attemptCount + ", createMs=" + this.createMs + '}';
    }

    public BatchKey getBatchKey() {
        return this.batchKey;
    }

    public int getCurrentBatchSize() {
        return this.currentBatchSize;
    }

    public int getCurrentBatchCount() {
        return this.currentBatchCount;
    }

    public List<CallBack> getCallBackList() {
        return this.callBackList;
    }

    public PutLogRequest.LogGroupList getLogGroupList() {
        return this.logGroupList;
    }

    public ProducerConfig getProducerConfig() {
        return this.producerConfig;
    }

    public EvictingQueue<Attempt> getReservedAttempts() {
        return this.reservedAttempts;
    }

    public int getAttemptCount() {
        return this.attemptCount;
    }

    public long getCreateMs() {
        return this.createMs;
    }

    public long getNextRetryMs() {
        return this.nextRetryMs;
    }

    public void setBatchKey(BatchKey batchKey) {
        this.batchKey = batchKey;
    }

    public void setCurrentBatchSize(int currentBatchSize) {
        this.currentBatchSize = currentBatchSize;
    }

    public void setCurrentBatchCount(int currentBatchCount) {
        this.currentBatchCount = currentBatchCount;
    }

    public void setCallBackList(List<CallBack> callBackList) {
        this.callBackList = callBackList;
    }

    public void setLogGroupList(PutLogRequest.LogGroupList logGroupList) {
        this.logGroupList = logGroupList;
    }

    public void setProducerConfig(ProducerConfig producerConfig) {
        this.producerConfig = producerConfig;
    }

    public void setReservedAttempts(EvictingQueue<Attempt> reservedAttempts) {
        this.reservedAttempts = reservedAttempts;
    }

    public void setAttemptCount(int attemptCount) {
        this.attemptCount = attemptCount;
    }

    public void setCreateMs(long createMs) {
        this.createMs = createMs;
    }

    public void setNextRetryMs(long nextRetryMs) {
        this.nextRetryMs = nextRetryMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchLog)) {
            return false;
        }
        BatchLog other = (BatchLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentBatchSize() != other.getCurrentBatchSize()) {
            return false;
        }
        if (this.getCurrentBatchCount() != other.getCurrentBatchCount()) {
            return false;
        }
        if (this.getAttemptCount() != other.getAttemptCount()) {
            return false;
        }
        if (this.getCreateMs() != other.getCreateMs()) {
            return false;
        }
        if (this.getNextRetryMs() != other.getNextRetryMs()) {
            return false;
        }
        BatchKey this$batchKey = this.getBatchKey();
        BatchKey other$batchKey = other.getBatchKey();
        if (this$batchKey == null ? other$batchKey != null : !((Object)this$batchKey).equals(other$batchKey)) {
            return false;
        }
        List<CallBack> this$callBackList = this.getCallBackList();
        List<CallBack> other$callBackList = other.getCallBackList();
        if (this$callBackList == null ? other$callBackList != null : !((Object)this$callBackList).equals(other$callBackList)) {
            return false;
        }
        PutLogRequest.LogGroupList this$logGroupList = this.getLogGroupList();
        PutLogRequest.LogGroupList other$logGroupList = other.getLogGroupList();
        if (this$logGroupList == null ? other$logGroupList != null : !((Object)this$logGroupList).equals(other$logGroupList)) {
            return false;
        }
        ProducerConfig this$producerConfig = this.getProducerConfig();
        ProducerConfig other$producerConfig = other.getProducerConfig();
        if (this$producerConfig == null ? other$producerConfig != null : !this$producerConfig.equals(other$producerConfig)) {
            return false;
        }
        EvictingQueue<Attempt> this$reservedAttempts = this.getReservedAttempts();
        EvictingQueue<Attempt> other$reservedAttempts = other.getReservedAttempts();
        return !(this$reservedAttempts == null ? other$reservedAttempts != null : !this$reservedAttempts.equals(other$reservedAttempts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BatchLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrentBatchSize();
        result = result * 59 + this.getCurrentBatchCount();
        result = result * 59 + this.getAttemptCount();
        long $createMs = this.getCreateMs();
        result = result * 59 + (int)($createMs >>> 32 ^ $createMs);
        long $nextRetryMs = this.getNextRetryMs();
        result = result * 59 + (int)($nextRetryMs >>> 32 ^ $nextRetryMs);
        BatchKey $batchKey = this.getBatchKey();
        result = result * 59 + ($batchKey == null ? 43 : ((Object)$batchKey).hashCode());
        List<CallBack> $callBackList = this.getCallBackList();
        result = result * 59 + ($callBackList == null ? 43 : ((Object)$callBackList).hashCode());
        PutLogRequest.LogGroupList $logGroupList = this.getLogGroupList();
        result = result * 59 + ($logGroupList == null ? 43 : ((Object)$logGroupList).hashCode());
        ProducerConfig $producerConfig = this.getProducerConfig();
        result = result * 59 + ($producerConfig == null ? 43 : $producerConfig.hashCode());
        EvictingQueue<Attempt> $reservedAttempts = this.getReservedAttempts();
        result = result * 59 + ($reservedAttempts == null ? 43 : $reservedAttempts.hashCode());
        return result;
    }

    public static class BatchManager {
        BatchLog batchLog;

        public boolean fullAndSendBatchRequest() {
            return this.batchLog.fullAndSendBatchRequest();
        }

        public void addNow(ProducerConfig config, ExecutorService executorService, TLSLogClient client, BlockingQueue<BatchLog> successQueue, BlockingQueue<BatchLog> failureQueue, AtomicInteger batchCount, RetryManager retryManager) {
            if (this.batchLog != null) {
                executorService.submit(new SendBatchTask(this.batchLog, config, successQueue, failureQueue, client, retryManager));
                this.batchLog = null;
            }
        }

        public void removeBatch(List<BatchLog> batchLogs) {
            if (this.batchLog != null) {
                batchLogs.add(this.batchLog);
                this.batchLog = null;
            }
        }

        public BatchLog getBatchLog() {
            return this.batchLog;
        }

        public void setBatchLog(BatchLog batchLog) {
            this.batchLog = batchLog;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchManager)) {
                return false;
            }
            BatchManager other = (BatchManager)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BatchLog this$batchLog = this.getBatchLog();
            BatchLog other$batchLog = other.getBatchLog();
            return !(this$batchLog == null ? other$batchLog != null : !((Object)this$batchLog).equals(other$batchLog));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BatchManager;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BatchLog $batchLog = this.getBatchLog();
            result = result * 59 + ($batchLog == null ? 43 : ((Object)$batchLog).hashCode());
            return result;
        }

        public String toString() {
            return "BatchLog.BatchManager(batchLog=" + this.getBatchLog() + ")";
        }
    }

    public static class BatchKey {
        String shardHash;
        String topicId;
        String source;
        String fileName;

        public BatchKey(String shardHash, String topicId, String source, String fileName) {
            this.shardHash = shardHash;
            this.topicId = topicId;
            this.source = source;
            this.fileName = fileName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BatchKey batchKey = (BatchKey)o;
            return Objects.equals(this.shardHash, batchKey.shardHash) && Objects.equals(this.topicId, batchKey.topicId) && Objects.equals(this.source, batchKey.source) && Objects.equals(this.fileName, batchKey.fileName);
        }

        public int hashCode() {
            return Objects.hash(this.shardHash, this.topicId, this.source, this.fileName);
        }

        public String getShardHash() {
            return this.shardHash;
        }

        public String getTopicId() {
            return this.topicId;
        }

        public String getSource() {
            return this.source;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setShardHash(String shardHash) {
            this.shardHash = shardHash;
        }

        public void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String toString() {
            return "BatchLog.BatchKey(shardHash=" + this.getShardHash() + ", topicId=" + this.getTopicId() + ", source=" + this.getSource() + ", fileName=" + this.getFileName() + ")";
        }
    }
}

