/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.ui;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class UiService
extends StatelessService {
    public static final String SELF_LINK = "/core/ui/default";

    public UiService() {
        this.toggleOption(Service.ServiceOption.HTML_USER_INTERFACE, true);
    }

    public void handleGet(Operation get) {
        String uriPath = get.getUri().getPath();
        String uriPrefixPath = Utils.buildUiResourceUriPrefixPath((Service)this);
        if (uriPath.equals(SELF_LINK)) {
            try {
                this.redirectGetToTrailingSlash(get, SELF_LINK);
                return;
            }
            catch (UnsupportedEncodingException e) {
                get.fail((Throwable)e);
                return;
            }
        }
        if (uriPath.equals("/core/ui/default/")) {
            this.proxyGetToCustomHtmlUiResource(get, uriPrefixPath + "/" + "index.html");
            return;
        }
        uriPath = uriPath.substring(SELF_LINK.length());
        this.proxyGetToCustomHtmlUiResource(get, uriPrefixPath + uriPath);
    }

    public void proxyGetToCustomHtmlUiResource(Operation op, String htmlResourcePath) {
        Operation get = op.clone();
        get.setUri(UriUtils.buildUri((ServiceHost)this.getHost(), (String)htmlResourcePath)).setReferer(op.getReferer()).setCompletion((o, e) -> op.setBody(o.getBodyRaw()).setContentType(o.getContentType()).complete());
        this.getHost().sendRequest(get);
    }

    private void redirectGetToTrailingSlash(Operation op, String folderPath) throws UnsupportedEncodingException {
        op.addResponseHeader("location", URLDecoder.decode(folderPath + "/", "UTF-8"));
        op.setStatusCode(302);
        op.setContentType("text/html");
        op.complete();
    }
}

