/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.services.common.AuthorizationCacheUtils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;

public class UserGroupService
extends StatefulService {
    public static final String FACTORY_LINK = ServiceUriPaths.CORE_AUTHZ_USER_GROUPS;

    public static Service createFactory() {
        FactoryService fs = new FactoryService(UserGroupState.class){

            @Override
            public Service createServiceInstance() throws Throwable {
                return new UserGroupService();
            }

            @Override
            public void handlePost(Operation request) {
                UserGroupService.checkAndNestCompletionForAuthzCacheClear(this, request);
                super.handlePost(request);
            }
        };
        fs.toggleOption(Service.ServiceOption.IDEMPOTENT_POST, true);
        return fs;
    }

    private static void checkAndNestCompletionForAuthzCacheClear(Service s, Operation op) {
        UserGroupState state;
        if (AuthorizationCacheUtils.isAuthzCacheClearApplicableOperation(op) && (state = AuthorizationCacheUtils.extractBody(op, s, UserGroupState.class)) != null) {
            AuthorizationCacheUtils.clearAuthzCacheForUserGroup(s, op, state);
        }
    }

    public UserGroupService() {
        super(UserGroupState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void processCompletionStageUpdateAuthzArtifacts(Operation op) {
        UserGroupService.checkAndNestCompletionForAuthzCacheClear(this, op);
        op.complete();
    }

    @Override
    public void setProcessingStage(Service.ProcessingStage stage) {
        super.setProcessingStage(stage);
    }

    @Override
    public void handleStart(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        UserGroupState newState = op.getBody(UserGroupState.class);
        if (!this.validate(op, newState)) {
            return;
        }
        op.complete();
    }

    @Override
    public void handlePut(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        UserGroupState newState = op.getBody(UserGroupState.class);
        if (!this.validate(op, newState)) {
            return;
        }
        UserGroupState currentState = (UserGroupState)this.getState(op);
        ServiceDocumentDescription documentDescription = this.getStateDescription();
        if (ServiceDocument.equals(documentDescription, currentState, newState)) {
            op.addPragmaDirective("xn-state-not-modified");
        }
        this.setState(op, newState);
        op.complete();
    }

    private boolean validate(Operation op, UserGroupState state) {
        if (state.query == null) {
            op.fail(new IllegalArgumentException("query is required"));
            return false;
        }
        return true;
    }

    public static class UserGroupState
    extends ServiceDocument {
        public QueryTask.Query query;

        public static class Builder {
            private UserGroupState userGroupState = new UserGroupState();

            private Builder() {
            }

            public static Builder create() {
                return new Builder();
            }

            public Builder withQuery(QueryTask.Query query) {
                this.userGroupState.query = query;
                return this;
            }

            public Builder withSelfLink(String userGroupSelfLink) {
                this.userGroupState.documentSelfLink = userGroupSelfLink;
                return this;
            }

            public UserGroupState build() {
                return this.userGroupState;
            }
        }
    }
}

