/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupBroadcastResponse;
import com.vmware.xenon.services.common.QueryTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class QueryTaskUtils {
    private static final int MAX_NEST_LEVEL_EXPAND_PROPERTY = 2;

    private QueryTaskUtils() {
    }

    private static void mergeCountQueries(List<ServiceDocumentQueryResult> dataSources, ServiceDocumentQueryResult result) {
        long highestCount = 0L;
        for (int i = 0; i < dataSources.size(); ++i) {
            ServiceDocumentQueryResult dataSource = dataSources.get(i);
            if (dataSource.documentLinks != null && !dataSource.documentLinks.isEmpty() || dataSource.documents != null && !dataSource.documents.isEmpty() || dataSource.documentCount == null || dataSource.documentCount <= 0L || highestCount >= dataSource.documentCount) continue;
            highestCount = dataSource.documentCount;
        }
        result.documentCount = highestCount;
        result.documentLinks = Collections.emptyList();
    }

    public static void processQueryResults(ServiceHost host, List<ServiceDocumentQueryResult> dataSources, boolean isAscOrder, EnumSet<QueryTask.QuerySpecification.QueryOption> queryOptions, NodeGroupBroadcastResponse nodeGroupResponse, ServiceDocumentQueryResult result, BiConsumer<ServiceDocumentQueryResult, Throwable> onCompletion) {
        if (queryOptions != null && queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.READ_AFTER_WRITE_CONSISTENCY)) {
            QueryTaskUtils.mergeForReadAfterWriteConsistency(host, dataSources, isAscOrder, queryOptions, nodeGroupResponse, result, onCompletion);
        } else {
            QueryTaskUtils.mergeQueryResults(dataSources, isAscOrder, queryOptions, result);
            onCompletion.accept(result, null);
        }
    }

    public static void mergeQueryResults(List<ServiceDocumentQueryResult> dataSources, boolean isAscOrder, ServiceDocumentQueryResult result) {
        QueryTaskUtils.mergeQueryResults(dataSources, isAscOrder, EnumSet.noneOf(QueryTask.QuerySpecification.QueryOption.class), result);
    }

    public static void mergeQueryResults(List<ServiceDocumentQueryResult> dataSources, boolean isAscOrder, EnumSet<QueryTask.QuerySpecification.QueryOption> queryOptions, ServiceDocumentQueryResult result) {
        result.documents = new HashMap<String, Object>();
        result.documentCount = 0L;
        if (queryOptions != null && queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
            QueryTaskUtils.mergeCountQueries(dataSources, result);
            return;
        }
        int[] indices = new int[dataSources.size()];
        block0: while (true) {
            String documentLinkPicked = null;
            ArrayList<Integer> sourcesPicked = new ArrayList<Integer>();
            for (int i = 0; i < dataSources.size(); ++i) {
                if ((long)indices[i] >= dataSources.get((int)i).documentCount || dataSources.get((int)i).documentLinks.isEmpty()) continue;
                String documentLink = dataSources.get((int)i).documentLinks.get(indices[i]);
                if (documentLinkPicked == null) {
                    documentLinkPicked = documentLink;
                    sourcesPicked.add(i);
                    continue;
                }
                if (isAscOrder && documentLink.compareTo(documentLinkPicked) < 0 || !isAscOrder && documentLink.compareTo(documentLinkPicked) > 0) {
                    documentLinkPicked = documentLink;
                    sourcesPicked.clear();
                    sourcesPicked.add(i);
                    continue;
                }
                if (!documentLink.equals(documentLinkPicked)) continue;
                sourcesPicked.add(i);
            }
            if (documentLinkPicked == null) break;
            result.documentLinks.add(documentLinkPicked);
            ServiceDocumentQueryResult partialResult = dataSources.get((Integer)sourcesPicked.get(0));
            if (partialResult.documents != null) {
                result.documents.put(documentLinkPicked, partialResult.documents.get(documentLinkPicked));
            }
            Object object = result;
            Long l = ((ServiceDocumentQueryResult)object).documentCount;
            Long l2 = ((ServiceDocumentQueryResult)object).documentCount = Long.valueOf(((ServiceDocumentQueryResult)object).documentCount + 1L);
            object = sourcesPicked.iterator();
            while (true) {
                int i;
                if (!object.hasNext()) continue block0;
                int n = i = ((Integer)object.next()).intValue();
                indices[n] = indices[n] + 1;
            }
            break;
        }
    }

    private static void mergeForReadAfterWriteConsistency(ServiceHost host, List<ServiceDocumentQueryResult> dataSources, boolean isAscOrder, EnumSet<QueryTask.QuerySpecification.QueryOption> queryOptions, NodeGroupBroadcastResponse nodeGroupResponse, ServiceDocumentQueryResult returnResult, BiConsumer<ServiceDocumentQueryResult, Throwable> onCompletion) {
        if (nodeGroupResponse.membershipQuorum < nodeGroupResponse.nodeCount / 2L + 1L) {
            onCompletion.accept(null, new IllegalStateException("Membership quorum value should be  a majority of the number of nodes"));
            return;
        }
        HashMap<String, Integer> linkToCountMap = new HashMap<String, Integer>();
        class VersionObjectPair {
            Long version;
            Object object;

            VersionObjectPair(Long version, Object object) {
                this.version = version;
                this.object = object;
            }
        }
        HashMap<String, VersionObjectPair> linkToVersionObjectMap = new HashMap<String, VersionObjectPair>();
        for (int i = 0; i < dataSources.size(); ++i) {
            ServiceDocumentQueryResult partialResult = dataSources.get(i);
            for (Object object : partialResult.documents.values()) {
                ServiceDocument jsonObject = Utils.fromJson(object, ServiceDocument.class);
                linkToCountMap.compute(jsonObject.documentSelfLink, (k, v) -> v == null ? Integer.valueOf(1) : v + 1);
                linkToVersionObjectMap.compute(jsonObject.documentSelfLink, (k, v) -> {
                    if (v == null) {
                        return new VersionObjectPair(jsonObject.documentVersion, entry);
                    }
                    if ((long)v.version.intValue() < jsonObject.documentVersion) {
                        return new VersionObjectPair(jsonObject.documentVersion, entry);
                    }
                    return v;
                });
            }
        }
        HashSet getLinks = new HashSet();
        HashMap<String, Object> documents = new HashMap<String, Object>();
        for (Map.Entry entry : linkToCountMap.entrySet()) {
            if ((long)((Integer)entry.getValue()).intValue() >= nodeGroupResponse.membershipQuorum) {
                documents.put((String)entry.getKey(), ((VersionObjectPair)linkToVersionObjectMap.get(entry.getKey())).object);
                continue;
            }
            getLinks.add(entry.getKey());
        }
        ArrayList<Operation> getOps = new ArrayList<Operation>();
        getLinks.forEach(link -> getOps.add(Operation.createGet(UriUtils.buildUri(host, link)).setReferer(host.getUri())));
        if (getOps.size() == 0) {
            onCompletion.accept(QueryTaskUtils.populateResultObject(documents, queryOptions, returnResult, isAscOrder), null);
            return;
        }
        OperationJoin.create(getOps).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                onCompletion.accept((ServiceDocumentQueryResult)null, (Throwable)ts.values().iterator().next());
                return;
            }
            for (Operation getOp : os.values()) {
                Object rawObject = getOp.getBodyRaw();
                ServiceDocument jsonObject = Utils.fromJson(rawObject, ServiceDocument.class);
                documents.put(jsonObject.documentSelfLink, rawObject);
            }
            onCompletion.accept(QueryTaskUtils.populateResultObject(documents, queryOptions, returnResult, isAscOrder), null);
        }).sendWith(host);
    }

    private static ServiceDocumentQueryResult populateResultObject(Map<String, Object> documents, EnumSet<QueryTask.QuerySpecification.QueryOption> queryOptions, ServiceDocumentQueryResult returnResult, boolean isAscOrder) {
        ArrayList<String> documentLinks = new ArrayList<String>(documents.keySet());
        Collections.sort(documentLinks, isAscOrder ? null : Collections.reverseOrder());
        returnResult.documentLinks = documentLinks;
        returnResult.documentCount = documentLinks.size();
        if (queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
            returnResult.documents = documents;
        }
        return returnResult;
    }

    public static void expandLinks(ServiceHost host, QueryTask task, Operation op) {
        ServiceDocumentQueryResult result = task.results;
        if (!task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_LINKS) || result == null || result.selectedLinksPerDocument == null || result.selectedLinksPerDocument.isEmpty()) {
            op.setBodyNoCloning(task).complete();
            return;
        }
        ConcurrentSkipListMap<String, String> uniqueLinkToState = new ConcurrentSkipListMap<String, String>();
        for (Map<String, String> selectedLinksPerDocument : result.selectedLinksPerDocument.values()) {
            for (Map.Entry<String, String> en : selectedLinksPerDocument.entrySet()) {
                uniqueLinkToState.put(en.getValue(), "");
            }
        }
        if (uniqueLinkToState.isEmpty()) {
            op.setBodyNoCloning(task).complete();
            return;
        }
        AtomicInteger remaining = new AtomicInteger(uniqueLinkToState.size());
        Operation.CompletionHandler c = (o, e) -> {
            String link = o.getUri().getPath();
            if (e != null) {
                host.log(Level.WARNING, "Failure retrieving link %s: %s", link, e.toString());
            }
            Object body = o.getBodyRaw();
            uniqueLinkToState.put(link, (String)body);
            int r = remaining.decrementAndGet();
            if (r != 0) {
                return;
            }
            result.selectedDocuments = uniqueLinkToState;
            op.setBodyNoCloning(task).complete();
        };
        for (String link : uniqueLinkToState.keySet()) {
            Operation get = Operation.createGet(UriUtils.buildUri(op.getUri(), link)).setCompletion(c).transferRefererFrom(op);
            host.sendRequest(get);
        }
    }

    public static Set<String> getExpandedQueryPropertyNames(ServiceDocumentDescription description) {
        if (description == null) {
            throw new IllegalArgumentException("description is required");
        }
        return QueryTaskUtils.getExpandedQueryPropertyNames(description.propertyDescriptions, 2);
    }

    private static Set<String> getExpandedQueryPropertyNames(Map<String, ServiceDocumentDescription.PropertyDescription> propertyDescriptions, int complexFieldNestLevel) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, ServiceDocumentDescription.PropertyDescription> entry : propertyDescriptions.entrySet()) {
            result.addAll(QueryTaskUtils.getExpandedQueryPropertyNames(entry.getKey(), entry.getValue(), complexFieldNestLevel));
        }
        return result;
    }

    private static Set<String> getExpandedQueryPropertyNames(String propertyName, ServiceDocumentDescription.PropertyDescription pd, int complexFieldNestLevel) {
        if (pd.indexingOptions != null && pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.STORE_ONLY) || pd.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.INFRASTRUCTURE)) {
            return Collections.emptySet();
        }
        if (pd.typeName == ServiceDocumentDescription.TypeName.PODO && pd.fieldDescriptions != null) {
            if (complexFieldNestLevel > 0) {
                Set<String> innerPropertyNames = QueryTaskUtils.getExpandedQueryPropertyNames(pd.fieldDescriptions, complexFieldNestLevel - 1);
                return innerPropertyNames.stream().map(p -> QueryTask.QuerySpecification.buildCompositeFieldName(propertyName, p)).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
        if (pd.typeName == ServiceDocumentDescription.TypeName.COLLECTION) {
            if (complexFieldNestLevel > 0) {
                Set<String> innerPropertyNames = QueryTaskUtils.getExpandedQueryPropertyNames("item", pd.elementDescription, complexFieldNestLevel - 1);
                return innerPropertyNames.stream().map(p -> QueryTask.QuerySpecification.buildCompositeFieldName(propertyName, p)).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
        return Collections.singleton(propertyName);
    }

    public static void failTask(Operation get, Throwable ex) {
        QueryTask t = new QueryTask();
        t.taskInfo.stage = TaskState.TaskStage.FAILED;
        t.taskInfo.failure = Utils.toServiceErrorResponse(ex);
        get.setBody(t).fail(ex);
    }
}

