/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeSelectorReplicationContext;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class NodeSelectorReplicationService
extends StatelessService {
    public static final int BINARY_SERIALIZATION = Integer.getInteger("xenon.NodeSelectorReplicationService.BINARY_SERIALIZATION", 1);
    private Service parent;
    private Map<String, Integer> nodeCountPerLocation;
    private Map<URI, String> locationPerNodeURI;
    private String nodeGroupLink;

    public NodeSelectorReplicationService(Service parent) {
        this.parent = parent;
        super.setHost(parent.getHost());
        super.setSelfLink(UriUtils.buildUriPath(parent.getSelfLink(), "/replication"));
        if (parent.getHost().getLocation() != null) {
            this.nodeCountPerLocation = new ConcurrentHashMap<String, Integer>();
            this.locationPerNodeURI = new ConcurrentHashMap<URI, String>();
        }
        super.setProcessingStage(Service.ProcessingStage.AVAILABLE);
    }

    void replicateUpdate(NodeGroupService.NodeGroupState localState, Operation outboundOp, NodeSelectorService.SelectAndForwardRequest req, NodeSelectorService.SelectOwnerResponse rsp, int replicationQuorum) {
        int memberCount = localState.nodes.size();
        NodeState selfNode = localState.nodes.get(this.getHost().getId());
        if (req.serviceOptions.contains((Object)Service.ServiceOption.OWNER_SELECTION) && selfNode.membershipQuorum > memberCount) {
            outboundOp.fail(new IllegalStateException("Not enough peers: " + memberCount));
            return;
        }
        if (memberCount == 1) {
            outboundOp.complete();
            return;
        }
        Collection<NodeState> selectedNodes = rsp.selectedNodes;
        int eligibleMemberCount = selectedNodes.size();
        String location = this.getHost().getLocation();
        NodeSelectorReplicationContext context = new NodeSelectorReplicationContext(location, selectedNodes, outboundOp);
        context.locationThreshold = selfNode.locationQuorum;
        String rplQuorumValue = outboundOp.getRequestHeaderAsIs("x-xenon-rpl-quorum");
        if (rplQuorumValue != null) {
            try {
                context.successThreshold = "x-xenon-all".equals(rplQuorumValue) ? eligibleMemberCount : Integer.parseInt(rplQuorumValue);
                if (context.successThreshold > eligibleMemberCount) {
                    String errorMsg = String.format("Requested quorum %d is larger than member count %d", context.successThreshold, eligibleMemberCount);
                    throw new IllegalArgumentException(errorMsg);
                }
            }
            catch (Exception e) {
                outboundOp.setRetryCount(0).fail(e);
                return;
            }
            context.failureThreshold = eligibleMemberCount - context.successThreshold + 1;
            this.replicateUpdateToNodes(context);
            return;
        }
        if (req.serviceOptions.contains((Object)Service.ServiceOption.OWNER_SELECTION)) {
            if (location == null) {
                context.successThreshold = replicationQuorum > 0 && outboundOp.getAction() != Service.Action.DELETE ? replicationQuorum : Math.min(eligibleMemberCount, selfNode.membershipQuorum);
                context.failureThreshold = eligibleMemberCount - context.successThreshold + 1;
            } else {
                int localNodeCount = this.getNodeCountInLocation(location, selectedNodes);
                if (selfNode.locationQuorum == 1) {
                    context.successThreshold = Math.min(localNodeCount, selfNode.membershipQuorum);
                    context.failureThreshold = localNodeCount - context.successThreshold + 1;
                }
            }
            this.replicateUpdateToNodes(context);
            return;
        }
        context.successThreshold = Math.min(2, eligibleMemberCount - 1);
        context.failureThreshold = eligibleMemberCount - context.successThreshold + 1;
        this.replicateUpdateToNodes(context);
    }

    private int getNodeCountInLocation(String location, Collection<NodeState> nodes) {
        Integer count = this.nodeCountPerLocation.get(location);
        if (count != null) {
            return count;
        }
        count = (int)nodes.stream().filter(ns -> Objects.equals(location, ns.customProperties.get("xenon.NodeState.location"))).peek(ns -> this.locationPerNodeURI.put(ns.groupReference, location)).count();
        this.nodeCountPerLocation.put(location, count);
        return count;
    }

    private void updateLocation(NodeState node) {
        this.nodeGroupLink = node.groupReference.getPath();
        this.locationPerNodeURI.computeIfAbsent(node.groupReference, u -> node.customProperties.get("xenon.NodeState.location"));
    }

    private String getLocation(Operation remotePeerResponse) {
        URI remotePeerService = remotePeerResponse.getUri();
        URI remoteNodeUri = UriUtils.buildServiceUri(remotePeerService.getScheme(), remotePeerService.getHost(), remotePeerService.getPort(), this.nodeGroupLink, null, null);
        return this.locationPerNodeURI.get(remoteNodeUri);
    }

    private void replicateUpdateToNodes(NodeSelectorReplicationContext context) {
        Operation update = NodeSelectorReplicationService.createReplicationRequest(context.parentOp, null);
        update.setAuthorizationContext(this.getSystemAuthorizationContext());
        update.setCompletion((o, e) -> this.handleReplicationCompletion(context, o, e));
        this.handleReplicationCompletion(context, null, null);
        for (NodeState m : context.nodes) {
            if (m.id.equals(this.getHost().getId()) || m.options.contains((Object)NodeState.NodeOption.OBSERVER)) continue;
            URI updateUri = this.createReplicaUri(m.groupReference, context.parentOp);
            update.setUri(updateUri);
            if (context.location != null) {
                this.updateLocation(m);
            }
            if (NodeState.isUnAvailable(m)) {
                int originalStatusCode = update.getStatusCode();
                update.setStatusCode(400);
                this.handleReplicationCompletion(context, update, new IllegalStateException("node is not available"));
                update.setStatusCode(originalStatusCode);
                continue;
            }
            this.getHost().getClient().send(update);
        }
    }

    private static Operation createReplicationRequest(Operation outboundOp, URI remoteUri) {
        String commitHeader;
        Operation update = Operation.createPost(remoteUri).setAction(outboundOp.getAction()).setRetryCount(1).forceRemote().setExpiration(outboundOp.getExpirationMicrosUtc()).transferRefererFrom(outboundOp);
        String pragmaHeader = outboundOp.getRequestHeaderAsIs("pragma");
        if (pragmaHeader != null && !"xn-fwd".equals(pragmaHeader)) {
            update.addRequestHeader("pragma", pragmaHeader);
            update.addPragmaDirective("xn-rpl");
        }
        if ((commitHeader = outboundOp.getRequestHeaderAsIs("x-xenon-rpl-phase")) != null) {
            update.addRequestHeader("x-xenon-rpl-phase", commitHeader);
        }
        Utils.encodeAndTransferLinkedStateToBody(outboundOp, update, BINARY_SERIALIZATION == 1);
        update.setFromReplication(true);
        update.setConnectionTag("xn-cnx-tag-replication");
        if (NodeSelectorService.REPLICATION_OPERATION_OPTION != null) {
            update.toggleOption(NodeSelectorService.REPLICATION_OPERATION_OPTION, true);
        }
        if (update.getCookies() != null) {
            update.getCookies().clear();
        }
        return update;
    }

    private URI createReplicaUri(URI remoteHost, Operation outboundOp) {
        return UriUtils.buildServiceUri(remoteHost.getScheme(), remoteHost.getHost(), remoteHost.getPort(), outboundOp.getUri().getPath(), outboundOp.getUri().getQuery(), null);
    }

    private void handleReplicationCompletion(NodeSelectorReplicationContext context, Operation o, Throwable e) {
        String remoteLocation = context.location;
        if (context.location != null) {
            if (o != null) {
                remoteLocation = this.getLocation(o);
            }
            if (context.locationThreshold == 1 && !context.location.equals(remoteLocation)) {
                return;
            }
        }
        if (e == null && o != null && o.getStatusCode() >= 400) {
            e = new IllegalStateException("Request failed: " + o.toString());
        }
        context.checkAndCompleteOperation(this.getHost(), e, o, remoteLocation);
    }

    @Override
    public void sendRequest(Operation op) {
        this.parent.sendRequest(op);
    }

    @Override
    public ServiceHost getHost() {
        return this.parent.getHost();
    }
}

