/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.vmware.xenon.common.ServerSentEvent;
import com.vmware.xenon.common.Utils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ServerSentEventConverter {
    public static final ServerSentEventConverter INSTANCE = new ServerSentEventConverter();
    public static final Charset ENCODING_CHARSET = StandardCharsets.UTF_8;
    private static final String NEW_LINE = "\n";
    private static final String NEW_LINE_REGEX = "\r?\n";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_ID = "id";
    private static final String FIELD_EVENT = "event";
    private static final String FIELD_RETRY = "retry";
    private static final String FIELD_NAME_DELIMITER = ":";
    private static final String FIELD_DELIMITER = "\n";
    private static final String FIELD_DELIMITER_REGEX = "\r?\n";
    private static final String EVENT_DELIMITER = "\n";

    private ServerSentEventConverter() {
    }

    public String serialize(ServerSentEvent event) {
        StringBuilder sb = Utils.getBuilder();
        if (event.event != null) {
            this.addField(sb, FIELD_EVENT, event.event);
        }
        if (event.data != null) {
            String[] lines;
            for (String line : lines = event.data.split("\r?\n", -1)) {
                this.addField(sb, FIELD_DATA, line);
            }
        }
        if (event.id != null) {
            this.addField(sb, FIELD_ID, event.id);
        }
        if (event.retry != null) {
            this.addField(sb, FIELD_RETRY, String.valueOf(event.retry));
        }
        sb.append("\n");
        return sb.toString();
    }

    private StringBuilder addField(StringBuilder sb, String fieldName, String value) {
        return sb.append(fieldName).append(FIELD_NAME_DELIMITER).append(value).append("\n");
    }

    public ServerSentEvent deserialize(String serialized) {
        String[] fields;
        ServerSentEvent event = new ServerSentEvent();
        StringBuilder dataBuilder = new StringBuilder();
        boolean dataAdded = false;
        block14: for (String field : fields = serialized.split("\r?\n")) {
            String fieldName;
            String[] tokens = field.split(FIELD_NAME_DELIMITER, 2);
            if (tokens.length < 2) {
                tokens = new String[]{field, ""};
            }
            if ((fieldName = tokens[0]).isEmpty()) continue;
            String value = tokens[1];
            if (value.startsWith(" ")) {
                value = value.substring(1);
            }
            switch (fieldName) {
                case "data": {
                    if (dataAdded) {
                        dataBuilder.append("\n");
                    }
                    dataBuilder.append(value);
                    dataAdded = true;
                    continue block14;
                }
                case "event": {
                    event.event = value;
                    continue block14;
                }
                case "retry": {
                    try {
                        event.retry = Long.parseLong(value, 10);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block14;
                }
                case "id": {
                    event.id = value;
                    continue block14;
                }
                default: {
                    continue block14;
                }
            }
        }
        if (dataAdded) {
            event.data = dataBuilder.toString();
        }
        return event;
    }
}

