/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.vmware.xenon.common.serialization.TypeTokens;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public enum ObjectMapTypeConverter implements JsonSerializer<Map<String, Object>>,
JsonDeserializer<Map<String, Object>>
{
    INSTANCE;

    public static final Type TYPE;

    public JsonElement serialize(Map<String, Object> map, Type type, JsonSerializationContext context) {
        JsonObject mapObject = new JsonObject();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Object v = e.getValue();
            if (v == null) {
                mapObject.add(e.getKey(), (JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (v instanceof JsonElement) {
                mapObject.add(e.getKey(), (JsonElement)v);
                continue;
            }
            mapObject.add(e.getKey(), context.serialize(v));
        }
        return mapObject;
    }

    public Map<String, Object> deserialize(JsonElement json, Type unused, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expecting a json Map object but found: " + json);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonNull()) {
                result.put(key, null);
                continue;
            }
            if (element.isJsonPrimitive()) {
                JsonPrimitive elem = element.getAsJsonPrimitive();
                Object value = null;
                if (elem.isBoolean()) {
                    value = elem.getAsBoolean();
                } else if (elem.isString()) {
                    value = elem.getAsString();
                } else if (elem.isNumber()) {
                    BigDecimal num = elem.getAsBigDecimal();
                    try {
                        value = num.longValueExact();
                    }
                    catch (ArithmeticException e) {
                        value = num.doubleValue();
                    }
                } else {
                    throw new RuntimeException("Unexpected value type for json element key:" + key + " value:" + element);
                }
                result.put(key, value);
                continue;
            }
            result.put(key, element);
        }
        return result;
    }

    static {
        TYPE = TypeTokens.MAP_OF_OBJECTS_BY_STRING;
    }
}

