/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.opentracing;

import brave.Tracing;
import brave.opentracing.BraveTracer;
import brave.sampler.BoundarySampler;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.opentracing.TracerFactoryInterface;
import io.opentracing.Tracer;
import java.util.Map;
import java.util.logging.Logger;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

public class Zipkin
implements TracerFactoryInterface {
    @Override
    public Tracer create(ServiceHost host) {
        Float rate;
        Logger logger = Logger.getLogger(this.getClass().getName());
        Map<String, String> env = System.getenv();
        String zipkinUrl = env.get("ZIPKIN_URL");
        String serviceName = env.get("ZIPKIN_SERVICE_NAME");
        String sampleRateString = env.get("ZIPKIN_SAMPLERATE");
        if (zipkinUrl == null || zipkinUrl.isEmpty()) {
            throw new RuntimeException("Zipkin tracing requires ZIPKIN_URL set.");
        }
        if (serviceName == null || serviceName.isEmpty()) {
            throw new RuntimeException("Service name missing - ZIPKIN_SERVICE_NAME not set.");
        }
        if (sampleRateString == null || sampleRateString.isEmpty()) {
            rate = Float.valueOf(1.0f);
        } else {
            try {
                rate = Float.valueOf(Float.parseFloat(sampleRateString));
            }
            catch (NumberFormatException nfe) {
                rate = Float.valueOf(1.0f);
            }
        }
        URLConnectionSender sender = null;
        AsyncReporter spanReporter = null;
        if (zipkinUrl.contains("/v1/")) {
            sender = URLConnectionSender.create((String)zipkinUrl);
            spanReporter = AsyncReporter.builder((Sender)sender).build((BytesEncoder)SpanBytesEncoder.JSON_V1);
        } else {
            sender = OkHttpSender.create((String)zipkinUrl);
            spanReporter = AsyncReporter.create((Sender)sender);
        }
        Tracing braveTracing = Tracing.newBuilder().localServiceName(serviceName).spanReporter((Reporter)spanReporter).sampler(BoundarySampler.create((float)rate.floatValue())).build();
        logger.info("Opentracing support using Zipkin");
        return BraveTracer.create((Tracing)braveTracing);
    }
}

