/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.opentracing;

import com.vmware.xenon.common.opentracing.TracerFactory;
import com.vmware.xenon.common.opentracing.TracingExecutor;
import io.opentracing.Tracer;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TracingScheduledExecutor
extends TracingExecutor
implements ScheduledExecutorService {
    private final ScheduledExecutorService scheduledExecutor;

    private TracingScheduledExecutor(ScheduledExecutorService executor, Tracer tracer) {
        super(executor, tracer);
        this.scheduledExecutor = executor;
    }

    public static ScheduledExecutorService create(ScheduledExecutorService executor, Tracer tracer) {
        if (!TracerFactory.factory.enabled()) {
            return executor;
        }
        return new TracingScheduledExecutor(executor, tracer);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduledExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }
}

