/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.opentracing;

import com.vmware.xenon.common.opentracing.TracerFactory;
import io.opentracing.ActiveSpan;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TracingExecutor
implements ExecutorService {
    private final ExecutorService executor;
    protected final Tracer tracer;

    protected TracingExecutor(ExecutorService executor, Tracer tracer) {
        this.executor = executor;
        this.tracer = tracer;
    }

    public static ExecutorService create(ExecutorService executor, Tracer tracer) {
        if (!TracerFactory.factory.enabled()) {
            return executor;
        }
        return new TracingExecutor(executor, tracer);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (this.tracer.activeSpan() != null) {
            Span queueSpan = this.tracer.buildSpan("Queue").startManual();
            ActiveSpan.Continuation cont = this.tracer.activeSpan().capture();
            try {
                this.executor.execute(() -> {
                    queueSpan.finish();
                    try (ActiveSpan parentSpan = cont.activate();){
                        command.run();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("error.kind", "exception");
                map.put("error.object", e);
                map.put("message", "could not submit to executor queue");
                queueSpan.log(map);
                queueSpan.finish();
                cont.activate().close();
                throw e;
            }
        } else {
            this.executor.execute(command);
        }
    }
}

