/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.opentracing;

import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.opentracing.TracerFactoryInterface;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentracing.NoopTracerFactory;
import io.opentracing.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TracerFactory {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static TracerFactory factory = new TracerFactory();
    private boolean enabled;
    private boolean enableChecked;

    public synchronized Tracer create(ServiceHost host) {
        TracerFactoryInterface factory;
        Logger logger = Logger.getLogger(this.getClass().getName());
        Map<String, String> env = System.getenv();
        String implementation = env.get("XENON_TRACER");
        if (implementation == null) {
            implementation = "";
        }
        implementation = implementation.toLowerCase();
        if (!this.enabled()) {
            logger.info(String.format("Opentracing not enabled.", new Object[0]));
            return NoopTracerFactory.create();
        }
        Class<?> factoryClass = null;
        try {
            if (implementation.equals("jaeger")) {
                factoryClass = Class.forName("com.vmware.xenon.common.opentracing.Jaeger");
            } else if (implementation.equals("zipkin")) {
                factoryClass = Class.forName("com.vmware.xenon.common.opentracing.Zipkin");
            } else {
                throw new RuntimeException(String.format("Bad tracer type %s", implementation));
            }
            if (factoryClass == null) {
                throw new RuntimeException(String.format("Failed to cast implementation '%s' to Class<TracerFactoryInterface>", implementation));
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to load implementation class", e);
            throw new RuntimeException(String.format("Could not load implementation for %s", implementation), e);
        }
        assert (factoryClass != null);
        try {
            factory = (TracerFactoryInterface)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "Failed to instantiate tracer factory", e);
            throw new RuntimeException(String.format("Could not instantiate factory for %s", implementation), e);
        }
        return factory.create(host);
    }

    public boolean enabled() {
        if (!this.enableChecked) {
            Map<String, String> env = System.getenv();
            String implementation = env.get("XENON_TRACER");
            this.enabled = implementation != null && implementation.length() > 0;
            this.enableChecked = true;
        }
        return this.enabled;
    }
}

