/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.ServerSentEvent;
import com.vmware.xenon.common.serialization.ServerSentEventConverter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import java.util.stream.Stream;

public class NettyHttpEventStreamHandler
extends DelimiterBasedFrameDecoder {
    private static final ByteBuf[] DELIMITERS = (ByteBuf[])Stream.of("\n\n", "\r\n\r\n").map(d -> d.getBytes(ServerSentEventConverter.ENCODING_CHARSET)).map(Unpooled::wrappedBuffer).toArray(ByteBuf[]::new);
    private Phase phase = Phase.NOT_INITIALIZED;

    public NettyHttpEventStreamHandler() {
        super(Integer.MAX_VALUE, DELIMITERS);
    }

    private boolean acceptInboundMessage(Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            return false;
        }
        switch (this.phase) {
            case NOT_INITIALIZED: {
                if (!(msg instanceof HttpResponse)) break;
                return true;
            }
            case IN_EVENT_STREAM: {
                if (!(msg instanceof HttpContent)) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!this.acceptInboundMessage(msg)) {
            this.resetState();
            ctx.fireChannelRead(msg);
            return;
        }
        switch (this.phase) {
            case NOT_INITIALIZED: {
                HttpResponse response = (HttpResponse)msg;
                HttpHeaders headers = response.headers();
                String contentType = headers.get("content-type");
                if (!"text/event-stream".equals(contentType) || response.status().code() != 200) {
                    this.resetState();
                    ctx.fireChannelRead(msg);
                    return;
                }
                this.phase = Phase.IN_EVENT_STREAM;
                EventStreamHeadersMessage transformedMsg = new EventStreamHeadersMessage();
                transformedMsg.originalResponse = response;
                ctx.fireChannelRead((Object)transformedMsg);
                return;
            }
            case IN_EVENT_STREAM: {
                ByteBuf content = ((HttpContent)msg).content();
                super.channelRead(ctx, (Object)content);
                return;
            }
        }
        this.resetState();
        ctx.fireChannelRead(msg);
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        ByteBuf rawEvent = (ByteBuf)super.decode(ctx, buffer);
        if (rawEvent == null) {
            return null;
        }
        String serializedEvent = rawEvent.toString(ServerSentEventConverter.ENCODING_CHARSET);
        rawEvent.release();
        ServerSentEvent event = ServerSentEventConverter.INSTANCE.deserialize(serializedEvent);
        EventStreamMessage message = new EventStreamMessage();
        message.event = event;
        return message;
    }

    private void resetState() {
        this.phase = Phase.NOT_INITIALIZED;
    }

    static final class EventStreamHeadersMessage
    extends DefaultHttpObject {
        HttpResponse originalResponse;

        EventStreamHeadersMessage() {
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }

    static final class EventStreamMessage
    extends DefaultHttpObject {
        ServerSentEvent event;

        EventStreamMessage() {
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }

    private static enum Phase {
        NOT_INITIALIZED,
        IN_EVENT_STREAM;

    }
}

