/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.config;

import com.vmware.xenon.common.config.ConfigurationSource;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class XenonConfiguration {
    private final ConfigurationSource source;
    static final Logger logger = Logger.getLogger(XenonConfiguration.class.getName());
    private static final XenonConfiguration INSTANCE = new XenonConfiguration(new ConfigurationSource());

    XenonConfiguration(ConfigurationSource source) {
        this.source = source;
    }

    public static double decimal(Class<?> subsystem, String property, double defaultValue) {
        return INSTANCE.getDecimal(subsystem, property, defaultValue);
    }

    public static long number(Class<?> subsystem, String property, long defaultValue) {
        return INSTANCE.getInteger(subsystem, property, defaultValue);
    }

    public static int integer(Class<?> subsystem, String property, long defaultValue) {
        return (int)INSTANCE.getInteger(subsystem, property, defaultValue);
    }

    public static long duration(Class<?> subsystem, String property, Duration defaultValue) {
        return INSTANCE.getDuration(subsystem, property, defaultValue);
    }

    public static long duration(Class<?> subsystem, String property, TimeUnit unit, long duration) {
        return INSTANCE.getDuration(subsystem, property, Duration.ofNanos(unit.toNanos(duration)));
    }

    public static String string(Class<?> subsystem, String property, String defaultValue) {
        return INSTANCE.getString(subsystem, property, defaultValue);
    }

    public static <T extends Enum<T>> T choice(Class<?> subsystem, String property, Class<T> enumType, T defaultValue) {
        return INSTANCE.getChoice(subsystem, property, enumType, defaultValue);
    }

    public static String secret(Class<?> subsystem, String property, String defaultValue) {
        return INSTANCE.getSecret(subsystem, property, defaultValue);
    }

    public static boolean bool(String subsystem, String property, boolean defaultValue) {
        return INSTANCE.getBool(subsystem, property, defaultValue);
    }

    public static boolean bool(Class<?> subsystem, String property, boolean defaultValue) {
        return INSTANCE.getBool(subsystem, property, defaultValue);
    }

    String getString(Class<?> subsystem, String property, String defaultValue) {
        String v = this.source.get(subsystem, property, true);
        if (v == null) {
            this.logUsingDefaultBecauseUnset(subsystem, property, defaultValue, true);
            return defaultValue;
        }
        return v;
    }

    <T extends Enum<T>> T getChoice(Class<?> subsystem, String property, Class<T> enumType, T defaultValue) {
        String v = this.source.get(subsystem, property, true);
        if (v == null) {
            this.logUsingDefaultBecauseUnset(subsystem, property, defaultValue, true);
            return defaultValue;
        }
        try {
            T res = Enum.valueOf(enumType, v);
            return res;
        }
        catch (IllegalArgumentException e) {
            this.logUsingDefaultBecauseBadValue(subsystem, property, defaultValue, v);
            return defaultValue;
        }
    }

    boolean getBool(String subsystem, String property, boolean defaultValue) {
        String v = this.source.get(subsystem, property, true);
        if (v == null) {
            this.logUsingDefaultBecauseUnset(subsystem, property, defaultValue, true);
            return defaultValue;
        }
        Long num = this.parseOr(v);
        if (num != null && num == 0L) {
            return false;
        }
        if (num != null && num == 1L) {
            return true;
        }
        return Boolean.parseBoolean(v);
    }

    boolean getBool(Class<?> subsystem, String property, boolean defaultValue) {
        return this.getBool(subsystem.getSimpleName(), property, defaultValue);
    }

    String getSecret(Class<?> subsystem, String property, String defaultValue) {
        String v = this.source.get(subsystem, property, false);
        if (v == null) {
            this.logUsingDefaultBecauseUnset(subsystem, property, defaultValue, false);
            return defaultValue;
        }
        return v;
    }

    long getDuration(Class<?> subsystem, String property, Duration defaultValue) {
        String v = this.source.get(subsystem, property, true);
        long dv = defaultValue.toNanos() / 1000L;
        if (v == null) {
            this.logUsingDefaultBecauseUnset(subsystem, property, dv, true);
            return dv;
        }
        try {
            long micros = Long.parseLong(v);
            if (micros < 0L) {
                this.logUsingDefaultBecauseBadValue(subsystem, property, dv, v);
                return dv;
            }
            return micros;
        }
        catch (NumberFormatException micros) {
            if (v.endsWith("ms")) {
                Long ms = this.parseOr(this.stripSuffix(v, 2));
                if (ms != null && ms >= 0L) {
                    return TimeUnit.MILLISECONDS.toMicros(ms);
                }
                this.logUsingDefaultBecauseBadValue(subsystem, property, dv, v);
                return dv;
            }
            if (v.endsWith("h")) {
                Long h = this.parseOr(this.stripSuffix(v, 1));
                if (h != null && h >= 0L) {
                    return TimeUnit.HOURS.toMicros(h);
                }
                this.logUsingDefaultBecauseBadValue(subsystem, property, dv, v);
                return dv;
            }
            if (v.endsWith("d")) {
                Long days = this.parseOr(this.stripSuffix(v, 1));
                if (days != null && days >= 0L) {
                    return TimeUnit.DAYS.toMicros(days);
                }
                this.logUsingDefaultBecauseBadValue(subsystem, property, dv, v);
                return dv;
            }
            if (v.endsWith("s")) {
                Long sec = this.parseOr(this.stripSuffix(v, 1));
                if (sec != null && sec >= 0L) {
                    return TimeUnit.SECONDS.toMicros(sec);
                }
                this.logUsingDefaultBecauseBadValue(subsystem, property, dv, v);
                return dv;
            }
            if (v.endsWith("m")) {
                Long min = this.parseOr(this.stripSuffix(v, 1));
                if (min != null && min >= 0L) {
                    return TimeUnit.MINUTES.toMicros(min);
                }
                this.logUsingDefaultBecauseBadValue(subsystem, property, dv, v);
                return dv;
            }
            return dv;
        }
    }

    double getDecimal(Class<?> subsystem, String property, double defaultValue) {
        String v = this.source.get(subsystem, property, true);
        if (v == null) {
            this.logUsingDefaultBecauseUnset(subsystem, property, defaultValue, true);
            return defaultValue;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            this.logUsingDefaultBecauseBadValue(subsystem, property, defaultValue, v);
            return defaultValue;
        }
    }

    long getInteger(Class<?> subsystem, String property, long defaultValue) {
        String v = this.source.get(subsystem, property, true);
        if (v == null) {
            this.logUsingDefaultBecauseUnset(subsystem, property, defaultValue, true);
            return defaultValue;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.lastToUpper(v) == 'K') {
                Long res = this.parseOr(this.stripSuffix(v, 1));
                if (res == null) {
                    this.logUsingDefaultBecauseBadValue(subsystem, property, defaultValue, v);
                    return defaultValue;
                }
                return 1024L * res;
            }
            if (this.lastToUpper(v) == 'M') {
                Long res = this.parseOr(this.stripSuffix(v, 1));
                if (res == null) {
                    this.logUsingDefaultBecauseBadValue(subsystem, property, defaultValue, v);
                    return defaultValue;
                }
                return 0x100000L * res;
            }
            if (this.lastToUpper(v) == 'G') {
                Long res = this.parseOr(this.stripSuffix(v, 1));
                if (res == null) {
                    this.logUsingDefaultBecauseBadValue(subsystem, property, defaultValue, v);
                    return defaultValue;
                }
                return 0x40000000L * res;
            }
            this.logUsingDefaultBecauseBadValue(subsystem, property, defaultValue, v);
            return defaultValue;
        }
    }

    private char lastToUpper(String v) {
        return Character.toUpperCase(v.charAt(v.length() - 1));
    }

    private void logUsingDefaultBecauseUnset(Object subsystem, String property, Object defaultValue, boolean verboseLogValue) {
        if (logger.isLoggable(Level.FINE)) {
            if (!verboseLogValue) {
                defaultValue = "******";
            }
            logger.log(Level.FINE, String.format("Using default value \"%s\" for %s.%s", defaultValue, ConfigurationSource.subsystemToString(subsystem), property));
        }
    }

    private void logUsingDefaultBecauseBadValue(Object subsystem, String property, Object defaultValue, String badValue) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, String.format("Using default value \"%s\" for %s.%s. Cannot parse \"%s\"", defaultValue, ConfigurationSource.subsystemToString(subsystem), property, badValue));
        }
    }

    private String stripSuffix(String v, int suffixLen) {
        return v.substring(0, v.length() - suffixLen);
    }

    private Long parseOr(String v) {
        if (v == null) {
            return null;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }
}

