/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.config;

import com.vmware.xenon.common.config.XenonConfiguration;
import java.util.logging.Level;

class ConfigurationSource {
    static final String MASK = "******";

    ConfigurationSource() {
    }

    String get(Class<?> subsystem, String name, boolean verboseResolution) {
        return this.get(ConfigurationSource.subsystemToString(subsystem), name, verboseResolution);
    }

    String get(String subsystem, String name, boolean verboseResolution) {
        String key = ConfigurationSource.buildKey(subsystem, name);
        String value = this.getProperty(key);
        if (value == null) {
            key = ConfigurationSource.toSnakeUpperCase("xenon." + subsystem).replace(".", "");
            value = this.getEnv(key = key + '_' + ConfigurationSource.toSnakeUpperCase(name));
            if (value != null) {
                this.logFoundEnvVar(verboseResolution, key, value);
            }
        } else {
            this.logFoundSystemProperty(verboseResolution, key, value);
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private void logFoundSystemProperty(boolean verboseResolution, String key, String value) {
        if (XenonConfiguration.logger.isLoggable(Level.FINE)) {
            if (!verboseResolution) {
                value = MASK;
            }
            XenonConfiguration.logger.log(Level.FINE, String.format("Found system property %s=\"%s\"", key, value));
        }
    }

    private void logFoundEnvVar(boolean verboseResolution, String varName, String value) {
        if (XenonConfiguration.logger.isLoggable(Level.FINE)) {
            if (!verboseResolution) {
                value = MASK;
            }
            XenonConfiguration.logger.log(Level.FINE, String.format("Found environment variable %s=\"%s\"", varName, value));
        }
    }

    static String buildKey(String subsystem, String name) {
        return "xenon." + subsystem + "." + name;
    }

    static String buildKey(Class<?> subsystem, String name) {
        return ConfigurationSource.buildKey(subsystem.getSimpleName(), name);
    }

    static String subsystemToString(Object subsystem) {
        return subsystem instanceof Class ? ((Class)subsystem).getSimpleName() : subsystem.toString();
    }

    static String toSnakeUpperCase(String key) {
        key = key.replace('.', '_');
        key = key.replace('-', '_');
        key = key.replaceAll("([^\\p{Upper}_])(\\p{Upper}+)", "$1_$2").toUpperCase();
        return key;
    }

    String getEnv(String key) {
        String res = System.getenv(key);
        if ("".equals(res)) {
            return null;
        }
        return res;
    }

    String getProperty(String key) {
        return System.getProperty(key);
    }
}

