/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;

public final class TransactionServiceHelper {
    private TransactionServiceHelper() {
    }

    static void handleGetWithinTransaction(StatefulService s, Operation get, Handler h, FailRequest fr, Operation.AuthorizationContext authContext) {
        if (get.isWithinTransaction()) {
            Operation inTransactionQueryOp = TransactionServiceHelper.buildLatestInTransactionQueryTaskOp(s, get.getTransactionId(), authContext).setCompletion((o, e) -> {
                if (e != null) {
                    get.fail(e);
                    return;
                }
                QueryTask response = o.getBody(QueryTask.class);
                if (response.results.documentLinks.isEmpty()) {
                    Operation nonTransactionQueryOp = TransactionServiceHelper.buildLatestNonTransactionQueryTaskOp(s, authContext).setCompletion((o2, e2) -> {
                        if (e2 != null) {
                            get.fail(e);
                            return;
                        }
                        QueryTask nonTransactionResponse = o2.getBody(QueryTask.class);
                        TransactionServiceHelper.returnLatestOrFail(nonTransactionResponse, get, fr);
                    });
                    s.sendRequest(nonTransactionQueryOp);
                } else {
                    TransactionServiceHelper.returnLatestOrFail(response, get, fr);
                }
            });
            s.sendRequest(inTransactionQueryOp);
        } else {
            Operation nonTransactionQueryOp = TransactionServiceHelper.buildLatestNonTransactionQueryTaskOp(s, authContext).setCompletion((o, e) -> {
                if (e != null) {
                    get.fail(e);
                    return;
                }
                QueryTask response = o.getBody(QueryTask.class);
                TransactionServiceHelper.returnLatestOrFail(response, get, fr);
            });
            s.sendRequest(nonTransactionQueryOp);
        }
    }

    private static void returnLatestOrFail(QueryTask response, Operation get, FailRequest fr) {
        if (response.results.documentLinks.isEmpty()) {
            get.setStatusCode(404);
            fr.failRequest(get, new IllegalStateException("Latest state not found"), false);
            return;
        }
        String latest = response.results.documentLinks.get(0);
        Object obj = response.results.documents.get(latest);
        get.setBodyNoCloning(obj).complete();
    }

    private static Operation buildLatestInTransactionQueryTaskOp(StatefulService s, String txid, Operation.AuthorizationContext authContext) {
        QueryTask.Query.Builder queryBuilder = QueryTask.Query.Builder.create();
        queryBuilder.addFieldClause("documentSelfLink", s.getSelfLink());
        queryBuilder.addFieldClause("documentTransactionId", txid);
        QueryTask.Builder queryTaskBuilder = QueryTask.Builder.createDirectTask().setQuery(queryBuilder.build());
        queryTaskBuilder.addOption(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        queryTaskBuilder.addOption(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        queryTaskBuilder.orderDescending("documentVersion", ServiceDocumentDescription.TypeName.LONG);
        QueryTask task = queryTaskBuilder.build();
        Operation returnOp = Operation.createPost(s.getHost(), ServiceUriPaths.CORE_QUERY_TASKS).setBody(task);
        returnOp.setAuthorizationContext(authContext);
        return returnOp;
    }

    private static Operation buildLatestNonTransactionQueryTaskOp(StatefulService s, Operation.AuthorizationContext authContext) {
        QueryTask.Query.Builder queryBuilder = QueryTask.Query.Builder.create();
        queryBuilder.addFieldClause("documentSelfLink", s.getSelfLink());
        queryBuilder.addFieldClause("documentTransactionId", "*", QueryTask.QueryTerm.MatchType.WILDCARD, QueryTask.Query.Occurance.MUST_NOT_OCCUR);
        QueryTask.Builder queryTaskBuilder = QueryTask.Builder.createDirectTask().setQuery(queryBuilder.build());
        queryTaskBuilder.addOption(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        queryTaskBuilder.addOption(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        queryTaskBuilder.orderDescending("documentVersion", ServiceDocumentDescription.TypeName.LONG);
        QueryTask task = queryTaskBuilder.build();
        Operation returnOp = Operation.createPost(s.getHost(), ServiceUriPaths.CORE_QUERY_TASKS).setBody(task);
        returnOp.setAuthorizationContext(authContext);
        return returnOp;
    }

    static Operation notifyTransactionCoordinatorOp(StatefulService s, Operation op, Throwable e) {
        URI txCoordinator = UriUtils.buildTransactionUri(s.getHost(), op.getTransactionId());
        s.addPendingTransaction(txCoordinator.getPath());
        Operation.TransactionContext operationsLogRecord = new Operation.TransactionContext();
        operationsLogRecord.action = op.getAction();
        operationsLogRecord.isSuccessful = e == null;
        Operation notifyCoordinatorOp = Operation.createPut(txCoordinator).setTransactionId(null);
        notifyCoordinatorOp.addRequestHeader("x-xenon-tx-reflink", s.getSelfLink());
        return s.setPendingTransactionsAsBody(notifyCoordinatorOp, operationsLogRecord);
    }

    static Operation notifyTransactionCoordinatorOfNewServiceOp(FactoryService factoryService, Service childService, Operation op) {
        childService.setHost(factoryService.getHost());
        URI childServiceUri = op.getUri().normalize();
        String childServicePath = UriUtils.normalizeUriPath(childServiceUri.getPath());
        childService.setSelfLink(childServicePath);
        return TransactionServiceHelper.notifyTransactionCoordinatorOp((StatefulService)childService, op, null);
    }

    static boolean handleOperationInTransaction(StatefulService s, Class<? extends ServiceDocument> st, Operation request, Operation.AuthorizationContext authContext) {
        if (request.getRequestHeaderAsIs("x-xenon-tx-phase") == null) {
            return false;
        }
        if (request.getRequestHeaderAsIs("x-xenon-tx-phase").equals("ensure-commit")) {
            return false;
        }
        if (request.getRequestHeaderAsIs("x-xenon-tx-phase").equals("commit")) {
            String txRefLink = request.getRequestHeader("x-xenon-tx-reflink");
            s.removePendingTransaction(txRefLink);
            s.getHost().clearTransactionalCachedServiceState(s, UriUtils.getLastPathSegment(txRefLink));
            QueryTask.QuerySpecification q = new QueryTask.QuerySpecification();
            QueryTask.Query txnIdClause = new QueryTask.Query().setTermPropertyName("documentTransactionId").setTermMatchValue(UriUtils.getLastPathSegment(txRefLink));
            txnIdClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
            q.query.addBooleanClause(txnIdClause);
            QueryTask.Query selfLinkClause = new QueryTask.Query().setTermPropertyName("documentSelfLink").setTermMatchValue(s.getSelfLink());
            selfLinkClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
            q.query.addBooleanClause(selfLinkClause);
            q.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT, QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
            QueryTask task = QueryTask.create(q).setDirect(true);
            URI uri = UriUtils.buildUri(s.getHost(), ServiceUriPaths.CORE_QUERY_TASKS);
            Operation startPost = Operation.createPost(uri).setBody(task).setCompletion((o, f) -> TransactionServiceHelper.unshadowQueryCompletion(s, st, o, f, request));
            startPost.setAuthorizationContext(authContext);
            s.sendRequest(startPost);
        } else if (request.getRequestHeaderAsIs("x-xenon-tx-phase").equals("abort")) {
            String txRefLink = request.getRequestHeader("x-xenon-tx-reflink");
            s.removePendingTransaction(txRefLink);
            s.getHost().clearTransactionalCachedServiceState(s, UriUtils.getLastPathSegment(txRefLink));
            request.complete();
        } else {
            request.fail(new IllegalArgumentException("Transaction control message, but none of {commit, abort}"));
        }
        return true;
    }

    static void unshadowQueryCompletion(StatefulService s, Class<? extends ServiceDocument> st, Operation o, Throwable f, Operation original) {
        if (f != null) {
            s.logInfo(f.toString(), new Object[0]);
            original.fail(f);
            return;
        }
        QueryTask response = o.getBody(QueryTask.class);
        if (response.results.documentLinks.isEmpty()) {
            original.fail(new IllegalStateException("There should be at least one shadowed, but none was found"));
            return;
        }
        List<String> dl = response.results.documentLinks;
        String latest = dl.get(0);
        Object obj = response.results.documents.get(latest);
        ServiceDocument sd = Utils.fromJson(obj, st);
        sd.documentTransactionId = null;
        s.setState(original, sd);
        original.complete();
    }

    static interface FailRequest {
        public void failRequest(Operation var1, Throwable var2, boolean var3);
    }

    static interface Handler {
        public void handler(Operation var1);
    }
}

