/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class ServiceAvailabilityFilter
implements OperationProcessingChain.Filter {
    @Override
    public OperationProcessingChain.FilterReturnCode processRequest(Operation op, OperationProcessingChain.OperationProcessingContext context) {
        Service parentService;
        Service service;
        String servicePath = op.getUri().getPath();
        if (servicePath == null) {
            Operation.failServiceNotFound(op);
            return OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING;
        }
        if ("".equals(servicePath)) {
            servicePath = "/";
        }
        if ((service = context.getService()) == null) {
            service = context.getHost().findService(servicePath, false);
        }
        if (service != null && service.getProcessingStage() == Service.ProcessingStage.AVAILABLE) {
            context.setService(service);
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        context.getHost().getServiceResourceTracker().updateCacheMissStats();
        if (ServiceHost.isHelperServicePath(servicePath)) {
            servicePath = UriUtils.getParentPath(servicePath);
        }
        boolean queueForServiceAvailability = op.hasPragmaDirective("xn-queue");
        if (service != null && ServiceHost.isServiceStartingOrAvailable(service.getProcessingStage()) || queueForServiceAvailability) {
            Service finalService = service;
            op.nestCompletion((o, e) -> {
                if (e != null || !ServiceHost.isServiceAvailable(finalService)) {
                    if (op.getExpirationMicrosUtc() < Utils.getNowMicrosUtc()) {
                        TimeoutException te = new TimeoutException();
                        op.fail(te);
                        context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, te);
                        return;
                    }
                    context.setService(null);
                    context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.RESUME_PROCESSING, null);
                    return;
                }
                context.setService(finalService);
                context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING, null);
            });
            String finalServicePath = servicePath;
            context.setSuspendConsumer(o -> {
                if (queueForServiceAvailability) {
                    context.getHost().registerForServiceAvailability(op, finalServicePath);
                } else {
                    context.getHost().getOperationTracker().trackServiceStartCompletion(finalServicePath, op);
                }
            });
            return OperationProcessingChain.FilterReturnCode.SUSPEND_PROCESSING;
        }
        context.setService(null);
        if (op.getAction() == Service.Action.DELETE && op.hasPragmaDirective("xn-no-index-update")) {
            op.complete();
            return OperationProcessingChain.FilterReturnCode.SUCCESS_STOP_PROCESSING;
        }
        String parentPath = UriUtils.getParentPath(servicePath);
        if (parentPath != null && (parentService = context.getHost().findService(parentPath, true)) != null && parentService.hasOption(Service.ServiceOption.PERSISTENCE) && parentService instanceof FactoryService) {
            String finalServicePath = servicePath;
            context.setSuspendConsumer(o -> context.getHost().run(() -> this.checkAndOnDemandStartService(op, finalServicePath, (FactoryService)parentService, context)));
            return OperationProcessingChain.FilterReturnCode.SUSPEND_PROCESSING;
        }
        Operation.failServiceNotFound(op);
        return OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING;
    }

    private void checkAndOnDemandStartService(Operation op, String servicePath, FactoryService factoryService, OperationProcessingChain.OperationProcessingContext context) {
        ServiceHost host = context.getHost();
        host.log(Level.FINE, "(%d) ODL check for %s", op.getId(), servicePath);
        boolean doProbe = false;
        if (!factoryService.hasOption(Service.ServiceOption.REPLICATION) && op.getAction() == Service.Action.DELETE) {
            doProbe = true;
        }
        if (!doProbe) {
            host.log(Level.FINE, "Skipping probe - starting service %s on-demand due to %s %d (isFromReplication: %b, isSynchronizeOwner: %b, isSynchronizePeer: %b)", new Object[]{servicePath, op.getAction(), op.getId(), op.isFromReplication(), op.isSynchronizeOwner(), op.isSynchronizePeer()});
            this.startServiceOnDemand(op, servicePath, factoryService, context);
            return;
        }
        Operation getOp = Operation.createGet(op.getUri()).addPragmaDirective("xn-check-index").transferRefererFrom(op).setCompletion((o, e) -> {
            if (e != null) {
                context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, e);
                op.fail(e);
                return;
            }
            if (!o.hasBody()) {
                context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, new ServiceHost.ServiceNotFoundException(op.getUri().getPath()));
                Operation.failServiceNotFound(op);
                return;
            }
            host.log(Level.FINE, "Starting service %s on-demand due to %s %d (isFromReplication: %b, isSynchronizeOwner: %b, isSynchronizePeer: %b)", new Object[]{servicePath, op.getAction(), op.getId(), op.isFromReplication(), op.isSynchronizeOwner(), op.isSynchronizePeer()});
            this.startServiceOnDemand(op, servicePath, factoryService, context);
        });
        Service indexService = host.getDocumentIndexService();
        if (indexService == null) {
            CancellationException e2 = new CancellationException("Index service is null");
            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, e2);
            op.fail(e2);
            return;
        }
        indexService.handleRequest(getOp);
    }

    private void startServiceOnDemand(Operation op, String servicePath, FactoryService factoryService, OperationProcessingChain.OperationProcessingContext context) {
        Service childService;
        ServiceHost host = context.getHost();
        Operation onDemandPost = Operation.createPost(host, servicePath);
        Operation.CompletionHandler c = (o, e) -> {
            if (e != null) {
                if (e instanceof CancellationException) {
                    host.log(Level.WARNING, "Stop of idle service %s detected, retrying", op.getUri().getPath());
                    host.scheduleCore(() -> this.checkAndOnDemandStartService(op, servicePath, factoryService, context), 1L, TimeUnit.SECONDS);
                    return;
                }
                Service.Action a = op.getAction();
                ServiceErrorResponse response = o.getErrorResponseBody();
                if (response != null) {
                    if (response.statusCode == 409 && response.getErrorCode() == -2147483646) {
                        if (a == Service.Action.DELETE) {
                            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.SUCCESS_STOP_PROCESSING, null);
                            op.complete();
                        } else if (a == Service.Action.POST) {
                            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, new ServiceHost.ServiceAlreadyStartedException(servicePath));
                            host.failRequestServiceAlreadyStarted(servicePath, null, op);
                        } else {
                            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, new ServiceHost.ServiceNotFoundException(servicePath));
                            Operation.failServiceNotFound(op, -2147483646);
                        }
                        return;
                    }
                    if (op.getAction() == Service.Action.DELETE && response.statusCode == 404) {
                        context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.SUCCESS_STOP_PROCESSING, null);
                        op.complete();
                        return;
                    }
                    if (response.statusCode == 404) {
                        host.log(Level.WARNING, "Failed to start service %s with 404 status code.", servicePath);
                        context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, new ServiceHost.ServiceNotFoundException(servicePath));
                        Operation.failServiceNotFound(op);
                        return;
                    }
                }
                host.log(Level.SEVERE, "Failed to start service %s with statusCode %d", servicePath, o.getStatusCode());
                context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, new Exception("Failed with status code: " + o.getStatusCode()));
                op.setBodyNoCloning(o.getBodyRaw()).setStatusCode(o.getStatusCode());
                op.fail(e);
                return;
            }
            host.log(Level.FINE, "Successfully started service %s. Resubmitting request %s %d", new Object[]{servicePath, op.getAction(), op.getId()});
            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.RESUME_PROCESSING, null);
        };
        onDemandPost.addPragmaDirective("xn-check-index").addPragmaDirective("xn-check-version").transferRefererFrom(op).setExpiration(op.getExpirationMicrosUtc()).setReplicationDisabled(true).setCompletion(c);
        if (op.isSynchronizeOwner()) {
            onDemandPost.addPragmaDirective("xn-synch-owner");
        }
        try {
            childService = factoryService.createServiceInstance();
            childService.toggleOption(Service.ServiceOption.FACTORY_ITEM, true);
        }
        catch (Throwable e1) {
            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, e1);
            op.fail(e1);
            return;
        }
        if (op.getAction() == Service.Action.DELETE) {
            onDemandPost.disableFailureLogging(true);
            op.disableFailureLogging(true);
        }
        onDemandPost.setAuthorizationContext(host.getSystemAuthorizationContext());
        host.startService(onDemandPost, childService, op);
    }
}

