/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentSkipListMap;

public final class RoundRobinOperationQueue {
    private static final int INITIAL_CAPACITY = 256;
    private final NavigableMap<String, Queue<Operation>> queues = new ConcurrentSkipListMap<String, Queue<Operation>>();
    private String activeKey = "";
    private String description = "";
    private final int limit;
    private int totalCount;

    public RoundRobinOperationQueue(String description, int limit) {
        this.description = description;
        this.limit = limit;
    }

    public synchronized boolean offer(String key, Operation op) {
        if (key == null || op == null) {
            throw new IllegalArgumentException(String.format("key and operation are required (%s)", this.description));
        }
        if (this.totalCount >= this.limit) {
            op.setStatusCode(503);
            op.fail(new CancellationException(String.format("Limit for queue %s exceeded: %d", this.description, this.limit)));
            return false;
        }
        Queue q = this.queues.computeIfAbsent(key, this::makeQueue);
        q.offer(op);
        ++this.totalCount;
        return true;
    }

    private Queue<Operation> makeQueue(String key) {
        return new ArrayDeque<Operation>(256);
    }

    public synchronized Operation poll() {
        while (!this.queues.isEmpty()) {
            Map.Entry<String, Queue<Operation>> nextActive = this.queues.higherEntry(this.activeKey);
            if (nextActive == null) {
                nextActive = this.queues.firstEntry();
            }
            this.activeKey = nextActive.getKey();
            Operation op = nextActive.getValue().poll();
            if (op != null) {
                --this.totalCount;
                return op;
            }
            this.queues.remove(nextActive.getKey());
        }
        return null;
    }

    public boolean isEmpty() {
        return this.queues.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> sizesByKey() {
        HashMap<String, Integer> sizes = new HashMap<String, Integer>();
        RoundRobinOperationQueue roundRobinOperationQueue = this;
        synchronized (roundRobinOperationQueue) {
            for (Map.Entry queueEntry : this.queues.entrySet()) {
                sizes.put((String)queueEntry.getKey(), ((Queue)queueEntry.getValue()).size());
            }
        }
        return sizes;
    }
}

