/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class OperationTracker {
    private ServiceHost host;
    private final SortedSet<Operation> pendingStartOperations = OperationTracker.createOperationSet();
    private final ConcurrentHashMap<String, SortedSet<Operation>> pendingServiceStartCompletions = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SortedSet<Operation>> pendingServiceAvailableCompletions = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Operation> pendingOperationsForRetry = new ConcurrentHashMap();

    private static ConcurrentSkipListSet<Operation> createOperationSet() {
        return new ConcurrentSkipListSet<Operation>(Comparator.comparingLong(Operation::getId));
    }

    public static OperationTracker create(ServiceHost host) {
        OperationTracker omt = new OperationTracker();
        omt.host = host;
        return omt;
    }

    public void trackOperationForRetry(long expirationMicros, Throwable e, Operation op) {
        this.host.log(Level.WARNING, "Retrying id %d to %s (retries: %d). Failure: %s", op.getId(), op.getUri(), op.getRetryCount(), e.toString());
        op.incrementRetryCount();
        this.pendingOperationsForRetry.put(expirationMicros, op);
    }

    public void trackStartOperation(Operation op) {
        this.pendingStartOperations.add(op);
    }

    public void removeStartOperation(Operation post) {
        this.pendingStartOperations.remove(post);
    }

    public void trackServiceStartCompletion(String link, Operation op) {
        this.pendingServiceStartCompletions.compute(link, (k, pendingOps) -> {
            if (pendingOps == null) {
                pendingOps = OperationTracker.createOperationSet();
            }
            pendingOps.add(op);
            return pendingOps;
        });
    }

    public SortedSet<Operation> removeServiceStartCompletions(String link) {
        return this.pendingServiceStartCompletions.remove(link);
    }

    public void trackServiceAvailableCompletion(String link, Operation opTemplate, boolean doOpClone) {
        Operation op = doOpClone ? opTemplate.clone() : opTemplate;
        this.pendingServiceAvailableCompletions.compute(link, (k, pendingOps) -> {
            if (pendingOps == null) {
                pendingOps = OperationTracker.createOperationSet();
            }
            pendingOps.add(op);
            return pendingOps;
        });
    }

    public boolean hasPendingServiceAvailableCompletions(String link) {
        return this.pendingServiceAvailableCompletions.containsKey(link);
    }

    public SortedSet<Operation> removeServiceAvailableCompletions(String link) {
        return this.pendingServiceAvailableCompletions.remove(link);
    }

    public void performMaintenance(long nowMicros) {
        Iterator<Operation> it;
        Service s;
        SortedSet<Operation> pendingOps;
        String link;
        Iterator<Operation> startOpsIt = this.pendingStartOperations.iterator();
        this.checkOperationExpiration(nowMicros, startOpsIt);
        for (Map.Entry<String, SortedSet<Operation>> entry : this.pendingServiceStartCompletions.entrySet()) {
            link = entry.getKey();
            pendingOps = entry.getValue();
            s = this.host.findService(link, true);
            if (s != null && s.getProcessingStage() == Service.ProcessingStage.AVAILABLE) {
                this.host.log(Level.WARNING, "Service %s available, but has pending start operations", link);
                this.processPendingServiceStartOperations(link, Service.ProcessingStage.AVAILABLE, s);
                continue;
            }
            if (s == null || s.getProcessingStage() == Service.ProcessingStage.STOPPED) {
                this.host.log(Level.WARNING, "Service %s has stopped, but has pending start operations", link);
                this.processPendingServiceStartOperations(link, Service.ProcessingStage.STOPPED, null);
                continue;
            }
            it = pendingOps.iterator();
            this.checkOperationExpiration(nowMicros, it);
        }
        for (Map.Entry<String, SortedSet<Operation>> entry : this.pendingServiceAvailableCompletions.entrySet()) {
            link = entry.getKey();
            pendingOps = entry.getValue();
            s = this.host.findService(link, true);
            if (s != null && s.getProcessingStage() == Service.ProcessingStage.AVAILABLE) {
                this.host.log(Level.WARNING, "Service %s available, but has pending start operations", link);
                this.host.processPendingServiceAvailableOperations(s, null, false);
                continue;
            }
            it = pendingOps.iterator();
            this.checkOperationExpiration(nowMicros, it);
        }
        long intervalMicros = TimeUnit.SECONDS.toMicros(1L);
        Iterator<Map.Entry<Long, Operation>> it2 = this.pendingOperationsForRetry.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry<Long, Operation> entry = it2.next();
            Operation o = entry.getValue();
            if (this.host.isStopping()) {
                o.fail(new CancellationException("Host is stopping"));
                return;
            }
            long queuingTimeMicros = entry.getKey();
            long estimatedRetryTimeMicros = (long)o.getRetryCount() * intervalMicros + queuingTimeMicros;
            if (estimatedRetryTimeMicros > nowMicros) continue;
            it2.remove();
            this.host.handleRequest(null, o);
        }
    }

    private void checkOperationExpiration(long now, Iterator<Operation> iterator) {
        Operation op;
        while (iterator.hasNext() && (op = iterator.next()) != null && op.getExpirationMicrosUtc() <= now) {
            iterator.remove();
            this.host.run(() -> op.fail(new TimeoutException(op.toString())));
        }
    }

    void processPendingServiceStartOperations(String link, Service.ProcessingStage processingStage, Service s) {
        SortedSet<Operation> ops = this.removeServiceStartCompletions(link);
        if (ops == null || ops.isEmpty()) {
            return;
        }
        for (Operation op : ops) {
            if (processingStage == Service.ProcessingStage.AVAILABLE) {
                this.host.run(() -> {
                    if (op.getUri() == null) {
                        op.setUri(s.getUri());
                    }
                    if (op.hasPragmaDirective("xn-post-to-put")) {
                        this.host.restoreActionOnChildServiceToPostOnFactory(link, op);
                    }
                    op.complete();
                });
                continue;
            }
            this.host.run(() -> op.fail(new IllegalStateException(op.toString())));
        }
    }

    public void close() {
        for (Operation operation : this.pendingOperationsForRetry.values()) {
            operation.fail(new CancellationException("Operation tracker is closing"));
        }
        this.pendingOperationsForRetry.clear();
        for (Operation operation : this.pendingStartOperations) {
            operation.fail(new CancellationException("Operation tracker is closing"));
        }
        this.pendingStartOperations.clear();
        for (SortedSet sortedSet : this.pendingServiceStartCompletions.values()) {
            for (Operation op : sortedSet) {
                op.fail(new CancellationException("Operation tracker is closing"));
            }
        }
        this.pendingServiceStartCompletions.clear();
        for (SortedSet sortedSet : this.pendingServiceAvailableCompletions.values()) {
            for (Operation op : sortedSet) {
                op.fail(new CancellationException("Operation tracker is closing"));
            }
        }
        this.pendingServiceAvailableCompletions.clear();
    }
}

