/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final String LOG_DATE_FIRST_PROPERTY = "xenon.LogFormatter.LOG_DATE_FIRST";
    private static final String LOG_DATE_FIRST_DEFAULT = Boolean.FALSE.toString();
    private static boolean LOG_DATE_FIRST = Boolean.valueOf(System.getProperty("xenon.LogFormatter.LOG_DATE_FIRST", LOG_DATE_FIRST_DEFAULT));
    private static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static void formatTimestampMillisTo(long millis, Appendable appendable) {
        long seconds = millis / 1000L;
        int nanos = (int)(millis % 1000L) * 1000000;
        DEFAULT_FORMAT.formatTo(LocalDateTime.ofEpochSecond(seconds, nanos, ZoneOffset.UTC), appendable);
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder(LogItem.create(record).toString());
        sb.append('\n');
        return sb.toString();
    }

    public static class LogItem {
        public String l;
        public long id;
        public long t;
        public int threadId;
        public String m;
        public String method;
        public String classOrUri;
        public Throwable thrown;

        public static LogItem create(LogRecord source) {
            LogItem sr = new LogItem();
            sr.l = source.getLevel().toString();
            sr.t = source.getMillis();
            sr.id = source.getSequenceNumber();
            sr.threadId = source.getThreadID();
            sr.m = source.getMessage();
            sr.method = source.getSourceMethodName();
            sr.classOrUri = source.getSourceClassName();
            sr.thrown = source.getThrown();
            if (sr.classOrUri == null) {
                sr.classOrUri = "";
            } else if (sr.classOrUri.startsWith("http")) {
                int findPathFromIndex = 8;
                int pathIndex = sr.classOrUri.indexOf(47, 8);
                int portIndex = sr.classOrUri.lastIndexOf(58, pathIndex == -1 ? Integer.MAX_VALUE : pathIndex);
                sr.classOrUri = sr.classOrUri.substring(portIndex + 1);
            } else {
                int simpleNameIndex = sr.classOrUri.lastIndexOf(46);
                if (simpleNameIndex != -1) {
                    sr.classOrUri = sr.classOrUri.substring(simpleNameIndex + 1);
                }
            }
            return sr;
        }

        public String toString() {
            int mLen = this.m == null ? 0 : this.m.length();
            StringBuilder sb = new StringBuilder(128 + mLen);
            if (LOG_DATE_FIRST) {
                LogFormatter.formatTimestampMillisTo(this.t, sb);
            }
            sb.append('[').append(this.id).append(']');
            sb.append('[').append(this.l.charAt(0)).append(']');
            if (!LOG_DATE_FIRST) {
                sb.append('[');
                LogFormatter.formatTimestampMillisTo(this.t, sb);
                sb.append(']');
            }
            sb.append('[').append(this.threadId).append(']');
            sb.append('[').append(this.classOrUri).append(']');
            sb.append('[').append(this.method).append(']');
            sb.append('[');
            if (mLen > 0) {
                sb.append(this.m);
            }
            sb.append(']');
            if (this.thrown != null) {
                sb.append('[');
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                this.thrown.printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
                sb.append(']');
            }
            return sb.toString();
        }
    }
}

