/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.AuthUtils;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.services.common.authn.BasicAuthenticationUtils;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class AuthenticationFilter
implements OperationProcessingChain.Filter {
    @Override
    public OperationProcessingChain.FilterReturnCode processRequest(Operation op, OperationProcessingChain.OperationProcessingContext context) {
        if (!context.getHost().isAuthorizationEnabled()) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        if (op.getAuthorizationContext() != null) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        if (BasicAuthenticationUtils.getAuthToken(op) != null) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        URI authServiceUri = context.getHost().getAuthenticationServiceUri();
        if (authServiceUri != null && authServiceUri.getPath().equals(op.getUri().getPath())) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        URI basicAuthServiceUri = context.getHost().getBasicAuthenticationServiceUri();
        if (basicAuthServiceUri != null && basicAuthServiceUri.getPath().equals(op.getUri().getPath())) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        Service authnService = context.getHost().getAuthenticationService();
        long dispatchTime = System.nanoTime();
        op.nestCompletion((o, e) -> {
            if (authnService.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                long dispatchDuration = System.nanoTime() - dispatchTime;
                AuthUtils.setAuthDurationStat(authnService, "authenticationDurationMicros", TimeUnit.NANOSECONDS.toMicros(dispatchDuration));
            }
            if (e != null) {
                context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, e);
                op.setBodyNoCloning(o.getBodyRaw()).setStatusCode(o.getStatusCode()).fail(e);
                return;
            }
            if (o.getStatusCode() != 200) {
                context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, new SecurityException());
                op.setBodyNoCloning(o.getBodyRaw()).setStatusCode(o.getStatusCode()).complete();
                return;
            }
            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING, null);
        });
        context.setSuspendConsumer(o -> context.getHost().queueOrScheduleRequest(authnService, op));
        return OperationProcessingChain.FilterReturnCode.SUSPEND_PROCESSING;
    }
}

