/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common.authn;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.AuthCredentialsService;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.UserService;
import com.vmware.xenon.services.common.authn.AuthenticationRequest;
import com.vmware.xenon.services.common.authn.BasicAuthenticationUtils;
import java.util.concurrent.TimeUnit;

public class BasicAuthenticationService
extends StatelessService {
    public static final String SELF_LINK = ServiceUriPaths.CORE_AUTHN_BASIC;
    public static final String AUTH_TOKEN_EXPIRATION_MICROS_PROPERTY = "xenon.BasicAuthenticationService.AUTH_TOKEN_EXPIRATION_SECONDS";
    public static final String UPPER_SESSION_LIMIT_SECONDS_PROPERTY = "xenon.BasicAuthenticationService.UPPER_SESSION_LIMIT_SECONDS";
    static final long AUTH_TOKEN_EXPIRATION_SECONDS = Long.getLong("xenon.BasicAuthenticationService.AUTH_TOKEN_EXPIRATION_SECONDS", TimeUnit.HOURS.toSeconds(1L));
    private final Long UPPER_SESSION_LIMIT_SECONDS = Long.getLong("xenon.BasicAuthenticationService.UPPER_SESSION_LIMIT_SECONDS");

    public BasicAuthenticationService() {
        this.toggleOption(Service.ServiceOption.CORE, true);
        this.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public boolean queueRequest(Operation op) {
        if (this.getSelfLink().equals(op.getUri().getPath())) {
            return false;
        }
        op.complete();
        return true;
    }

    @Override
    public void handlePost(Operation op) {
        if (op.hasPragmaDirective("xn-verify-token")) {
            BasicAuthenticationUtils.handleTokenVerify(this, op);
            op.removePragmaDirective("xn-verify-token");
            return;
        }
        AuthenticationRequest authRequest = op.getBody(AuthenticationRequest.class);
        if (authRequest.requestType == null) {
            authRequest.requestType = AuthenticationRequest.AuthenticationRequestType.LOGIN;
        }
        switch (authRequest.requestType) {
            case LOGIN: {
                String[] userNameAndPassword = BasicAuthenticationUtils.parseRequest(this, op);
                if (userNameAndPassword == null) {
                    return;
                }
                BasicAuthenticationUtils.BasicAuthenticationContext authContext = new BasicAuthenticationUtils.BasicAuthenticationContext();
                authContext.userQuery = QueryTask.Query.Builder.create().addKindFieldClause(UserService.UserState.class).addFieldClause("email", userNameAndPassword[0]).build();
                authContext.authQuery = QueryTask.Query.Builder.create().addKindFieldClause(AuthCredentialsService.AuthCredentialsServiceState.class).addFieldClause("userEmail", userNameAndPassword[0]).addFieldClause("privateKey", userNameAndPassword[1]).build();
                BasicAuthenticationUtils.handleLogin(this, op, authContext, this.getExpirationTime(authRequest));
                break;
            }
            case LOGOUT: {
                BasicAuthenticationUtils.handleLogout(this, op);
                break;
            }
        }
    }

    protected long getExpirationTime(AuthenticationRequest authRequest) {
        long expirationTimeSeconds;
        long l = expirationTimeSeconds = authRequest.sessionExpirationSeconds != null ? authRequest.sessionExpirationSeconds : AUTH_TOKEN_EXPIRATION_SECONDS;
        if (this.UPPER_SESSION_LIMIT_SECONDS != null && expirationTimeSeconds > this.UPPER_SESSION_LIMIT_SECONDS) {
            expirationTimeSeconds = this.UPPER_SESSION_LIMIT_SECONDS;
        }
        return Utils.fromNowMicrosUtc(TimeUnit.SECONDS.toMicros(expirationTimeSeconds));
    }
}

