/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.DeferredResult;
import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.NodeSelectorState;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceConfiguration;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.SynchronizationTaskService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.SynchronizationRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;

public class SynchronizationManagementService
extends StatelessService {
    public static final String SELF_LINK = "/core/management/synch";
    public static final EnumSet<Service.ServiceOption> FACTORY_SERVICE_OPTION = EnumSet.of(Service.ServiceOption.FACTORY);

    @Override
    public void handlePatch(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        SynchronizationRequest synchRequest = op.getBody(SynchronizationRequest.class);
        if (synchRequest.kind == null || !synchRequest.kind.equals(Utils.buildKind(SynchronizationRequest.class))) {
            op.fail(new IllegalArgumentException(String.format("Invalid 'kind' in the request body", new Object[0])));
            return;
        }
        if (synchRequest.documentSelfLink == null || synchRequest.documentSelfLink.isEmpty()) {
            op.fail(new IllegalArgumentException(String.format("%s cannot be null or empty", "documentSelfLink")));
            return;
        }
        URI uri = UriUtils.buildUri(this.getHost(), synchRequest.documentSelfLink);
        uri = UriUtils.buildConfigUri(uri);
        Operation.createGet(uri).setCompletion((o, e) -> {
            if (e != null) {
                op.setBody(o.getBodyRaw());
                op.fail(e);
                return;
            }
            String peerNodeSelectorPath = o.getBody(ServiceConfiguration.class).peerNodeSelectorPath;
            this.sendSynchronizationRequest(synchRequest.documentSelfLink, peerNodeSelectorPath, synchRequest, op);
        }).sendWith(this);
    }

    @Override
    public void handleGet(Operation get) {
        Operation operation = Operation.createGet(null).setCompletion((o, e) -> {
            if (e != null) {
                get.setBody(o.getBodyRaw());
                get.complete();
                return;
            }
            String queryFactory = null;
            Map<String, String> queryParams = UriUtils.parseUriQueryParams(get.getUri());
            if (queryParams.size() > 0) {
                queryFactory = queryParams.get("documentSelfLink");
            }
            ArrayList<Operation> configGets = new ArrayList<Operation>();
            ServiceDocumentQueryResult result = new ServiceDocumentQueryResult();
            result.documents = new HashMap<String, Object>();
            ServiceDocumentQueryResult factories = o.getBody(ServiceDocumentQueryResult.class);
            for (String factorySelfLink : factories.documentLinks) {
                if (queryFactory != null && !queryFactory.equals(factorySelfLink)) continue;
                URI configUri = UriUtils.buildConfigUri(this.getHost(), factorySelfLink);
                result.documents.put(factorySelfLink, new SynchronizationManagementState());
                Operation configGet = Operation.createGet(configUri);
                configGets.add(configGet);
            }
            if (configGets.isEmpty()) {
                get.fail(new IllegalArgumentException(String.format("Factory %s cannot be found", queryFactory)));
                return;
            }
            OperationJoin.JoinedCompletionHandler joinedCompletion = (os, fs) -> {
                ArrayList factoryStatuses = new ArrayList();
                for (Operation op : os.values()) {
                    if (op.getErrorResponseBody() != null) continue;
                    String factorySelfLink = UriUtils.getParentPath(op.getUri().getPath());
                    String peerNodeSelectorPath = op.getBody(ServiceConfiguration.class).peerNodeSelectorPath;
                    DeferredResult<Object> factoryStatus = this.getFactoryStatus(factorySelfLink, result, peerNodeSelectorPath);
                    factoryStatuses.add(factoryStatus);
                }
                DeferredResult.allOf(factoryStatuses).thenApply(this.packAndReturnResults(get, result));
            };
            OperationJoin.create(configGets).setCompletion(joinedCompletion).sendWith(this);
        });
        this.getHost().queryServiceUris(FACTORY_SERVICE_OPTION, true, operation, null);
    }

    private DeferredResult<Object> sendSynchronizationRequest(String factoryLink, String selectorPath, SynchronizationRequest synchRequest, Operation op) {
        DeferredResult<Object> factoryStatus = new DeferredResult<Object>();
        URI nodeSelectorUri = UriUtils.buildUri(this.getHost(), selectorPath);
        NodeSelectorService.SelectAndForwardRequest req = new NodeSelectorService.SelectAndForwardRequest();
        req.key = factoryLink;
        Operation selectorPost = Operation.createPost(nodeSelectorUri).setReferer(this.getUri()).setBodyNoCloning(req);
        Operation factorySynchPost = Operation.createPatch(null).setBody(synchRequest).setReferer(this.getUri());
        DeferredResult.allOf(this.getNodeSelectorAvailability(selectorPost, factoryStatus)).thenCompose(a -> this.getFactoryOwnerFromNodeSelector(selectorPost, factorySynchPost, factorySynchPost)).thenAccept(a -> this.sendSynchronizationRequest(factoryLink, factorySynchPost, op));
        return factoryStatus;
    }

    private void sendSynchronizationRequest(String factoryLink, Operation factorySynchPost, Operation op) {
        URI uri = UriUtils.buildUri(factorySynchPost.getUri(), factoryLink);
        uri = UriUtils.extendUri(uri, "/synchronization");
        factorySynchPost.setUri(uri);
        factorySynchPost.setCompletion((o, e) -> {
            if (e != null) {
                this.log(Level.WARNING, "Failed to start factory synchronization: %s", e);
                op.fail(e);
                return;
            }
            op.setBody(o.getBodyRaw());
            op.complete();
        }).sendWith(this);
    }

    private DeferredResult<Object> getFactoryStatus(String factoryLink, ServiceDocumentQueryResult result, String selectorPath) {
        DeferredResult<Object> factoryStatus = new DeferredResult<Object>();
        URI nodeSelectorUri = UriUtils.buildUri(this.getHost(), selectorPath);
        NodeSelectorService.SelectAndForwardRequest req = new NodeSelectorService.SelectAndForwardRequest();
        req.key = factoryLink;
        Operation selectorPost = Operation.createPost(nodeSelectorUri).setReferer(this.getUri()).setBodyNoCloning(req);
        Operation synchGets = Operation.createGet(null).setReferer(this.getUri());
        Operation factoryStatGets = Operation.createGet(null).setReferer(this.getUri());
        DeferredResult.allOf(this.getNodeSelectorAvailability(selectorPost, factoryStatus)).thenCompose(a -> this.getFactoryOwnerFromNodeSelector(selectorPost, synchGets, factoryStatGets)).thenCompose(a -> this.getFactoryAvailability(result, factoryStatGets)).thenCompose(a -> this.getSynchronizationTaskStatus(result, synchGets, factoryStatus));
        return factoryStatus;
    }

    private Function<? super List<Object>, Object> packAndReturnResults(Operation get, ServiceDocumentQueryResult result) {
        return a -> {
            result.documentOwner = this.getHost().getId();
            result.documentCount = result.documents.size();
            result.documentLinks = new ArrayList<String>(result.documents.keySet());
            Collections.sort(result.documentLinks);
            get.setBodyNoCloning(result);
            get.complete();
            return null;
        };
    }

    private DeferredResult<Object> getSynchronizationTaskStatus(ServiceDocumentQueryResult result, Operation synchTaskGet, DeferredResult<Object> factoryStatus) {
        DeferredResult<Object> synchronizationTask = new DeferredResult<Object>();
        synchTaskGet.setCompletion((o, e) -> {
            if (e != null) {
                this.log(Level.WARNING, "Failed to GET synchronization task status: %s", e);
                synchronizationTask.complete(null);
                factoryStatus.complete(null);
                return;
            }
            SynchronizationTaskService.State s = o.getBody(SynchronizationTaskService.State.class);
            SynchronizationManagementState factoryState = (SynchronizationManagementState)result.documents.get(s.factorySelfLink);
            if (s.taskInfo.stage == TaskState.TaskStage.STARTED && factoryState.status.equals((Object)SynchronizationManagementState.Status.UNAVAILABLE)) {
                factoryState.status = SynchronizationManagementState.Status.SYNCHRONIZING;
            }
            synchronizationTask.complete(null);
            factoryStatus.complete(null);
        }).sendWith(this);
        return synchronizationTask;
    }

    private DeferredResult<Object> getFactoryAvailability(ServiceDocumentQueryResult result, Operation factoryStatGet) {
        DeferredResult<Object> factoryStats = new DeferredResult<Object>();
        factoryStatGet.setCompletion((o, e) -> {
            if (e != null) {
                this.log(Level.WARNING, "Failed to GET factory stats: %s", e);
                factoryStats.complete(null);
                return;
            }
            ServiceStats s = o.getBody(ServiceStats.class);
            SynchronizationManagementState factoryState = (SynchronizationManagementState)result.documents.get(UriUtils.getParentPath(s.documentSelfLink));
            ServiceStats.ServiceStat availableStat = s.entries.get("isAvailable");
            factoryState.owner = s.documentOwner;
            factoryState.status = SynchronizationManagementState.Status.UNAVAILABLE;
            if (availableStat != null && availableStat.latestValue == 1.0) {
                factoryState.status = SynchronizationManagementState.Status.AVAILABLE;
            }
            factoryStats.complete(null);
        }).sendWith(this);
        return factoryStats;
    }

    private DeferredResult<Object> getFactoryOwnerFromNodeSelector(Operation selectPost, Operation synchGet, Operation factoryStatGet) {
        DeferredResult<Object> findSelector = new DeferredResult<Object>();
        selectPost.setCompletion((o, e) -> {
            if (e != null) {
                this.log(Level.WARNING, "Failed to GET node selector: %s", e);
                findSelector.complete(null);
                return;
            }
            NodeSelectorService.SelectOwnerResponse selectRsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            String synchTaskLink = UriUtils.buildUriPath("/core/synch-tasks", UriUtils.convertPathCharsFromLink(selectRsp.key));
            URI synchTaskOwnerUri = UriUtils.buildUri(selectRsp.ownerNodeGroupReference, synchTaskLink);
            URI factoryStatOwnerUri = UriUtils.buildStatsUri(UriUtils.buildUri(selectRsp.ownerNodeGroupReference, selectRsp.key));
            synchGet.setUri(synchTaskOwnerUri);
            factoryStatGet.setUri(factoryStatOwnerUri);
            findSelector.complete(null);
        }).sendWith(this);
        return findSelector;
    }

    private DeferredResult<Object> getNodeSelectorAvailability(Operation selectPost, DeferredResult<Object> factoryStatus) {
        DeferredResult<Object> findSelector = new DeferredResult<Object>();
        Operation selectorGet = Operation.createGet(selectPost.getUri()).setReferer(this.getUri());
        selectorGet.setCompletion((o, e) -> {
            if (e != null) {
                String message = "Failed to GET node selector: " + e;
                this.log(Level.WARNING, message, new Object[0]);
                findSelector.fail(new Throwable(message));
                factoryStatus.complete(null);
                return;
            }
            NodeSelectorState selectorRsp = o.getBody(NodeSelectorState.class);
            if (selectorRsp.status != NodeSelectorState.Status.AVAILABLE) {
                findSelector.fail(new Throwable("Node selector status: " + (Object)((Object)selectorRsp.status)));
                factoryStatus.complete(null);
                return;
            }
            findSelector.complete(null);
        }).sendWith(this);
        return findSelector;
    }

    public static class SynchronizationManagementState {
        public Status status = Status.UNAVAILABLE;
        public String owner;

        public static enum Status {
            AVAILABLE,
            UNAVAILABLE,
            SYNCHRONIZING;

        }
    }
}

