/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.RequestRouter;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStatUtils;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.OperationIndexService;
import java.net.URI;
import java.util.EnumSet;
import java.util.logging.Level;

public class ServiceHostManagementService
extends StatefulService {
    public static final String SELF_LINK = UriUtils.buildUriPath("/core/management");
    public static final String STAT_NAME_AVAILABLE_MEMORY_BYTES_PREFIX = "availableMemoryBytes";
    public static final String STAT_NAME_AVAILABLE_MEMORY_BYTES_PER_DAY = "availableMemoryBytesPerDay";
    public static final String STAT_NAME_AVAILABLE_MEMORY_BYTES_PER_HOUR = "availableMemoryBytesPerHour";
    public static final String STAT_NAME_AVAILABLE_DISK_BYTES_PREFIX = "availableDiskByte";
    public static final String STAT_NAME_AVAILABLE_DISK_BYTES_PER_DAY = "availableDiskBytePerDay";
    public static final String STAT_NAME_AVAILABLE_DISK_BYTES_PER_HOUR = "availableDiskBytePerHour";
    public static final String STAT_NAME_CPU_USAGE_PCT_PREFIX = "cpuUsagePercent";
    public static final String STAT_NAME_CPU_USAGE_PCT_PER_DAY = "cpuUsagePercentPerDay";
    public static final String STAT_NAME_CPU_USAGE_PCT_PER_HOUR = "cpuUsagePercentPerHour";
    public static final String STAT_NAME_THREAD_COUNT = "threadCount";
    public static final String STAT_NAME_JVM_THREAD_COUNT_PREFIX = "jvmThreadCount";
    public static final String STAT_NAME_JVM_THREAD_COUNT_PER_DAY = "jvmThreadCountPerDay";
    public static final String STAT_NAME_JVM_THREAD_COUNT_PER_HOUR = "jvmThreadCountPerHour";
    public static final String STAT_NAME_HTTP11_CONNECTION_COUNT_PREFIX = "http11ConnectionCount";
    public static final String STAT_NAME_HTTP11_CONNECTION_COUNT_PER_DAY = "http11ConnectionCountPerDay";
    public static final String STAT_NAME_HTTP11_CONNECTION_COUNT_PER_HOUR = "http11ConnectionCountPerHour";
    public static final String STAT_NAME_HTTP2_CONNECTION_COUNT_PREFIX = "http2ConnectionCount";
    public static final String STAT_NAME_HTTP2_CONNECTION_COUNT_PER_DAY = "http2ConnectionCountPerDay";
    public static final String STAT_NAME_HTTP2_CONNECTION_COUNT_PER_HOUR = "http2ConnectionCountPerHour";
    public static final String STAT_NAME_HTTP11_PENDING_OP_COUNT_PREFIX = "http11PendingOperationCount";
    public static final String STAT_NAME_HTTP11_PENDING_OP_COUNT_PER_DAY = "http11PendingOperationCountPerDay";
    public static final String STAT_NAME_HTTP11_PENDING_OP_COUNT_PER_HOUR = "http11PendingOperationCountPerHour";
    public static final String STAT_NAME_HTTP2_PENDING_OP_COUNT_PREFIX = "http2PendingOperationCount";
    public static final String STAT_NAME_HTTP2_PENDING_OP_COUNT_PER_DAY = "http2PendingOperationCountPerDay";
    public static final String STAT_NAME_HTTP2_PENDING_OP_COUNT_PER_HOUR = "http2PendingOperationCountPerHour";
    public static final String STAT_NAME_HTTP11_AVAILABLE_CONNECTION_COUNT_PREFIX = "http11AvailableConnectionCount";
    public static final String STAT_NAME_HTTP11_AVAILABLE_CONNECTION_COUNT_PER_DAY = "http11AvailableConnectionCountPerDay";
    public static final String STAT_NAME_HTTP11_AVAILABLE_CONNECTION_COUNT_PER_HOUR = "http11AvailableConnectionCountPerHour";
    public static final String STAT_NAME_HTTP2_AVAILABLE_CONNECTION_COUNT_PREFIX = "http2AvailableConnectionCount";
    public static final String STAT_NAME_HTTP2_AVAILABLE_CONNECTION_COUNT_PER_DAY = "http2AvailableConnectionCountPerDay";
    public static final String STAT_NAME_HTTP2_AVAILABLE_CONNECTION_COUNT_PER_HOUR = "http2AvailableConnectionCountPerHour";
    public static final String STAT_NAME_EXECUTOR_QUEUE_DEPTH = "executorQueueDepth";
    public static final String STAT_NAME_SCHEDULED_EXECUTOR_QUEUE_DEPTH = "scheduledExecutorQueueDepth";
    public static final String STAT_NAME_SERVICE_COUNT = "serviceCount";
    public static final String STAT_NAME_SERVICE_CACHE_CLEAR_COUNT = "serviceCacheClearCount";
    public static final String STAT_NAME_SERVICE_CACHE_MISS_COUNT = "serviceCacheMissCount";
    public static final String STAT_NAME_SERVICE_CACHE_HIT_COUNT = "serviceCacheHitCount";
    public static final String STAT_NAME_RATE_LIMITED_OP_COUNT = "rateLimitedOperationCount";
    public static final String STAT_NAME_PENDING_SERVICE_DELETION_COUNT = "pendingServiceDeletionCount";
    public static final String STAT_NAME_AUTO_BACKUP_SKIPPED_COUNT = "autoBackupSkippedCount";
    public static final String STAT_NAME_AUTO_BACKUP_PERFORMED_COUNT = "autoBackupPerformedCount";
    public static final String STAT_NAME_AUTO_BACKUP_FAILED_COUNT = "autoBackupFailedCount";
    public static final String STAT_NAME_AUTHORIZATION_CACHE_SIZE = "authorizationCacheSize";
    public static final String STAT_NAME_AUTHORIZATION_CACHE_INSERT_COUNT = "authorizationCacheInsertCount";

    public ServiceHostManagementService() {
        super(ServiceHost.ServiceHostState.class);
        super.toggleOption(Service.ServiceOption.CORE, true);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
    }

    @Override
    public void handleStart(Operation post) {
        this.initializeStats();
        post.complete();
    }

    private void initializeStats() {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        ServiceStatUtils.getOrCreateHourlyTimeSeriesStat(this, STAT_NAME_AUTO_BACKUP_PERFORMED_COUNT, EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.SUM));
        ServiceStatUtils.getOrCreateDailyTimeSeriesStat(this, STAT_NAME_AUTO_BACKUP_PERFORMED_COUNT, EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.SUM));
        ServiceStatUtils.getOrCreateHourlyTimeSeriesStat(this, STAT_NAME_AUTO_BACKUP_SKIPPED_COUNT, EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.SUM));
        ServiceStatUtils.getOrCreateDailyTimeSeriesStat(this, STAT_NAME_AUTO_BACKUP_SKIPPED_COUNT, EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.SUM));
    }

    @Override
    @RequestRouter.Route.RouteDocumentation(description="Describe this host.", responses={@RequestRouter.Route.RouteDocumentation.ApiResponse(statusCode=200, description="OK", response=ServiceHost.ServiceHostState.class)})
    public void handleGet(Operation get) {
        this.getHost().updateSystemInfo(false);
        ServiceHost.ServiceHostState s = this.getHost().getState();
        s.documentSelfLink = this.getSelfLink();
        s.documentKind = Utils.buildKind(ServiceHost.ServiceHostState.class);
        s.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        get.setBody(s).complete();
    }

    @Override
    public void handlePatch(Operation patch) {
        try {
            if (!patch.hasBody()) {
                throw new IllegalArgumentException("empty body");
            }
            BaseManagementServiceRequest request = patch.getBody(BaseManagementServiceRequest.class);
            if (request.kind == null || request.kind.equals("")) {
                throw new IllegalArgumentException("kind is required");
            }
            if (request.kind.equals(ConfigureOperationTracingRequest.KIND)) {
                ConfigureOperationTracingRequest tr = patch.getBody(ConfigureOperationTracingRequest.class);
                this.handleOperationTracingRequest(tr, patch);
                return;
            }
            if (request.kind.equals(ConfigureInboundRequestLogging.KIND)) {
                ConfigureInboundRequestLogging lr = patch.getBody(ConfigureInboundRequestLogging.class);
                this.handleConfigureInboundRequestLogging(lr, patch);
                return;
            }
            if (request.kind.equals(BackupRequest.KIND)) {
                BackupRequest br = patch.getBody(BackupRequest.class);
                this.handleBackupRequest(br, patch);
                return;
            }
            if (request.kind.equals(RestoreRequest.KIND)) {
                RestoreRequest rr = patch.getBody(RestoreRequest.class);
                this.handleRestoreRequest(rr, patch);
                return;
            }
            if (request.kind.equals(SynchronizeWithPeersRequest.KIND)) {
                SynchronizeWithPeersRequest sr = patch.getBody(SynchronizeWithPeersRequest.class);
                this.handleSynchronizeWithPeersRequest(sr, patch);
                return;
            }
            if (request.kind.equals(AutoBackupConfiguration.KIND)) {
                AutoBackupConfiguration autoBackupConfigRequest = patch.getBody(AutoBackupConfiguration.class);
                this.handleAutoBackupConfigRequest(autoBackupConfigRequest, patch);
                return;
            }
            throw new IllegalArgumentException("unknown request");
        }
        catch (Exception e) {
            patch.fail(e);
            return;
        }
    }

    @Override
    @RequestRouter.Route.RouteDocumentation(description="Shuts down this host. If the host is the process owner then the process is terminated with exit code 0.")
    public void handleDelete(Operation delete) {
        this.logInfo("Received shutdown request from %s", delete.getReferer());
        boolean isProcessOwner = this.getHost().isProcessOwner();
        delete.setStatusCode(202);
        delete.complete();
        this.getHost().stop();
        if (isProcessOwner) {
            System.exit(0);
        } else {
            this.logInfo("This host is NOT the process owner. Skipping System.exit()", new Object[0]);
        }
    }

    private void handleSynchronizeWithPeersRequest(SynchronizeWithPeersRequest rr, Operation patch) {
        if (rr.nodeSelectorPath == null) {
            patch.fail(new IllegalArgumentException("nodeSelectorPath is required"));
            return;
        }
        if (this.getHost().getServiceStage(rr.nodeSelectorPath) == null) {
            patch.fail(new IllegalArgumentException(rr.nodeSelectorPath + " is not started on this host"));
            return;
        }
        this.getHost().scheduleNodeGroupChangeMaintenance(rr.nodeSelectorPath);
        patch.complete();
    }

    private void handleOperationTracingRequest(ConfigureOperationTracingRequest req, Operation op) throws Exception {
        URI operationTracingServiceUri = UriUtils.buildUri(this.getHost(), "/core/operation-index");
        Operation.CompletionHandler serviceCompletion = (o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            boolean start = req.enable == OperationTracingEnable.START;
            this.logInfo("%s %s", start ? "Started" : "Stopped", operationTracingServiceUri.toString());
            Level level = start ? Level.ALL : Level.OFF;
            try {
                if (req.level != null) {
                    level = Level.parse(req.level);
                }
            }
            catch (Exception ex) {
                this.logSevere(ex);
            }
            this.getHost().setOperationTracingLevel(level);
            op.complete();
        };
        if (req.enable == OperationTracingEnable.START) {
            OperationIndexService operationService = new OperationIndexService();
            this.getHost().startService(Operation.createPost(operationTracingServiceUri).setCompletion(serviceCompletion), operationService);
        } else {
            this.sendRequest(Operation.createDelete(operationTracingServiceUri).setCompletion(serviceCompletion));
        }
    }

    private void handleConfigureInboundRequestLogging(ConfigureInboundRequestLogging request, Operation op) {
        if (request.loggingInfo == null) {
            op.fail(new IllegalArgumentException("loggingInfo is missing"));
            return;
        }
        this.getHost().setRequestLoggingInfo(request.loggingInfo);
        op.complete();
    }

    private void handleBackupRequest(BackupRequest req, Operation op) {
        String scheme;
        if (req.destination != null && ("http".equals(scheme = req.destination.getScheme()) || "https".equals(scheme))) {
            req.backupType = BackupType.STREAM;
        }
        this.sendPatchToBackupService(op, req.backupServiceLink, req);
    }

    private void handleRestoreRequest(RestoreRequest req, Operation op) {
        this.sendPatchToBackupService(op, req.backupServiceLink, req);
    }

    private void handleAutoBackupConfigRequest(AutoBackupConfiguration req, Operation op) {
        this.getHost().setAutoBackupEnabled(req.enable);
        this.logInfo("Auto Backup is %s", req.enable ? "enabled" : "disabled");
        op.complete();
    }

    private void sendPatchToBackupService(Operation op, String backupServiceLink, Object body) {
        Operation patch = Operation.createPatch(this, backupServiceLink).transferRequestHeadersFrom(op).transferRefererFrom(op).setExpiration(op.getExpirationMicrosUtc()).setBody(body).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.transferResponseHeadersFrom(o);
            op.setBodyNoCloning(o.getBodyRaw());
            op.complete();
        });
        this.sendRequest(patch);
    }

    public static class AutoBackupConfiguration
    extends BaseManagementServiceRequest {
        public static final String KIND = Utils.buildKind(AutoBackupConfiguration.class);
        public boolean enable;
    }

    public static class RestoreRequest
    extends BaseManagementServiceRequest {
        public static final String KIND = Utils.buildKind(RestoreRequest.class);
        public String bearer;
        public URI destination;
        public Long timeSnapshotBoundaryMicros;
        public String backupServiceLink = "/core/document-index-backup";
        public String indexServiceLink = "/core/document-index";
    }

    public static class BackupRequest
    extends BaseManagementServiceRequest {
        public static final String KIND = Utils.buildKind(BackupRequest.class);
        public String bearer;
        public URI destination;
        public BackupType backupType = BackupType.ZIP;
        public String indexServiceLink = "/core/document-index";
        public String backupServiceLink = "/core/document-index-backup";
    }

    public static enum BackupType {
        ZIP,
        DIRECTORY,
        STREAM;

    }

    public static class ConfigureInboundRequestLogging
    extends BaseManagementServiceRequest {
        public static final String KIND = Utils.buildKind(ConfigureInboundRequestLogging.class);
        public ServiceHost.RequestLoggingInfo loggingInfo;
    }

    public static class ConfigureOperationTracingRequest
    extends BaseManagementServiceRequest {
        public static final String KIND = Utils.buildKind(ConfigureOperationTracingRequest.class);
        public OperationTracingEnable enable = OperationTracingEnable.START;
        public String level;
    }

    public static class SynchronizeWithPeersRequest
    extends BaseManagementServiceRequest {
        public static final String KIND = Utils.buildKind(SynchronizeWithPeersRequest.class);
        public String nodeSelectorPath;

        public static SynchronizeWithPeersRequest create(String path) {
            SynchronizeWithPeersRequest r = new SynchronizeWithPeersRequest();
            r.kind = KIND;
            r.nodeSelectorPath = path;
            return r;
        }
    }

    private static class BaseManagementServiceRequest {
        public String kind;

        private BaseManagementServiceRequest() {
        }
    }

    public static enum OperationTracingEnable {
        START,
        STOP;

    }
}

