/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class NodeSelectorReplicationContext {
    String location;
    Collection<NodeState> nodes;
    Operation parentOp;
    int successThreshold;
    int failureThreshold;
    int locationThreshold;
    private int successCount;
    private int failureCount;
    private Set<String> locations;
    private int failureStatus;
    private List<Integer> failureErrorCodes;
    private Status completionStatus = Status.PENDING;

    public NodeSelectorReplicationContext(String location, Collection<NodeState> nodes, Operation op) {
        this.location = location;
        this.nodes = nodes;
        this.parentOp = op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndCompleteOperation(ServiceHost h, Throwable e, Operation o, String remoteLocation) {
        Status ct;
        String failureMsg = null;
        Operation op = this.parentOp;
        int errorCode = 0;
        if (e != null && o != null) {
            h.log(Level.WARNING, "(Original id: %d) Replication request to %s-%s failed with %d, %s", new Object[]{op.getId(), o.getUri(), o.getAction(), o.getStatusCode(), e.getMessage()});
            this.failureStatus = o.getStatusCode();
            errorCode = this.getErrorCode(o);
        }
        NodeSelectorReplicationContext nodeSelectorReplicationContext = this;
        synchronized (nodeSelectorReplicationContext) {
            this.saveErrorCode(errorCode);
            if (this.completionStatus != Status.PENDING) {
                return;
            }
            if (e == null && ++this.successCount == this.successThreshold) {
                this.completionStatus = Status.SUCCEEDED;
            } else if (e != null && ++this.failureCount == this.failureThreshold) {
                this.completionStatus = Status.FAILED;
                failureMsg = String.format("(Original id: %d) %s to %s failed. Success: %d,  Fail: %d, quorum: %d, failure threshold: %d", new Object[]{op.getId(), op.getAction(), op.getUri().getPath(), this.successCount, this.failureCount, this.successThreshold, this.failureThreshold});
            }
            if (remoteLocation != null) {
                if (this.locations == null) {
                    this.locations = new HashSet<String>();
                }
                this.locations.add(remoteLocation);
                if (this.successCount >= this.successThreshold) {
                    this.completionStatus = this.locations.size() < this.locationThreshold ? Status.PENDING : Status.SUCCEEDED;
                }
            }
            ct = this.completionStatus;
        }
        if (ct == Status.SUCCEEDED) {
            op.setStatusCode(200).complete();
            return;
        }
        if (ct == Status.FAILED) {
            h.log(Level.WARNING, "%s", failureMsg);
            op.setStatusCode(this.failureStatus);
            IllegalStateException ex = new IllegalStateException(failureMsg);
            ServiceErrorResponse sep = Utils.toServiceErrorResponse(ex);
            sep.statusCode = this.failureStatus;
            op.setBody(sep);
            op.fail(ex);
            return;
        }
    }

    private int getErrorCode(Operation o) {
        Object obj;
        if (o.hasBody() && o.getContentType().equals("application/json") && (obj = o.getBodyRaw()) instanceof ServiceErrorResponse) {
            ServiceErrorResponse rsp = (ServiceErrorResponse)obj;
            return rsp.getErrorCode();
        }
        return 0;
    }

    private void saveErrorCode(int errorCode) {
        if (errorCode == 0) {
            return;
        }
        if (this.failureErrorCodes == null) {
            this.failureErrorCodes = new ArrayList<Integer>();
        }
        this.failureErrorCodes.add(errorCode);
    }

    public static enum Status {
        SUCCEEDED,
        FAILED,
        PENDING;

    }
}

