/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.DeferredResult;
import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.NodeSelectorState;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceConfiguration;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.ServiceStatUtils;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeGroupUtils;
import com.vmware.xenon.services.common.NodeState;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MigrationTaskService
extends StatefulService {
    public static final String STAT_NAME_PROCESSED_DOCUMENTS = "processedServiceCount";
    public static final String STAT_NAME_ESTIMATED_TOTAL_SERVICE_COUNT = "estimatedTotalServiceCount";
    public static final String STAT_NAME_FETCHED_DOCUMENT_COUNT = "fetchedDocumentCount";
    public static final String STAT_NAME_BEFORE_TRANSFORM_COUNT = "beforeTransformDocumentCount";
    public static final String STAT_NAME_AFTER_TRANSFORM_COUNT = "afterTransformDocumentCount";
    public static final String STAT_NAME_DELETE_RETRY_COUNT = "deleteRetryCount";
    public static final String STAT_NAME_DELETED_DOCUMENT_COUNT = "deletedDocumentCount";
    public static final String STAT_NAME_COUNT_QUERY_TIME_DURATION_MICRO = "countQueryTimeDurationMicros";
    public static final String STAT_NAME_RETRIEVAL_OPERATIONS_DURATION_MICRO = "retrievalOperationsDurationMicros";
    public static final String STAT_NAME_RETRIEVAL_QUERY_TIME_DURATION_MICRO_FORMAT = "retrievalQueryTimeDurationMicros-%s";
    public static final String FACTORY_LINK = "/management/migration-tasks";
    private static final Integer DEFAULT_PAGE_SIZE = 10000;
    private static final Long DEFAULT_MAINTENANCE_INTERVAL_MILLIS = TimeUnit.MINUTES.toMicros(1L);
    private static final Integer DEFAULT_MAXIMUM_CONVERGENCE_CHECKS = 10;
    private static final Object DUMMY_OBJECT = new Object();

    public static Service createFactory() {
        FactoryService fs = FactoryService.create(MigrationTaskService.class, State.class, new Service.ServiceOption[0]);
        fs.toggleOption(Service.ServiceOption.IDEMPOTENT_POST, true);
        fs.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        return fs;
    }

    public MigrationTaskService() {
        super(State.class);
        super.toggleOption(Service.ServiceOption.CORE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
    }

    @Override
    public void handleStart(Operation startPost) {
        State initState = (State)this.getBody(startPost);
        this.logInfo("Starting migration with initState: %s", initState);
        initState = this.initialize(initState);
        if (TaskState.isFinished(initState.taskInfo)) {
            startPost.complete();
            return;
        }
        if (!this.verifyState(initState, startPost)) {
            return;
        }
        startPost.complete();
        State patchState = new State();
        if (initState.taskInfo == null) {
            patchState.taskInfo = TaskState.create();
        }
        if (initState.continuousMigration.booleanValue()) {
            this.setMaintenanceIntervalMicros(initState.maintenanceIntervalMicros);
        }
        if (initState.taskInfo.stage == TaskState.TaskStage.CANCELLED) {
            this.logInfo("In stage %s, will restart on next maintenance interval", new Object[]{initState.taskInfo.stage});
            return;
        }
        Operation.createPatch(this.getUri()).setBody(patchState).sendWith(this);
    }

    private State initialize(State initState) {
        if (initState.querySpec == null) {
            initState.querySpec = new QueryTask.QuerySpecification();
        }
        if (initState.querySpec.resultLimit == null) {
            initState.querySpec.resultLimit = DEFAULT_PAGE_SIZE;
        }
        initState.querySpec.options.addAll(EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT, QueryTask.QuerySpecification.QueryOption.BROADCAST, QueryTask.QuerySpecification.QueryOption.OWNER_SELECTION, QueryTask.QuerySpecification.QueryOption.FORWARD_ONLY));
        if (initState.querySpec.query == null || initState.querySpec.query.booleanClauses == null || initState.querySpec.query.booleanClauses.isEmpty()) {
            initState.querySpec.query = this.buildFieldClause(initState);
        } else {
            initState.querySpec.query.addBooleanClause(this.buildFieldClause(initState));
        }
        if (initState.taskInfo == null) {
            initState.taskInfo = new TaskState();
        }
        if (initState.taskInfo.stage == null) {
            initState.taskInfo.stage = TaskState.TaskStage.CREATED;
        }
        if (initState.maintenanceIntervalMicros == null) {
            initState.maintenanceIntervalMicros = DEFAULT_MAINTENANCE_INTERVAL_MILLIS;
        }
        if (initState.maximumConvergenceChecks == null) {
            initState.maximumConvergenceChecks = DEFAULT_MAXIMUM_CONVERGENCE_CHECKS;
        }
        if (initState.migrationOptions == null) {
            initState.migrationOptions = EnumSet.noneOf(MigrationOption.class);
        }
        if (initState.continuousMigration == null) {
            initState.continuousMigration = Boolean.FALSE;
        }
        if (initState.continuousMigration.booleanValue()) {
            initState.migrationOptions.add(MigrationOption.CONTINUOUS);
        }
        return initState;
    }

    private QueryTask.Query buildFieldClause(State initState) {
        QueryTask.Query query = QueryTask.Query.Builder.create().addFieldClause("documentSelfLink", this.addSlash(initState.sourceFactoryLink), QueryTask.QueryTerm.MatchType.PREFIX).build();
        return query;
    }

    private boolean verifyState(State state, Operation operation) {
        ArrayList<String> errMsgs = new ArrayList<String>();
        if (state.sourceFactoryLink == null) {
            errMsgs.add("sourceFactory cannot be null.");
        }
        if (state.sourceNodeGroupReference == null && state.sourceReferences.isEmpty()) {
            errMsgs.add("sourceNode or sourceUri need to be specified.");
        }
        if (state.sourceNodeGroupReference != null && !state.sourceReferences.isEmpty()) {
            errMsgs.add("cannot specify both sourceNode and sourceReferences.");
        }
        if (state.destinationFactoryLink == null) {
            errMsgs.add("destinationFactory cannot be null.");
        }
        if (state.destinationNodeGroupReference == null && state.destinationReferences.isEmpty()) {
            errMsgs.add("destinationNode or destinationReferences need to be specified.");
        }
        if (state.destinationNodeGroupReference != null && !state.destinationReferences.isEmpty()) {
            errMsgs.add("cannot specify both destinationNode and destinationReferences.");
        }
        if (!errMsgs.isEmpty()) {
            operation.fail(new IllegalArgumentException(String.join((CharSequence)" ", errMsgs)));
        }
        return errMsgs.isEmpty();
    }

    @Override
    public void handlePatch(Operation patchOperation) {
        State patchState = (State)this.getBody(patchOperation);
        State currentState = (State)this.getState(patchOperation);
        this.applyPatch(patchState, currentState);
        if (!this.verifyState(currentState, patchOperation) && !this.verifyPatchedState(currentState, patchOperation)) {
            return;
        }
        patchOperation.complete();
        this.logInfo("After PATCH, the latest state is: %s", currentState);
        if (TaskState.isFinished(currentState.taskInfo) || TaskState.isFailed(currentState.taskInfo) || TaskState.isCancelled(currentState.taskInfo)) {
            return;
        }
        if ((patchState.maintenanceIntervalMicros != null || patchState.continuousMigration != null) && currentState.continuousMigration.booleanValue()) {
            this.setMaintenanceIntervalMicros(currentState.maintenanceIntervalMicros);
        }
        this.resolveNodeGroupReferences(currentState);
    }

    private URI extractBaseUri(NodeState state) {
        URI uri = state.groupReference;
        return UriUtils.buildUri(uri.getScheme(), uri.getHost(), uri.getPort(), null, null);
    }

    @Override
    public void handleMaintenance(Operation maintenanceOperation) {
        maintenanceOperation.complete();
        ServiceMaintenanceRequest serviceMaintenanceRequest = maintenanceOperation.getBody(ServiceMaintenanceRequest.class);
        if (!serviceMaintenanceRequest.reasons.contains((Object)ServiceMaintenanceRequest.MaintenanceReason.PERIODIC_SCHEDULE)) {
            return;
        }
        Operation.CompletionHandler c = (o, t) -> {
            if (t != null) {
                this.logWarning("Error retrieving document %s, %s", this.getUri(), t);
                return;
            }
            State state = o.getBody(State.class);
            if (!state.continuousMigration.booleanValue()) {
                return;
            }
            if (state.taskInfo.stage == TaskState.TaskStage.STARTED || state.taskInfo.stage == TaskState.TaskStage.CREATED) {
                return;
            }
            State patch = new State();
            this.logInfo("Continuous migration enabled, restarting", new Object[0]);
            if (state.taskInfo.stage == TaskState.TaskStage.FINISHED) {
                patch.querySpec = state.querySpec;
                QueryTask.Query q = this.findUpdateTimeMicrosRangeClause(patch.querySpec.query);
                if (q != null) {
                    q.setNumericRange(QueryTask.NumericRange.createGreaterThanOrEqualRange(state.latestSourceUpdateTimeMicros));
                } else {
                    QueryTask.Query timeClause = QueryTask.Query.Builder.create().addRangeClause("documentUpdateTimeMicros", QueryTask.NumericRange.createGreaterThanOrEqualRange(state.latestSourceUpdateTimeMicros)).build();
                    patch.querySpec.query.addBooleanClause(timeClause);
                }
            }
            patch.taskInfo = TaskState.createAsStarted();
            Operation.createPatch(this.getUri()).setBody(patch).sendWith(this);
        };
        Operation.createGet(this.getUri()).setCompletion(c).sendWith(this);
    }

    private QueryTask.Query findUpdateTimeMicrosRangeClause(QueryTask.Query query) {
        if (query.term != null && query.term.propertyName != null && query.term.propertyName.equals("documentUpdateTimeMicros") && query.term.range != null) {
            return query;
        }
        if (query.booleanClauses == null) {
            return null;
        }
        for (QueryTask.Query q : query.booleanClauses) {
            QueryTask.Query match = this.findUpdateTimeMicrosRangeClause(q);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private void resolveNodeGroupReferences(State currentState) {
        this.logInfo("Resolving node group differences. [source=%s] [destination=%s]", currentState.sourceNodeGroupReference, currentState.destinationNodeGroupReference);
        DeferredResult<Object> sourceDeferred = new DeferredResult<Object>();
        if (currentState.sourceReferences.isEmpty()) {
            MigrationTaskService.createGet(currentState.sourceNodeGroupReference, currentState).setCompletion((os, ex) -> {
                if (ex != null) {
                    sourceDeferred.fail(ex);
                    return;
                }
                NodeGroupService.NodeGroupState sourceGroup = os.getBody(NodeGroupService.NodeGroupState.class);
                currentState.sourceReferences = this.filterAvailableNodeUris(sourceGroup);
                this.waitUntilNodeGroupsAreStable(currentState, currentState.sourceNodeGroupReference, currentState.maximumConvergenceChecks, sourceDeferred);
            }).sendWith(this);
        } else {
            sourceDeferred.complete(DUMMY_OBJECT);
        }
        DeferredResult<Object> destDeferred = new DeferredResult<Object>();
        if (currentState.destinationReferences.isEmpty()) {
            MigrationTaskService.createGet(currentState.destinationNodeGroupReference, currentState).setCompletion((os, ex) -> {
                if (ex != null) {
                    destDeferred.fail(ex);
                    return;
                }
                NodeGroupService.NodeGroupState sourceGroup = os.getBody(NodeGroupService.NodeGroupState.class);
                currentState.destinationReferences = this.filterAvailableNodeUris(sourceGroup);
                this.waitUntilNodeGroupsAreStable(currentState, currentState.destinationNodeGroupReference, currentState.maximumConvergenceChecks, destDeferred);
            }).sendWith(this);
        } else {
            destDeferred.complete(DUMMY_OBJECT);
        }
        DeferredResult.allOf(sourceDeferred, destDeferred).thenCompose(aVoid -> {
            DeferredResult<Object> nodeSelectorAvailabilityDeferred = new DeferredResult<Object>();
            this.waitNodeSelectorAreStable(currentState, currentState.sourceReferences, currentState.sourceFactoryLink, currentState.maximumConvergenceChecks, nodeSelectorAvailabilityDeferred);
            return nodeSelectorAvailabilityDeferred;
        }).thenCompose(peerNodeSelectorPath -> {
            DeferredResult<Object> waitFactoryIsAvailableDeferred = new DeferredResult<Object>();
            if (peerNodeSelectorPath != null) {
                this.waitFactoryIsAvailable(currentState, currentState.sourceReferences.get(0), (String)peerNodeSelectorPath, currentState.sourceFactoryLink, currentState.maximumConvergenceChecks, waitFactoryIsAvailableDeferred);
            } else {
                this.logInfo("Skipping Factory service availability check because node-selector link is missing.", new Object[0]);
                waitFactoryIsAvailableDeferred.complete(null);
            }
            return waitFactoryIsAvailableDeferred;
        }).thenAccept(aVoid -> this.computeFirstCurrentPageLinks(currentState, currentState.sourceReferences, currentState.destinationReferences)).exceptionally(throwable -> {
            this.failTask((Throwable)throwable);
            return null;
        });
    }

    private List<URI> filterAvailableNodeUris(NodeGroupService.NodeGroupState destinationGroup) {
        return destinationGroup.nodes.values().stream().filter(ns -> !NodeState.isUnAvailable(ns)).map(this::extractBaseUri).collect(Collectors.toList());
    }

    private void waitUntilNodeGroupsAreStable(State currentState, URI nodeGroupReference, int allowedConvergenceChecks, DeferredResult<Object> deferredResult) {
        Operation callbackOp = new Operation().setCompletion((op, ex) -> {
            if (ex != null) {
                if (allowedConvergenceChecks <= 0) {
                    String msg = "Nodegroups did not converge after " + currentState.maximumConvergenceChecks + " retries.";
                    deferredResult.fail(new Exception(msg));
                    return;
                }
                this.logInfo("Nodegroups are not convereged scheduling retry.", new Object[0]);
                this.getHost().schedule(() -> this.waitUntilNodeGroupsAreStable(currentState, nodeGroupReference, allowedConvergenceChecks - 1, deferredResult), currentState.maintenanceIntervalMicros, TimeUnit.MICROSECONDS);
                return;
            }
            deferredResult.complete(null);
        }).setReferer(this.getUri());
        NodeGroupUtils.checkConvergence(this.getHost(), nodeGroupReference, callbackOp);
    }

    private void waitFactoryIsAvailable(State currentState, URI hostUri, String nodeSelectorPath, String factoryLink, int maxRetry, DeferredResult<Object> deferredResult) {
        if (maxRetry <= 0) {
            String msg = String.format("Failed to verify availability of factory service %s after %s retries", factoryLink, currentState.maximumConvergenceChecks);
            this.logSevere(msg, new Object[0]);
            deferredResult.fail(new Exception(msg));
            return;
        }
        URI service = UriUtils.buildUri(hostUri, factoryLink);
        NodeGroupUtils.checkServiceAvailability((o, e) -> {
            if (e != null) {
                this.logInfo("Factory service not available yet, scheduling retry #%d. Error message: %s ", maxRetry, e.getMessage());
                this.getHost().schedule(() -> this.waitFactoryIsAvailable(currentState, hostUri, nodeSelectorPath, factoryLink, maxRetry - 1, deferredResult), currentState.maintenanceIntervalMicros, TimeUnit.MICROSECONDS);
                return;
            }
            this.logInfo("Factory service is available.", new Object[0]);
            deferredResult.complete(null);
        }, this.getHost(), service, nodeSelectorPath);
    }

    private void waitNodeSelectorAreStable(State currentState, List<URI> sourceURIs, String factoryLink, int maxRetry, DeferredResult<Object> deferredResult) {
        Set<Operation> getOps = sourceURIs.stream().map(sourceUri -> {
            URI uri = UriUtils.buildUri(sourceUri, factoryLink);
            return Operation.createGet(UriUtils.buildConfigUri(uri));
        }).collect(Collectors.toSet());
        OperationJoin.create(getOps).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                String msg = "Failed to get factory config from all source nodes";
                this.logSevere(msg, new Object[0]);
                deferredResult.fail(new Exception(msg));
                return;
            }
            Optional<String> peerNodeSelectorPath = os.values().stream().map(operation -> operation.getBody(ServiceConfiguration.class).peerNodeSelectorPath).filter(selectorPath -> selectorPath != null).findFirst();
            if (peerNodeSelectorPath.isPresent()) {
                currentState.nodeSelectorPath = peerNodeSelectorPath.get();
                this.waitNodeSelectorAreStableRetry(currentState, sourceURIs, maxRetry, peerNodeSelectorPath.get(), deferredResult);
            } else {
                this.logInfo("Skipping node-selector availability check because node-selector link is missing.", new Object[0]);
                deferredResult.complete(null);
            }
        }).sendWith(this);
    }

    private void waitNodeSelectorAreStableRetry(State currentState, List<URI> sourceURIs, int maxRetry, String peerNodeSelectorPath, DeferredResult<Object> deferredResult) {
        if (maxRetry <= 0) {
            String msg = String.format("Failed to verify availability of all node selector paths after %s retries", currentState.maximumConvergenceChecks);
            this.logSevere(msg, new Object[0]);
            deferredResult.fail(new Exception(msg));
            return;
        }
        Set<Operation> getOps = sourceURIs.stream().map(sourceUri -> Operation.createGet(UriUtils.buildUri(sourceUri, peerNodeSelectorPath))).collect(Collectors.toSet());
        OperationJoin.create(getOps).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.logInfo("Failed (%s) to get reply from all (%s) Node Selectors, scheduling retry #%d.", ts.size(), os.size(), maxRetry);
                this.getHost().schedule(() -> this.waitNodeSelectorAreStableRetry(currentState, sourceURIs, maxRetry - 1, peerNodeSelectorPath, deferredResult), currentState.maintenanceIntervalMicros, TimeUnit.MICROSECONDS);
                return;
            }
            List availableNodeSelectors = os.values().stream().map(operation -> operation.getBody(NodeSelectorState.class).status).filter(status -> status.equals((Object)NodeSelectorState.Status.AVAILABLE)).collect(Collectors.toList());
            if (availableNodeSelectors.size() != sourceURIs.size()) {
                this.logInfo("Not all (%d) Node Selectors are available (%d) , scheduling retry #%d.", sourceURIs.size(), availableNodeSelectors.size(), maxRetry);
                this.getHost().schedule(() -> this.waitNodeSelectorAreStableRetry(currentState, sourceURIs, maxRetry - 1, peerNodeSelectorPath, deferredResult), currentState.maintenanceIntervalMicros, TimeUnit.MICROSECONDS);
            } else {
                this.logInfo("Node Selectors are available.", new Object[0]);
                deferredResult.complete(peerNodeSelectorPath);
            }
        }).sendWith(this);
    }

    private void computeFirstCurrentPageLinks(State currentState, List<URI> sourceURIs, List<URI> destinationURIs) {
        this.logInfo("Node groups are stable. Computing pages to be migrated...", new Object[0]);
        long documentExpirationTimeMicros = currentState.documentExpirationTimeMicros;
        URI sourceHostUri = this.selectRandomUri(sourceURIs);
        URI factoryUri = UriUtils.buildUri(sourceHostUri, currentState.sourceFactoryLink);
        URI factoryConfigUri = UriUtils.buildConfigUri(factoryUri);
        Operation configGet = MigrationTaskService.createGet(factoryConfigUri, currentState);
        this.sendWithDeferredResult(configGet).thenCompose(op -> {
            FactoryService.FactoryServiceConfiguration factoryConfig = op.getBody(FactoryService.FactoryServiceConfiguration.class);
            currentState.factoryChildOptions = factoryConfig.childOptions;
            QueryTask countQuery = QueryTask.Builder.createDirectTask().addOption(QueryTask.QuerySpecification.QueryOption.COUNT).setQuery(this.buildFieldClause(currentState)).build();
            if (currentState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS) || factoryConfig.childOptions.contains((Object)Service.ServiceOption.IMMUTABLE)) {
                countQuery.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
            }
            if (currentState.migrationOptions.contains((Object)MigrationOption.ESTIMATE_COUNT)) {
                countQuery.documentExpirationTimeMicros = documentExpirationTimeMicros;
                Operation countOp = MigrationTaskService.createPost(UriUtils.buildUri(sourceHostUri, ServiceUriPaths.CORE_QUERY_TASKS), currentState).setBody(countQuery);
                return this.sendWithDeferredResult(countOp);
            }
            countQuery.results = new ServiceDocumentQueryResult();
            countQuery.results.documentCount = -1L;
            countQuery.results.queryTimeMicros = -1L;
            Operation dummyOp = Operation.createGet(null).setBody(countQuery);
            return DeferredResult.completed(dummyOp);
        }).thenAccept(countOp -> {
            QueryTask countQueryTask = countOp.getBody(QueryTask.class);
            Long estimatedTotalServiceCount = countQueryTask.results.documentCount;
            long queryTimeMicros = countQueryTask.results.queryTimeMicros;
            this.logInfo("[factory=%s] Estimated total service count =%,d calculation took %,d microsec ", currentState.sourceFactoryLink, estimatedTotalServiceCount, queryTimeMicros);
            this.setStat(STAT_NAME_COUNT_QUERY_TIME_DURATION_MICRO, (double)queryTimeMicros);
            this.adjustStat(STAT_NAME_ESTIMATED_TOTAL_SERVICE_COUNT, (double)estimatedTotalServiceCount.longValue());
            QueryTask queryTask = QueryTask.create(currentState.querySpec).setDirect(true);
            if (countQueryTask.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS)) {
                queryTask.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
            }
            queryTask.nodeSelectorLink = currentState.nodeSelectorPath;
            queryTask.documentExpirationTimeMicros = documentExpirationTimeMicros;
            URI queryTaskUri = UriUtils.buildUri(sourceHostUri, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS);
            Operation retrievalOp = MigrationTaskService.createPost(queryTaskUri, currentState).setBody(queryTask);
            retrievalOp.setCompletion((op, ex) -> {
                if (ex != null) {
                    this.failTask(ex);
                    return;
                }
                if (op.getBody(QueryTask.class).results.nextPageLink == null) {
                    this.patchToFinished(null);
                } else {
                    URI currentPageLink = this.getNextPageLinkUri(op);
                    this.migrate(currentState, currentPageLink, destinationURIs, 0L);
                }
            }).sendWith(this);
        }).exceptionally(throwable -> {
            this.failTask((Throwable)throwable);
            throw new CompletionException((Throwable)throwable);
        });
    }

    private void migrate(State currentState, URI currentPageLink, List<URI> destinationURIs, long lastUpdateTime) {
        if (currentPageLink == null) {
            this.patchToFinished(lastUpdateTime);
            return;
        }
        Operation currentPageGet = Operation.createGet(currentPageLink);
        long start = Utils.getSystemNowMicrosUtc();
        currentPageGet.setCompletion((op, ex) -> {
            if (ex != null) {
                this.failTask(ex);
                return;
            }
            ServiceStats.ServiceStat retrievalOpTimeStat = this.getSingleBinTimeSeriesStat(STAT_NAME_RETRIEVAL_OPERATIONS_DURATION_MICRO);
            this.setStat(retrievalOpTimeStat, (double)(Utils.getSystemNowMicrosUtc() - start));
            QueryTask queryTask = op.getBody(QueryTask.class);
            URI nextPage = null;
            if (queryTask.results.nextPageLink != null) {
                nextPage = this.getNextPageLinkUri(op);
            }
            String authority = op.getUri().getAuthority();
            String queryTimeStatKey = String.format(STAT_NAME_RETRIEVAL_QUERY_TIME_DURATION_MICRO_FORMAT, authority);
            this.setStat(this.getSingleBinTimeSeriesStat(queryTimeStatKey), (double)queryTask.results.queryTimeMicros.longValue());
            Collection<Object> docs = queryTask.results.documents.values();
            this.adjustStat(STAT_NAME_FETCHED_DOCUMENT_COUNT, (double)docs.size());
            if (docs.isEmpty()) {
                this.migrate(currentState, nextPage, destinationURIs, lastUpdateTime);
                return;
            }
            long maxDocumentUpdateTime = docs.stream().map(doc -> Utils.fromJson((Object)doc, ServiceDocument.class).documentUpdateTimeMicros).max(Long::compareTo).orElse(0L);
            maxDocumentUpdateTime = Math.max(lastUpdateTime, maxDocumentUpdateTime);
            if (currentState.migrationOptions.contains((Object)MigrationOption.ALL_VERSIONS)) {
                URI hostUri = this.getHostUri(op);
                this.retrieveAllVersions(docs, hostUri, nextPage, currentState, destinationURIs, maxDocumentUpdateTime);
            } else {
                this.transformResults(currentState, docs, nextPage, destinationURIs, maxDocumentUpdateTime);
            }
        }).sendWith(this);
    }

    private void retrieveAllVersions(Collection<Object> results, URI hostUri, URI nextPageLink, State currentState, List<URI> destinationURIs, long lastUpdateTime) {
        ArrayList deferredResults = new ArrayList();
        for (Object doc : results) {
            ServiceDocument document = Utils.fromJson(doc, ServiceDocument.class);
            String selfLink = document.documentSelfLink;
            URI templateUri = UriUtils.buildUri(hostUri, selfLink, "/template");
            Operation o = MigrationTaskService.createGet(templateUri, currentState);
            DeferredResult<List> deferredResult = this.sendWithDeferredResult(o).thenCompose(op -> {
                ServiceDocument template = op.getBody(ServiceDocument.class);
                int resultLimit = Long.valueOf(template.documentDescription.versionRetentionLimit).intValue();
                QueryTask.Query qs = QueryTask.Query.Builder.create().addFieldClause("documentSelfLink", selfLink).build();
                QueryTask q = QueryTask.Builder.createDirectTask().addOption(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS).addOption(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT).setQuery(qs).setResultLimit(resultLimit).orderAscending("documentVersion", ServiceDocumentDescription.TypeName.LONG).build();
                URI postUri = UriUtils.buildUri(hostUri, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS);
                Operation queryOp = MigrationTaskService.createPost(postUri, currentState).setBody(q);
                return this.sendWithDeferredResult(queryOp);
            }).thenCompose(op -> {
                Operation getNextPageOp = MigrationTaskService.createGet(this.getNextPageLinkUri((Operation)op), currentState);
                return this.sendWithDeferredResult(getNextPageOp);
            }).thenApply(op -> {
                QueryTask queryTask = op.getBody(QueryTask.class);
                List docs = queryTask.results.documentLinks.stream().map(link -> queryTask.results.documents.get(link)).collect(Collectors.toList());
                return docs;
            }).exceptionally(ex -> {
                this.failTask((Throwable)ex);
                return null;
            });
            deferredResults.add(deferredResult);
        }
        DeferredResult.allOf(deferredResults).thenAccept(docsList -> {
            List<Object> allVersions = docsList.stream().flatMap(Collection::stream).collect(Collectors.toList());
            this.transformResults(currentState, allVersions, nextPageLink, destinationURIs, lastUpdateTime);
        });
    }

    private void transformUsingMap(State state, Collection<Object> cleanJson, URI nextPageLink, List<URI> destinationURIs, long lastUpdateTime) {
        Collection transformations = cleanJson.stream().map(doc -> MigrationTaskService.createPost(UriUtils.buildUri(this.selectRandomUri(destinationURIs), state.transformationServiceLink), state).setBody(Collections.singletonMap(doc, state.destinationFactoryLink))).collect(Collectors.toList());
        this.adjustStat(STAT_NAME_BEFORE_TRANSFORM_COUNT, (double)transformations.size());
        OperationJoin.create(transformations).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            HashMap<Object, String> transformedJson = new HashMap<Object, String>();
            for (Operation o : os.values()) {
                Map m = o.getBody(Map.class);
                for (Map.Entry entry : m.entrySet()) {
                    transformedJson.put(entry.getKey(), Utils.fromJson(entry.getValue(), String.class));
                }
            }
            this.adjustStat(STAT_NAME_AFTER_TRANSFORM_COUNT, (double)transformedJson.size());
            this.migrateEntities(transformedJson, state, nextPageLink, destinationURIs, lastUpdateTime);
        }).sendWith(this);
    }

    private void transformUsingObject(State state, Collection<Object> cleanJson, URI nextPageLink, List<URI> destinationURIs, long lastUpdateTime) {
        Collection transformations = cleanJson.stream().map(doc -> {
            TransformRequest transformRequest = new TransformRequest();
            transformRequest.originalDocument = Utils.toJson(doc);
            transformRequest.destinationLink = state.destinationFactoryLink;
            return MigrationTaskService.createPost(UriUtils.buildUri(this.selectRandomUri(destinationURIs), state.transformationServiceLink), state).setBody(transformRequest);
        }).collect(Collectors.toList());
        this.adjustStat(STAT_NAME_BEFORE_TRANSFORM_COUNT, (double)transformations.size());
        OperationJoin.create(transformations).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            HashMap<Object, String> transformedJson = new HashMap<Object, String>();
            for (Operation o : os.values()) {
                TransformResponse response = o.getBody(TransformResponse.class);
                transformedJson.putAll(response.destinationLinks);
            }
            this.adjustStat(STAT_NAME_AFTER_TRANSFORM_COUNT, (double)transformedJson.size());
            this.migrateEntities(transformedJson, state, nextPageLink, destinationURIs, lastUpdateTime);
        }).sendWith(this);
    }

    private void transformResults(State state, Collection<Object> results, URI nextPageLink, List<URI> destinationURIs, long lastUpdateTime) {
        Collection cleanJson = results.stream().map(d -> this.removeFactoryPathFromSelfLink(d, state.sourceFactoryLink)).collect(Collectors.toList());
        if (state.transformationServiceLink != null) {
            this.logInfo("Transforming results using [migrationOptions=%s] [transformLink=%s]", state.migrationOptions, state.transformationServiceLink);
            if (state.migrationOptions.contains((Object)MigrationOption.USE_TRANSFORM_REQUEST)) {
                this.transformUsingObject(state, cleanJson, nextPageLink, destinationURIs, lastUpdateTime);
            } else {
                this.transformUsingMap(state, cleanJson, nextPageLink, destinationURIs, lastUpdateTime);
            }
        } else {
            Map<Object, String> jsonMap = cleanJson.stream().collect(Collectors.toMap(e -> e, e -> state.destinationFactoryLink));
            this.migrateEntities(jsonMap, state, nextPageLink, destinationURIs, lastUpdateTime);
        }
    }

    private void migrateEntities(Map<Object, String> json, State state, URI nextPageLink, List<URI> destinationURIs, long lastUpdateTime) {
        if (json.isEmpty()) {
            this.migrate(state, nextPageLink, destinationURIs, lastUpdateTime);
            return;
        }
        if (state.migrationOptions.contains((Object)MigrationOption.ALL_VERSIONS)) {
            this.migrateEntitiesForAllVersions(json, state, nextPageLink, destinationURIs, lastUpdateTime);
        } else {
            this.migrateEntitiesForSingleVersion(json, state, nextPageLink, destinationURIs, lastUpdateTime);
        }
    }

    private void migrateEntitiesForAllVersions(Map<Object, String> json, State state, URI nextPageLink, List<URI> destinationURIs, long lastUpdateTime) {
        SortedSet docs;
        String selfLink;
        boolean performRetry = state.migrationOptions.contains((Object)MigrationOption.DELETE_AFTER);
        HashMap<String, SortedSet> docsBySelfLink = new HashMap<String, SortedSet>();
        HashMap<String, String> factoryLinkBySelfLink = new HashMap<String, String>();
        block3: for (Object object : json.keySet()) {
            ServiceDocument doc = Utils.fromJson(object, ServiceDocument.class);
            Service.Action action = Service.Action.valueOf(doc.documentUpdateAction);
            switch (action) {
                case PUT: 
                case PATCH: 
                case DELETE: 
                case POST: {
                    continue block3;
                }
            }
            String format = "action=%s is not supported for ALL_VERSIONS migration. selfLink=%s, version=%s";
            String message = String.format(format, new Object[]{action, doc.documentSelfLink, doc.documentVersion});
            this.failTask(new RuntimeException(message));
            return;
        }
        for (Map.Entry entry : json.entrySet()) {
            Object docJson = entry.getKey();
            String string = (String)entry.getValue();
            selfLink = Utils.fromJson(docJson, ServiceDocument.class).documentSelfLink;
            factoryLinkBySelfLink.putIfAbsent(selfLink, string);
            docs = docsBySelfLink.computeIfAbsent(selfLink, key -> new TreeSet((left, right) -> {
                ServiceDocument leftDoc = Utils.fromJson(left, ServiceDocument.class);
                ServiceDocument rightDoc = Utils.fromJson(right, ServiceDocument.class);
                return Long.compare(leftDoc.documentVersion, rightDoc.documentVersion);
            }));
            docs.add(docJson);
        }
        ConcurrentHashMap failureBySelfLink = new ConcurrentHashMap();
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : docsBySelfLink.entrySet()) {
            selfLink = (String)entry.getKey();
            docs = (SortedSet)entry.getValue();
            String factoryLink = (String)factoryLinkBySelfLink.get(selfLink);
            URI destinationUri = this.selectRandomUri(destinationURIs);
            List<Operation> ops = this.createMigrateOpsWithAllVersions(state, destinationUri, factoryLink, selfLink, docs);
            DeferredResult<Operation> deferredResult = DeferredResult.completed(new Operation());
            for (Operation op : ops) {
                deferredResult = deferredResult.thenCompose(o -> {
                    this.logFine(() -> String.format("migrating history. link=%s%s action=%s dest=%s", new Object[]{factoryLink, selfLink, o.getAction(), destinationUri}));
                    return this.sendWithDeferredResult(op);
                });
            }
            deferredResult = deferredResult.exceptionally(throwable -> {
                this.logWarning("Migrating entity failed. link=%s, ex=%s", selfLink, throwable);
                failureBySelfLink.put(selfLink, throwable);
                return null;
            });
            arrayList.add(deferredResult);
        }
        int numOfProcessedDoc = json.size();
        DeferredResult.allOf(arrayList).whenComplete((operations, ignore) -> {
            if (failureBySelfLink.isEmpty()) {
                this.adjustStat(STAT_NAME_PROCESSED_DOCUMENTS, (double)numOfProcessedDoc);
                this.migrate(state, nextPageLink, destinationURIs, lastUpdateTime);
            } else if (performRetry) {
                this.logInfo("Migration retry start. links=%s", failureBySelfLink.size());
                this.retryMigrateEntitiesForAllVersions(failureBySelfLink.keySet(), docsBySelfLink, factoryLinkBySelfLink, numOfProcessedDoc, state, nextPageLink, destinationURIs, lastUpdateTime);
            } else {
                this.failTask(failureBySelfLink.values());
            }
        });
    }

    private void retryMigrateEntitiesForAllVersions(Set<String> failedSelfLinks, Map<String, SortedSet<Object>> docsBySelfLink, Map<String, String> factoryLinkBySelfLink, int numOfProcessedDoc, State state, URI nextPageLink, List<URI> destinationURIs, long lastUpdateTime) {
        ArrayList retryDeferredResults = new ArrayList();
        for (String failedSelfLink : failedSelfLinks) {
            SortedSet<Object> docs = docsBySelfLink.get(failedSelfLink);
            String factoryLink = factoryLinkBySelfLink.get(failedSelfLink);
            URI destinationUri = this.selectRandomUri(destinationURIs);
            List<Operation> ops = this.createRetryMigrateOpsWithAllVersions(state, destinationUri, factoryLink, failedSelfLink, docs);
            DeferredResult<Operation> deferredResult = DeferredResult.completed(new Operation());
            for (Operation op : ops) {
                deferredResult = deferredResult.thenCompose(ignore -> {
                    this.logFine(() -> String.format("migrating history. link=%s%s action=%s dest=%s", new Object[]{factoryLink, failedSelfLink, op.getAction(), destinationUri}));
                    return this.sendWithDeferredResult(op);
                });
            }
            retryDeferredResults.add(deferredResult);
        }
        DeferredResult.allOf(retryDeferredResults).whenComplete((retryOps, retryEx) -> {
            if (retryEx != null) {
                this.failTask((Throwable)retryEx);
                return;
            }
            this.adjustStat(STAT_NAME_PROCESSED_DOCUMENTS, (double)numOfProcessedDoc);
            this.migrate(state, nextPageLink, destinationURIs, lastUpdateTime);
        });
    }

    private void migrateEntitiesForSingleVersion(Map<Object, String> json, State state, URI nextPageLink, List<URI> destinationURIs, long lastUpdateTime) {
        boolean performRetry = state.migrationOptions.contains((Object)MigrationOption.DELETE_AFTER);
        HashSet opIdsToDelete = new HashSet();
        Map<Operation, Object> posts = json.entrySet().stream().map(entry -> {
            Object docJson = entry.getKey();
            String factoryLink = (String)entry.getValue();
            URI uri = UriUtils.buildUri(this.selectRandomUri(destinationURIs), factoryLink);
            String action = Utils.getJsonMapValue(docJson, "documentUpdateAction", String.class);
            boolean toDelete = Service.Action.DELETE.toString().equals(action);
            Operation op = MigrationTaskService.createPost(uri, state).setBodyNoCloning(docJson);
            op.addPragmaDirective("xn-from-migration");
            if (toDelete) {
                opIdsToDelete.add(op.getId());
            }
            return new AbstractMap.SimpleEntry(op, docJson);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        OperationJoin.create(posts.keySet()).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                HashSet opIdsToRetry = new HashSet(ts.keySet());
                opIdsToRetry.removeAll(opIdsToDelete);
                if (opIdsToRetry.isEmpty()) {
                    this.migrate(state, nextPageLink, destinationURIs, lastUpdateTime);
                } else if (performRetry) {
                    Map<Long, Throwable> failedOps = ts.entrySet().stream().filter(entry -> opIdsToRetry.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    this.logWarning("Migrating entities failed with exception: %s; Retrying operation.", Utils.toString(failedOps));
                    this.useFallBack(state, posts, failedOps, nextPageLink, destinationURIs, lastUpdateTime);
                } else {
                    this.failTask(ts.values());
                }
                return;
            }
            this.logInfo("[source=%s][dest=%s] MigrationTask created %,d entries in destination.", state.sourceFactoryLink, state.destinationFactoryLink, posts.size());
            this.adjustStat(STAT_NAME_PROCESSED_DOCUMENTS, (double)posts.size());
            if (opIdsToDelete.isEmpty()) {
                this.migrate(state, nextPageLink, destinationURIs, lastUpdateTime);
            } else {
                Set<Operation> deletes = opIdsToDelete.stream().map(os::get).map(op -> {
                    String selfLink = op.getBody(ServiceDocument.class).documentSelfLink;
                    URI deleteUri = UriUtils.buildUri(this.selectRandomUri(destinationURIs), selfLink);
                    return MigrationTaskService.createDelete(deleteUri, state).addRequestHeader("x-xenon-rpl-quorum", "x-xenon-all").addPragmaDirective("xn-from-migration");
                }).collect(Collectors.toSet());
                OperationJoin.create(deletes).setCompletion((deleteOps, deleteExs) -> {
                    if (deleteExs != null && !deleteExs.isEmpty()) {
                        Set<Operation> retryDeletes = deleteExs.keySet().stream().map(deleteOps::get).map(op -> UriUtils.buildUri(this.selectRandomUri(destinationURIs), op.getUri().getPath())).map(uri -> MigrationTaskService.createDelete(uri, state).addRequestHeader("x-xenon-rpl-quorum", "x-xenon-all").addPragmaDirective("xn-from-migration")).collect(Collectors.toSet());
                        this.adjustStat(STAT_NAME_DELETE_RETRY_COUNT, (double)retryDeletes.size());
                        OperationJoin.create(retryDeletes).setCompletion((retryOps, retryExs) -> {
                            if (retryExs != null && !retryExs.isEmpty()) {
                                this.failTask(retryExs.values());
                                return;
                            }
                            this.adjustStat(STAT_NAME_DELETED_DOCUMENT_COUNT, (double)retryOps.size());
                            this.migrate(state, nextPageLink, destinationURIs, lastUpdateTime);
                        }).sendWith(this);
                        return;
                    }
                    this.adjustStat(STAT_NAME_DELETED_DOCUMENT_COUNT, (double)deleteOps.size());
                    this.migrate(state, nextPageLink, destinationURIs, lastUpdateTime);
                }).sendWith(this);
            }
        }).sendWith(this);
    }

    private List<Operation> createRetryMigrateOpsWithAllVersions(State currentState, URI destinationUri, String factoryLink, String selfLink, SortedSet<Object> docs) {
        URI destinationFactoryUri = UriUtils.buildUri(destinationUri, factoryLink);
        URI destinationTargetUri = UriUtils.extendUri(destinationFactoryUri, selfLink);
        Operation delete = MigrationTaskService.createDelete(destinationTargetUri, currentState).addRequestHeader("x-xenon-rpl-quorum", "x-xenon-all").addPragmaDirective("xn-from-migration");
        List<Operation> createOps = this.createMigrateOpsWithAllVersions(currentState, destinationUri, factoryLink, selfLink, docs);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add(delete);
        ops.addAll(createOps);
        return ops;
    }

    private List<Operation> createMigrateOpsWithAllVersions(State currentState, URI destinationUri, String factoryLink, String selfLink, SortedSet<Object> sortedDocs) {
        ArrayList<Object> docs = new ArrayList<Object>(sortedDocs);
        Object firstDoc = docs.remove(0);
        URI destinationFactoryUri = UriUtils.buildUri(destinationUri, factoryLink);
        URI destinationTargetUri = UriUtils.extendUri(destinationFactoryUri, selfLink);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        Operation post = MigrationTaskService.createPost(destinationFactoryUri, currentState).addPragmaDirective("xn-force-index-update").addPragmaDirective("xn-from-migration").setBodyNoCloning(firstDoc);
        ops.add(post);
        for (Object e : docs) {
            Operation operation;
            Service.Action action = Service.Action.valueOf(Utils.fromJson(e, ServiceDocument.class).documentUpdateAction);
            switch (action) {
                case PUT: {
                    operation = MigrationTaskService.createPut(destinationTargetUri, currentState).setBodyNoCloning(e);
                    break;
                }
                case PATCH: {
                    operation = MigrationTaskService.createPatch(destinationTargetUri, currentState).setBodyNoCloning(e);
                    break;
                }
                case DELETE: {
                    operation = MigrationTaskService.createDelete(destinationTargetUri, currentState).addRequestHeader("x-xenon-rpl-quorum", "x-xenon-all");
                    break;
                }
                case POST: {
                    operation = MigrationTaskService.createPost(destinationFactoryUri, currentState).addPragmaDirective("xn-force-index-update").setBodyNoCloning(e);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported action type: " + (Object)((Object)action));
                }
            }
            operation.addPragmaDirective("xn-from-migration");
            ops.add(operation);
        }
        return ops;
    }

    private void patchToFinished(Long lastUpdateTime) {
        State patch = new State();
        patch.taskInfo = TaskState.createAsFinished();
        if (lastUpdateTime != null) {
            patch.latestSourceUpdateTimeMicros = lastUpdateTime;
        }
        Operation.createPatch(this.getUri()).setBody(patch).sendWith(this);
    }

    private void useFallBack(State state, Map<Operation, Object> posts, Map<Long, Throwable> operationFailures, URI nextPageLink, List<URI> destinationURIs, long lastUpdateTime) {
        Map<URI, Operation> entityDestinationUriTofailedOps = this.getFailedOperations(posts, operationFailures.keySet());
        Collection<Operation> deleteOperations = this.createDeleteOperations(state, entityDestinationUriTofailedOps.keySet());
        OperationJoin.create(deleteOperations).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            Collection<Operation> postOperations = this.createPostOperations(state, entityDestinationUriTofailedOps, posts);
            OperationJoin.create(postOperations).setCompletion((oss, tss) -> {
                if (tss != null && !tss.isEmpty()) {
                    this.failTask(tss.values());
                    return;
                }
                this.adjustStat(STAT_NAME_PROCESSED_DOCUMENTS, (double)posts.size());
                this.migrate(state, nextPageLink, destinationURIs, lastUpdateTime);
            }).sendWith(this);
        }).sendWith(this);
    }

    private Map<URI, Operation> getFailedOperations(Map<Operation, Object> posts, Set<Long> failedOpIds) {
        HashMap<URI, Operation> ops = new HashMap<URI, Operation>();
        for (Map.Entry<Operation, Object> entry : posts.entrySet()) {
            Operation op = entry.getKey();
            if (!failedOpIds.contains(op.getId())) continue;
            Object jsonObject = entry.getValue();
            String selfLink = Utils.getJsonMapValue(jsonObject, "documentSelfLink", String.class);
            URI getUri = UriUtils.buildUri(op.getUri(), op.getUri().getPath(), selfLink);
            ops.put(getUri, op);
        }
        return ops;
    }

    private static Operation createDelete(URI uri, State currentState) {
        Operation op = Operation.createDelete(uri);
        return MigrationTaskService.prepareOp(op, currentState);
    }

    private static Operation createGet(URI uri, State currentState) {
        Operation op = Operation.createGet(uri);
        return MigrationTaskService.prepareOp(op, currentState);
    }

    private static Operation createPatch(URI uri, State currentState) {
        Operation op = Operation.createPatch(uri);
        return MigrationTaskService.prepareOp(op, currentState);
    }

    private static Operation createPost(URI uri, State currentState) {
        Operation op = Operation.createPost(uri);
        return MigrationTaskService.prepareOp(op, currentState);
    }

    private static Operation createPut(URI uri, State currentState) {
        Operation op = Operation.createPut(uri);
        return MigrationTaskService.prepareOp(op, currentState);
    }

    private static Operation prepareOp(Operation op, State currentState) {
        if (currentState.operationTimeoutMicros != null) {
            op.setExpiration(Utils.fromNowMicrosUtc(currentState.operationTimeoutMicros));
        }
        return op;
    }

    private Collection<Operation> createDeleteOperations(State currentState, Collection<URI> uris) {
        return uris.stream().map(u -> MigrationTaskService.createDelete(u, currentState).addRequestHeader("x-xenon-rpl-quorum", "x-xenon-all").addPragmaDirective("xn-from-migration")).collect(Collectors.toList());
    }

    private Collection<Operation> createPostOperations(State currentState, Map<URI, Operation> failedOps, Map<Operation, Object> posts) {
        return failedOps.values().stream().map(o -> {
            Object newBody = posts.get(o);
            return MigrationTaskService.createPost(o.getUri(), currentState).setBodyNoCloning(newBody).addPragmaDirective("xn-from-migration").addPragmaDirective("xn-force-index-update");
        }).collect(Collectors.toList());
    }

    private boolean verifyPatchedState(State state, Operation operation) {
        ArrayList errMsgs = new ArrayList();
        if (!errMsgs.isEmpty()) {
            operation.fail(new IllegalArgumentException(String.join((CharSequence)"\n", errMsgs)));
        }
        return errMsgs.isEmpty();
    }

    private State applyPatch(State patchState, State currentState) {
        Utils.mergeWithState(this.getStateDescription(), currentState, patchState);
        currentState.latestSourceUpdateTimeMicros = Math.max(Optional.ofNullable(currentState.latestSourceUpdateTimeMicros).orElse(0L), Optional.ofNullable(patchState.latestSourceUpdateTimeMicros).orElse(0L));
        return currentState;
    }

    private Object removeFactoryPathFromSelfLink(Object jsonObject, String factoryPath) {
        String selfLink = this.extractId(jsonObject, factoryPath);
        return Utils.toJson(Utils.setJsonProperty(jsonObject, "documentSelfLink", selfLink));
    }

    private String extractId(Object jsonObject, String factoryPath) {
        String selfLink = Utils.getJsonMapValue(jsonObject, "documentSelfLink", String.class);
        if (selfLink.startsWith(factoryPath)) {
            selfLink = selfLink.replaceFirst(factoryPath, "");
        }
        return selfLink;
    }

    private URI selectRandomUri(Collection<URI> uris) {
        int num = (int)(Math.random() * (double)uris.size());
        for (URI uri : uris) {
            if (--num >= 0) continue;
            return uri;
        }
        return null;
    }

    private String addSlash(String string) {
        if (string.endsWith("/")) {
            return string;
        }
        return string + "/";
    }

    private URI getNextPageLinkUri(Operation operation) {
        URI queryUri = operation.getUri();
        return UriUtils.buildUri(queryUri.getScheme(), queryUri.getHost(), queryUri.getPort(), operation.getBody(QueryTask.class).results.nextPageLink, null);
    }

    private URI getHostUri(Operation operation) {
        URI uri = operation.getUri();
        return UriUtils.buildUri(uri.getScheme(), uri.getHost(), uri.getPort(), null, null);
    }

    private void failTask(Throwable t) {
        State patch = new State();
        patch.taskInfo = TaskState.createAsFailed();
        patch.taskInfo.failure = Utils.toServiceErrorResponse(t);
        Operation.createPatch(this.getUri()).setBody(patch).sendWith(this);
    }

    private void failTask(Collection<Throwable> ts) {
        for (Throwable t : ts) {
            this.logWarning("%s", t);
        }
        this.failTask(ts.iterator().next());
    }

    private ServiceStats.ServiceStat getSingleBinTimeSeriesStat(String statName) {
        return ServiceStatUtils.getOrCreateTimeSeriesStat(this, statName, () -> new ServiceStats.TimeSeriesStats(1, Long.MAX_VALUE, EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.AVG, ServiceStats.TimeSeriesStats.AggregationType.MAX, ServiceStats.TimeSeriesStats.AggregationType.MIN, ServiceStats.TimeSeriesStats.AggregationType.LATEST)));
    }

    public static class TransformResponse {
        public Map<String, String> destinationLinks;
    }

    public static class TransformRequest {
        public String originalDocument;
        public String destinationLink;
    }

    public static class State
    extends ServiceDocument {
        public URI sourceNodeGroupReference;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public List<URI> sourceReferences = new ArrayList<URI>();
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String sourceFactoryLink;
        public URI destinationNodeGroupReference;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public List<URI> destinationReferences = new ArrayList<URI>();
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String destinationFactoryLink;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String transformationServiceLink;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public QueryTask.QuerySpecification querySpec;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public TaskState taskInfo;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Long maintenanceIntervalMicros;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Integer maximumConvergenceChecks;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Boolean continuousMigration;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public EnumSet<MigrationOption> migrationOptions;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Long operationTimeoutMicros;
        public Long latestSourceUpdateTimeMicros = 0L;
        public EnumSet<Service.ServiceOption> factoryChildOptions;
        private String nodeSelectorPath;

        public String toString() {
            String stage = this.taskInfo != null && this.taskInfo.stage != null ? this.taskInfo.stage.name() : "null";
            return String.format("MigrationTaskService: [documentSelfLink=%s] [stage=%s] [sourceFactoryLink=%s]", this.documentSelfLink, stage, this.sourceFactoryLink);
        }
    }

    public static enum MigrationOption {
        CONTINUOUS,
        DELETE_AFTER,
        USE_TRANSFORM_REQUEST,
        ALL_VERSIONS,
        ESTIMATE_COUNT;

    }
}

