/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vmware.xenon.common.FileUtils;
import com.vmware.xenon.common.NamedThreadFactory;
import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.QueryFilterUtils;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.RoundRobinOperationQueue;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStatUtils;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.serialization.GsonSerializers;
import com.vmware.xenon.common.serialization.KryoSerializers;
import com.vmware.xenon.services.common.DocumentStoredFieldVisitor;
import com.vmware.xenon.services.common.GuestUserService;
import com.vmware.xenon.services.common.Lucene60FieldInfosFormatWithCache;
import com.vmware.xenon.services.common.LuceneIndexDocumentHelper;
import com.vmware.xenon.services.common.LuceneQueryConverter;
import com.vmware.xenon.services.common.QueryFilter;
import com.vmware.xenon.services.common.QueryPageService;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceHostManagementService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.SystemUserService;
import com.vmware.xenon.services.common.UpdateIndexRequest;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.lucene60.Lucene60FieldInfosFormat;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexUpgrader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.GroupingSearch;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class LuceneDocumentIndexService
extends StatelessService {
    public static final String SELF_LINK = "/core/document-index";
    public static final String PROPERTY_NAME_QUERY_THREAD_COUNT = "xenon." + LuceneDocumentIndexService.class.getSimpleName() + ".QUERY_THREAD_COUNT";
    public static final int QUERY_THREAD_COUNT = Integer.getInteger(PROPERTY_NAME_QUERY_THREAD_COUNT, Utils.DEFAULT_THREAD_COUNT * 2);
    public static final String PROPERTY_NAME_UPDATE_THREAD_COUNT = "xenon." + LuceneDocumentIndexService.class.getSimpleName() + ".UPDATE_THREAD_COUNT";
    public static final int UPDATE_THREAD_COUNT = Integer.getInteger(PROPERTY_NAME_UPDATE_THREAD_COUNT, Utils.DEFAULT_THREAD_COUNT / 2);
    public static final String PROPERTY_NAME_QUERY_QUEUE_DEPTH = "xenon.LuceneDocumentIndexService.queryQueueDepth";
    public static final int QUERY_QUEUE_DEPTH = Integer.getInteger("xenon.LuceneDocumentIndexService.queryQueueDepth", 100000);
    public static final String PROPERTY_NAME_UPDATE_QUEUE_DEPTH = "xenon.LuceneDocumentIndexService.updateQueueDepth";
    public static final int UPDATE_QUEUE_DEPTH = Integer.getInteger("xenon.LuceneDocumentIndexService.updateQueueDepth", 100000);
    public static final String FILE_PATH_LUCENE = "lucene";
    public static final int DEFAULT_INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH = 10000;
    public static final int DEFAULT_INDEX_SEARCHER_COUNT_THRESHOLD = 200;
    public static final int DEFAULT_QUERY_RESULT_LIMIT = 10000;
    public static final int DEFAULT_QUERY_PAGE_RESULT_LIMIT = 10000;
    public static final int DEFAULT_EXPIRED_DOCUMENT_SEARCH_THRESHOLD = 10000;
    public static final int DEFAULT_METADATA_UPDATE_MAX_QUEUE_DEPTH = 10000;
    public static final long DEFAULT_PAGINATED_SEARCHER_EXPIRATION_DELAY = TimeUnit.SECONDS.toMicros(1L);
    private static final String DOCUMENTS_WITHOUT_RESULTS = "DocumentsWithoutResults";
    private static final int SEARCHER_REUSE_MAX_ATTEMPTS = 50;
    protected String indexDirectory;
    private static int expiredDocumentSearchThreshold = 1000;
    private static int indexFileCountThresholdForWriterRefresh = 10000;
    private static int versionRetentionBulkCleanupThreshold = 10000;
    private static int versionRetentionServiceThreshold = 100;
    private static int queryResultLimit = 10000;
    private static int queryPageResultLimit = 10000;
    private static long searcherRefreshIntervalMicros = 0L;
    private static int metadataUpdateMaxQueueDepth = 10000;
    private final Runnable queryTaskHandler = this::handleQueryRequest;
    private final Runnable updateRequestHandler = this::handleUpdateRequest;
    static final String LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE = "binarySerializedState";
    static final String LUCENE_FIELD_NAME_JSON_SERIALIZED_STATE = "jsonSerializedState";
    public static final String STAT_NAME_ACTIVE_QUERY_FILTERS = "activeQueryFilterCount";
    public static final String STAT_NAME_ACTIVE_PAGINATED_QUERIES = "activePaginatedQueryCount";
    public static final String STAT_NAME_COMMIT_COUNT = "commitCount";
    public static final String STAT_NAME_INDEX_LOAD_RETRY_COUNT = "indexLoadRetryCount";
    public static final String STAT_NAME_COMMIT_DURATION_MICROS = "commitDurationMicros";
    public static final String STAT_NAME_GROUP_QUERY_COUNT = "groupQueryCount";
    public static final String STAT_NAME_QUERY_DURATION_MICROS = "queryDurationMicros";
    public static final String STAT_NAME_GROUP_QUERY_DURATION_MICROS = "groupQueryDurationMicros";
    public static final String STAT_NAME_QUERY_SINGLE_DURATION_MICROS = "querySingleDurationMicros";
    public static final String STAT_NAME_QUERY_ALL_VERSIONS_DURATION_MICROS = "queryAllVersionsDurationMicros";
    public static final String STAT_NAME_RESULT_PROCESSING_DURATION_MICROS = "resultProcessingDurationMicros";
    public static final String STAT_NAME_INDEXED_FIELD_COUNT = "indexedFieldCount";
    public static final String STAT_NAME_INDEXED_DOCUMENT_COUNT = "indexedDocumentCount";
    public static final String STAT_NAME_FORCED_UPDATE_DOCUMENT_DELETE_COUNT = "singleVersionDocumentDeleteCount";
    public static final String STAT_NAME_FIELD_COUNT_PER_DOCUMENT = "fieldCountPerDocument";
    public static final String STAT_NAME_INDEXING_DURATION_MICROS = "indexingDurationMicros";
    public static final String STAT_NAME_SEARCHER_UPDATE_COUNT = "indexSearcherUpdateCount";
    public static final String STAT_NAME_SEARCHER_REUSE_BY_DOCUMENT_KIND_COUNT = "indexSearcherReuseByDocumentKindCount";
    public static final String STAT_NAME_PAGINATED_SEARCHER_UPDATE_COUNT = "paginatedIndexSearcherUpdateCount";
    public static final String STAT_NAME_PAGINATED_SEARCHER_FORCE_DELETION_COUNT = "paginatedIndexSearcherForceDeletionCount";
    public static final String STAT_NAME_WRITER_ALREADY_CLOSED_EXCEPTION_COUNT = "indexWriterAlreadyClosedFailureCount";
    public static final String STAT_NAME_READER_ALREADY_CLOSED_EXCEPTION_COUNT = "indexReaderAlreadyClosedFailureCount";
    public static final String STAT_NAME_SERVICE_DELETE_COUNT = "serviceDeleteCount";
    public static final String STAT_NAME_DOCUMENT_EXPIRATION_COUNT = "expiredDocumentCount";
    public static final String STAT_NAME_DOCUMENT_EXPIRATION_FORCED_MAINTENANCE_COUNT = "expiredDocumentForcedMaintenanceCount";
    public static final String STAT_NAME_METADATA_INDEXING_UPDATE_COUNT = "metadataIndexingUpdateCount";
    public static final String STAT_NAME_VERSION_CACHE_LOOKUP_COUNT = "versionCacheLookupCount";
    public static final String STAT_NAME_VERSION_CACHE_MISS_COUNT = "versionCacheMissCount";
    public static final String STAT_NAME_VERSION_CACHE_ENTRY_COUNT = "versionCacheEntryCount";
    public static final String STAT_NAME_MAINTENANCE_SEARCHER_REFRESH_DURATION_MICROS = "maintenanceSearcherRefreshDurationMicros";
    public static final String STAT_NAME_MAINTENANCE_DOCUMENT_EXPIRATION_DURATION_MICROS = "maintenanceDocumentExpirationDurationMicros";
    public static final String STAT_NAME_MAINTENANCE_VERSION_RETENTION_DURATION_MICROS = "maintenanceVersionRetentionDurationMicros";
    public static final String STAT_NAME_MAINTENANCE_METADATA_INDEXING_DURATION_MICROS = "maintenanceMetadataIndexingDurationMicros";
    public static final String STAT_NAME_DOCUMENT_KIND_QUERY_COUNT_FORMAT = "documentKindQueryCount-%s";
    public static final String STAT_NAME_NON_DOCUMENT_KIND_QUERY_COUNT = "nonDocumentKindQueryCount";
    public static final String STAT_NAME_SINGLE_QUERY_BY_FACTORY_COUNT_FORMAT = "singleQueryByFactoryCount-%s";
    public static final String STAT_NAME_PREFIX_UPDATE_QUEUE_DEPTH = "updateQueueDepth";
    public static final String STAT_NAME_FORMAT_UPDATE_QUEUE_DEPTH = "updateQueueDepth-%s";
    public static final String STAT_NAME_PREFIX_QUERY_QUEUE_DEPTH = "queryQueueDepth";
    public static final String STAT_NAME_FORMAT_QUERY_QUEUE_DEPTH = "queryQueueDepth-%s";
    private static final String STAT_NAME_MAINTENANCE_MEMORY_LIMIT_DURATION_MICROS = "maintenanceMemoryLimitDurationMicros";
    private static final String STAT_NAME_MAINTENANCE_FILE_LIMIT_REFRESH_DURATION_MICROS = "maintenanceFileLimitRefreshDurationMicros";
    static final String STAT_NAME_VERSION_RETENTION_SERVICE_COUNT = "versionRetentionServiceCount";
    static final String STAT_NAME_ITERATIONS_PER_QUERY = "iterationsPerQuery";
    private static final EnumSet<ServiceStats.TimeSeriesStats.AggregationType> AGGREGATION_TYPE_AVG_MAX = EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.AVG, ServiceStats.TimeSeriesStats.AggregationType.MAX);
    private static final EnumSet<ServiceStats.TimeSeriesStats.AggregationType> AGGREGATION_TYPE_SUM = EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.SUM);
    protected final Object searchSync = new Object();
    private final Object metadataUpdateSync = new Object();
    protected final Semaphore writerSync = new Semaphore(UPDATE_THREAD_COUNT + QUERY_THREAD_COUNT);
    protected Map<Long, IndexSearcher> searchers = new HashMap<Long, IndexSearcher>();
    private ThreadLocal<LuceneIndexDocumentHelper> indexDocumentHelper = ThreadLocal.withInitial(LuceneIndexDocumentHelper::new);
    protected Map<Integer, Long> searcherUpdateTimesMicros = new ConcurrentHashMap<Integer, Long>();
    protected TreeMap<Long, PaginatedSearcherInfo> paginatedSearchersByCreationTime = new TreeMap();
    protected TreeMap<Long, List<PaginatedSearcherInfo>> paginatedSearchersByExpirationTime = new TreeMap();
    protected IndexWriter writer = null;
    protected Map<String, QueryTask> activeQueries = new ConcurrentHashMap<String, QueryTask>();
    private long writerUpdateTimeMicros;
    private long writerCreationTimeMicros;
    private long serviceRemovalDetectedTimeMicros;
    private final Map<String, DocumentUpdateInfo> updatesPerLink = new HashMap<String, DocumentUpdateInfo>();
    private final Map<String, Long> liveVersionsPerLink = new HashMap<String, Long>();
    private final Map<String, Long> immutableParentLinks = new HashMap<String, Long>();
    private final Map<String, Long> documentKindUpdateInfo = new HashMap<String, Long>();
    private final SortedSet<MetadataUpdateInfo> metadataUpdates = new TreeSet<MetadataUpdateInfo>(Comparator.comparingLong(info -> info.updateTimeMicros));
    private final Map<String, MetadataUpdateInfo> metadataUpdatesPerLink = new HashMap<String, MetadataUpdateInfo>();
    long updateMapMemoryLimit;
    private Sort versionSort;
    ExecutorService privateIndexingExecutor;
    ExecutorService privateQueryExecutor;
    private Set<String> fieldsToLoadIndexingIdLookup;
    private Set<String> fieldToLoadVersionLookup;
    private Set<String> fieldsToLoadNoExpand;
    private Set<String> fieldsToLoadWithExpand;
    private final RoundRobinOperationQueue queryQueue = new RoundRobinOperationQueue("index-service-query", Integer.getInteger("xenon.LuceneDocumentIndexService.queryQueueDepth", 10000));
    private final RoundRobinOperationQueue updateQueue = new RoundRobinOperationQueue("index-service-update", Integer.getInteger("xenon.LuceneDocumentIndexService.updateQueueDepth", 100000));
    private URI uri;
    private Lucene60FieldInfosFormatWithCache fieldInfosFormat;

    public static void setImplicitQueryResultLimit(int limit) {
        queryResultLimit = limit;
    }

    public static int getImplicitQueryResultLimit() {
        return queryResultLimit;
    }

    public static void setImplicitQueryProcessingPageSize(int limit) {
        queryPageResultLimit = limit;
    }

    public static int getImplicitQueryProcessingPageSize() {
        return queryPageResultLimit;
    }

    public static void setIndexFileCountThresholdForWriterRefresh(int count) {
        indexFileCountThresholdForWriterRefresh = count;
    }

    public static int getIndexFileCountThresholdForWriterRefresh() {
        return indexFileCountThresholdForWriterRefresh;
    }

    public static void setExpiredDocumentSearchThreshold(int count) {
        expiredDocumentSearchThreshold = count;
    }

    public static int getExpiredDocumentSearchThreshold() {
        return expiredDocumentSearchThreshold;
    }

    public static void setVersionRetentionBulkCleanupThreshold(int count) {
        versionRetentionBulkCleanupThreshold = count;
    }

    public static int getVersionRetentionBulkCleanupThreshold() {
        return versionRetentionBulkCleanupThreshold;
    }

    public static void setVersionRetentionServiceThreshold(int count) {
        versionRetentionServiceThreshold = count;
    }

    public static int getVersionRetentionServiceThreshold() {
        return versionRetentionServiceThreshold;
    }

    public static long getSearcherRefreshIntervalMicros() {
        return searcherRefreshIntervalMicros;
    }

    public static void setSearcherRefreshIntervalMicros(long interval) {
        searcherRefreshIntervalMicros = interval;
    }

    public static void setMetadataUpdateMaxQueueDepth(int depth) {
        metadataUpdateMaxQueueDepth = depth;
    }

    public static int getMetadataUpdateMaxQueueDepth() {
        return metadataUpdateMaxQueueDepth;
    }

    public LuceneDocumentIndexService() {
        this(FILE_PATH_LUCENE);
    }

    public LuceneDocumentIndexService(String indexDirectory) {
        super(ServiceDocument.class);
        super.toggleOption(Service.ServiceOption.CORE, true);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        this.indexDirectory = indexDirectory;
    }

    private boolean isDurable() {
        return this.indexDirectory != null;
    }

    @Override
    public void handleStart(Operation post) {
        super.setMaintenanceIntervalMicros(this.getHost().getMaintenanceIntervalMicros() * 5L);
        this.uri = super.getUri();
        this.privateQueryExecutor = new ThreadPoolExecutor(QUERY_THREAD_COUNT, QUERY_THREAD_COUNT, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(QUERY_QUEUE_DEPTH), new NamedThreadFactory(this.getUri() + "/queries"));
        this.privateIndexingExecutor = new ThreadPoolExecutor(UPDATE_THREAD_COUNT, UPDATE_THREAD_COUNT, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(UPDATE_QUEUE_DEPTH), new NamedThreadFactory(this.getUri() + "/updates"));
        this.initializeInstance();
        if (this.isDurable()) {
            File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
            for (int retryCount = 0; retryCount < 2; ++retryCount) {
                try {
                    this.createWriter(directory, true);
                    this.doSelfValidationQuery();
                    if (retryCount != 1) break;
                    this.logInfo("Retry to create index writer was successful", new Object[0]);
                    break;
                }
                catch (Exception e) {
                    this.adjustStat(STAT_NAME_INDEX_LOAD_RETRY_COUNT, 1.0);
                    if (retryCount >= 1) {
                        this.logWarning("Failure creating index writer: %s", Utils.toString(e));
                        post.fail(e);
                        return;
                    }
                    this.logWarning("Failure creating index writer: %s, will retry", Utils.toString(e));
                    this.close(this.writer);
                    this.archiveCorruptIndexFiles(directory);
                    continue;
                }
            }
        } else {
            try {
                this.createWriter(null, false);
            }
            catch (Exception e) {
                this.logSevere(e);
                post.fail(e);
                return;
            }
        }
        this.initializeStats();
        post.complete();
    }

    private void initializeInstance() {
        this.liveVersionsPerLink.clear();
        this.updatesPerLink.clear();
        this.searcherUpdateTimesMicros.clear();
        this.paginatedSearchersByCreationTime.clear();
        this.paginatedSearchersByExpirationTime.clear();
        this.versionSort = new Sort((SortField)new SortedNumericSortField("documentVersion", SortField.Type.LONG, true));
        this.fieldsToLoadIndexingIdLookup = new HashSet<String>();
        this.fieldsToLoadIndexingIdLookup.add("documentVersion");
        this.fieldsToLoadIndexingIdLookup.add("documentUpdateAction");
        this.fieldsToLoadIndexingIdLookup.add("xenon.indexing.id");
        this.fieldsToLoadIndexingIdLookup.add("documentUpdateTimeMicros");
        this.fieldsToLoadIndexingIdLookup.add("xenon.indexing.metadata.tombstone.time");
        this.fieldToLoadVersionLookup = new HashSet<String>();
        this.fieldToLoadVersionLookup.add("documentVersion");
        this.fieldToLoadVersionLookup.add("documentUpdateTimeMicros");
        this.fieldsToLoadNoExpand = new HashSet<String>();
        this.fieldsToLoadNoExpand.add("documentSelfLink");
        this.fieldsToLoadNoExpand.add("documentVersion");
        this.fieldsToLoadNoExpand.add("documentUpdateTimeMicros");
        this.fieldsToLoadNoExpand.add("documentUpdateAction");
        this.fieldsToLoadWithExpand = new HashSet<String>(this.fieldsToLoadNoExpand);
        this.fieldsToLoadWithExpand.add("documentExpirationTimeMicros");
        this.fieldsToLoadWithExpand.add(LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE);
    }

    private void initializeStats() {
        IndexWriter w = this.writer;
        this.setTimeSeriesStat(STAT_NAME_INDEXED_DOCUMENT_COUNT, AGGREGATION_TYPE_SUM, w != null ? (double)w.numDocs() : 0.0);
        this.setTimeSeriesStat(STAT_NAME_INDEXED_FIELD_COUNT, AGGREGATION_TYPE_SUM, w != null ? (double)(w.numDocs() * 10) : 0.0);
    }

    private void setTimeSeriesStat(String name, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> type, double v) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        ServiceStats.ServiceStat dayStat = ServiceStatUtils.getOrCreateDailyTimeSeriesStat(this, name, type);
        this.setStat(dayStat, v);
        ServiceStats.ServiceStat hourStat = ServiceStatUtils.getOrCreateHourlyTimeSeriesStat(this, name, type);
        this.setStat(hourStat, v);
    }

    private void adjustTimeSeriesStat(String name, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> type, double delta) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        ServiceStats.ServiceStat dayStat = ServiceStatUtils.getOrCreateDailyTimeSeriesStat(this, name, type);
        this.adjustStat(dayStat, delta);
        ServiceStats.ServiceStat hourStat = ServiceStatUtils.getOrCreateHourlyTimeSeriesStat(this, name, type);
        this.adjustStat(hourStat, delta);
    }

    private void setTimeSeriesHistogramStat(String name, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> type, double v) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        ServiceStats.ServiceStat dayStat = ServiceStatUtils.getOrCreateDailyTimeSeriesHistogramStat(this, name, type);
        this.setStat(dayStat, v);
        ServiceStats.ServiceStat hourStat = ServiceStatUtils.getOrCreateHourlyTimeSeriesHistogramStat(this, name, type);
        this.setStat(hourStat, v);
    }

    private String getQueryStatName(QueryTask.Query query) {
        if (query.term != null) {
            if (query.term.propertyName.equals("documentKind")) {
                return String.format(STAT_NAME_DOCUMENT_KIND_QUERY_COUNT_FORMAT, query.term.matchValue);
            }
            return STAT_NAME_NON_DOCUMENT_KIND_QUERY_COUNT;
        }
        StringBuilder kindSb = new StringBuilder();
        for (QueryTask.Query clause : query.booleanClauses) {
            if (clause.term == null || clause.term.propertyName == null || clause.term.matchValue == null || !clause.term.propertyName.equals("documentKind")) continue;
            if (kindSb.length() > 0) {
                kindSb.append(", ");
            }
            kindSb.append(clause.term.matchValue);
        }
        if (kindSb.length() > 0) {
            return String.format(STAT_NAME_DOCUMENT_KIND_QUERY_COUNT_FORMAT, kindSb.toString());
        }
        return STAT_NAME_NON_DOCUMENT_KIND_QUERY_COUNT;
    }

    public IndexWriter createWriter(File directory, boolean doUpgrade) throws Exception {
        RAMDirectory luceneDirectory = directory != null ? MMapDirectory.open((Path)directory.toPath()) : new RAMDirectory();
        return this.createWriterWithLuceneDirectory((Directory)luceneDirectory, doUpgrade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexWriter createWriterWithLuceneDirectory(Directory dir, boolean doUpgrade) throws Exception {
        SimpleAnalyzer analyzer = new SimpleAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
        iwc.setCodec(this.createCodec());
        Long totalMBs = this.getHost().getServiceMemoryLimitMB(this.getSelfLink(), ServiceHost.ServiceHostState.MemoryLimitType.EXACT);
        if (totalMBs != null) {
            long cacheSizeMB = totalMBs * 99L / 100L;
            cacheSizeMB = Math.max(1L, cacheSizeMB);
            iwc.setRAMBufferSizeMB((double)cacheSizeMB);
            long memoryLimitMB = Math.max(1L, totalMBs / 100L);
            this.updateMapMemoryLimit = memoryLimitMB * 1024L * 1024L;
        }
        if (doUpgrade && DirectoryReader.indexExists((Directory)dir)) {
            this.upgradeIndex(dir);
        }
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        iwc.setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy()));
        IndexWriter w = new IndexWriter(dir, iwc);
        w.commit();
        Object object = this.searchSync;
        synchronized (object) {
            this.writer = w;
            this.updatesPerLink.clear();
            this.writerCreationTimeMicros = this.writerUpdateTimeMicros = Utils.getNowMicrosUtc();
        }
        return this.writer;
    }

    private Codec createCodec() {
        Codec codec = Codec.getDefault();
        if (!(codec.fieldInfosFormat() instanceof Lucene60FieldInfosFormat)) {
            this.getHost().log(Level.WARNING, "Caching of FieldInfo will be disabled: unsupported Lucene version", new Object[0]);
            return codec;
        }
        this.fieldInfosFormat = new Lucene60FieldInfosFormatWithCache();
        return new FilterCodec(codec.getName(), codec){

            public FieldInfosFormat fieldInfosFormat() {
                return LuceneDocumentIndexService.this.fieldInfosFormat;
            }
        };
    }

    private void upgradeIndex(Directory dir) throws IOException {
        boolean doUpgrade = false;
        String lastSegmentsFile = SegmentInfos.getLastCommitSegmentsFileName((String[])dir.listAll());
        SegmentInfos sis = SegmentInfos.readCommit((Directory)dir, (String)lastSegmentsFile);
        for (SegmentCommitInfo commit : sis) {
            if (commit.info.getVersion().equals((Object)Version.LATEST)) continue;
            this.logInfo("Found Index version %s", commit.info.getVersion().toString());
            doUpgrade = true;
            break;
        }
        if (doUpgrade) {
            this.logInfo("Upgrading index to %s", Version.LATEST.toString());
            IndexWriterConfig iwc = new IndexWriterConfig(null);
            new IndexUpgrader(dir, iwc, false).upgrade();
            this.writerUpdateTimeMicros = Utils.getNowMicrosUtc();
        }
    }

    void archiveCorruptIndexFiles(File directory) {
        File newDirectory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory + "." + Utils.getNowMicrosUtc());
        try {
            this.logWarning("Archiving corrupt index files to %s", newDirectory.toPath());
            Files.createDirectory(newDirectory.toPath(), new FileAttribute[0]);
            FileUtils.moveOrDeleteFiles(directory, newDirectory, false);
        }
        catch (IOException e) {
            this.logWarning(e.toString(), new Object[0]);
        }
    }

    private void doSelfValidationQuery() throws Exception {
        TermQuery tq = new TermQuery(new Term("documentSelfLink", this.getSelfLink()));
        ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
        Operation op = Operation.createGet(this.getUri());
        EnumSet<QueryTask.QuerySpecification.QueryOption> options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        IndexSearcher s = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.writer, (boolean)true, (boolean)true));
        this.queryIndexPaginated(op, options, s, (Query)tq, null, Integer.MAX_VALUE, 0L, null, null, rsp, null, Utils.getNowMicrosUtc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeleteRuntimeContext(Operation op) throws Exception {
        PaginatedSearcherInfo infoToRemove;
        DeleteQueryRuntimeContextRequest request = (DeleteQueryRuntimeContextRequest)op.getBodyRaw();
        if (request.context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        IndexSearcher nativeSearcher = (IndexSearcher)request.context.nativeSearcher;
        if (nativeSearcher == null) {
            throw new IllegalArgumentException("Native searcher must be present");
        }
        Object object = this.searchSync;
        synchronized (object) {
            infoToRemove = this.removeSearcherInfoUnsafe(nativeSearcher);
        }
        if (infoToRemove == null) {
            op.complete();
            return;
        }
        try {
            infoToRemove.searcher.getIndexReader().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        op.complete();
        this.adjustTimeSeriesStat(STAT_NAME_PAGINATED_SEARCHER_FORCE_DELETION_COUNT, AGGREGATION_TYPE_SUM, 1.0);
    }

    private PaginatedSearcherInfo removeSearcherInfoUnsafe(IndexSearcher searcher) {
        PaginatedSearcherInfo infoToRemove = null;
        Iterator<Map.Entry<Long, PaginatedSearcherInfo>> itr = this.paginatedSearchersByCreationTime.entrySet().iterator();
        while (itr.hasNext()) {
            PaginatedSearcherInfo info = itr.next().getValue();
            if (!info.searcher.equals(searcher)) continue;
            if (!info.singleUse) {
                throw new IllegalStateException("Context deletion is supported only for SINGLE_USE queries");
            }
            infoToRemove = info;
            itr.remove();
            break;
        }
        if (infoToRemove == null) {
            return null;
        }
        long expirationTime = infoToRemove.expirationTimeMicros;
        List<PaginatedSearcherInfo> expirationList = this.paginatedSearchersByExpirationTime.get(expirationTime);
        expirationList.remove(infoToRemove);
        if (expirationList.isEmpty()) {
            this.paginatedSearchersByExpirationTime.remove(expirationTime);
        }
        this.searcherUpdateTimesMicros.remove(infoToRemove.searcher.hashCode());
        return infoToRemove;
    }

    private void handleBackup(Operation op) throws Exception {
        if (!this.isDurable()) {
            op.fail(new IllegalStateException("Index service is not durable"));
            return;
        }
        this.logWarning("Please use backup feature from %s.", ServiceHostManagementService.class);
        String outFileName = this.indexDirectory + "-" + Utils.getNowMicrosUtc();
        Path zipFilePath = Files.createTempFile(outFileName, ".zip", new FileAttribute[0]);
        ServiceHostManagementService.BackupRequest backupRequest = new ServiceHostManagementService.BackupRequest();
        backupRequest.kind = ServiceHostManagementService.BackupRequest.KIND;
        backupRequest.backupType = ServiceHostManagementService.BackupType.ZIP;
        backupRequest.destination = zipFilePath.toUri();
        Operation patch = Operation.createPatch(this, "/core/document-index-backup").transferRequestHeadersFrom(op).transferRefererFrom(op).setBody(backupRequest).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            BackupResponse response = new BackupResponse();
            response.backupFile = backupRequest.destination;
            op.transferResponseHeadersFrom(o);
            op.setBodyNoCloning(response);
            op.complete();
        });
        this.sendRequest(patch);
    }

    private void handleRestore(Operation op) {
        if (!this.isDurable()) {
            op.fail(new IllegalStateException("Index service is not durable"));
            return;
        }
        this.logWarning("Please use restore feature from %s.", ServiceHostManagementService.class);
        RestoreRequest req = op.getBody(RestoreRequest.class);
        ServiceHostManagementService.RestoreRequest restoreRequest = new ServiceHostManagementService.RestoreRequest();
        restoreRequest.kind = ServiceHostManagementService.RestoreRequest.KIND;
        restoreRequest.destination = req.backupFile;
        restoreRequest.timeSnapshotBoundaryMicros = req.timeSnapshotBoundaryMicros;
        Operation patch = Operation.createPatch(this, "/core/document-index-backup").transferRequestHeadersFrom(op).transferRefererFrom(op).setBody(restoreRequest).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.transferResponseHeadersFrom(o);
            op.complete();
        });
        this.sendRequest(patch);
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation op) {
        Service.Action a = op.getAction();
        if (a == Service.Action.PUT) {
            Operation.failActionNotSupported(op);
            return;
        }
        if (a == Service.Action.PATCH && op.isRemote()) {
            Operation.failActionNotSupported(op);
            return;
        }
        try {
            if (a == Service.Action.GET || a == Service.Action.PATCH) {
                if (this.offerQueryOperation(op)) {
                    this.privateQueryExecutor.submit(this.queryTaskHandler);
                }
            } else if (this.offerUpdateOperation(op)) {
                this.privateIndexingExecutor.submit(this.updateRequestHandler);
            }
        }
        catch (RejectedExecutionException e) {
            op.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleQueryRequest() {
        Operation op = this.pollQueryOperation();
        if (op == null) {
            return;
        }
        if (op.getExpirationMicrosUtc() > 0L && op.getExpirationMicrosUtc() < Utils.getSystemNowMicrosUtc()) {
            op.fail(new RejectedExecutionException("Operation has expired"));
            return;
        }
        OperationContext originalContext = OperationContext.getOperationContext();
        try {
            this.writerSync.acquire();
            OperationContext.setFrom(op);
            switch (op.getAction()) {
                case GET: {
                    if (!op.isRemote() && op.hasBody() && op.getBodyRaw() instanceof InternalDocumentIndexInfo) {
                        InternalDocumentIndexInfo response = new InternalDocumentIndexInfo();
                        response.indexWriter = this.writer;
                        response.indexDirectory = this.indexDirectory;
                        response.luceneIndexService = this;
                        response.writerSync = this.writerSync;
                        op.setBodyNoCloning(response).complete();
                        return;
                    }
                    this.handleGetImpl(op);
                    return;
                }
                case PATCH: {
                    ServiceDocument sd = (ServiceDocument)op.getBodyRaw();
                    if (sd.documentKind != null) {
                        if (sd.documentKind.equals(QueryTask.KIND)) {
                            QueryTask task = (QueryTask)sd;
                            this.handleQueryTaskPatch(op, task);
                            return;
                        }
                        if (sd.documentKind.equals(DeleteQueryRuntimeContextRequest.KIND)) {
                            this.handleDeleteRuntimeContext(op);
                            return;
                        }
                        if (sd.documentKind.equals(BackupRequest.KIND)) {
                            this.handleBackup(op);
                            return;
                        }
                        if (sd.documentKind.equals(RestoreRequest.KIND)) {
                            this.handleRestore(op);
                            return;
                        }
                    }
                    Operation.failActionNotSupported(op);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            this.checkFailureAndRecover(e);
            op.fail(e);
            return;
        }
        finally {
            OperationContext.setFrom(originalContext);
            this.writerSync.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleUpdateRequest() {
        Operation op = this.pollUpdateOperation();
        if (op == null) {
            return;
        }
        OperationContext originalContext = OperationContext.getOperationContext();
        try {
            this.writerSync.acquire();
            OperationContext.setFrom(op);
            switch (op.getAction()) {
                case DELETE: {
                    this.handleDeleteImpl(op);
                    return;
                }
                case POST: {
                    Object o = op.getBodyRaw();
                    if (o != null) {
                        if (o instanceof UpdateIndexRequest) {
                            this.updateIndex(op);
                            return;
                        }
                        if (o instanceof MaintenanceRequest) {
                            this.handleMaintenanceImpl(op);
                            return;
                        }
                    }
                    Operation.failActionNotSupported(op);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            this.checkFailureAndRecover(e);
            op.fail(e);
            return;
        }
        finally {
            OperationContext.setFrom(originalContext);
            this.writerSync.release();
        }
    }

    private void handleQueryTaskPatch(Operation op, QueryTask task) throws Exception {
        QueryTask.QuerySpecification qs = task.querySpec;
        Query luceneQuery = (Query)qs.context.nativeQuery;
        Sort luceneSort = (Sort)qs.context.nativeSort;
        if (luceneQuery == null) {
            luceneQuery = LuceneQueryConverter.convert(task.querySpec.query, qs.context);
            if (qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.TIME_SNAPSHOT)) {
                Query latestDocumentClause = LongPoint.newRangeQuery((String)"documentUpdateTimeMicros", (long)0L, (long)qs.timeSnapshotBoundaryMicros);
                luceneQuery = new BooleanQuery.Builder().add(latestDocumentClause, BooleanClause.Occur.MUST).add(luceneQuery, BooleanClause.Occur.FILTER).build();
            }
            qs.context.nativeQuery = luceneQuery;
        }
        if (luceneSort == null && task.querySpec.options != null && task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.SORT)) {
            luceneSort = LuceneQueryConverter.convertToLuceneSort(task.querySpec, false);
            task.querySpec.context.nativeSort = luceneSort;
        }
        if (qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.CONTINUOUS) && this.handleContinuousQueryTaskPatch(op, task, qs)) {
            return;
        }
        if (qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.GROUP_BY)) {
            this.handleGroupByQueryTaskPatch(op, task);
            return;
        }
        QueryPageService.LuceneQueryPage lucenePage = (QueryPageService.LuceneQueryPage)qs.context.nativePage;
        IndexSearcher s = (IndexSearcher)qs.context.nativeSearcher;
        ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
        if (s == null && qs.resultLimit != null && qs.resultLimit > 0 && qs.resultLimit != Integer.MAX_VALUE && !qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS)) {
            Set<String> documentKind = qs.context.kindScope;
            long expiration = task.documentExpirationTimeMicros + DEFAULT_PAGINATED_SEARCHER_EXPIRATION_DELAY;
            s = this.createOrUpdatePaginatedQuerySearcher(expiration, this.writer, documentKind, qs.options);
        }
        if (!this.queryIndex(s, op, null, qs.options, luceneQuery, lucenePage, qs.resultLimit, task.documentExpirationTimeMicros, task.indexLink, task.nodeSelectorLink, rsp, qs)) {
            op.setBodyNoCloning(rsp).complete();
        }
    }

    private boolean handleContinuousQueryTaskPatch(Operation op, QueryTask task, QueryTask.QuerySpecification qs) throws QueryFilter.QueryFilterException {
        switch (task.taskInfo.stage) {
            case CREATED: {
                this.logWarning("Task %s is in invalid state: %s", new Object[]{task.taskInfo.stage});
                op.fail(new IllegalStateException("Stage not supported"));
                return true;
            }
            case STARTED: {
                QueryTask clonedTask = new QueryTask();
                clonedTask.documentSelfLink = task.documentSelfLink;
                clonedTask.querySpec = task.querySpec;
                clonedTask.querySpec.context.filter = QueryFilter.create(qs.query);
                clonedTask.querySpec.context.subjectLink = this.getSubject(op);
                this.activeQueries.put(task.documentSelfLink, clonedTask);
                this.adjustTimeSeriesStat(STAT_NAME_ACTIVE_QUERY_FILTERS, AGGREGATION_TYPE_SUM, 1.0);
                this.logInfo("Activated continuous query task: %s", task.documentSelfLink);
                break;
            }
            case CANCELLED: 
            case FAILED: 
            case FINISHED: {
                if (this.activeQueries.remove(task.documentSelfLink) != null) {
                    this.adjustTimeSeriesStat(STAT_NAME_ACTIVE_QUERY_FILTERS, AGGREGATION_TYPE_SUM, -1.0);
                }
                op.complete();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher createOrUpdatePaginatedQuerySearcher(long expirationMicros, IndexWriter w, Set<String> kindScope, EnumSet<QueryTask.QuerySpecification.QueryOption> queryOptions) throws IOException {
        IndexSearcher searcher;
        boolean doNotRefresh = queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.DO_NOT_REFRESH);
        boolean singleUse = queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.SINGLE_USE);
        if (singleUse || !doNotRefresh && kindScope == null) {
            return this.createPaginatedQuerySearcher(expirationMicros, w, singleUse);
        }
        Object object = this.searchSync;
        synchronized (object) {
            searcher = this.getOrUpdateExistingSearcher(expirationMicros, kindScope, doNotRefresh);
        }
        if (searcher != null) {
            return searcher;
        }
        return this.createPaginatedQuerySearcher(expirationMicros, w, false);
    }

    private IndexSearcher getOrUpdateExistingSearcher(long newExpirationMicros, Set<String> kindScope, boolean doNotRefresh) {
        if (this.paginatedSearchersByCreationTime.isEmpty()) {
            return null;
        }
        int maxAttempts = 50;
        PaginatedSearcherInfo info = null;
        for (PaginatedSearcherInfo i : this.paginatedSearchersByCreationTime.descendingMap().values()) {
            Long searcherUpdateTime;
            if (maxAttempts-- < 0) break;
            if (i.singleUse || (searcherUpdateTime = this.searcherUpdateTimesMicros.get(i.searcher.hashCode())) == null || this.documentNeedsNewSearcher(null, kindScope, -1, searcherUpdateTime, doNotRefresh)) continue;
            info = i;
            break;
        }
        if (info == null) {
            return null;
        }
        this.adjustTimeSeriesStat(STAT_NAME_SEARCHER_REUSE_BY_DOCUMENT_KIND_COUNT, AGGREGATION_TYPE_SUM, 1.0);
        long currentExpirationMicros = info.expirationTimeMicros;
        if (newExpirationMicros <= currentExpirationMicros) {
            return info.searcher;
        }
        List expirationList = this.paginatedSearchersByExpirationTime.get(currentExpirationMicros);
        if (expirationList == null || !expirationList.contains(info)) {
            throw new IllegalStateException("Searcher not found in expiration list");
        }
        expirationList.remove(info);
        if (expirationList.isEmpty()) {
            this.paginatedSearchersByExpirationTime.remove(currentExpirationMicros);
        }
        info.expirationTimeMicros = newExpirationMicros;
        expirationList = this.paginatedSearchersByExpirationTime.computeIfAbsent(newExpirationMicros, _k -> new ArrayList(1));
        expirationList.add(info);
        return info.searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher createPaginatedQuerySearcher(long expirationMicros, IndexWriter w, boolean singleUse) throws IOException {
        if (w == null) {
            throw new IllegalStateException("Writer not available");
        }
        this.adjustTimeSeriesStat(STAT_NAME_PAGINATED_SEARCHER_UPDATE_COUNT, AGGREGATION_TYPE_SUM, 1.0);
        long now = Utils.getNowMicrosUtc();
        IndexSearcher s = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)w, (boolean)true, (boolean)true));
        s.setSimilarity(s.getSimilarity(false));
        PaginatedSearcherInfo info = new PaginatedSearcherInfo();
        info.creationTimeMicros = now;
        info.expirationTimeMicros = expirationMicros;
        info.singleUse = singleUse;
        info.searcher = s;
        Object object = this.searchSync;
        synchronized (object) {
            this.paginatedSearchersByCreationTime.put(info.creationTimeMicros, info);
            List expirationList = this.paginatedSearchersByExpirationTime.computeIfAbsent(info.expirationTimeMicros, _k -> new ArrayList(1));
            expirationList.add(info);
            this.searcherUpdateTimesMicros.put(s.hashCode(), now);
        }
        return s;
    }

    public void handleGetImpl(Operation get) throws Exception {
        String selfLink = null;
        Long version = null;
        Service.ServiceOption serviceOption = Service.ServiceOption.NONE;
        EnumSet<QueryTask.QuerySpecification.QueryOption> options = EnumSet.noneOf(QueryTask.QuerySpecification.QueryOption.class);
        if (get.hasPragmaDirective("xn-check-index")) {
            serviceOption = Service.ServiceOption.PERSISTENCE;
            selfLink = get.getUri().getPath();
            options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_DELETED);
        } else {
            Map<String, String> params = UriUtils.parseUriQueryParams(get.getUri());
            String cap = params.get("capability");
            if (cap != null) {
                serviceOption = Service.ServiceOption.valueOf(cap);
            }
            if (serviceOption == Service.ServiceOption.IMMUTABLE) {
                options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
                serviceOption = Service.ServiceOption.PERSISTENCE;
            }
            if (params.containsKey("includeDeleted")) {
                options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_DELETED);
            }
            if (params.containsKey("documentVersion")) {
                version = Long.parseLong(params.get("documentVersion"));
            }
            selfLink = params.get("documentSelfLink");
            String fieldToExpand = params.get("$expand");
            if (fieldToExpand == null) {
                fieldToExpand = params.get("expand");
            }
            if (fieldToExpand != null && fieldToExpand.equals("documentLinks")) {
                options.add(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
            }
        }
        if (selfLink == null) {
            get.fail(new IllegalArgumentException("documentSelfLink query parameter is required"));
            return;
        }
        if (!selfLink.endsWith("*")) {
            if (get.isRemote() && this.getHost().isAuthorizationEnabled()) {
                get.nestCompletion((op, ex) -> {
                    ServiceDocument doc;
                    if (ex != null) {
                        get.fail(ex);
                        return;
                    }
                    if (get.getAuthorizationContext().isSystemUser() || !op.hasBody()) {
                        get.complete();
                        return;
                    }
                    QueryFilter queryFilter = get.getAuthorizationContext().getResourceQueryFilter(Service.Action.GET);
                    if (queryFilter == null) {
                        queryFilter = QueryFilter.FALSE;
                    }
                    if (!QueryFilterUtils.evaluate(queryFilter, doc = (ServiceDocument)op.getBodyRaw(), this.getHost())) {
                        get.fail(403);
                        return;
                    }
                    get.complete();
                });
            }
            this.queryIndexSingle(selfLink, get, version);
            return;
        }
        int resultLimit = Integer.MAX_VALUE;
        selfLink = selfLink.substring(0, selfLink.length() - 1);
        PrefixQuery tq = new PrefixQuery(new Term("documentSelfLink", selfLink));
        ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
        rsp.documentLinks = new ArrayList<String>();
        if (this.queryIndex(null, get, selfLink, options, (Query)tq, null, resultLimit, 0L, null, null, rsp, null)) {
            return;
        }
        if (serviceOption == Service.ServiceOption.PERSISTENCE) {
            get.setBodyNoCloning(rsp).complete();
            return;
        }
        this.queryServiceHost(selfLink + "*", options, get);
    }

    private Operation pollQueryOperation() {
        return this.queryQueue.poll();
    }

    private Operation pollUpdateOperation() {
        return this.updateQueue.poll();
    }

    private boolean offerQueryOperation(Operation op) {
        String subject = this.getSubject(op);
        return this.queryQueue.offer(subject, op);
    }

    private boolean offerUpdateOperation(Operation op) {
        String subject = this.getSubject(op);
        return this.updateQueue.offer(subject, op);
    }

    private String getSubject(Operation op) {
        if (op.getAuthorizationContext() != null && op.getAuthorizationContext().isSystemUser()) {
            return SystemUserService.SELF_LINK;
        }
        if (this.getHost().isAuthorizationEnabled()) {
            return op.getAuthorizationContext().getClaims().getSubject();
        }
        return GuestUserService.SELF_LINK;
    }

    private boolean queryIndex(IndexSearcher s, Operation op, String selfLinkPrefix, EnumSet<QueryTask.QuerySpecification.QueryOption> options, Query tq, QueryPageService.LuceneQueryPage page, int count, long expiration, String indexLink, String nodeSelectorPath, ServiceDocumentQueryResult rsp, QueryTask.QuerySpecification qs) throws Exception {
        long queryStartTimeMicros;
        if (options == null) {
            options = EnumSet.noneOf(QueryTask.QuerySpecification.QueryOption.class);
        }
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT) || options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT) || options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_SELECTED_FIELDS)) {
            rsp.documents = new HashMap<String, Object>();
        }
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
            rsp.documentCount = 0L;
        } else {
            rsp.documentLinks = new ArrayList<String>();
        }
        IndexWriter w = this.writer;
        if (w == null) {
            op.fail(new CancellationException("Index writer is null"));
            return true;
        }
        Set<String> kindScope = null;
        if (qs != null && qs.context != null) {
            kindScope = qs.context.kindScope;
        }
        if (s == null) {
            s = this.createOrRefreshSearcher(selfLinkPrefix, kindScope, count, w, options.contains((Object)QueryTask.QuerySpecification.QueryOption.DO_NOT_REFRESH));
        }
        if ((tq = this.updateQuery(op, qs, tq, queryStartTimeMicros = Utils.getNowMicrosUtc(), options)) == null) {
            return false;
        }
        if (qs != null && qs.query != null && this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            String queryStat = this.getQueryStatName(qs.query);
            this.adjustStat(queryStat, 1.0);
        }
        ServiceDocumentQueryResult result = options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT) ? this.queryIndexCount(options, s, tq, rsp, qs, queryStartTimeMicros, nodeSelectorPath) : this.queryIndexPaginated(op, options, s, tq, page, count, expiration, indexLink, nodeSelectorPath, rsp, qs, queryStartTimeMicros);
        result.documentOwner = this.getHost().getId();
        if (!options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT) && result.documentLinks.isEmpty()) {
            return false;
        }
        op.setBodyNoCloning(result).complete();
        return true;
    }

    private void queryIndexSingle(String selfLink, Operation op, Long version) throws Exception {
        String factoryLink;
        IndexWriter w = this.writer;
        if (w == null) {
            op.fail(new CancellationException("Index writer is null"));
            return;
        }
        IndexSearcher s = this.createOrRefreshSearcher(selfLink, null, 1, w, false);
        long startNanos = System.nanoTime();
        TopDocs hits = this.queryIndexForVersion(selfLink, s, version, null);
        long durationNanos = System.nanoTime() - startNanos;
        this.setTimeSeriesHistogramStat(STAT_NAME_QUERY_SINGLE_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, TimeUnit.NANOSECONDS.toMicros(durationNanos));
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION) && (factoryLink = UriUtils.getParentPath(selfLink)) != null) {
            String statKey = String.format(STAT_NAME_SINGLE_QUERY_BY_FACTORY_COUNT_FORMAT, factoryLink);
            this.adjustStat(statKey, 1.0);
        }
        if (hits.totalHits == 0) {
            op.complete();
            return;
        }
        DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
        this.loadDoc(s, visitor, hits.scoreDocs[0].doc, this.fieldsToLoadWithExpand);
        boolean hasExpired = false;
        Long expiration = visitor.documentExpirationTimeMicros;
        if (expiration != null) {
            boolean bl = hasExpired = expiration <= Utils.getSystemNowMicrosUtc();
        }
        if (hasExpired) {
            op.complete();
            return;
        }
        ServiceDocument sd = this.getStateFromLuceneDocument(visitor, selfLink);
        op.setBodyNoCloning(sd).complete();
    }

    private TopDocs queryIndexForVersion(String selfLink, IndexSearcher s, Long version, Long documentsUpdatedBeforeInMicros) throws IOException {
        TermQuery tqSelfLink = new TermQuery(new Term("documentSelfLink", selfLink));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add((Query)tqSelfLink, BooleanClause.Occur.MUST);
        if (documentsUpdatedBeforeInMicros != null) {
            Query documentsUpdatedBeforeInMicrosQuery = LongPoint.newRangeQuery((String)"documentUpdateTimeMicros", (long)0L, (long)documentsUpdatedBeforeInMicros);
            builder.add(documentsUpdatedBeforeInMicrosQuery, BooleanClause.Occur.MUST);
        } else if (version != null) {
            Query versionQuery = LongPoint.newRangeQuery((String)"documentVersion", (long)version, (long)version);
            builder.add(versionQuery, BooleanClause.Occur.MUST);
        }
        TopFieldDocs hits = s.search((Query)builder.build(), 1, this.versionSort, false, false);
        return hits;
    }

    private void queryServiceHost(String selfLink, EnumSet<QueryTask.QuerySpecification.QueryOption> options, Operation op) {
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
            op.nestCompletion(o -> this.expandLinks((Operation)o, op));
        }
        this.getHost().queryServiceUris(selfLink, op);
    }

    private Query updateQuery(Operation op, QueryTask.QuerySpecification qs, Query tq, long now, EnumSet<QueryTask.QuerySpecification.QueryOption> queryOptions) {
        Query expirationClause = LongPoint.newRangeQuery((String)"documentExpirationTimeMicros", (long)1L, (long)now);
        BooleanQuery.Builder builder = new BooleanQuery.Builder().add(expirationClause, BooleanClause.Occur.MUST_NOT).add(tq, BooleanClause.Occur.FILTER);
        if (queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.INDEXED_METADATA)) {
            if (!queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS) && !queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.TIME_SNAPSHOT)) {
                Query currentClause = NumericDocValuesField.newExactQuery((String)"xenon.indexing.metadata.tombstone.time", (long)Long.MAX_VALUE);
                builder.add(currentClause, BooleanClause.Occur.MUST);
            }
            if (qs != null && qs.sortTerm == null && queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.TIME_SNAPSHOT)) {
                Query tombstoneClause = NumericDocValuesField.newRangeQuery((String)"xenon.indexing.metadata.tombstone.time", (long)qs.timeSnapshotBoundaryMicros, (long)Long.MAX_VALUE);
                builder.add(tombstoneClause, BooleanClause.Occur.MUST);
            }
        }
        if (!this.getHost().isAuthorizationEnabled()) {
            return builder.build();
        }
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx == null) {
            return null;
        }
        if (ctx.isSystemUser()) {
            return builder.build();
        }
        QueryTask.Query resourceQuery = ctx.getResourceQuery(Service.Action.GET);
        Object rq = null;
        rq = resourceQuery == null ? new MatchNoDocsQuery() : LuceneQueryConverter.convert(resourceQuery, null);
        builder.add((Query)rq, BooleanClause.Occur.FILTER);
        return builder.build();
    }

    private void handleGroupByQueryTaskPatch(Operation op, QueryTask task) throws IOException {
        QueryTask.QuerySpecification qs = task.querySpec;
        IndexSearcher s = (IndexSearcher)qs.context.nativeSearcher;
        QueryPageService.LuceneQueryPage page = (QueryPageService.LuceneQueryPage)qs.context.nativePage;
        Query tq = (Query)qs.context.nativeQuery;
        Sort sort = (Sort)qs.context.nativeSort;
        if (sort == null && qs.sortTerm != null) {
            sort = LuceneQueryConverter.convertToLuceneSort(qs, false);
        }
        Sort groupSort = null;
        if (qs.groupSortTerm != null) {
            groupSort = LuceneQueryConverter.convertToLuceneSort(qs, true);
        }
        GroupingSearch groupingSearch = qs.groupByTerm.propertyType == ServiceDocumentDescription.TypeName.LONG || qs.groupByTerm.propertyType == ServiceDocumentDescription.TypeName.DOUBLE ? new GroupingSearch(qs.groupByTerm.propertyName + "_groupBySuffix") : new GroupingSearch(LuceneIndexDocumentHelper.createSortFieldPropertyName(qs.groupByTerm.propertyName));
        groupingSearch.setGroupSort(groupSort);
        groupingSearch.setSortWithinGroup(sort);
        this.adjustTimeSeriesStat(STAT_NAME_GROUP_QUERY_COUNT, AGGREGATION_TYPE_SUM, 1.0);
        int groupOffset = page != null ? page.groupOffset : 0;
        int groupLimit = qs.groupResultLimit != null ? qs.groupResultLimit : 10000;
        Set<String> kindScope = qs.context.kindScope;
        if (s == null && qs.groupResultLimit != null) {
            long expiration = task.documentExpirationTimeMicros + DEFAULT_PAGINATED_SEARCHER_EXPIRATION_DELAY;
            s = this.createOrUpdatePaginatedQuerySearcher(expiration, this.writer, kindScope, qs.options);
        }
        if (s == null) {
            s = this.createOrRefreshSearcher(null, kindScope, Integer.MAX_VALUE, this.writer, qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.DO_NOT_REFRESH));
        }
        ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
        rsp.nextPageLinksPerGroup = new TreeMap<String, String>();
        long startNanos = System.nanoTime();
        TopGroups groups = groupingSearch.search(s, tq, groupOffset, groupLimit);
        long durationNanos = System.nanoTime() - startNanos;
        this.setTimeSeriesHistogramStat(STAT_NAME_GROUP_QUERY_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, TimeUnit.NANOSECONDS.toMicros(durationNanos));
        for (GroupDocs groupDocs : groups.groups) {
            if (groupDocs.totalHits == 0) continue;
            QueryTask.Query perGroupQuery = Utils.clone(qs.query);
            String groupValue = groupDocs.groupValue != null ? ((BytesRef)groupDocs.groupValue).utf8ToString() : DOCUMENTS_WITHOUT_RESULTS;
            QueryTask.Query clause = new QueryTask.Query().setTermPropertyName(qs.groupByTerm.propertyName).setTermMatchType(QueryTask.QueryTerm.MatchType.TERM);
            clause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
            if (qs.groupByTerm.propertyType == ServiceDocumentDescription.TypeName.LONG && groupDocs.groupValue != null) {
                clause.setNumericRange(QueryTask.NumericRange.createEqualRange(Long.parseLong(groupValue)));
            } else if (qs.groupByTerm.propertyType == ServiceDocumentDescription.TypeName.DOUBLE && groupDocs.groupValue != null) {
                clause.setNumericRange(QueryTask.NumericRange.createEqualRange(Double.parseDouble(groupValue)));
            } else {
                clause.setTermMatchValue(groupValue);
            }
            if (perGroupQuery.booleanClauses == null) {
                QueryTask.Query topLevelClause = perGroupQuery;
                perGroupQuery.addBooleanClause(topLevelClause);
            }
            perGroupQuery.addBooleanClause(clause);
            Query lucenePerGroupQuery = LuceneQueryConverter.convert(perGroupQuery, qs.context);
            String pageLink = this.createNextPage(op, s, qs, lucenePerGroupQuery, sort, null, 0, null, task.documentExpirationTimeMicros, task.indexLink, task.nodeSelectorLink, false);
            rsp.nextPageLinksPerGroup.put(groupValue, pageLink);
        }
        if (qs.groupResultLimit != null && groups.groups.length >= groupLimit) {
            groups = groupingSearch.search(s, tq, groupLimit + groupOffset, groupLimit);
            if (groups.totalGroupedHitCount > 0) {
                rsp.nextPageLink = this.createNextPage(op, s, qs, tq, sort, null, 0, groupLimit + groupOffset, task.documentExpirationTimeMicros, task.indexLink, task.nodeSelectorLink, page != null);
            }
        }
        op.setBodyNoCloning(rsp).complete();
    }

    private ServiceDocumentQueryResult queryIndexCount(EnumSet<QueryTask.QuerySpecification.QueryOption> queryOptions, IndexSearcher searcher, Query termQuery, ServiceDocumentQueryResult response, QueryTask.QuerySpecification querySpec, long queryStartTimeMicros, String nodeSelectorPath) throws Exception {
        if (queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS)) {
            response.documentCount = searcher.count(termQuery);
            long queryTimeMicros = Utils.getNowMicrosUtc() - queryStartTimeMicros;
            response.queryTimeMicros = queryTimeMicros;
            this.setTimeSeriesHistogramStat(STAT_NAME_QUERY_ALL_VERSIONS_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, queryTimeMicros);
            return response;
        }
        response.queryTimeMicros = 0L;
        TopDocs results = null;
        ScoreDoc after = null;
        long start = queryStartTimeMicros;
        int resultLimit = queryResultLimit;
        if (querySpec.resultLimit != null && querySpec.resultLimit != Integer.MAX_VALUE) {
            resultLimit = querySpec.resultLimit;
            if (querySpec.resultLimit < 10000) {
                this.logWarning("\n*****\nresultLimit value is too low, query will take much longer on large result sets.Do not set this value for COUNT queries, or set it above default of 10000\n*****\n", new Object[0]);
            }
        }
        while (true) {
            results = searcher.searchAfter(after, termQuery, resultLimit);
            long queryEndTimeMicros = Utils.getNowMicrosUtc();
            long luceneQueryDurationMicros = queryEndTimeMicros - start;
            long queryDurationMicros = queryEndTimeMicros - queryStartTimeMicros;
            response.queryTimeMicros = queryDurationMicros;
            if (results == null || results.scoreDocs == null || results.scoreDocs.length == 0) break;
            this.setTimeSeriesHistogramStat(STAT_NAME_QUERY_ALL_VERSIONS_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, luceneQueryDurationMicros);
            after = this.processQueryResults(querySpec, queryOptions, resultLimit, searcher, response, results.scoreDocs, start, nodeSelectorPath, false);
            long now = Utils.getNowMicrosUtc();
            this.setTimeSeriesHistogramStat(STAT_NAME_RESULT_PROCESSING_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, now - queryEndTimeMicros);
            start = now;
        }
        response.documentLinks.clear();
        return response;
    }

    private ServiceDocumentQueryResult queryIndexPaginated(Operation op, EnumSet<QueryTask.QuerySpecification.QueryOption> options, IndexSearcher s, Query tq, QueryPageService.LuceneQueryPage page, int count, long expiration, String indexLink, String nodeSelectorPath, ServiceDocumentQueryResult rsp, QueryTask.QuerySpecification qs, long queryStartTimeMicros) throws Exception {
        int offset;
        int hitCount;
        ScoreDoc after = null;
        boolean hasExplicitLimit = count != Integer.MAX_VALUE;
        boolean isPaginatedQuery = hasExplicitLimit && !options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS);
        boolean hasPage = page != null;
        boolean shouldProcessResults = true;
        boolean useDirectSearch = options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS) && options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        int resultLimit = count;
        if (isPaginatedQuery && !hasPage) {
            resultLimit = 1;
            hitCount = 1;
            shouldProcessResults = false;
            rsp.documentCount = 1L;
        } else {
            hitCount = !hasExplicitLimit ? queryResultLimit : (!options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS) ? Math.max(resultLimit, queryPageResultLimit) : resultLimit);
        }
        if (hasPage) {
            after = page.after;
            rsp.prevPageLink = page.previousPageLink;
        }
        Sort sort = this.versionSort;
        if (qs != null && qs.sortTerm != null) {
            if (qs.context != null) {
                sort = (Sort)qs.context.nativeSort;
            }
            if (sort == null) {
                sort = LuceneQueryConverter.convertToLuceneSort(qs, false);
            }
        }
        Object results = null;
        int queryCount = 0;
        rsp.queryTimeMicros = 0L;
        long start = queryStartTimeMicros;
        int n = offset = qs == null || qs.offset == null ? 0 : qs.offset;
        do {
            results = useDirectSearch ? (sort == null ? s.search(tq, hitCount) : s.search(tq, hitCount, sort, false, false)) : (sort == null ? s.searchAfter(after, tq, hitCount) : s.searchAfter(after, tq, hitCount, sort, false, false));
            if (results == null) {
                return rsp;
            }
            ++queryCount;
            long end = Utils.getNowMicrosUtc();
            if (!(hasExplicitLimit || hasPage || isPaginatedQuery || results.totalHits <= hitCount)) {
                throw new IllegalStateException("Query returned large number of results, please specify a resultLimit. Results:" + results.totalHits + ", QuerySpec: " + Utils.toJson(qs));
            }
            ScoreDoc[] hits = results.scoreDocs;
            long queryTime = end - start;
            rsp.documentCount = 0L;
            ServiceDocumentQueryResult serviceDocumentQueryResult = rsp;
            Long.valueOf(serviceDocumentQueryResult.queryTimeMicros + queryTime);
            serviceDocumentQueryResult.queryTimeMicros = serviceDocumentQueryResult.queryTimeMicros;
            ScoreDoc bottom = null;
            if (shouldProcessResults) {
                start = end;
                bottom = this.processQueryResults(qs, options, count, s, rsp, hits, queryStartTimeMicros, nodeSelectorPath, true);
                end = Utils.getNowMicrosUtc();
                int size = rsp.documentLinks.size();
                if (size < offset) {
                    rsp.documentLinks.clear();
                    rsp.documentCount = 0L;
                    if (rsp.documents != null) {
                        rsp.documents.clear();
                    }
                    offset -= size;
                } else {
                    List<String> links = rsp.documentLinks.subList(0, offset);
                    if (rsp.documents != null) {
                        links.forEach(rsp.documents::remove);
                    }
                    ServiceDocumentQueryResult serviceDocumentQueryResult2 = rsp;
                    Long.valueOf(serviceDocumentQueryResult2.documentCount - (long)links.size());
                    serviceDocumentQueryResult2.documentCount = serviceDocumentQueryResult2.documentCount;
                    links.clear();
                    offset = 0;
                }
                if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                    String statName = options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS) ? STAT_NAME_QUERY_ALL_VERSIONS_DURATION_MICROS : STAT_NAME_QUERY_DURATION_MICROS;
                    this.setTimeSeriesHistogramStat(statName, AGGREGATION_TYPE_AVG_MAX, queryTime);
                    this.setTimeSeriesHistogramStat(STAT_NAME_RESULT_PROCESSING_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, end - start);
                }
            }
            if (count == Integer.MAX_VALUE || useDirectSearch || hits.length == 0) break;
            if (isPaginatedQuery) {
                if (!hasPage) {
                    bottom = null;
                }
                if (!hasPage || rsp.documentLinks.size() >= count || hits.length < resultLimit) {
                    boolean createNextPageLink = true;
                    if (hasPage) {
                        int numOfHits = hitCount + offset;
                        createNextPageLink = this.checkNextPageHasEntry(bottom, options, s, tq, sort, numOfHits, qs, queryStartTimeMicros, nodeSelectorPath);
                    }
                    if (!createNextPageLink) break;
                    rsp.nextPageLink = this.createNextPage(op, s, qs, tq, sort, bottom, offset, null, expiration, indexLink, nodeSelectorPath, hasPage);
                    break;
                }
            }
            after = bottom;
        } while ((resultLimit = count - rsp.documentLinks.size()) > 0);
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            ServiceStats.ServiceStat st = ServiceStatUtils.getOrCreateHistogramStat(this, STAT_NAME_ITERATIONS_PER_QUERY);
            this.setStat(st, (double)queryCount);
        }
        return rsp;
    }

    private boolean checkNextPageHasEntry(ScoreDoc after, EnumSet<QueryTask.QuerySpecification.QueryOption> options, IndexSearcher s, Query tq, Sort sort, int count, QueryTask.QuerySpecification qs, long queryStartTimeMicros, String nodeSelectorPath) throws Exception {
        ScoreDoc[] hits;
        Object nextPageResults;
        boolean hasValidNextPageEntry = false;
        while (after != null && (nextPageResults = sort == null ? s.searchAfter(after, tq, count) : s.searchAfter(after, tq, count, sort, false, false)) != null && (hits = nextPageResults.scoreDocs).length != 0) {
            ServiceDocumentQueryResult rspForNextPage = new ServiceDocumentQueryResult();
            rspForNextPage.documents = new HashMap<String, Object>();
            after = this.processQueryResults(qs, options, 1, s, rspForNextPage, hits, queryStartTimeMicros, nodeSelectorPath, false);
            if (rspForNextPage.documentCount <= 0L) continue;
            hasValidNextPageEntry = true;
            break;
        }
        return hasValidNextPageEntry;
    }

    private String createNextPage(Operation op, IndexSearcher s, QueryTask.QuerySpecification qs, Query tq, Sort sort, ScoreDoc after, int offset, Integer groupOffset, long expiration, String indexLink, String nodeSelectorPath, boolean hasPage) {
        String nextPageId = Utils.getNowMicrosUtc() + "";
        URI u = UriUtils.buildUri(this.getHost(), UriUtils.buildUriPath(ServiceUriPaths.CORE_QUERY_PAGE, nextPageId));
        URI forwarderUri = UriUtils.buildForwardToQueryPageUri(u, this.getHost().getId());
        String nextLink = forwarderUri.getPath() + "?" + forwarderUri.getQuery();
        String prevLinkForNewPage = null;
        boolean isForwardOnly = qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.FORWARD_ONLY);
        if (!isForwardOnly) {
            URI forwarderUriOfPrevLinkForNewPage = UriUtils.buildForwardToQueryPageUri(op.getReferer(), this.getHost().getId());
            prevLinkForNewPage = forwarderUriOfPrevLinkForNewPage.getPath() + "?" + forwarderUriOfPrevLinkForNewPage.getQuery();
        }
        QueryPageService.LuceneQueryPage page = null;
        page = after != null || groupOffset == null ? new QueryPageService.LuceneQueryPage(hasPage ? prevLinkForNewPage : null, after) : new QueryPageService.LuceneQueryPage(hasPage ? prevLinkForNewPage : null, groupOffset);
        QueryTask.QuerySpecification spec = new QueryTask.QuerySpecification();
        qs.copyTo(spec);
        if (groupOffset == null) {
            spec.options.remove((Object)QueryTask.QuerySpecification.QueryOption.GROUP_BY);
        }
        spec.offset = offset;
        spec.context.nativeQuery = tq;
        spec.context.nativePage = page;
        spec.context.nativeSearcher = s;
        spec.context.nativeSort = sort;
        ServiceDocument body = new ServiceDocument();
        body.documentSelfLink = u.getPath();
        body.documentExpirationTimeMicros = expiration;
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx != null) {
            body.documentAuthPrincipalLink = ctx.getClaims().getSubject();
        }
        Operation startPost = Operation.createPost(u).setBody(body).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Unable to start next page service: %s", e.toString());
            }
        });
        if (ctx != null) {
            this.setAuthorizationContext(startPost, ctx);
        }
        this.getHost().startService(startPost, new QueryPageService(spec, indexLink, nodeSelectorPath));
        return nextLink;
    }

    private ScoreDoc processQueryResults(QueryTask.QuerySpecification qs, EnumSet<QueryTask.QuerySpecification.QueryOption> options, int resultLimit, IndexSearcher s, ServiceDocumentQueryResult rsp, ScoreDoc[] hits, long queryStartTimeMicros, String nodeSelectorPath, boolean populateResponse) throws Exception {
        Set linkBlackList;
        ScoreDoc lastDocVisited = null;
        Set<String> fieldsToLoad = this.fieldsToLoadNoExpand;
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT) || options.contains((Object)QueryTask.QuerySpecification.QueryOption.OWNER_SELECTION) || options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT) || options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_SELECTED_FIELDS)) {
            fieldsToLoad = this.fieldsToLoadWithExpand;
        }
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.SELECT_LINKS)) {
            fieldsToLoad = new HashSet<String>(fieldsToLoad);
            for (QueryTask.QueryTerm link : qs.linkTerms) {
                fieldsToLoad.add(link.propertyName);
            }
        }
        LinkedHashSet<String> uniques = new LinkedHashSet<String>(rsp.documentLinks);
        boolean hasCountOption = options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT);
        boolean hasIncludeAllVersionsOption = options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        Set<String> linkWhiteList = null;
        long documentsUpdatedBefore = -1L;
        Set<Object> set = linkBlackList = options.contains((Object)QueryTask.QuerySpecification.QueryOption.TIME_SNAPSHOT) ? Collections.emptySet() : null;
        if (qs != null) {
            if (qs.context != null && qs.context.documentLinkWhiteList != null) {
                linkWhiteList = qs.context.documentLinkWhiteList;
            }
            if (qs.timeSnapshotBoundaryMicros != null) {
                documentsUpdatedBefore = qs.timeSnapshotBoundaryMicros;
            }
        }
        long searcherUpdateTime = this.getSearcherUpdateTime(s, queryStartTimeMicros);
        HashMap<String, Long> latestVersionPerLink = new HashMap<String, Long>();
        DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
        for (ScoreDoc sd : hits) {
            String link;
            if (!hasCountOption && uniques.size() >= resultLimit) break;
            lastDocVisited = sd;
            this.loadDoc(s, visitor, sd.doc, fieldsToLoad);
            String originalLink = link = visitor.documentSelfLink;
            if (linkWhiteList != null && !linkWhiteList.contains(link) || linkBlackList != null && linkBlackList.contains(originalLink)) continue;
            long documentVersion = visitor.documentVersion;
            Long latestVersion = (Long)latestVersionPerLink.get(originalLink);
            if (hasIncludeAllVersionsOption) {
                link = UriUtils.buildPathWithVersion(link, documentVersion);
            } else {
                if (latestVersion == null) {
                    latestVersion = this.getLatestVersion(s, searcherUpdateTime, link, documentVersion, documentsUpdatedBefore);
                    if (latestVersion == -1L) {
                        linkBlackList.add(originalLink);
                        continue;
                    }
                    latestVersionPerLink.put(originalLink, latestVersion);
                }
                if (documentVersion < latestVersion) continue;
                boolean isDeleted = Service.Action.DELETE.name().equals(visitor.documentUpdateAction);
                if (isDeleted && !options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_DELETED)) {
                    if (documentVersion < latestVersion) continue;
                    uniques.remove(link);
                    if (rsp.documents != null) {
                        rsp.documents.remove(link);
                    }
                    if (rsp.selectedLinksPerDocument == null) continue;
                    rsp.selectedLinksPerDocument.remove(link);
                    continue;
                }
            }
            if (hasCountOption) {
                uniques.add(link);
                continue;
            }
            String json = null;
            ServiceDocument state = null;
            if ((options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT) || options.contains((Object)QueryTask.QuerySpecification.QueryOption.OWNER_SELECTION) || options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_SELECTED_FIELDS)) && (state = this.getStateFromLuceneDocument(visitor, originalLink)) == null) {
                this.augmentDoc(s, visitor, sd.doc, LUCENE_FIELD_NAME_JSON_SERIALIZED_STATE);
                json = visitor.jsonSerializedState;
                if (json == null) continue;
            }
            if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.OWNER_SELECTION) && !this.processQueryResultsForOwnerSelection(json, state, nodeSelectorPath)) continue;
            if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT) && !rsp.documents.containsKey(link)) {
                byte[] binaryData = visitor.binarySerializedState;
                if (binaryData != null) {
                    ByteBuffer buffer = ByteBuffer.wrap(binaryData, 0, binaryData.length);
                    rsp.documents.put(link, buffer);
                } else {
                    this.logWarning("Binary State not found for %s", link);
                }
            } else if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT) && !rsp.documents.containsKey(link)) {
                if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BUILTIN_CONTENT_ONLY)) {
                    ServiceDocument stateClone = new ServiceDocument();
                    state.copyTo(stateClone);
                    rsp.documents.put(link, stateClone);
                } else if (state == null) {
                    rsp.documents.put(link, Utils.fromJson(json, JsonElement.class));
                } else {
                    JsonObject jo = this.toJsonElement(state);
                    rsp.documents.put(link, jo);
                }
            } else if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_SELECTED_FIELDS) && !rsp.documents.containsKey(link)) {
                TreeSet selectFields = new TreeSet();
                if (qs != null) {
                    qs.selectTerms.forEach(qt -> selectFields.add(qt.propertyName));
                }
                ServiceDocument copy = (ServiceDocument)state.getClass().newInstance();
                for (String selectField : selectFields) {
                    Field field = ReflectionUtils.getField(state.getClass(), selectField);
                    if (field != null) {
                        Object value = field.get(state);
                        if (value == null) continue;
                        field.set(copy, value);
                        continue;
                    }
                    this.logFine("Unknown field '%s' passed for EXPAND_SELECTED_FIELDS", selectField);
                }
                JsonObject jo = this.toJsonElement(copy);
                Iterator it = jo.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    if (selectFields.contains(entry.getKey())) continue;
                    it.remove();
                }
                rsp.documents.put(link, jo);
            }
            if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.SELECT_LINKS)) {
                this.processQueryResultsForSelectLinks(s, qs, rsp, visitor, sd.doc, link, state);
            }
            uniques.add(link);
        }
        rsp.documentLinks.clear();
        rsp.documentLinks.addAll(uniques);
        rsp.documentCount = rsp.documentLinks.size();
        return lastDocVisited;
    }

    private JsonObject toJsonElement(ServiceDocument state) {
        return (JsonObject)GsonSerializers.getJsonMapperFor(state.getClass()).toJsonElement(state);
    }

    private void loadDoc(IndexSearcher s, DocumentStoredFieldVisitor visitor, int docId, Set<String> fields) throws IOException {
        visitor.reset(fields);
        s.doc(docId, (StoredFieldVisitor)visitor);
    }

    private void augmentDoc(IndexSearcher s, DocumentStoredFieldVisitor visitor, int docId, String field) throws IOException {
        visitor.reset(field);
        s.doc(docId, (StoredFieldVisitor)visitor);
    }

    private boolean processQueryResultsForOwnerSelection(String json, ServiceDocument state, String nodeSelectorPath) {
        NodeSelectorService.SelectOwnerResponse ownerResponse;
        String documentSelfLink = state == null ? Utils.fromJson((String)json, ServiceDocument.class).documentSelfLink : state.documentSelfLink;
        if (nodeSelectorPath == null) {
            nodeSelectorPath = this.getPeerNodeSelectorPath();
        }
        return (ownerResponse = this.getHost().findOwnerNode(nodeSelectorPath, documentSelfLink)) != null && ownerResponse.isLocalHostOwner;
    }

    private ServiceDocument processQueryResultsForSelectLinks(IndexSearcher s, QueryTask.QuerySpecification qs, ServiceDocumentQueryResult rsp, DocumentStoredFieldVisitor d, int docId, String link, ServiceDocument state) throws Exception {
        Map<String, String> linksPerDocument;
        if (rsp.selectedLinksPerDocument == null) {
            rsp.selectedLinksPerDocument = new HashMap<String, Map<String, String>>();
            rsp.selectedLinks = new HashSet<String>();
        }
        if ((linksPerDocument = rsp.selectedLinksPerDocument.get(link)) == null) {
            linksPerDocument = new HashMap<String, String>();
            rsp.selectedLinksPerDocument.put(link, linksPerDocument);
        }
        for (QueryTask.QueryTerm qt : qs.linkTerms) {
            Object fieldValue;
            Field linkCollectionField;
            String linkValue = d.getLink(qt.propertyName);
            if (linkValue != null) {
                linksPerDocument.put(qt.propertyName, linkValue);
                rsp.selectedLinks.add(linkValue);
                continue;
            }
            if (state == null) {
                DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
                this.loadDoc(s, visitor, docId, this.fieldsToLoadWithExpand);
                state = this.getStateFromLuceneDocument(visitor, link);
                if (state == null) {
                    this.logWarning("Skipping link term %s for %s, can not find serialized state", qt.propertyName, link);
                    continue;
                }
            }
            if ((linkCollectionField = ReflectionUtils.getField(state.getClass(), qt.propertyName)) == null || (fieldValue = linkCollectionField.get(state)) == null) continue;
            if (!(fieldValue instanceof Collection)) {
                this.logWarning("Skipping link term %s for %s, field is not a collection", qt.propertyName, link);
                continue;
            }
            Collection linkCollection = (Collection)fieldValue;
            int index = 0;
            for (String item : linkCollection) {
                if (item == null) continue;
                linksPerDocument.put(QueryTask.QuerySpecification.buildLinkCollectionItemName(qt.propertyName, index++), item);
                rsp.selectedLinks.add(item);
            }
        }
        return state;
    }

    private ServiceDocument getStateFromLuceneDocument(DocumentStoredFieldVisitor doc, String link) {
        byte[] binaryStateField = doc.binarySerializedState;
        if (binaryStateField == null) {
            this.logWarning("State not found for %s", link);
            return null;
        }
        ServiceDocument state = (ServiceDocument)KryoSerializers.deserializeDocument(binaryStateField, 0, binaryStateField.length);
        if (state.documentSelfLink == null) {
            state.documentSelfLink = link;
        }
        if (state.documentKind == null) {
            state.documentKind = Utils.buildKind(state.getClass());
        }
        return state;
    }

    private long getSearcherUpdateTime(IndexSearcher s, long queryStartTimeMicros) {
        if (s == null) {
            return 0L;
        }
        return this.searcherUpdateTimesMicros.getOrDefault(s.hashCode(), queryStartTimeMicros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLatestVersion(IndexSearcher s, long searcherUpdateTime, String link, long version, long documentsUpdatedBeforeInMicros) throws IOException {
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            this.adjustStat(STAT_NAME_VERSION_CACHE_LOOKUP_COUNT, 1.0);
        }
        Object object = this.searchSync;
        synchronized (object) {
            String parentLink;
            DocumentUpdateInfo dui = this.updatesPerLink.get(link);
            if (documentsUpdatedBeforeInMicros == -1L && dui != null && dui.updateTimeMicros <= searcherUpdateTime) {
                return Math.max(version, dui.version);
            }
            if (!this.immutableParentLinks.isEmpty() && this.immutableParentLinks.containsKey(parentLink = UriUtils.getParentPath(link))) {
                return 0L;
            }
        }
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            this.adjustStat(STAT_NAME_VERSION_CACHE_MISS_COUNT, 1.0);
        }
        TopDocs td = this.queryIndexForVersion(link, s, null, documentsUpdatedBeforeInMicros > 0L ? Long.valueOf(documentsUpdatedBeforeInMicros) : null);
        if (documentsUpdatedBeforeInMicros != -1L && td.totalHits == 0) {
            return -1L;
        }
        if (td.totalHits == 0) {
            return version;
        }
        DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
        this.loadDoc(s, visitor, td.scoreDocs[0].doc, this.fieldToLoadVersionLookup);
        long latestVersion = visitor.documentVersion;
        long updateTime = visitor.documentUpdateTimeMicros;
        this.updateLinkInfoCache(null, link, null, latestVersion, updateTime);
        return latestVersion;
    }

    private void expandLinks(Operation o, Operation get) {
        ServiceDocumentQueryResult r = o.getBody(ServiceDocumentQueryResult.class);
        if (r.documentLinks == null || r.documentLinks.isEmpty()) {
            get.setBodyNoCloning(r).complete();
            return;
        }
        r.documents = new HashMap<String, Object>();
        AtomicInteger i = new AtomicInteger(r.documentLinks.size());
        Operation.CompletionHandler c = (op, e) -> {
            try {
                if (e != null) {
                    this.logWarning("failure expanding %s: %s", op.getUri().getPath(), e.getMessage());
                    return;
                }
                Map<String, Object> map = r.documents;
                synchronized (map) {
                    r.documents.put(op.getUri().getPath(), op.getBodyRaw());
                }
            }
            finally {
                if (i.decrementAndGet() == 0) {
                    get.setBodyNoCloning(r).complete();
                }
            }
        };
        for (String selfLink : r.documentLinks) {
            this.sendRequest(Operation.createGet(this, selfLink).setCompletion(c));
        }
    }

    public void handleDeleteImpl(Operation delete) throws Exception {
        this.setProcessingStage(Service.ProcessingStage.STOPPED);
        this.privateIndexingExecutor.shutdown();
        this.privateQueryExecutor.shutdown();
        IndexWriter w = this.writer;
        this.writer = null;
        this.close(w);
        this.getHost().stopService(this);
        delete.complete();
    }

    void close(IndexWriter wr) {
        try {
            if (wr == null) {
                return;
            }
            this.logInfo("Document count: %d ", wr.maxDoc());
            wr.commit();
            wr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndex(Operation updateOp) throws Exception {
        UpdateIndexRequest r = updateOp.getBody(UpdateIndexRequest.class);
        ServiceDocument s = r.document;
        ServiceDocumentDescription desc = r.description;
        if (updateOp.isRemote()) {
            updateOp.fail(new IllegalStateException("Remote requests not allowed"));
            return;
        }
        if (s == null) {
            updateOp.fail(new IllegalArgumentException("document is required"));
            return;
        }
        String link = s.documentSelfLink;
        if (link == null) {
            updateOp.fail(new IllegalArgumentException("documentSelfLink is required"));
            return;
        }
        if (s.documentUpdateAction == null) {
            updateOp.fail(new IllegalArgumentException("documentUpdateAction is required"));
            return;
        }
        if (desc == null) {
            updateOp.fail(new IllegalArgumentException("description is required"));
            return;
        }
        IndexWriter wr = this.writer;
        if (wr == null) {
            updateOp.fail(new CancellationException("Index writer is null"));
            return;
        }
        s.documentDescription = null;
        LuceneIndexDocumentHelper indexDocHelper = this.indexDocumentHelper.get();
        indexDocHelper.addSelfLinkField(link);
        if (s.documentKind != null) {
            indexDocHelper.addKindField(s.documentKind);
        }
        indexDocHelper.addUpdateActionField(s.documentUpdateAction);
        indexDocHelper.addBinaryStateFieldToDocument(s, r.serializedDocument, desc);
        if (s.documentAuthPrincipalLink != null) {
            indexDocHelper.addAuthPrincipalLinkField(s.documentAuthPrincipalLink);
        }
        if (s.documentTransactionId != null) {
            indexDocHelper.addTxIdField(s.documentTransactionId);
        }
        indexDocHelper.addUpdateTimeField(s.documentUpdateTimeMicros);
        if (s.documentExpirationTimeMicros > 0L) {
            indexDocHelper.addExpirationTimeField(s.documentExpirationTimeMicros);
        }
        indexDocHelper.addVersionField(s.documentVersion);
        if (desc.documentIndexingOptions.contains((Object)ServiceDocumentDescription.DocumentIndexingOption.INDEX_METADATA)) {
            indexDocHelper.addIndexingIdField(link, s.documentEpoch, s.documentVersion);
            indexDocHelper.addTombstoneTimeField();
        }
        Document threadLocalDoc = indexDocHelper.getDoc();
        try {
            if (desc.propertyDescriptions == null || desc.propertyDescriptions.isEmpty()) {
                this.addDocumentToIndex(wr, updateOp, threadLocalDoc, s, desc);
                return;
            }
            indexDocHelper.addIndexableFieldsToDocument(s, desc);
            if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                int fieldCount = indexDocHelper.getDoc().getFields().size();
                this.setTimeSeriesStat(STAT_NAME_INDEXED_FIELD_COUNT, AGGREGATION_TYPE_SUM, fieldCount);
                ServiceStats.ServiceStat st = ServiceStatUtils.getOrCreateHistogramStat(this, STAT_NAME_FIELD_COUNT_PER_DOCUMENT);
                this.setStat(st, (double)fieldCount);
            }
            this.addDocumentToIndex(wr, updateOp, threadLocalDoc, s, desc);
        }
        finally {
            threadLocalDoc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDocumentRetentionLimit(ServiceDocument state, ServiceDocumentDescription desc) throws IOException {
        long chunkThreshold;
        if (desc.versionRetentionLimit == Long.MIN_VALUE) {
            return;
        }
        long limit = Math.max(1L, desc.versionRetentionLimit);
        if (state.documentVersion < limit) {
            return;
        }
        long floor = Math.max(1L, desc.versionRetentionFloor);
        if (floor > limit) {
            floor = limit;
        }
        if ((state.documentVersion - limit) % (chunkThreshold = Math.max(1L, limit - floor)) != 0L) {
            return;
        }
        String link = state.documentSelfLink;
        long newValue = state.documentVersion - floor;
        Map<String, Long> map = this.liveVersionsPerLink;
        synchronized (map) {
            Long currentValue = this.liveVersionsPerLink.get(link);
            if (currentValue == null || newValue > currentValue) {
                this.liveVersionsPerLink.put(link, newValue);
            }
        }
    }

    private void checkFailureAndRecover(Exception e) {
        Document threadLocalDoc = this.indexDocumentHelper.get().getDoc();
        threadLocalDoc.clear();
        if (this.getHost().isStopping()) {
            this.logInfo("Exception after host stop, on index service thread: %s", e.toString());
            return;
        }
        if (!(e instanceof AlreadyClosedException)) {
            this.logSevere("Exception on index service thread: %s", Utils.toString(e));
            return;
        }
        IndexWriter w = this.writer;
        if (w != null && w.isOpen() || e.getMessage().contains("IndexReader")) {
            this.adjustStat(STAT_NAME_READER_ALREADY_CLOSED_EXCEPTION_COUNT, 1.0);
            this.logWarning("Exception on index service thread: %s", Utils.toString(e));
            return;
        }
        this.logSevere("Exception on index service thread: %s", Utils.toString(e));
        this.adjustStat(STAT_NAME_WRITER_ALREADY_CLOSED_EXCEPTION_COUNT, 1.0);
        this.applyFileLimitRefreshWriter(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllDocumentsForSelfLinkForcedPost(IndexWriter wr, ServiceDocument sd) throws IOException {
        this.adjustStat(STAT_NAME_FORCED_UPDATE_DOCUMENT_DELETE_COUNT, 1.0);
        wr.deleteDocuments(new Term[]{new Term("documentSelfLink", sd.documentSelfLink)});
        Object object = this.searchSync;
        synchronized (object) {
            long now;
            this.updatesPerLink.remove(sd.documentSelfLink);
            this.writerUpdateTimeMicros = now = Utils.getNowMicrosUtc();
            this.serviceRemovalDetectedTimeMicros = now;
        }
        this.updateLinkInfoCache(this.getHost().buildDocumentDescription(sd.documentSelfLink), sd.documentSelfLink, sd.documentKind, 0L, Utils.getNowMicrosUtc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllDocumentsForSelfLink(Operation postOrDelete, String link, ServiceDocument state) throws Exception {
        this.deleteDocumentsFromIndex(postOrDelete, state != null ? this.getHost().buildDocumentDescription(state.documentSelfLink) : null, link, state != null ? state.documentKind : null, 0L, Long.MAX_VALUE);
        Object object = this.searchSync;
        synchronized (object) {
            long now;
            this.updatesPerLink.remove(link);
            this.writerUpdateTimeMicros = now = Utils.getNowMicrosUtc();
            this.serviceRemovalDetectedTimeMicros = now;
        }
        this.adjustTimeSeriesStat(STAT_NAME_SERVICE_DELETE_COUNT, AGGREGATION_TYPE_SUM, 1.0);
        this.logFine("%s expired", link);
        if (state == null) {
            return;
        }
        this.applyActiveQueries(postOrDelete, state, null);
        this.sendRequest(Operation.createDelete(this, state.documentSelfLink).setBodyNoCloning(state).disableFailureLogging(true).addPragmaDirective("xn-no-index-update"));
    }

    private void deleteDocumentsFromIndex(Operation delete, ServiceDocumentDescription desc, String link, String kind, long oldestVersion, long newestVersion) throws Exception {
        IndexWriter wr = this.writer;
        if (wr == null) {
            delete.fail(new CancellationException("Index writer is null"));
            return;
        }
        this.deleteDocumentFromIndex(link, oldestVersion, newestVersion, wr);
        this.updateLinkInfoCache(desc, link, kind, newestVersion, Utils.getNowMicrosUtc());
        delete.complete();
    }

    private void deleteDocumentFromIndex(String link, long oldestVersion, long newestVersion, IndexWriter wr) throws IOException {
        TermQuery linkQuery = new TermQuery(new Term("documentSelfLink", link));
        Query versionQuery = LongPoint.newRangeQuery((String)"documentVersion", (long)oldestVersion, (long)newestVersion);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(versionQuery, BooleanClause.Occur.MUST);
        builder.add((Query)linkQuery, BooleanClause.Occur.MUST);
        BooleanQuery bq = builder.build();
        wr.deleteDocuments(new Query[]{bq});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocumentToIndex(IndexWriter wr, Operation op, Document doc, ServiceDocument sd, ServiceDocumentDescription desc) throws IOException {
        long startNanos = 0L;
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            startNanos = System.nanoTime();
        }
        if (op.getAction() == Service.Action.POST && op.hasPragmaDirective("xn-force-index-update")) {
            if (desc.documentIndexingOptions.contains((Object)ServiceDocumentDescription.DocumentIndexingOption.INDEX_METADATA)) {
                Object object = this.metadataUpdateSync;
                synchronized (object) {
                    SortedSet<MetadataUpdateInfo> sortedSet = this.metadataUpdates;
                    synchronized (sortedSet) {
                        this.metadataUpdatesPerLink.remove(sd.documentSelfLink);
                        this.metadataUpdates.removeIf(info -> info.selfLink.equals(sd.documentSelfLink));
                    }
                }
            }
            this.deleteAllDocumentsForSelfLinkForcedPost(wr, sd);
        }
        wr.addDocument((Iterable)doc);
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            long durationNanos = System.nanoTime() - startNanos;
            this.setTimeSeriesStat(STAT_NAME_INDEXED_DOCUMENT_COUNT, AGGREGATION_TYPE_SUM, 1.0);
            this.setTimeSeriesHistogramStat(STAT_NAME_INDEXING_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, TimeUnit.NANOSECONDS.toMicros(durationNanos));
        }
        long updateTime = Utils.getNowMicrosUtc();
        this.updateLinkInfoCache(desc, sd.documentSelfLink, sd.documentKind, sd.documentVersion, updateTime);
        op.setBody(null).complete();
        this.checkDocumentRetentionLimit(sd, desc);
        this.checkDocumentIndexingMetadata(sd, desc, updateTime);
        this.applyActiveQueries(op, sd, desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDocumentIndexingMetadata(ServiceDocument sd, ServiceDocumentDescription desc, long updateTimeMicros) {
        if (!desc.documentIndexingOptions.contains((Object)ServiceDocumentDescription.DocumentIndexingOption.INDEX_METADATA)) {
            return;
        }
        if (sd.documentVersion == 0L) {
            return;
        }
        SortedSet<MetadataUpdateInfo> sortedSet = this.metadataUpdates;
        synchronized (sortedSet) {
            MetadataUpdateInfo info = this.metadataUpdatesPerLink.get(sd.documentSelfLink);
            if (info != null) {
                if (info.updateTimeMicros < updateTimeMicros) {
                    this.metadataUpdates.remove(info);
                    info.updateTimeMicros = updateTimeMicros;
                    this.metadataUpdates.add(info);
                }
                return;
            }
            info = new MetadataUpdateInfo();
            info.selfLink = sd.documentSelfLink;
            info.kind = sd.documentKind;
            info.updateTimeMicros = updateTimeMicros;
            this.metadataUpdatesPerLink.put(sd.documentSelfLink, info);
            this.metadataUpdates.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkInfoCache(ServiceDocumentDescription desc, String link, String kind, long version, long lastAccessTime) {
        boolean isImmutable = desc != null && desc.serviceCapabilities != null && desc.serviceCapabilities.contains((Object)Service.ServiceOption.IMMUTABLE);
        Object object = this.searchSync;
        synchronized (object) {
            if (isImmutable) {
                String parent = UriUtils.getParentPath(link);
                this.immutableParentLinks.compute(parent, (k, time) -> {
                    time = time == null ? Long.valueOf(lastAccessTime) : Long.valueOf(Math.max(time, lastAccessTime));
                    return time;
                });
            } else {
                this.updatesPerLink.compute(link, (k, entry) -> {
                    if (entry == null) {
                        entry = new DocumentUpdateInfo();
                    }
                    if (version >= entry.version) {
                        entry.updateTimeMicros = Math.max(entry.updateTimeMicros, lastAccessTime);
                        entry.version = version;
                    }
                    return entry;
                });
            }
            if (kind != null) {
                this.documentKindUpdateInfo.compute(kind, (k, entry) -> {
                    if (entry == null) {
                        entry = 0L;
                    }
                    entry = Math.max(entry, lastAccessTime);
                    return entry;
                });
            }
            if (this.writerUpdateTimeMicros < lastAccessTime) {
                this.writerUpdateTimeMicros = lastAccessTime;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkInfoCacheForMetadataUpdates(long updateTimeMicros, Collection<MetadataUpdateInfo> entries) {
        Object object = this.searchSync;
        synchronized (object) {
            for (MetadataUpdateInfo info : entries) {
                this.updatesPerLink.compute(info.selfLink, (k, entry) -> {
                    if (entry != null) {
                        entry.updateTimeMicros = Math.max(entry.updateTimeMicros, updateTimeMicros);
                    }
                    return entry;
                });
                this.documentKindUpdateInfo.compute(info.kind, (k, entry) -> {
                    entry = Math.max(entry, updateTimeMicros);
                    return entry;
                });
            }
            if (this.writerUpdateTimeMicros < updateTimeMicros) {
                this.writerUpdateTimeMicros = updateTimeMicros;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher createOrRefreshSearcher(String selfLink, Set<String> kindScope, int resultLimit, IndexWriter w, boolean doNotRefresh) throws IOException {
        IndexSearcher s;
        boolean needNewSearcher = false;
        long threadId = Thread.currentThread().getId();
        long now = Utils.getNowMicrosUtc();
        Object object = this.searchSync;
        synchronized (object) {
            s = this.searchers.get(threadId);
            long searcherUpdateTime = this.getSearcherUpdateTime(s, 0L);
            needNewSearcher = s == null ? true : this.documentNeedsNewSearcher(selfLink, kindScope, resultLimit, searcherUpdateTime, doNotRefresh);
        }
        if (s != null && !needNewSearcher) {
            this.adjustTimeSeriesStat(STAT_NAME_SEARCHER_REUSE_BY_DOCUMENT_KIND_COUNT, AGGREGATION_TYPE_SUM, 1.0);
            return s;
        }
        if (s != null) {
            IndexReader oldReader = s.getIndexReader();
            DirectoryReader newReader = DirectoryReader.openIfChanged((DirectoryReader)((DirectoryReader)oldReader), (IndexWriter)w);
            if (newReader == null || newReader == oldReader) {
                return s;
            }
            oldReader.close();
            this.searcherUpdateTimesMicros.remove(s.hashCode());
            s = new IndexSearcher((IndexReader)newReader);
        } else {
            s = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)w, (boolean)true, (boolean)true));
        }
        s.setSimilarity(s.getSimilarity(false));
        this.adjustTimeSeriesStat(STAT_NAME_SEARCHER_UPDATE_COUNT, AGGREGATION_TYPE_SUM, 1.0);
        object = this.searchSync;
        synchronized (object) {
            this.searchers.put(threadId, s);
            this.searcherUpdateTimesMicros.put(s.hashCode(), now);
            return s;
        }
    }

    private boolean documentNeedsNewSearcher(String selfLink, Set<String> kindScope, int resultLimit, long searcherUpdateTime, boolean doNotRefresh) {
        if (selfLink != null && resultLimit == 1) {
            DocumentUpdateInfo du = this.updatesPerLink.get(selfLink);
            if (du == null && searcherUpdateTime < this.serviceRemovalDetectedTimeMicros) {
                return true;
            }
            if (du != null && du.updateTimeMicros >= searcherUpdateTime) {
                return true;
            }
            String parent = UriUtils.getParentPath(selfLink);
            Long updateTime = this.immutableParentLinks.get(parent);
            return updateTime != null && updateTime >= searcherUpdateTime;
        }
        boolean needNewSearcher = false;
        long indexUpdateTime = kindScope == null ? this.writerUpdateTimeMicros : kindScope.stream().map(this.documentKindUpdateInfo::get).filter(Objects::nonNull).max(Long::compare).orElse(Long.MIN_VALUE);
        if (searcherUpdateTime < indexUpdateTime) {
            needNewSearcher = true;
        }
        if (doNotRefresh && needNewSearcher && indexUpdateTime + searcherRefreshIntervalMicros >= Utils.getSystemNowMicrosUtc()) {
            return false;
        }
        return needNewSearcher;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void handleMaintenance(Operation post) {
        if (this.fieldInfosFormat != null) {
            this.fieldInfosFormat.handleMaintenance();
        }
        Operation maintenanceOp = Operation.createPost(this.getUri()).setBodyNoCloning(new MaintenanceRequest()).setCompletion((o, ex) -> {
            if (ex != null) {
                post.fail(ex);
                return;
            }
            post.complete();
        });
        this.setAuthorizationContext(maintenanceOp, this.getSystemAuthorizationContext());
        this.handleRequest(maintenanceOp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMaintenanceImpl(Operation op) throws Exception {
        try {
            IndexWriter w = this.writer;
            if (w == null) {
                op.fail(new CancellationException("Index writer is null"));
                return;
            }
            long searcherCreationTime = Utils.getNowMicrosUtc();
            SortedSet<MetadataUpdateInfo> sortedSet = this.metadataUpdates;
            synchronized (sortedSet) {
                this.metadataUpdatesPerLink.clear();
            }
            long startNanos = System.nanoTime();
            IndexSearcher s = this.createOrRefreshSearcher(null, null, Integer.MAX_VALUE, w, false);
            long endNanos = System.nanoTime();
            this.setTimeSeriesHistogramStat(STAT_NAME_MAINTENANCE_SEARCHER_REFRESH_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, TimeUnit.NANOSECONDS.toMicros(endNanos - startNanos));
            long deadline = Utils.getSystemNowMicrosUtc() + this.getMaintenanceIntervalMicros();
            startNanos = endNanos;
            this.applyDocumentExpirationPolicy(s, deadline);
            endNanos = System.nanoTime();
            this.setTimeSeriesHistogramStat(STAT_NAME_MAINTENANCE_DOCUMENT_EXPIRATION_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, TimeUnit.NANOSECONDS.toMicros(endNanos - startNanos));
            startNanos = endNanos;
            this.applyDocumentVersionRetentionPolicy(deadline);
            endNanos = System.nanoTime();
            this.setTimeSeriesHistogramStat(STAT_NAME_MAINTENANCE_VERSION_RETENTION_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, TimeUnit.NANOSECONDS.toMicros(endNanos - startNanos));
            startNanos = endNanos;
            Object object = this.metadataUpdateSync;
            synchronized (object) {
                this.applyMetadataIndexingUpdates(s, searcherCreationTime, deadline);
            }
            endNanos = System.nanoTime();
            this.setTimeSeriesHistogramStat(STAT_NAME_MAINTENANCE_METADATA_INDEXING_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, TimeUnit.NANOSECONDS.toMicros(endNanos - startNanos));
            startNanos = endNanos;
            this.applyMemoryLimit();
            endNanos = System.nanoTime();
            this.setTimeSeriesHistogramStat(STAT_NAME_MAINTENANCE_MEMORY_LIMIT_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, TimeUnit.NANOSECONDS.toMicros(endNanos - startNanos));
            startNanos = endNanos;
            long sequenceNumber = w.commit();
            endNanos = System.nanoTime();
            this.adjustTimeSeriesStat(STAT_NAME_COMMIT_COUNT, AGGREGATION_TYPE_SUM, 1.0);
            this.setTimeSeriesHistogramStat(STAT_NAME_COMMIT_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, TimeUnit.NANOSECONDS.toMicros(endNanos - startNanos));
            if (sequenceNumber > -1L) {
                CommitInfo commitInfo = new CommitInfo();
                commitInfo.sequenceNumber = sequenceNumber;
                this.publish(Operation.createPatch(null).setBody(commitInfo));
            }
            startNanos = endNanos;
            this.applyFileLimitRefreshWriter(false);
            endNanos = System.nanoTime();
            this.setTimeSeriesHistogramStat(STAT_NAME_MAINTENANCE_FILE_LIMIT_REFRESH_DURATION_MICROS, AGGREGATION_TYPE_AVG_MAX, TimeUnit.NANOSECONDS.toMicros(endNanos - startNanos));
            if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                this.setStat(STAT_NAME_INDEXED_DOCUMENT_COUNT, (double)w.numDocs());
                this.logQueueDepthStat(this.updateQueue, STAT_NAME_FORMAT_UPDATE_QUEUE_DEPTH);
                this.logQueueDepthStat(this.queryQueue, STAT_NAME_FORMAT_QUERY_QUEUE_DEPTH);
            }
            op.complete();
        }
        catch (Exception e) {
            if (this.getHost().isStopping()) {
                op.fail(new CancellationException("Host is stopping"));
                return;
            }
            this.logWarning("Attempting recovery due to error: %s", Utils.toString(e));
            this.applyFileLimitRefreshWriter(true);
            op.fail(e);
        }
    }

    private void logQueueDepthStat(RoundRobinOperationQueue queue, String format) {
        Map<String, Integer> sizes = queue.sizesByKey();
        for (Map.Entry<String, Integer> e : sizes.entrySet()) {
            String statName = String.format(format, e.getKey());
            this.setTimeSeriesStat(statName, AGGREGATION_TYPE_AVG_MAX, e.getValue().intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMetadataIndexingUpdates(IndexSearcher searcher, long searcherCreationTime, long deadline) throws IOException {
        IndexWriter wr;
        HashMap<String, MetadataUpdateInfo> entries = new HashMap<String, MetadataUpdateInfo>();
        SortedSet<MetadataUpdateInfo> sortedSet = this.metadataUpdates;
        synchronized (sortedSet) {
            Iterator it = this.metadataUpdates.iterator();
            while (it.hasNext()) {
                MetadataUpdateInfo info = (MetadataUpdateInfo)it.next();
                if (info.updateTimeMicros > searcherCreationTime) break;
                entries.put(info.selfLink, info);
                it.remove();
            }
        }
        if (entries.isEmpty()) {
            return;
        }
        Collection<MetadataUpdateInfo> entriesToProcess = entries.values();
        int queueDepth = entriesToProcess.size();
        Iterator it = entriesToProcess.iterator();
        int updateCount = 0;
        while (it.hasNext() && --queueDepth > metadataUpdateMaxQueueDepth && (wr = this.writer) != null) {
            updateCount = (int)((long)updateCount + this.applyMetadataIndexingUpdate(searcher, wr, (MetadataUpdateInfo)it.next()));
        }
        while (it.hasNext() && Utils.getSystemNowMicrosUtc() < deadline && (wr = this.writer) != null) {
            updateCount = (int)((long)updateCount + this.applyMetadataIndexingUpdate(searcher, wr, (MetadataUpdateInfo)it.next()));
        }
        if (it.hasNext()) {
            SortedSet<MetadataUpdateInfo> sortedSet2 = this.metadataUpdates;
            synchronized (sortedSet2) {
                while (it.hasNext()) {
                    MetadataUpdateInfo info = (MetadataUpdateInfo)it.next();
                    it.remove();
                    this.metadataUpdatesPerLink.putIfAbsent(info.selfLink, info);
                    this.metadataUpdates.add(info);
                }
            }
        }
        this.updateLinkInfoCacheForMetadataUpdates(Utils.getNowMicrosUtc(), entriesToProcess);
        if (updateCount > 0) {
            this.setTimeSeriesHistogramStat(STAT_NAME_METADATA_INDEXING_UPDATE_COUNT, AGGREGATION_TYPE_SUM, updateCount);
        }
    }

    private long applyMetadataIndexingUpdate(IndexSearcher searcher, IndexWriter wr, MetadataUpdateInfo info) throws IOException {
        TopDocs results;
        TermQuery selfLinkClause = new TermQuery(new Term("documentSelfLink", info.selfLink));
        Query currentClause = NumericDocValuesField.newExactQuery((String)"xenon.indexing.metadata.tombstone.time", (long)Long.MAX_VALUE);
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)selfLinkClause, BooleanClause.Occur.MUST).add(currentClause, BooleanClause.Occur.MUST).build();
        long highestVersion = -1L;
        String lastUpdateAction = null;
        int pageSize = 10000;
        long updateCount = 0L;
        ScoreDoc after = null;
        HashMap<Long, ArrayList<DocumentStoredFieldVisitor>> versionToDocsMap = new HashMap<Long, ArrayList<DocumentStoredFieldVisitor>>();
        while ((results = searcher.searchAfter(after, (Query)booleanQuery, 10000)) != null && results.scoreDocs != null && results.scoreDocs.length != 0) {
            for (ScoreDoc scoreDoc : results.scoreDocs) {
                DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
                this.loadDoc(searcher, visitor, scoreDoc.doc, this.fieldsToLoadIndexingIdLookup);
                ArrayList<DocumentStoredFieldVisitor> versionDocList = (ArrayList<DocumentStoredFieldVisitor>)versionToDocsMap.get(visitor.documentVersion);
                if (versionDocList == null) {
                    versionDocList = new ArrayList<DocumentStoredFieldVisitor>();
                    versionToDocsMap.put(visitor.documentVersion, versionDocList);
                }
                versionDocList.add(visitor);
                if (visitor.documentVersion <= highestVersion) continue;
                highestVersion = visitor.documentVersion;
                lastUpdateAction = visitor.documentUpdateAction;
            }
            HashSet<Long> missingVersions = new HashSet<Long>();
            for (Long version : versionToDocsMap.keySet()) {
                if (version == highestVersion || versionToDocsMap.containsKey(version + 1L)) continue;
                missingVersions.add(version + 1L);
            }
            Query versionClause = LongPoint.newSetQuery((String)"documentVersion", missingVersions);
            BooleanQuery missingVersionQuery = new BooleanQuery.Builder().add((Query)selfLinkClause, BooleanClause.Occur.MUST).add(versionClause, BooleanClause.Occur.MUST).build();
            TopDocs missingVersionResult = searcher.searchAfter(after, (Query)missingVersionQuery, 10000);
            if (missingVersionResult != null && missingVersionResult.scoreDocs != null && missingVersionResult.scoreDocs.length != 0) {
                for (ScoreDoc scoreDoc : missingVersionResult.scoreDocs) {
                    DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
                    this.loadDoc(searcher, visitor, scoreDoc.doc, this.fieldsToLoadIndexingIdLookup);
                    ArrayList<DocumentStoredFieldVisitor> versionDocList = (ArrayList<DocumentStoredFieldVisitor>)versionToDocsMap.get(visitor.documentVersion);
                    if (versionDocList == null) {
                        versionDocList = new ArrayList<DocumentStoredFieldVisitor>();
                        versionToDocsMap.put(visitor.documentVersion, versionDocList);
                    }
                    versionDocList.add(visitor);
                }
            }
            for (List visitorDocs : versionToDocsMap.values()) {
                for (DocumentStoredFieldVisitor visitor : visitorDocs) {
                    if (visitor.documentVersion == highestVersion && !Service.Action.DELETE.toString().equals(lastUpdateAction) || visitor.documentTombstoneTimeMicros != Long.MAX_VALUE) continue;
                    Long nextVersionCreationTime = null;
                    if (visitor.documentVersion == highestVersion) {
                        nextVersionCreationTime = ((DocumentStoredFieldVisitor)((Object)((List)versionToDocsMap.get((Object)Long.valueOf((long)visitor.documentVersion))).get((int)0))).documentUpdateTimeMicros;
                    } else {
                        List list = (List)versionToDocsMap.get(visitor.documentVersion + 1L);
                        if (list != null) {
                            nextVersionCreationTime = ((DocumentStoredFieldVisitor)((Object)list.get((int)0))).documentUpdateTimeMicros;
                        }
                    }
                    if (nextVersionCreationTime == null) continue;
                    this.updateTombstoneTime(wr, visitor.documentIndexingId, nextVersionCreationTime);
                    ++updateCount;
                }
            }
            if (results.scoreDocs.length < 10000) break;
            after = results.scoreDocs[results.scoreDocs.length - 1];
        }
        return updateCount;
    }

    private void updateTombstoneTime(IndexWriter wr, String indexingId, long documentUpdateTimeMicros) throws IOException {
        Term indexingIdTerm = new Term("xenon.indexing.id", indexingId);
        wr.updateNumericDocValue(indexingIdTerm, "xenon.indexing.metadata.tombstone.time", documentUpdateTimeMicros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFileLimitRefreshWriter(boolean force) {
        long count;
        if (this.getHost().isStopping()) {
            return;
        }
        if (!this.isDurable()) {
            return;
        }
        long now = Utils.getNowMicrosUtc();
        if (now - this.writerCreationTimeMicros < this.getHost().getMaintenanceIntervalMicros()) {
            this.logInfo("Skipping writer re-open, it was created recently", new Object[0]);
            return;
        }
        File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
        try (Stream<Path> stream = null;){
            stream = Files.list(directory.toPath());
            count = stream.count();
            if (!force && count < (long)indexFileCountThresholdForWriterRefresh) {
                return;
            }
        }
        int acquireReleaseCount = QUERY_THREAD_COUNT + UPDATE_THREAD_COUNT;
        try {
            this.writerSync.release();
            this.writerSync.acquire(acquireReleaseCount);
            IndexWriter w = this.writer;
            if (w == null) {
                return;
            }
            this.logInfo("(%s) closing all %d searchers, document count: %d, file count: %d", this.writerSync, this.searchers.size(), w.maxDoc(), count);
            for (IndexSearcher s : this.searchers.values()) {
                s.getIndexReader().close();
                this.searcherUpdateTimesMicros.remove(s.hashCode());
            }
            this.searchers.clear();
            if (!force) {
                return;
            }
            this.logInfo("Closing all paginated searchers (%d)", this.paginatedSearchersByCreationTime.size());
            for (PaginatedSearcherInfo info : this.paginatedSearchersByCreationTime.values()) {
                try {
                    IndexSearcher s = info.searcher;
                    s.getIndexReader().close();
                }
                catch (Exception exception) {}
            }
            this.paginatedSearchersByCreationTime.clear();
            this.paginatedSearchersByExpirationTime.clear();
            this.searcherUpdateTimesMicros.clear();
            try {
                w.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            w = this.createWriter(directory, false);
            stream = Files.list(directory.toPath());
            count = stream.count();
            this.logInfo("(%s) reopened writer, document count: %d, file count: %d", this.writerSync, w.maxDoc(), count);
        }
        catch (Exception e) {
            this.logSevere(e);
            this.logWarning("Stopping local host since index is not accessible", new Object[0]);
            this.close(this.writer);
            this.writer = null;
            this.sendRequest(Operation.createDelete(this, "/core/management"));
        }
        finally {
            this.writerSync.release(acquireReleaseCount - 1);
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDocumentVersionRetentionPolicy(long deadline) throws Exception {
        HashMap<String, Long> links = new HashMap<String, Long>();
        do {
            Map<String, Long> map = this.liveVersionsPerLink;
            synchronized (map) {
                Iterator<Map.Entry<String, Long>> it = this.liveVersionsPerLink.entrySet().iterator();
                for (int count = 0; it.hasNext() && count < versionRetentionServiceThreshold; ++count) {
                    Map.Entry<String, Long> e = it.next();
                    links.put(e.getKey(), e.getValue());
                    it.remove();
                }
            }
            if (links.isEmpty()) break;
            this.adjustTimeSeriesStat(STAT_NAME_VERSION_RETENTION_SERVICE_COUNT, AGGREGATION_TYPE_SUM, links.size());
            Operation dummyDelete = Operation.createDelete(null);
            for (Map.Entry e : links.entrySet()) {
                IndexWriter wr = this.writer;
                if (wr == null) {
                    return;
                }
                this.deleteDocumentsFromIndex(dummyDelete, null, (String)e.getKey(), null, 0L, (Long)e.getValue());
            }
            links.clear();
        } while (Utils.getSystemNowMicrosUtc() < deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMemoryLimit() {
        long activePaginatedQueries;
        if (this.getHost().isStopping()) {
            return;
        }
        long now = Utils.getNowMicrosUtc();
        this.applyMemoryLimitToDocumentUpdateInfo();
        HashMap<Long, List<PaginatedSearcherInfo>> entriesToClose = new HashMap<Long, List<PaginatedSearcherInfo>>();
        Iterator iterator = this.searchSync;
        synchronized (iterator) {
            Map.Entry<Long, List<PaginatedSearcherInfo>> entry;
            long expirationMicros;
            Iterator<Map.Entry<Long, List<PaginatedSearcherInfo>>> itr = this.paginatedSearchersByExpirationTime.entrySet().iterator();
            while (itr.hasNext() && (expirationMicros = (entry = itr.next()).getKey().longValue()) <= now) {
                List<PaginatedSearcherInfo> expirationList = entry.getValue();
                for (PaginatedSearcherInfo info : expirationList) {
                    this.paginatedSearchersByCreationTime.remove(info.creationTimeMicros);
                    this.searcherUpdateTimesMicros.remove(info.searcher.hashCode());
                }
                entriesToClose.put(expirationMicros, expirationList);
                itr.remove();
            }
            activePaginatedQueries = this.paginatedSearchersByCreationTime.size();
        }
        this.setTimeSeriesStat(STAT_NAME_ACTIVE_PAGINATED_QUERIES, AGGREGATION_TYPE_AVG_MAX, activePaginatedQueries);
        for (Map.Entry entry : entriesToClose.entrySet()) {
            for (PaginatedSearcherInfo info : (List)entry.getValue()) {
                this.logFine("Closing paginated query searcher, expired at %d", entry.getKey());
                try {
                    info.searcher.getIndexReader().close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyMemoryLimitToDocumentUpdateInfo() {
        long memThresholdBytes = this.updateMapMemoryLimit;
        int bytesPerLinkEstimate = 64;
        int count = 0;
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            this.setStat(STAT_NAME_VERSION_CACHE_ENTRY_COUNT, (double)this.updatesPerLink.size());
        }
        Object object = this.searchSync;
        synchronized (object) {
            if (this.updatesPerLink.isEmpty()) {
                return;
            }
            if (memThresholdBytes > (long)(this.updatesPerLink.size() * 64)) {
                return;
            }
            Iterator<Map.Entry<String, DocumentUpdateInfo>> li = this.updatesPerLink.entrySet().iterator();
            while (li.hasNext()) {
                Map.Entry<String, DocumentUpdateInfo> e = li.next();
                if (this.getHost().getServiceStage(e.getKey()) != null) continue;
                ++count;
                li.remove();
            }
            this.writerUpdateTimeMicros = Utils.getNowMicrosUtc();
        }
        if (count == 0) {
            return;
        }
        this.serviceRemovalDetectedTimeMicros = Utils.getNowMicrosUtc();
        this.logInfo("Cleared %d document update entries", count);
    }

    private void applyDocumentExpirationPolicy(IndexSearcher s, long deadline) throws Exception {
        Query versionQuery = LongPoint.newRangeQuery((String)"documentExpirationTimeMicros", (long)1L, (long)Utils.getNowMicrosUtc());
        ScoreDoc after = null;
        Operation dummyDelete = null;
        boolean firstQuery = true;
        HashMap<String, Long> latestVersions = new HashMap<String, Long>();
        do {
            TopFieldDocs results = s.searchAfter(after, versionQuery, expiredDocumentSearchThreshold, this.versionSort, false, false);
            if (results.scoreDocs == null || results.scoreDocs.length == 0) {
                return;
            }
            after = results.scoreDocs[results.scoreDocs.length - 1];
            if (firstQuery && results.totalHits > expiredDocumentSearchThreshold) {
                this.adjustTimeSeriesStat(STAT_NAME_DOCUMENT_EXPIRATION_FORCED_MAINTENANCE_COUNT, AGGREGATION_TYPE_SUM, 1.0);
            }
            firstQuery = false;
            DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
            for (ScoreDoc scoreDoc : results.scoreDocs) {
                this.loadDoc(s, visitor, scoreDoc.doc, this.fieldsToLoadNoExpand);
                String documentSelfLink = visitor.documentSelfLink;
                Long latestVersion = (Long)latestVersions.get(documentSelfLink);
                if (latestVersion == null) {
                    long searcherUpdateTime = this.getSearcherUpdateTime(s, 0L);
                    latestVersion = this.getLatestVersion(s, searcherUpdateTime, documentSelfLink, 0L, -1L);
                    latestVersions.put(documentSelfLink, latestVersion);
                }
                if (visitor.documentVersion < latestVersion) continue;
                this.augmentDoc(s, visitor, scoreDoc.doc, LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE);
                ServiceDocument serviceDocument = null;
                try {
                    serviceDocument = this.getStateFromLuceneDocument(visitor, documentSelfLink);
                }
                catch (Exception e) {
                    this.logWarning("Error deserializing state for %s: %s", documentSelfLink, e.getMessage());
                }
                if (dummyDelete == null) {
                    dummyDelete = Operation.createDelete(null);
                }
                this.deleteAllDocumentsForSelfLink(dummyDelete, documentSelfLink, serviceDocument);
                this.adjustTimeSeriesStat(STAT_NAME_DOCUMENT_EXPIRATION_COUNT, AGGREGATION_TYPE_SUM, 1.0);
            }
        } while (Utils.getSystemNowMicrosUtc() < deadline);
    }

    private void applyActiveQueries(Operation op, ServiceDocument latestState, ServiceDocumentDescription desc) {
        if (this.activeQueries.isEmpty()) {
            return;
        }
        if (op.getAction() == Service.Action.DELETE) {
            latestState = Utils.clone(latestState);
            latestState.documentUpdateAction = Service.Action.DELETE.name();
        }
        OperationContext.setFrom(op);
        for (Map.Entry<String, QueryTask> taskEntry : this.activeQueries.entrySet()) {
            if (this.getHost().isStopping()) continue;
            QueryTask activeTask = taskEntry.getValue();
            QueryFilter filter = activeTask.querySpec.context.filter;
            if (desc == null ? !QueryFilterUtils.evaluate(filter, latestState, this.getHost()) : !filter.evaluate(latestState, desc)) continue;
            QueryTask patchBody = new QueryTask();
            patchBody.taskInfo.stage = TaskState.TaskStage.STARTED;
            patchBody.querySpec = null;
            patchBody.results = new ServiceDocumentQueryResult();
            patchBody.results.documentLinks.add(latestState.documentSelfLink);
            if (activeTask.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT) || activeTask.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
                patchBody.results.documents = new HashMap<String, Object>();
                patchBody.results.documents.put(latestState.documentSelfLink, latestState);
            }
            Operation patchOperation = Operation.createPatch(this, activeTask.documentSelfLink).setBodyNoCloning(patchBody);
            OperationContext currentContext = OperationContext.getOperationContext();
            if (activeTask.querySpec.context.subjectLink != null) {
                this.setAuthorizationContext(patchOperation, this.getAuthorizationContextForSubject(activeTask.querySpec.context.subjectLink));
            }
            this.sendRequest(patchOperation);
            OperationContext.restoreOperationContext(currentContext);
        }
    }

    void setWriterUpdateTimeMicros(long writerUpdateTimeMicros) {
        this.writerUpdateTimeMicros = writerUpdateTimeMicros;
    }

    public static class CommitInfo {
        public static final String KIND = Utils.buildKind(CommitInfo.class);
        public String kind = KIND;
        public long sequenceNumber;
    }

    public static class MaintenanceRequest {
        static final String KIND = Utils.buildKind(MaintenanceRequest.class);
    }

    public static class RestoreRequest
    extends ServiceDocument {
        public URI backupFile;
        public Long timeSnapshotBoundaryMicros;
        static final String KIND = Utils.buildKind(RestoreRequest.class);
    }

    public static class InternalDocumentIndexInfo {
        public IndexWriter indexWriter;
        public String indexDirectory;
        public LuceneDocumentIndexService luceneIndexService;
        public Semaphore writerSync;
    }

    public static class BackupResponse
    extends ServiceDocument {
        public URI backupFile;
        static final String KIND = Utils.buildKind(BackupResponse.class);
    }

    public static class BackupRequest
    extends ServiceDocument {
        static final String KIND = Utils.buildKind(BackupRequest.class);
    }

    public static class DeleteQueryRuntimeContextRequest
    extends ServiceDocument {
        public QueryTask.QuerySpecification.QueryRuntimeContext context;
        static final String KIND = Utils.buildKind(DeleteQueryRuntimeContextRequest.class);
    }

    public static class PaginatedSearcherInfo {
        public long creationTimeMicros;
        public long expirationTimeMicros;
        public boolean singleUse;
        public IndexSearcher searcher;
    }

    public static class DocumentUpdateInfo {
        public long updateTimeMicros;
        public long version;
    }

    public static class MetadataUpdateInfo {
        public String selfLink;
        public String kind;
        public long updateTimeMicros;
    }
}

