/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.TaskService;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class GraphQueryTask
extends TaskService.TaskServiceState {
    public EnumSet<GraphQueryOption> options = EnumSet.noneOf(GraphQueryOption.class);
    public List<QueryTask> stages;
    public Set<String> tenantLinks;
    @ServiceDocument.PropertyOptions(usage={ServiceDocumentDescription.PropertyUsageOption.SERVICE_USE})
    public List<String> resultLinks = new ArrayList<String>();
    @ServiceDocument.PropertyOptions(usage={ServiceDocumentDescription.PropertyUsageOption.SINGLE_ASSIGNMENT, ServiceDocumentDescription.PropertyUsageOption.SERVICE_USE})
    public int depthLimit;
    @ServiceDocument.PropertyOptions(usage={ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL, ServiceDocumentDescription.PropertyUsageOption.SERVICE_USE})
    public int currentDepth;

    public static class Builder {
        private final GraphQueryTask task = new GraphQueryTask();

        private Builder(int depthLimit) {
            this.task.taskInfo = new TaskState();
            this.task.stages = new ArrayList<QueryTask>();
            this.task.depthLimit = depthLimit;
        }

        public static Builder create(int depthLimit) {
            return new Builder(depthLimit);
        }

        public Builder addOption(GraphQueryOption option) {
            this.task.options.add(option);
            return this;
        }

        public Builder setDirect(boolean isDirect) {
            this.task.taskInfo.isDirect = isDirect;
            return this;
        }

        public Builder setQueryStage(int depthIndex, QueryTask query) {
            this.task.stages.set(depthIndex, query);
            return this;
        }

        public Builder addQueryStage(QueryTask queryTask) {
            this.task.stages.add(queryTask);
            return this;
        }

        public Builder setDepthLimit(int depthLimit) {
            this.task.depthLimit = depthLimit;
            return this;
        }

        public GraphQueryTask build() {
            return this.task;
        }
    }

    public static enum GraphQueryOption {
        FILTER_STAGE_RESULTS,
        USE_LINK_TERM;

    }
}

