/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;

final class FieldInfoCache {
    private static final int MAX_FIELD_INFO_COUNT = 1500;
    private static final Field fiValues;
    private static final Field fiByNumberTable;
    private final ConcurrentMap<FieldInfoKey, FieldInfo> infoCache = new ConcurrentHashMap<FieldInfoKey, FieldInfo>();
    private FieldInfos longest;

    public static int hashCode(FieldInfo fi) {
        int h = 17;
        h = h * 31 + fi.number;
        h = h * 31 + fi.name.hashCode();
        return h;
    }

    public static boolean equals(FieldInfo a, FieldInfo b) {
        return a.number == b.number && a.name.equals(b.name) && a.getPointDimensionCount() == b.getPointDimensionCount() && a.getPointNumBytes() == b.getPointNumBytes() && a.getDocValuesGen() == b.getDocValuesGen() && a.getIndexOptions() == b.getIndexOptions() && a.hasPayloads() == b.hasPayloads() && a.hasVectors() == b.hasVectors() && a.omitsNorms() == b.omitsNorms() && a.hasNorms() == b.hasNorms();
    }

    public FieldInfos dedupFieldInfos(FieldInfo[] infos) {
        FieldInfos cached = this.longest;
        if (cached == null || cached.size() < infos.length) {
            cached = new FieldInfos(infos);
            this.trimFieldInfos(cached);
            this.longest = cached;
            return cached;
        }
        if (cached.size() == infos.length) {
            for (FieldInfo a : infos) {
                FieldInfo b = cached.fieldInfo(a.number);
                if (b != null && FieldInfoCache.equals(a, b)) continue;
                FieldInfos update = new FieldInfos(infos);
                this.trimFieldInfos(update);
                this.longest = update;
                return update;
            }
            return cached;
        }
        FieldInfos update = new FieldInfos(infos);
        this.trimFieldInfos(update);
        return update;
    }

    private void trimFieldInfos(FieldInfos fieldInfos) {
        try {
            Object obj = fiByNumberTable.get(fieldInfos);
            if (obj == null) {
                return;
            }
            List values = (List)fiValues.get(fieldInfos);
            values = Collections.unmodifiableList(new ArrayList(values));
            fiValues.set(fieldInfos, values);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public FieldInfo dedupFieldInfo(String name, int fieldNumber, boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, DocValuesType docValuesType, long dvGen, Map<String, String> attributes, int pointDimensionCount, int pointNumBytes) {
        FieldInfoKey key = new FieldInfoKey();
        key.name = name;
        key.fieldNumber = fieldNumber;
        key.storeTermVector = storeTermVector;
        key.omitNorms = omitNorms;
        key.storePayloads = storePayloads;
        key.indexOptions = indexOptions;
        key.docValuesType = docValuesType;
        key.dvGen = dvGen;
        key.attributes = attributes;
        key.pointDimensionCount = pointDimensionCount;
        key.pointNumBytes = pointNumBytes;
        return this.infoCache.computeIfAbsent(key, FieldInfoKey::toFieldInfo);
    }

    public void handleMaintenance() {
        if (this.infoCache.size() > 1500) {
            this.infoCache.clear();
        }
    }

    static {
        try {
            fiValues = FieldInfos.class.getDeclaredField("values");
            fiValues.setAccessible(true);
            fiByNumberTable = FieldInfos.class.getDeclaredField("byNumberTable");
            fiByNumberTable.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class FieldInfoKey {
        String name;
        int fieldNumber;
        boolean storeTermVector;
        boolean omitNorms;
        boolean storePayloads;
        IndexOptions indexOptions;
        DocValuesType docValuesType;
        long dvGen;
        Map<String, String> attributes;
        int pointDimensionCount;
        int pointNumBytes;

        private FieldInfoKey() {
        }

        public int hashCode() {
            int h = 17;
            h = h * 31 + this.fieldNumber;
            h = h * 31 + this.name.hashCode();
            return h;
        }

        public FieldInfo toFieldInfo() {
            FieldInfo fi = new FieldInfo(this.name, this.fieldNumber, this.storeTermVector, this.omitNorms, this.storePayloads, this.indexOptions, this.docValuesType, this.dvGen, this.attributes, this.pointDimensionCount, this.pointNumBytes);
            fi.checkConsistency();
            return fi;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FieldInfoKey)) {
                return false;
            }
            FieldInfoKey that = (FieldInfoKey)obj;
            return this.fieldNumber == that.fieldNumber && this.name.equals(that.name) && this.pointDimensionCount == that.pointDimensionCount && this.pointNumBytes == that.pointNumBytes && this.dvGen == that.dvGen && this.indexOptions == that.indexOptions && this.storePayloads == that.storePayloads && this.storeTermVector == that.storeTermVector && this.omitNorms == that.omitNorms;
        }
    }
}

