/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FileUtils;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.StatelessService;
import java.io.File;
import java.nio.file.Path;

public class DirectoryContentService
extends StatelessService {
    private final Path root;

    public DirectoryContentService(Path root) {
        this.root = root;
        this.toggleOption(Service.ServiceOption.URI_NAMESPACE_OWNER, true);
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleGet(Operation get) {
        String path = get.getUri().getPath();
        if (path.contains("..")) {
            get.fail(404);
            return;
        }
        File file = this.root.resolve(path = path.substring(this.getSelfLink().length() + 1)).toFile();
        if (file.isDirectory() || !file.canRead()) {
            get.fail(404);
            return;
        }
        FileUtils.readFileAndComplete(get, file);
    }
}

