/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;

public class CheckpointService
extends StatefulService {
    public static final String FACTORY_LINK = "/core/checkpoints";

    public CheckpointService() {
        super(CheckpointState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.IDEMPOTENT_POST, true);
    }

    @Override
    public void handleStart(Operation startPost) {
        if (this.validateState(startPost) == null) {
            return;
        }
        startPost.complete();
    }

    @Override
    public void handlePut(Operation put) {
        if (!put.hasPragmaDirective("xn-post-to-put")) {
            Operation.failActionNotSupported(put);
            return;
        }
        CheckpointState newState = this.validateState(put);
        if (newState == null) {
            return;
        }
        CheckpointState currentState = (CheckpointState)this.getState(put);
        boolean update = this.updateState(currentState, newState);
        if (!update) {
            put.addPragmaDirective("xn-state-not-modified");
            put.complete();
            return;
        }
        put.complete();
    }

    private CheckpointState validateState(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("initial state is required"));
            return null;
        }
        CheckpointState body = op.getBody(CheckpointState.class);
        if (body.timestamp == null) {
            op.fail(new IllegalArgumentException("timestamp is required"));
            return null;
        }
        return body;
    }

    private boolean updateState(CheckpointState currentState, CheckpointState newState) {
        if (newState.timestamp <= currentState.timestamp) {
            return false;
        }
        currentState.timestamp = newState.timestamp;
        return true;
    }

    public static class CheckpointState
    extends ServiceDocument {
        public static final long VERSION_RETENTION_LIMIT = 10L;
        public static final long VERSION_RETENTION_FLOOR = 3L;
        public Long timestamp;
        public String factoryLink;
    }
}

