/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.CheckpointService;

public class CheckpointFactoryService
extends FactoryService {
    public static final String SELF_LINK = "/core/checkpoints";

    public CheckpointFactoryService() {
        super(CheckpointService.CheckpointState.class);
    }

    @Override
    public void handleStart(Operation startPost) {
        this.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        this.setAvailable(true);
        startPost.complete();
    }

    @Override
    public Service createServiceInstance() throws Throwable {
        return new CheckpointService();
    }

    @Override
    protected String buildDefaultChildSelfLink(ServiceDocument document) throws IllegalArgumentException {
        CheckpointService.CheckpointState state = (CheckpointService.CheckpointState)document;
        if (state == null || state.factoryLink.isEmpty()) {
            throw new IllegalArgumentException("factoryLink is required");
        }
        return this.createSelfLinkFromState(state);
    }

    private String createSelfLinkFromState(CheckpointService.CheckpointState state) {
        return UriUtils.buildUriPath(SELF_LINK, UriUtils.convertPathCharsFromLink(state.factoryLink));
    }
}

