/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupBroadcastResponse;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.QueryTaskUtils;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public class BroadcastQueryPageService
extends StatelessService {
    public static final String SELF_LINK_PREFIX = "broadcast-query-page";
    public static final String KIND = Utils.buildKind(QueryTask.class);
    private final QueryTask.QuerySpecification spec;
    private final List<String> pageLinks;
    private final long expirationMicros;
    private final NodeGroupBroadcastResponse nodeGroupResponse;
    private String currentPageLink;
    private String prevPageLink;
    private String nextPageLink;

    public BroadcastQueryPageService(QueryTask.QuerySpecification spec, List<String> pageLinks, long expMicros, NodeGroupBroadcastResponse nodeGroupResponse, String currentPageLink, String prevPageLink, String nextPageLink) {
        super(QueryTask.class);
        this.spec = spec;
        this.pageLinks = pageLinks;
        this.expirationMicros = expMicros;
        this.nodeGroupResponse = nodeGroupResponse;
        this.currentPageLink = currentPageLink;
        this.prevPageLink = prevPageLink;
        this.nextPageLink = nextPageLink;
    }

    @Override
    public void handleStart(Operation post) {
        ServiceDocument initState = post.getBody(ServiceDocument.class);
        long interval = initState.documentExpirationTimeMicros - Utils.getSystemNowMicrosUtc();
        if (interval < 0L) {
            this.logWarning("Task expiration is in the past, extending it", new Object[0]);
            interval = this.getHost().getMaintenanceIntervalMicros() * 2L;
        }
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        super.setMaintenanceIntervalMicros(interval);
        post.complete();
    }

    @Override
    public void handleGet(Operation get) {
        List responses = Collections.synchronizedList(new ArrayList());
        AtomicInteger remainingQueries = new AtomicInteger(this.pageLinks.size());
        if (remainingQueries.get() == 0) {
            get.complete();
            return;
        }
        for (String indexLink : this.pageLinks) {
            Operation op = Operation.createGet(UriUtils.buildUri(this.getHost(), indexLink)).transferRefererFrom(get).setExpiration(Utils.fromNowMicrosUtc(this.getHost().getOperationTimeoutMicros())).setCompletion((o, e) -> {
                int r;
                if (e != null) {
                    get.fail(e);
                    return;
                }
                QueryTask rsp = o.getBody(QueryTask.class);
                if (rsp != null) {
                    responses.add(rsp);
                }
                if ((r = remainingQueries.decrementAndGet()) == 0) {
                    this.collectPagesAndStartNewServices(responses, (response, error) -> {
                        if (error != null) {
                            get.fail((Throwable)error);
                            return;
                        }
                        rsp.results = response;
                        get.setBodyNoCloning(rsp).complete();
                    });
                }
            });
            this.getHost().sendRequest(op);
        }
    }

    private void collectPagesAndStartNewServices(List<QueryTask> responses, BiConsumer<ServiceDocumentQueryResult, Throwable> onCompletion) {
        ArrayList<ServiceDocumentQueryResult> queryResults = new ArrayList<ServiceDocumentQueryResult>();
        ArrayList<String> nextPageLinks = new ArrayList<String>();
        ArrayList<String> prevPageLinks = new ArrayList<String>();
        for (QueryTask rsp : responses) {
            if (rsp.results == null) continue;
            queryResults.add(rsp.results);
            if (rsp.results.nextPageLink != null) {
                nextPageLinks.add(rsp.results.nextPageLink);
            }
            if (rsp.results.prevPageLink == null) continue;
            prevPageLinks.add(rsp.results.prevPageLink);
        }
        ServiceDocumentQueryResult mergeResults = new ServiceDocumentQueryResult();
        mergeResults.queryTimeMicros = queryResults.stream().map(r -> r.queryTimeMicros).max(Long::compareTo).orElse(null);
        if (!nextPageLinks.isEmpty()) {
            if (this.nextPageLink == null) {
                this.nextPageLink = this.startNewService(nextPageLinks, this.currentPageLink, null);
            }
            mergeResults.nextPageLink = this.nextPageLink;
        }
        if (!prevPageLinks.isEmpty()) {
            if (this.prevPageLink == null) {
                this.prevPageLink = this.startNewService(prevPageLinks, null, this.currentPageLink);
            }
            mergeResults.prevPageLink = this.prevPageLink;
        }
        boolean isAscOrder = this.spec.sortOrder == null || this.spec.sortOrder == QueryTask.QuerySpecification.SortOrder.ASC;
        QueryTaskUtils.processQueryResults(this.getHost(), queryResults, isAscOrder, this.spec.options, this.nodeGroupResponse, mergeResults, onCompletion);
    }

    @Override
    public void handleMaintenance(Operation op) {
        op.complete();
        this.getHost().stopService(this);
    }

    private String startNewService(List<String> pageLinks, String prevPageLink, String nextPageLink) {
        URI broadcastPageServiceUri = UriUtils.buildUri(this.getHost(), UriUtils.buildUriPath(ServiceUriPaths.CORE_QUERY_BROADCAST_PAGE, String.valueOf(Utils.getNowMicrosUtc())));
        URI forwarderUri = UriUtils.buildForwardToPeerUri(broadcastPageServiceUri, this.getHost().getId(), "/core/node-selectors/default", EnumSet.noneOf(Service.ServiceOption.class));
        String broadcastQueryPageLink = forwarderUri.getPath() + "?" + forwarderUri.getQuery();
        ServiceDocument postBody = new ServiceDocument();
        postBody.documentSelfLink = broadcastPageServiceUri.getPath();
        postBody.documentExpirationTimeMicros = this.expirationMicros;
        Operation startPost = Operation.createPost(broadcastPageServiceUri).setBody(postBody).setCompletion((o, e) -> {
            if (e != null) {
                this.failTask(e, o, null);
                return;
            }
        });
        this.getHost().startService(startPost, new BroadcastQueryPageService(this.spec, pageLinks, this.expirationMicros, this.nodeGroupResponse, broadcastQueryPageLink, prevPageLink, nextPageLink));
        return broadcastQueryPageLink;
    }

    private void failTask(Throwable e, Operation directOp, Operation.CompletionHandler c) {
        QueryTask t = new QueryTask();
        t.taskInfo.stage = TaskState.TaskStage.FAILED;
        t.taskInfo.failure = Utils.toServiceErrorResponse(e);
        if (directOp != null) {
            directOp.setBody(t).fail(e);
            return;
        }
        this.sendRequest(Operation.createPatch(this.getUri()).setBody(t).setCompletion(c));
    }

    @Override
    public void handleDelete(Operation delete) {
        if (this.pageLinks.isEmpty()) {
            super.handleDelete(delete);
            return;
        }
        OperationJoin.create(this.pageLinks.stream().map(link -> Operation.createDelete(this, link).setReferer(this.getUri()))).setCompletion((ops, exs) -> {
            if (exs != null) {
                this.logWarning("Failed to delete query result pages for broadcast query result %s: %s", this.getUri(), Utils.toString(exs));
            }
            super.handleDelete(delete);
        }).sendWith(this);
    }
}

