/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class SortedKeysMapViewAdapterFactory
implements TypeAdapterFactory {
    private static final TypeToken<Map<String, ?>> TYPE = new TypeToken<Map<String, ?>>(){};
    private static final Comparator<Map.Entry<?, ?>> COMP = (a, b) -> ((Comparable)a.getKey()).compareTo(b.getKey());

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!Map.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        final TypeAdapter orig = gson.getDelegateAdapter((TypeAdapterFactory)this, TYPE);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    orig.write(out, null);
                    return;
                }
                Map map = (Map)value;
                if (map.size() <= 1) {
                    orig.write(out, (Object)map);
                } else {
                    orig.write(out, new SortedKeysView(map));
                }
            }

            public T read(JsonReader in) throws IOException {
                return orig.read(in);
            }
        };
    }

    static final class SortedKeysView<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> map;

        SortedKeysView(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            try {
                TreeSet<Map.Entry<K, V>> res = new TreeSet<Map.Entry<K, V>>(COMP);
                for (Map.Entry<K, V> entry : this.map.entrySet()) {
                    res.add(new AbstractMap.SimpleImmutableEntry<K, V>(entry));
                }
                return res;
            }
            catch (ClassCastException e) {
                return this.map.entrySet();
            }
        }
    }
}

