/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.vmware.xenon.common.serialization.TypeTokens;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

public enum ObjectCollectionTypeConverter implements JsonSerializer<Collection<Object>>,
JsonDeserializer<Collection<Object>>
{
    INSTANCE;

    public static final Type TYPE_LIST;
    public static final Type TYPE_SET;
    public static final Type TYPE_COLLECTION;

    public JsonElement serialize(Collection<Object> set, Type type, JsonSerializationContext context) {
        JsonArray setObject = new JsonArray();
        for (Object e : set) {
            if (e == null) {
                setObject.add((JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (e instanceof JsonElement) {
                setObject.add((JsonElement)e);
                continue;
            }
            setObject.add(context.serialize(e));
        }
        return setObject;
    }

    public Collection<Object> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        HashSet<Object> result;
        if (!json.isJsonArray()) {
            throw new JsonParseException("Expecting a json array object but found: " + json);
        }
        if (TYPE_SET.equals(type)) {
            result = new HashSet();
        } else if (TYPE_LIST.equals(type) || TYPE_COLLECTION.equals(type)) {
            result = new LinkedList();
        } else {
            throw new JsonParseException("Unexpected target type: " + type);
        }
        JsonArray jsonArray = json.getAsJsonArray();
        for (JsonElement entry : jsonArray) {
            if (entry.isJsonNull()) {
                result.add(null);
                continue;
            }
            if (entry.isJsonPrimitive()) {
                JsonPrimitive elem = entry.getAsJsonPrimitive();
                Object value = null;
                if (elem.isBoolean()) {
                    value = elem.getAsBoolean();
                } else if (elem.isString()) {
                    value = elem.getAsString();
                } else if (elem.isNumber()) {
                    BigDecimal num = elem.getAsBigDecimal();
                    try {
                        value = num.longValueExact();
                    }
                    catch (ArithmeticException e) {
                        value = num.doubleValue();
                    }
                } else {
                    throw new RuntimeException("Unexpected value type for json element:" + elem);
                }
                result.add(value);
                continue;
            }
            result.add(entry);
        }
        return result;
    }

    static {
        TYPE_LIST = TypeTokens.LIST_OF_OBJECTS;
        TYPE_SET = TypeTokens.SET_OF_OBJECTS;
        TYPE_COLLECTION = TypeTokens.COLLECTION_OF_OBJECTS;
    }
}

