/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonWriter;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.serialization.ByteArrayToBase64TypeAdapter;
import com.vmware.xenon.common.serialization.HashingJsonWriter;
import com.vmware.xenon.common.serialization.InstantConverter;
import com.vmware.xenon.common.serialization.ObjectCollectionTypeConverter;
import com.vmware.xenon.common.serialization.ObjectMapTypeConverter;
import com.vmware.xenon.common.serialization.PathConverter;
import com.vmware.xenon.common.serialization.RequestRouteConverter;
import com.vmware.xenon.common.serialization.SortedKeysMapViewAdapterFactory;
import com.vmware.xenon.common.serialization.UtcDateTypeAdapter;
import com.vmware.xenon.common.serialization.ZonedDateTimeConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;

public class JsonMapper {
    public static final String PROPERTY_JSON_SUPPRESS_GSON_SERIALIZATION_ERRORS = "xenon.json.suppressGsonSerializationErrors";
    public static final String PROPERTY_DISABLE_OBJECT_COLLECTION_AND_MAP_JSON_ADAPTERS = "xenon.JsonMapper.disableObjectCollectionAndMapJsonAdapters";
    private static boolean JSON_SUPPRESS_GSON_SERIALIZATION_ERRORS = false;
    private static boolean DISABLE_OBJECT_COLLECTION_AND_MAP_JSON_ADAPTERS = false;
    private static final int MAX_SERIALIZATION_ATTEMPTS = 100;
    private static final String JSON_INDENT = "  ";
    private final Gson compact;
    private Gson hashing;
    private final Gson compactSensitive;
    private final Gson compactExcludeBuiltin;
    private final Gson compactSensitiveAndExcludeBuiltin;
    private boolean jsonSuppressGsonSerializationErrors = JSON_SUPPRESS_GSON_SERIALIZATION_ERRORS;

    public JsonMapper() {
        this(JsonMapper.createDefaultGson(EnumSet.of(JsonOptions.COMPACT)), JsonMapper.createDefaultGson(EnumSet.of(JsonOptions.COMPACT, JsonOptions.EXCLUDE_SENSITIVE)));
    }

    public JsonMapper(Consumer<GsonBuilder> gsonConfigCallback) {
        this(JsonMapper.createCustomGson(EnumSet.of(JsonOptions.COMPACT), gsonConfigCallback), JsonMapper.createCustomGson(EnumSet.of(JsonOptions.COMPACT, JsonOptions.EXCLUDE_SENSITIVE), gsonConfigCallback));
        this.hashing = this.createHashingGson(gsonConfigCallback);
    }

    public JsonMapper(Gson compact, Gson compactSensitive) {
        this.compact = compact;
        this.compactSensitive = compactSensitive;
        this.hashing = this.createHashingGson(null);
        this.compactExcludeBuiltin = JsonMapper.createDefaultGson(EnumSet.of(JsonOptions.COMPACT, JsonOptions.EXCLUDE_BUILTIN));
        this.compactSensitiveAndExcludeBuiltin = JsonMapper.createDefaultGson(EnumSet.of(JsonOptions.COMPACT, JsonOptions.EXCLUDE_BUILTIN, JsonOptions.EXCLUDE_SENSITIVE));
    }

    private Gson createHashingGson(Consumer<GsonBuilder> gsonConfigCallback) {
        GsonBuilder bldr = new GsonBuilder();
        JsonMapper.registerCommonGsonTypeAdapters(bldr);
        bldr.disableHtmlEscaping();
        bldr.registerTypeAdapterFactory((TypeAdapterFactory)new SortedKeysMapViewAdapterFactory());
        if (gsonConfigCallback != null) {
            gsonConfigCallback.accept(bldr);
        }
        return bldr.create();
    }

    public String toJson(Object body) {
        int i = 1;
        while (true) {
            try {
                return this.compact.toJson(body);
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    public void toJson(Object body, Appendable appendable) {
        int i = 1;
        while (true) {
            try {
                this.compact.toJson(body, appendable);
                return;
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    public JsonElement toJsonElement(Object body) {
        if (body == null) {
            return null;
        }
        int i = 1;
        while (true) {
            try {
                JsonTreeWriter writer = new JsonTreeWriter();
                this.compact.toJson(body, body.getClass(), (JsonWriter)writer);
                return writer.get();
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    public String toJsonHtml(Object body) {
        if (body == null) {
            return this.compact.toJson(null);
        }
        int i = 1;
        while (true) {
            try {
                StringBuilder appendable = new StringBuilder();
                this.toJsonHtml(body, appendable);
                return appendable.toString();
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    private Gson getGsonForOptions(Set<JsonOptions> options) {
        if (options.containsAll(EnumSet.of(JsonOptions.EXCLUDE_BUILTIN, JsonOptions.EXCLUDE_SENSITIVE))) {
            return this.compactSensitiveAndExcludeBuiltin;
        }
        if (options.contains((Object)JsonOptions.EXCLUDE_BUILTIN)) {
            return this.compactExcludeBuiltin;
        }
        if (options.contains((Object)JsonOptions.EXCLUDE_SENSITIVE)) {
            return this.compactSensitive;
        }
        return this.compact;
    }

    public void toJson(Set<JsonOptions> options, Object body, Appendable appendable) {
        Gson gson = this.getGsonForOptions(options);
        int i = 1;
        while (true) {
            try {
                if (!options.contains((Object)JsonOptions.COMPACT)) {
                    gson.toJson(body, body.getClass(), this.makePrettyJsonWriter(appendable));
                    return;
                }
                gson.toJson(body, appendable);
                return;
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    private void handleIllegalStateException(IllegalStateException e, int i) {
        if (e.getMessage() == null) {
            Utils.logWarning("Failure serializing body because of GSON race (attempt %d)", i);
            if (i >= 100) {
                throw e;
            }
            try {
                Thread.sleep(0L, 1000 * i);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        throw e;
    }

    public <T> T fromJson(Object json, Class<T> clazz) {
        if (clazz.isInstance(json)) {
            return clazz.cast(json);
        }
        return this.fromJson(json, (Type)clazz);
    }

    public <T> T fromJson(Object json, Type type) {
        try {
            if (json instanceof JsonElement) {
                return (T)this.compact.fromJson((JsonElement)json, type);
            }
            return (T)this.compact.fromJson(json.toString(), type);
        }
        catch (RuntimeException e) {
            if (this.jsonSuppressGsonSerializationErrors) {
                throw new JsonSyntaxException("JSON body could not be parsed");
            }
            throw e;
        }
    }

    public void setJsonSuppressGsonSerializationErrors(boolean suppressErrors) {
        this.jsonSuppressGsonSerializationErrors = suppressErrors;
    }

    private static Gson createDefaultGson(EnumSet<JsonOptions> options) {
        return JsonMapper.createDefaultGsonBuilder(options).create();
    }

    private static Gson createCustomGson(EnumSet<JsonOptions> options, Consumer<GsonBuilder> gsonConfigCallback) {
        GsonBuilder bldr = JsonMapper.createDefaultGsonBuilder(options);
        gsonConfigCallback.accept(bldr);
        return bldr.create();
    }

    public static GsonBuilder createDefaultGsonBuilder(EnumSet<JsonOptions> options) {
        GsonBuilder bldr = new GsonBuilder();
        JsonMapper.registerCommonGsonTypeAdapters(bldr);
        if (!options.contains((Object)JsonOptions.COMPACT)) {
            bldr.setPrettyPrinting();
        }
        bldr.disableHtmlEscaping();
        if (options.contains((Object)JsonOptions.EXCLUDE_SENSITIVE)) {
            bldr.addSerializationExclusionStrategy((ExclusionStrategy)new SensitiveAnnotationExclusionStrategy());
        }
        if (options.contains((Object)JsonOptions.EXCLUDE_BUILTIN)) {
            bldr.addSerializationExclusionStrategy((ExclusionStrategy)new BuiltInServiceDocumentFieldsExclusionStrategy());
        }
        return bldr;
    }

    private static void registerCommonGsonTypeAdapters(GsonBuilder bldr) {
        if (!DISABLE_OBJECT_COLLECTION_AND_MAP_JSON_ADAPTERS) {
            bldr.registerTypeAdapter(ObjectCollectionTypeConverter.TYPE_LIST, (Object)ObjectCollectionTypeConverter.INSTANCE);
            bldr.registerTypeAdapter(ObjectCollectionTypeConverter.TYPE_SET, (Object)ObjectCollectionTypeConverter.INSTANCE);
            bldr.registerTypeAdapter(ObjectCollectionTypeConverter.TYPE_COLLECTION, (Object)ObjectCollectionTypeConverter.INSTANCE);
        }
        bldr.registerTypeAdapter(ObjectMapTypeConverter.TYPE, (Object)ObjectMapTypeConverter.INSTANCE);
        bldr.registerTypeAdapter(InstantConverter.TYPE, (Object)InstantConverter.INSTANCE);
        bldr.registerTypeAdapter(ZonedDateTimeConverter.TYPE, (Object)ZonedDateTimeConverter.INSTANCE);
        bldr.registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter());
        bldr.registerTypeAdapter(RequestRouteConverter.TYPE, (Object)RequestRouteConverter.INSTANCE);
        bldr.registerTypeHierarchyAdapter(Path.class, (Object)PathConverter.INSTANCE);
        bldr.registerTypeHierarchyAdapter(Date.class, (Object)UtcDateTypeAdapter.INSTANCE);
    }

    public void toJsonHtml(Object body, Appendable appendable) {
        if (body == null) {
            this.compact.toJson(null, appendable);
            return;
        }
        int i = 1;
        while (true) {
            try {
                JsonWriter jsonWriter = this.makePrettyJsonWriter(appendable);
                this.compact.toJson(body, body.getClass(), jsonWriter);
                return;
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    private JsonWriter makePrettyJsonWriter(Appendable appendable) {
        JsonWriter jsonWriter = new JsonWriter(Streams.writerForAppendable((Appendable)appendable));
        jsonWriter.setIndent(JSON_INDENT);
        return jsonWriter;
    }

    public long hashJson(Object body, long seed) {
        if (body == null) {
            return seed;
        }
        int i = 1;
        while (true) {
            try {
                HashingJsonWriter w = new HashingJsonWriter(seed);
                this.hashing.toJson(body, body.getClass(), (JsonWriter)w);
                return w.getHash();
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    static {
        String v = System.getProperty(PROPERTY_JSON_SUPPRESS_GSON_SERIALIZATION_ERRORS);
        if (v != null) {
            JSON_SUPPRESS_GSON_SERIALIZATION_ERRORS = Boolean.valueOf(v);
        }
        if ((v = System.getProperty(PROPERTY_DISABLE_OBJECT_COLLECTION_AND_MAP_JSON_ADAPTERS)) != null) {
            DISABLE_OBJECT_COLLECTION_AND_MAP_JSON_ADAPTERS = Boolean.valueOf(v);
        }
    }

    private static class BuiltInServiceDocumentFieldsExclusionStrategy
    implements ExclusionStrategy {
        private BuiltInServiceDocumentFieldsExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return ServiceDocument.isBuiltInDocumentField(fieldAttributes.getName());
        }
    }

    private static class SensitiveAnnotationExclusionStrategy
    implements ExclusionStrategy {
        private SensitiveAnnotationExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            Collection annotations = fieldAttributes.getAnnotations();
            for (Annotation a : annotations) {
                if (ServiceDocument.UsageOptions.class.equals(a.annotationType())) {
                    ServiceDocument.UsageOptions usageOptions = (ServiceDocument.UsageOptions)a;
                    for (ServiceDocument.UsageOption usageOption : usageOptions.value()) {
                        if (!usageOption.option().equals((Object)ServiceDocumentDescription.PropertyUsageOption.SENSITIVE)) continue;
                        return true;
                    }
                    continue;
                }
                if (ServiceDocument.UsageOption.class.equals(a.annotationType())) {
                    ServiceDocument.UsageOption usageOption = (ServiceDocument.UsageOption)a;
                    if (!usageOption.option().equals((Object)ServiceDocumentDescription.PropertyUsageOption.SENSITIVE)) continue;
                    return true;
                }
                if (!ServiceDocument.PropertyOptions.class.equals(a.annotationType())) continue;
                ServiceDocument.PropertyOptions propertyOptions = (ServiceDocument.PropertyOptions)a;
                for (ServiceDocumentDescription.PropertyUsageOption propertyUsageOption : propertyOptions.usage()) {
                    if (!propertyUsageOption.equals((Object)ServiceDocumentDescription.PropertyUsageOption.SENSITIVE)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }

    public static enum JsonOptions {
        COMPACT,
        EXCLUDE_SENSITIVE,
        EXCLUDE_BUILTIN;

    }
}

