/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStatUtils;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.SystemHostInfo;
import com.vmware.xenon.common.UtilityService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ServiceResourceTracker {
    private final Map<String, Service> attachedServices;
    private final ConcurrentMap<String, ServiceDocument> cachedServiceStates = new ConcurrentHashMap<String, ServiceDocument>();
    private final ConcurrentMap<String, Long> persistedServiceLastAccessTimes = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<CachedServiceStateKey, ServiceDocument> cachedTransactionalServiceStates = new ConcurrentHashMap<CachedServiceStateKey, ServiceDocument>();
    private final ServiceHost host;
    private boolean isServiceStateCaching = true;
    private long startTimeMicros;
    private ThreadMXBean threadBean;
    private Service mgmtService;

    public static ServiceResourceTracker create(ServiceHost host, Map<String, Service> services) {
        ServiceResourceTracker srt = new ServiceResourceTracker(host, services);
        return srt;
    }

    public ServiceResourceTracker(ServiceHost host, Map<String, Service> services) {
        this.attachedServices = services;
        this.host = host;
    }

    private void checkAndInitializeStats() {
        if (this.startTimeMicros > 0L) {
            return;
        }
        this.startTimeMicros = Utils.getNowMicrosUtc();
        if (this.host.getManagementService() == null) {
            this.host.log(Level.WARNING, "Management service not found, stats will not be available", new Object[0]);
            return;
        }
        long inUseMem = this.host.getState().systemInfo.totalMemoryByteCount - this.host.getState().systemInfo.freeMemoryByteCount;
        long freeMem = this.host.getState().systemInfo.maxMemoryByteCount - inUseMem;
        long freeDisk = this.host.getState().systemInfo.freeDiskByteCount;
        this.createTimeSeriesStat("availableMemoryBytes", freeMem);
        this.createTimeSeriesStat("availableDiskByte", freeDisk);
        this.createTimeSeriesStat("cpuUsagePercent", 0.0);
        this.createTimeSeriesStat("http11ConnectionCount", 0.0);
        this.createTimeSeriesStat("http2ConnectionCount", 0.0);
        this.getManagementService().setStat("threadCount", (double)Utils.DEFAULT_THREAD_COUNT);
    }

    void createTimeSeriesStat(String name, double v) {
        Service service = this.getManagementService();
        EnumSet<ServiceStats.TimeSeriesStats.AggregationType> types = EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.AVG);
        ServiceStats.ServiceStat dayStat = ServiceStatUtils.getOrCreateDailyTimeSeriesStat(service, name, types);
        ServiceStats.ServiceStat hourStat = ServiceStatUtils.getOrCreateHourlyTimeSeriesHistogramStat(service, name, types);
        service.setStat(dayStat, v);
        service.setStat(hourStat, v);
    }

    private void updateStats(long now) {
        ScheduledThreadPoolExecutor scheduledExecutor;
        ForkJoinPool executor;
        ServiceClient.ConnectionPoolMetrics http2TagInfo;
        long[] threadIds;
        this.host.updateMemoryAndDiskInfo();
        ServiceHost.ServiceHostState hostState = this.host.getStateNoCloning();
        SystemHostInfo shi = hostState.systemInfo;
        Service mgmtService = this.getManagementService();
        if (mgmtService == null) {
            return;
        }
        this.checkAndInitializeStats();
        mgmtService.setStat("serviceCount", (double)hostState.serviceCount);
        long freeMemory = shi.maxMemoryByteCount - (shi.totalMemoryByteCount - shi.freeMemoryByteCount);
        mgmtService.setStat("availableMemoryBytesPerHour", (double)freeMemory);
        mgmtService.setStat("availableMemoryBytesPerDay", (double)freeMemory);
        mgmtService.setStat("availableDiskBytePerHour", (double)shi.freeDiskByteCount);
        mgmtService.setStat("availableDiskBytePerDay", (double)shi.freeDiskByteCount);
        if (this.threadBean == null) {
            this.threadBean = ManagementFactory.getThreadMXBean();
        }
        if (!this.threadBean.isCurrentThreadCpuTimeSupported()) {
            return;
        }
        long totalTime = 0L;
        for (long threadId : threadIds = this.threadBean.getAllThreadIds()) {
            totalTime += this.threadBean.getThreadCpuTime(threadId);
        }
        double runningTime = now - this.startTimeMicros;
        if (runningTime <= 0.0) {
            return;
        }
        this.createTimeSeriesStat("jvmThreadCount", threadIds.length);
        totalTime = TimeUnit.NANOSECONDS.toMicros(totalTime);
        double pctUse = (double)totalTime / runningTime;
        mgmtService.setStat("cpuUsagePercentPerHour", pctUse);
        mgmtService.setStat("cpuUsagePercentPerDay", pctUse);
        ServiceClient.ConnectionPoolMetrics http11TagInfo = this.host.getClient().getConnectionPoolMetrics(false);
        if (http11TagInfo != null) {
            this.createTimeSeriesStat("http11PendingOperationCount", http11TagInfo.pendingRequestCount);
            this.createTimeSeriesStat("http11ConnectionCount", http11TagInfo.inUseConnectionCount);
            this.createTimeSeriesStat("http11AvailableConnectionCount", http11TagInfo.availableConnectionCount);
        }
        if ((http2TagInfo = this.host.getClient().getConnectionPoolMetrics(true)) != null) {
            this.createTimeSeriesStat("http2PendingOperationCount", http2TagInfo.pendingRequestCount);
            this.createTimeSeriesStat("http2ConnectionCount", http2TagInfo.inUseConnectionCount);
            this.createTimeSeriesStat("http2AvailableConnectionCount", http2TagInfo.availableConnectionCount);
        }
        if ((executor = (ForkJoinPool)this.host.getExecutor()) != null) {
            this.createTimeSeriesStat("executorQueueDepth", executor.getQueuedSubmissionCount());
        }
        if ((scheduledExecutor = (ScheduledThreadPoolExecutor)this.host.getScheduledExecutor()) != null) {
            this.createTimeSeriesStat("scheduledExecutorQueueDepth", scheduledExecutor.getQueue().size());
        }
    }

    private Service getManagementService() {
        if (this.mgmtService == null) {
            this.mgmtService = this.host.getManagementService();
        }
        return this.mgmtService;
    }

    public void setServiceStateCaching(boolean enable) {
        this.isServiceStateCaching = enable;
    }

    public void resetCachedServiceState(Service s, ServiceDocument st, Operation op) {
        this.updateCachedServiceState(s, st, op, false);
    }

    public void updateCachedServiceState(Service s, ServiceDocument st, Operation op) {
        this.updateCachedServiceState(s, st, op, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCachedServiceState(Service s, ServiceDocument st, Operation op, boolean checkVersion) {
        if (ServiceHost.isServiceIndexed(s) && !this.isTransactional(op)) {
            this.persistedServiceLastAccessTimes.put(s.getSelfLink(), Utils.getNowMicrosUtc());
        }
        boolean cacheState = !ServiceHost.isServiceIndexed(s);
        if (!(cacheState |= (!op.isFromReplication() || op.isSynchronizeOwner()) && this.isServiceStateCaching)) {
            return;
        }
        if (!this.isTransactional(op)) {
            String string = s.getSelfLink();
            synchronized (string) {
                ServiceDocument cachedState2 = this.cachedServiceStates.put(s.getSelfLink(), st);
                if (checkVersion && cachedState2 != null && cachedState2.documentVersion > st.documentVersion) {
                    this.cachedServiceStates.put(s.getSelfLink(), cachedState2);
                }
            }
            return;
        }
        CachedServiceStateKey key = new CachedServiceStateKey(s.getSelfLink(), op.getTransactionId());
        this.cachedTransactionalServiceStates.compute(key, (k, cachedState) -> {
            if (cachedState != null && cachedState.documentVersion > st.documentVersion) {
                return cachedState;
            }
            return st;
        });
    }

    public ServiceDocument getCachedServiceState(Service s, Operation op) {
        String servicePath = s.getSelfLink();
        ServiceDocument state = null;
        if (this.isTransactional(op)) {
            CachedServiceStateKey key = new CachedServiceStateKey(servicePath, op.getTransactionId());
            state = (ServiceDocument)this.cachedTransactionalServiceStates.get(key);
        }
        if (state == null) {
            state = (ServiceDocument)this.cachedServiceStates.get(servicePath);
        }
        if (state == null) {
            this.updateCacheMissStats();
            return null;
        }
        if (state.documentExpirationTimeMicros > 0L && state.documentExpirationTimeMicros < Utils.getNowMicrosUtc()) {
            this.stopServiceAndClearFromCache(s, state);
            return null;
        }
        if (ServiceHost.isServiceIndexed(s) && !this.isTransactional(op)) {
            this.persistedServiceLastAccessTimes.put(servicePath, Utils.getNowMicrosUtc());
        }
        this.updateCacheHitStats();
        return state;
    }

    private void stopServiceAndClearFromCache(Service s, ServiceDocument state) {
        Operation deleteExp = Operation.createDelete(this.host, s.getSelfLink()).setBody(state).disableFailureLogging(true).addPragmaDirective("xn-no-index-update").addPragmaDirective("xn-no-fwd").setReferer(this.host.getUri());
        this.host.sendRequest(deleteExp);
    }

    public void clearCachedServiceState(Service s, Operation op) {
        String servicePath = s.getSelfLink();
        if (!this.isTransactional(op)) {
            this.persistedServiceLastAccessTimes.remove(servicePath);
            ServiceDocument doc = (ServiceDocument)this.cachedServiceStates.remove(servicePath);
            if (doc != null) {
                this.updateCacheClearStats();
            }
            return;
        }
        this.clearTransactionalCachedServiceState(servicePath, op.getTransactionId());
    }

    public void clearTransactionalCachedServiceState(String servicePath, String transactionId) {
        CachedServiceStateKey key = new CachedServiceStateKey(servicePath, transactionId);
        ServiceDocument doc = (ServiceDocument)this.cachedTransactionalServiceStates.remove(key);
        Service s = this.host.findService(servicePath, true);
        if (s == null) {
            return;
        }
        if (doc != null) {
            this.updateCacheClearStats();
        }
    }

    public void updateCacheMissStats() {
        this.host.getManagementService().adjustStat("serviceCacheMissCount", 1.0);
    }

    private void updateCacheClearStats() {
        this.host.getManagementService().adjustStat("serviceCacheClearCount", 1.0);
    }

    private void updateCacheHitStats() {
        this.host.getManagementService().adjustStat("serviceCacheHitCount", 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMaintenance(long now, long deadlineMicros) {
        this.updateStats(now);
        ServiceHost.ServiceHostState hostState = this.host.getStateNoCloning();
        int stopServiceCount = 0;
        for (Service service : this.attachedServices.values()) {
            Long lastAccessTime;
            ServiceDocument state = (ServiceDocument)this.cachedServiceStates.get(service.getSelfLink());
            if (!ServiceHost.isServiceIndexed(service)) {
                if (state == null || state.documentExpirationTimeMicros <= 0L || state.documentExpirationTimeMicros >= now) continue;
                this.stopServiceAndClearFromCache(service, state);
                continue;
            }
            if (this.serviceExemptFromCacheEviction(service) || this.serviceActive(lastAccessTime = (Long)this.persistedServiceLastAccessTimes.get(service.getSelfLink()), service, now)) continue;
            this.stopServiceAndClearFromCache(service, state);
            ++stopServiceCount;
            if (deadlineMicros >= Utils.getSystemNowMicrosUtc()) continue;
            break;
        }
        if (hostState.serviceCount < 0L) {
            ServiceHost.ServiceHostState serviceHostState = hostState;
            synchronized (serviceHostState) {
                hostState.serviceCount = this.attachedServices.size();
            }
        }
        if (stopServiceCount == 0) {
            return;
        }
        this.host.log(Level.FINE, "Attempt stop on %d services, attached: %d, cached: %d, persistedServiceLastAccessTimes: %d", stopServiceCount, hostState.serviceCount, this.cachedServiceStates.size(), this.persistedServiceLastAccessTimes.size());
    }

    private boolean serviceExemptFromCacheEviction(Service service) {
        if (service.hasOption(Service.ServiceOption.FACTORY)) {
            return true;
        }
        if (service.hasOption(Service.ServiceOption.TRANSACTION_PENDING)) {
            return true;
        }
        if (service.hasOption(Service.ServiceOption.PERIODIC_MAINTENANCE)) {
            return true;
        }
        if (this.host.isServiceStarting(service, service.getSelfLink())) {
            return true;
        }
        if (this.host.hasPendingServiceAvailableCompletions(service.getSelfLink())) {
            return true;
        }
        if (service.getSelfLink().startsWith(ServiceUriPaths.CORE_AUTHZ)) {
            return true;
        }
        return this.hasServiceSoftState(service);
    }

    private boolean serviceActive(Long lastAccessTime, Service s, long now) {
        boolean active;
        if (lastAccessTime == null) {
            return false;
        }
        long cacheClearDelayMicros = s.getCacheClearDelayMicros();
        if (ServiceHost.isServiceImmutable(s)) {
            cacheClearDelayMicros = 0L;
        }
        boolean bl = active = cacheClearDelayMicros + lastAccessTime > now;
        if (!active) {
            this.host.log(Level.FINE, "Considering stopping service %s, isOwner: %b, because it was inactive for %d seconds", s.getSelfLink(), this.host.isDocumentOwner(s), TimeUnit.MICROSECONDS.toSeconds(now - lastAccessTime));
        }
        return active;
    }

    void retryOnDemandLoadConflict(Operation op, Service s) {
        if (!ServiceHost.isServiceIndexed(s)) {
            op.fail(new CancellationException("Service has stopped"));
            return;
        }
        op.removePragmaDirective("xn-check-index");
        this.host.log(Level.WARNING, "ODL conflict: retrying %s (%d %s) on %s", new Object[]{op.getAction(), op.getId(), op.getContextId(), op.getUri().getPath()});
        long interval = Math.max(TimeUnit.SECONDS.toMicros(1L), this.host.getMaintenanceIntervalMicros());
        this.host.scheduleCore(() -> this.host.handleRequest(null, op), interval, TimeUnit.MICROSECONDS);
    }

    public void close() {
        this.cachedServiceStates.clear();
        this.persistedServiceLastAccessTimes.clear();
    }

    private boolean isTransactional(Operation op) {
        return op != null && op.getTransactionId() != null && this.host.getTransactionServiceUri() != null;
    }

    private boolean hasServiceSoftState(Service service) {
        UtilityService subUtilityService = (UtilityService)service.getUtilityService("/subscriptions");
        UtilityService statsUtilityService = (UtilityService)service.getUtilityService("/stats");
        boolean hasSoftState = false;
        if (subUtilityService != null && subUtilityService.hasSubscribers()) {
            hasSoftState = true;
        }
        if (statsUtilityService != null && statsUtilityService.hasStats()) {
            hasSoftState = true;
        }
        return hasSoftState;
    }

    private static final class CachedServiceStateKey {
        private final String servicePath;
        private final String transactionId;

        CachedServiceStateKey(String servicePath, String transactionId) {
            this.servicePath = servicePath;
            this.transactionId = transactionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedServiceStateKey that = (CachedServiceStateKey)o;
            if (this.servicePath != null ? !this.servicePath.equals(that.servicePath) : that.servicePath != null) {
                return false;
            }
            return this.transactionId != null ? this.transactionId.equals(that.transactionId) : that.transactionId == null;
        }

        public int hashCode() {
            int result = this.servicePath != null ? this.servicePath.hashCode() : 0;
            result = 31 * result + (this.transactionId != null ? this.transactionId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return String.format("CachedServiceStateKey{servicePath: %s, transactionId: %s}", this.servicePath, this.transactionId);
        }
    }
}

