/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.Utils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.EnumSet;

public class ServiceDocument {
    public static final String FIELD_NAME_SELF_LINK = "documentSelfLink";
    public static final String FIELD_NAME_VERSION = "documentVersion";
    public static final String FIELD_NAME_EPOCH = "documentEpoch";
    public static final String FIELD_NAME_KIND = "documentKind";
    public static final String FIELD_NAME_UPDATE_TIME_MICROS = "documentUpdateTimeMicros";
    public static final String FIELD_NAME_UPDATE_ACTION = "documentUpdateAction";
    public static final String FIELD_NAME_DESCRIPTION = "documentDescription";
    public static final String FIELD_NAME_OWNER = "documentOwner";
    public static final String FIELD_NAME_SOURCE_LINK = "documentSourceLink";
    public static final String FIELD_NAME_EXPIRATION_TIME_MICROS = "documentExpirationTimeMicros";
    public static final String FIELD_NAME_AUTH_PRINCIPAL_LINK = "documentAuthPrincipalLink";
    public static final String FIELD_NAME_TRANSACTION_ID = "documentTransactionId";
    public static final String FIELD_NAME_SUFFIX_LINK = "Link";
    public static final String FIELD_NAME_SUFFIX_LINKS = "Links";
    public static final String FIELD_NAME_SUFFIX_ADDRESS = "Address";
    public ServiceDocumentDescription documentDescription;
    public long documentVersion;
    public Long documentEpoch;
    public String documentKind;
    public String documentSelfLink;
    public long documentUpdateTimeMicros;
    public String documentUpdateAction;
    public long documentExpirationTimeMicros;
    public String documentOwner;
    public String documentSourceLink;
    public String documentAuthPrincipalLink;
    public String documentTransactionId;

    public void copyTo(ServiceDocument target) {
        target.documentEpoch = this.documentEpoch;
        target.documentDescription = this.documentDescription;
        target.documentOwner = this.documentOwner;
        target.documentSourceLink = this.documentSourceLink;
        target.documentVersion = this.documentVersion;
        target.documentKind = this.documentKind;
        target.documentSelfLink = this.documentSelfLink;
        target.documentUpdateTimeMicros = this.documentUpdateTimeMicros;
        target.documentUpdateAction = this.documentUpdateAction;
        target.documentExpirationTimeMicros = this.documentExpirationTimeMicros;
        target.documentAuthPrincipalLink = this.documentAuthPrincipalLink;
        target.documentTransactionId = this.documentTransactionId;
    }

    public static boolean isDeleted(ServiceDocument document) {
        return document != null && Service.Action.DELETE.toString().equals(document.documentUpdateAction);
    }

    public static EnumSet<DocumentRelationship> compare(ServiceDocument stateA, ServiceDocument stateB, ServiceDocumentDescription desc, long timeEpsilon) {
        long epochB;
        boolean preferred = false;
        EnumSet<DocumentRelationship> results = EnumSet.noneOf(DocumentRelationship.class);
        if (stateB == null) {
            results.add(DocumentRelationship.PREFERRED);
            return results;
        }
        long epochA = stateA.documentEpoch != null ? stateA.documentEpoch : 0L;
        long l = epochB = stateB.documentEpoch != null ? stateB.documentEpoch : 0L;
        if (epochA > epochB || epochA == epochB && stateA.documentVersion > stateB.documentVersion) {
            results.add(DocumentRelationship.NEWER_VERSION);
            preferred = true;
        } else if (epochA == epochB && stateA.documentVersion == stateB.documentVersion) {
            results.add(DocumentRelationship.EQUAL_VERSION);
        }
        long timeDifference = stateA.documentUpdateTimeMicros - stateB.documentUpdateTimeMicros;
        if (timeDifference == 0L) {
            results.add(DocumentRelationship.EQUAL_TIME);
        } else if (timeDifference > 0L) {
            results.add(DocumentRelationship.NEWER_UPDATE_TIME);
        }
        if (results.contains((Object)DocumentRelationship.EQUAL_VERSION)) {
            if (Math.abs(timeDifference) < timeEpsilon) {
                if (!ServiceDocument.equals(desc, stateA, stateB)) {
                    results.add(DocumentRelationship.IN_CONFLICT);
                }
            } else if (results.contains((Object)DocumentRelationship.NEWER_UPDATE_TIME)) {
                preferred = true;
            }
        }
        if (preferred) {
            results.add(DocumentRelationship.PREFERRED);
        }
        return results;
    }

    public static boolean equals(ServiceDocumentDescription description, ServiceDocument currentDocument, ServiceDocument newDocument) {
        if (currentDocument == null || newDocument == null) {
            throw new IllegalArgumentException("Null Service documents cannot be checked for equality.");
        }
        try {
            String currentSignature = Utils.computeSignature(currentDocument, description);
            String newSignature = Utils.computeSignature(newDocument, description);
            return currentSignature.equals(newSignature);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            return false;
        }
    }

    public static boolean isBuiltInDocumentField(String name) {
        switch (name) {
            case "documentKind": 
            case "documentExpirationTimeMicros": 
            case "documentOwner": 
            case "documentSourceLink": 
            case "documentVersion": 
            case "documentEpoch": 
            case "documentUpdateTimeMicros": 
            case "documentUpdateAction": 
            case "documentSelfLink": 
            case "documentDescription": 
            case "documentAuthPrincipalLink": 
            case "documentTransactionId": {
                return true;
            }
        }
        return false;
    }

    public static boolean isAutoMergeEnabledByDefaultForField(String name) {
        switch (name) {
            case "documentExpirationTimeMicros": {
                return true;
            }
        }
        return false;
    }

    public static boolean isBuiltInSignatureExcludedDocumentField(String name) {
        switch (name) {
            case "documentKind": 
            case "documentOwner": 
            case "documentSourceLink": 
            case "documentVersion": 
            case "documentEpoch": 
            case "documentUpdateTimeMicros": 
            case "documentSelfLink": 
            case "documentAuthPrincipalLink": 
            case "documentTransactionId": {
                return true;
            }
        }
        return false;
    }

    public static boolean isBuiltInInfrastructureDocumentField(String name) {
        switch (name) {
            case "documentKind": 
            case "documentExpirationTimeMicros": 
            case "documentOwner": 
            case "documentSourceLink": 
            case "documentVersion": 
            case "documentEpoch": 
            case "documentUpdateTimeMicros": 
            case "documentSelfLink": 
            case "documentAuthPrincipalLink": 
            case "documentTransactionId": {
                return true;
            }
        }
        return false;
    }

    public static boolean isBuiltInNonIndexedDocumentField(String name) {
        switch (name) {
            case "documentDescription": 
            case "documentUpdateAction": {
                return true;
            }
        }
        return false;
    }

    public static boolean isBuiltInDocumentFieldWithNullExampleValue(String name) {
        switch (name) {
            case "documentAuthPrincipalLink": 
            case "documentSourceLink": 
            case "documentOwner": 
            case "documentTransactionId": 
            case "documentEpoch": {
                return true;
            }
        }
        return false;
    }

    public static boolean isLink(String name) {
        return name.endsWith(FIELD_NAME_SUFFIX_LINK);
    }

    public static boolean isLinks(String name) {
        return name.endsWith(FIELD_NAME_SUFFIX_LINKS);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Documentation {
        public String name() default "";

        public String description() default "";

        public String exampleString() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface IndexingParameters {
        public ServiceDocumentDescription.DocumentIndexingOption[] indexing() default {};

        public int serializedStateSize() default 32768;

        public int versionRetention() default 1000;

        public int versionRetentionFloor() default 500;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface PropertyOptions {
        public ServiceDocumentDescription.PropertyUsageOption[] usage() default {};

        public ServiceDocumentDescription.PropertyIndexingOption[] indexing() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface UsageOptions {
        public UsageOption[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=UsageOptions.class)
    @Target(value={ElementType.FIELD})
    public static @interface UsageOption {
        public ServiceDocumentDescription.PropertyUsageOption option();
    }

    public static enum DocumentRelationship {
        IN_CONFLICT,
        EQUAL,
        NEWER_VERSION,
        NEWER_UPDATE_TIME,
        EQUAL_TIME,
        EQUAL_VERSION,
        PREFERRED;

    }
}

