/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.Utils;

public class RequestRateLimitsFilter
implements OperationProcessingChain.Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationProcessingChain.FilterReturnCode processRequest(Operation op, OperationProcessingChain.OperationProcessingContext context) {
        if (op.isFromReplication() || op.isForwarded()) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        if (!op.isRemote()) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        Operation.AuthorizationContext authCtx = op.getAuthorizationContext();
        if (authCtx == null) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        Claims claims = authCtx.getClaims();
        if (claims == null) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        String subject = claims.getSubject();
        if (subject == null) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        ServiceHost.RequestRateInfo rateInfo = context.getHost().getRequestRateLimit(subject);
        if (rateInfo == null) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        ServiceHost.RequestRateInfo requestRateInfo = rateInfo;
        synchronized (requestRateInfo) {
            rateInfo.timeSeries.add(Utils.getSystemNowMicrosUtc(), 0.0, 1.0);
            ServiceStats.TimeSeriesStats.TimeBin mostRecentBin = (ServiceStats.TimeSeriesStats.TimeBin)rateInfo.timeSeries.bins.get(rateInfo.timeSeries.bins.lastKey());
            if (mostRecentBin.sum < rateInfo.limit) {
                return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
            }
        }
        context.getHost().getManagementService().adjustStat("rateLimitedOperationCount", 1.0);
        if (rateInfo.options.contains((Object)ServiceHost.RequestRateInfo.Option.PAUSE_PROCESSING)) {
            op.toggleOption(Operation.OperationOption.RATE_LIMITED, true);
        }
        if (!rateInfo.options.contains((Object)ServiceHost.RequestRateInfo.Option.FAIL)) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        Operation.failLimitExceeded(op, -2147483640, "rate limit for " + op.getUri().getPath());
        return OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING;
    }
}

