/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Utils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public final class PrivateKeyReader {
    private PrivateKeyReader() {
    }

    public static PrivateKey fromPem(Path path, String password) {
        PrivateKey privateKey;
        try {
            byte[] der = PrivateKeyReader.getDer(path);
            KeySpec keySpec = PrivateKeyReader.getKeySpec(der, password);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            privateKey = kf.generatePrivate(keySpec);
        }
        catch (Exception e) {
            String msg = String.format("Failed to read PKCS#8 PEM file. file=%s", path);
            Utils.logWarning(msg, new Object[0]);
            throw new RuntimeException(msg, e);
        }
        return privateKey;
    }

    private static byte[] getDer(Path path) throws IOException {
        List<String> lines = Files.readAllLines(path);
        String base64Text = lines.subList(1, lines.size() - 1).stream().collect(Collectors.joining());
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(base64Text);
    }

    private static KeySpec getKeySpec(byte[] encodedKey, String password) throws Exception {
        PKCS8EncodedKeySpec keySpec;
        if (password == null) {
            keySpec = new PKCS8EncodedKeySpec(encodedKey);
        } else {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
            EncryptedPrivateKeyInfo privateKeyInfo = new EncryptedPrivateKeyInfo(encodedKey);
            String algorithmName = privateKeyInfo.getAlgName();
            Cipher cipher = Cipher.getInstance(algorithmName);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithmName);
            SecretKey pbeKey = secretKeyFactory.generateSecret(pbeKeySpec);
            AlgorithmParameters algParams = privateKeyInfo.getAlgParameters();
            cipher.init(2, (Key)pbeKey, algParams);
            keySpec = privateKeyInfo.getKeySpec(cipher);
        }
        return keySpec;
    }
}

