/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;

public class OperationProcessingChain {
    private Level logLevel;
    private boolean loggingEnabled;
    private Predicate<Operation> logFilter;
    private List<Filter> filters = new ArrayList<Filter>();

    public OperationProcessingContext createContext(ServiceHost host) {
        return new OperationProcessingContext(host, this);
    }

    public OperationProcessingChain setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public OperationProcessingChain toggleLogging(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        return this;
    }

    public OperationProcessingChain setLogFilter(Predicate<Operation> logFilter) {
        this.logFilter = logFilter;
        return this;
    }

    private OperationProcessingChain() {
    }

    public static OperationProcessingChain create(Filter ... filters) {
        OperationProcessingChain opProcessingChain = new OperationProcessingChain();
        for (Filter filter : filters) {
            filter.init();
            opProcessingChain.filters.add(filter);
        }
        return opProcessingChain;
    }

    public void close() {
        for (Filter filter : this.filters) {
            filter.close();
        }
        this.filters.clear();
    }

    public void processRequest(Operation op, OperationProcessingContext context, Consumer<Operation> operationConsumer) {
        context.operationConsumer = operationConsumer;
        FilterReturnCode rc = this.processRequest(op, context, 0);
        if (rc == FilterReturnCode.CONTINUE_PROCESSING) {
            operationConsumer.accept(op);
        }
    }

    public void resumeProcessingRequest(Operation op, OperationProcessingContext context, FilterReturnCode filterReturnCode, Throwable e) {
        if (this.shouldLog(op)) {
            String msg = "";
            switch (filterReturnCode) {
                case SUCCESS_STOP_PROCESSING: {
                    msg = "Operation completed";
                    break;
                }
                case FAILED_STOP_PROCESSING: {
                    msg = "Operation failed";
                    if (e == null) break;
                    msg = msg + ": " + e.getMessage();
                    break;
                }
                case CONTINUE_PROCESSING: {
                    msg = "Operation processing continued";
                    break;
                }
                case RESUME_PROCESSING: {
                    msg = "Operation processing resumed";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected FilterReturnCode: " + (Object)((Object)filterReturnCode));
                }
            }
            this.log(op, context, msg, this.logLevel);
        }
        if (filterReturnCode != FilterReturnCode.CONTINUE_PROCESSING && filterReturnCode != FilterReturnCode.RESUME_PROCESSING) {
            return;
        }
        int nextFilterStartIndex = filterReturnCode == FilterReturnCode.RESUME_PROCESSING ? context.currentFilterPosition : context.currentFilterPosition + 1;
        FilterReturnCode rc = FilterReturnCode.CONTINUE_PROCESSING;
        if (nextFilterStartIndex < this.filters.size()) {
            rc = this.processRequest(op, context, nextFilterStartIndex);
        }
        if (rc == FilterReturnCode.CONTINUE_PROCESSING) {
            context.operationConsumer.accept(op);
        }
    }

    public Filter findFilter(Predicate<Filter> tester) {
        return this.filters.stream().filter(tester).findFirst().orElse(null);
    }

    private FilterReturnCode processRequest(Operation op, OperationProcessingContext context, int startIndex) {
        boolean shouldLog = this.shouldLog(op);
        block6: for (int i = startIndex; i < this.filters.size(); ++i) {
            Filter filter = this.filters.get(i);
            context.currentFilterPosition = i;
            FilterReturnCode rc = filter.processRequest(op, context);
            String msg = shouldLog ? String.format("returned %s", new Object[]{rc}) : null;
            switch (rc) {
                case CONTINUE_PROCESSING: {
                    if (!shouldLog) continue block6;
                    this.log(op, context, msg, this.logLevel);
                    continue block6;
                }
                case SUCCESS_STOP_PROCESSING: {
                    if (shouldLog) {
                        msg = msg + ". Operation completed - stopping processing";
                        this.log(op, context, msg, this.logLevel);
                    }
                    return rc;
                }
                case FAILED_STOP_PROCESSING: {
                    if (shouldLog) {
                        msg = msg + ". Operation failed - stopping processing";
                        this.log(op, context, msg, this.logLevel);
                    }
                    return rc;
                }
                case SUSPEND_PROCESSING: {
                    if (shouldLog) {
                        msg = msg + ". Operation will be resumed asynchronously - suspend processing";
                        this.log(op, context, msg, this.logLevel);
                    }
                    if (context.suspendConsumer == null) {
                        throw new IllegalStateException(String.format("Operation %d %s has been suspended with a null suspendConsumer", new Object[]{op.getId(), op.getAction()}));
                    }
                    Consumer suspendConsumer = context.suspendConsumer;
                    context.suspendConsumer = null;
                    suspendConsumer.accept(op);
                    return rc;
                }
                default: {
                    msg = msg + ". Unexpected returned code - failing operation and stopping processing";
                    this.log(op, context, msg, Level.SEVERE);
                }
            }
        }
        return FilterReturnCode.CONTINUE_PROCESSING;
    }

    private boolean shouldLog(Operation op) {
        boolean shouldLog = this.loggingEnabled;
        if (this.logFilter != null) {
            shouldLog &= this.logFilter.test(op);
        }
        return shouldLog;
    }

    private void log(Operation op, OperationProcessingContext context, String msg, Level logLevel) {
        String hostId = context.host != null ? context.host.getId() : "";
        String path = op.getUri() != null ? op.getUri().getPath() : "";
        Filter filter = this.filters.get(context.currentFilterPosition);
        String filterName = filter != null ? filter.getClass().getSimpleName() : "";
        String logMsg = String.format("(host: %s, op %d %s %s) filter %s: %s", new Object[]{hostId, op.getId(), op.getAction(), path, filterName, msg});
        Level level = logLevel != null ? logLevel : Level.INFO;
        Utils.log(this.getClass(), op.getUri().getPath(), level, logMsg, new Object[0]);
    }

    public static interface Filter {
        public FilterReturnCode processRequest(Operation var1, OperationProcessingContext var2);

        default public void init() {
        }

        default public void close() {
        }
    }

    public static class OperationProcessingContext {
        private ServiceHost host;
        private Service service;
        private OperationProcessingChain opProcessingChain;
        private int currentFilterPosition;
        private Consumer<Operation> operationConsumer;
        private Consumer<Operation> suspendConsumer;

        private OperationProcessingContext(ServiceHost host, OperationProcessingChain opProcessingChain) {
            this.host = host;
            this.opProcessingChain = opProcessingChain;
            this.currentFilterPosition = -1;
        }

        public ServiceHost getHost() {
            return this.host;
        }

        public Service getService() {
            return this.service;
        }

        public OperationProcessingChain getOpProcessingChain() {
            return this.opProcessingChain;
        }

        public int getCurrentFilterPosition() {
            return this.currentFilterPosition;
        }

        public void setService(Service service) {
            this.service = service;
        }

        public void setSuspendConsumer(Consumer<Operation> suspendConsumer) {
            this.suspendConsumer = suspendConsumer;
        }

        public void resumeProcessingRequest(Operation op, FilterReturnCode filterReturnCode, Throwable e) {
            this.opProcessingChain.resumeProcessingRequest(op, this, filterReturnCode, e);
        }
    }

    public static enum FilterReturnCode {
        CONTINUE_PROCESSING,
        RESUME_PROCESSING,
        FAILED_STOP_PROCESSING,
        SUCCESS_STOP_PROCESSING,
        SUSPEND_PROCESSING;

    }
}

