/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.google.gson.JsonSyntaxException;
import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.ServerSentEvent;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceRequestSender;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.serialization.KryoSerializers;
import com.vmware.xenon.services.common.GuestUserService;
import com.vmware.xenon.services.common.QueryFilter;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.SystemUserService;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import javax.security.cert.X509Certificate;

public class Operation
implements Cloneable {
    private static final int TO_STRING_SERIALIZED_BODY_LIMIT = 256;
    public static final String REFERER_HEADER = "referer";
    public static final String CONNECTION_HEADER = "connection";
    public static final String CONTENT_TYPE_HEADER = "content-type";
    public static final String CONTENT_ENCODING_HEADER = "content-encoding";
    public static final String CONTENT_LENGTH_HEADER = "content-length";
    public static final String CONTENT_RANGE_HEADER = "content-range";
    public static final String RANGE_HEADER = "range";
    public static final String RETRY_AFTER_HEADER = "retry-after";
    public static final String PRAGMA_HEADER = "pragma";
    public static final String SET_COOKIE_HEADER = "set-cookie";
    public static final String COOKIE_HEADER = "cookie";
    public static final String LOCATION_HEADER = "location";
    public static final String USER_AGENT_HEADER = "user-agent";
    public static final String HOST_HEADER = "host";
    public static final String ACCEPT_HEADER = "accept";
    public static final String ACCEPT_ENCODING_HEADER = "accept-encoding";
    public static final String AUTHORIZATION_HEADER = "authorization";
    public static final String ACCEPT_LANGUAGE_HEADER = "accept-language";
    public static final String LAST_EVENT_ID_HEADER = "last-event-id";
    public static final String STREAM_ID_HEADER = "x-http2-stream-id";
    public static final String STREAM_WEIGHT_HEADER = "x-http2-stream-weight";
    public static final String HTTP2_SCHEME_HEADER = "x-http2-scheme";
    public static final String HEADER_NAME_PREFIX = "x-xenon-";
    public static final String CONTEXT_ID_HEADER = "x-xenon-ctx-id";
    public static final String REQUEST_AUTH_TOKEN_HEADER = "x-xenon-auth-token";
    public static final String REPLICATION_PHASE_HEADER = "x-xenon-rpl-phase";
    public static final String REPLICATION_QUORUM_HEADER = "x-xenon-rpl-quorum";
    public static final String REPLICATION_PARENT_HEADER = "x-xenon-rpl-parent";
    public static final String REPLICATION_QUORUM_HEADER_VALUE_ALL = "x-xenon-all";
    public static final String TRANSACTION_HEADER = "x-xenon-tx-phase";
    public static final String TRANSACTION_ID_HEADER = "x-xenon-tx-id";
    public static final String TRANSACTION_REFLINK_HEADER = "x-xenon-tx-reflink";
    public static final String PRAGMA_DIRECTIVE_CREATED = "xn-created";
    public static final String PRAGMA_DIRECTIVE_FORWARDED = "xn-fwd";
    public static final String PRAGMA_DIRECTIVE_REPLICATED = "xn-rpl";
    public static final String PRAGMA_DIRECTIVE_SYNCH_OWNER = "xn-synch-owner";
    public static final String PRAGMA_DIRECTIVE_SYNCH_PEER = "xn-synch-peer";
    public static final String PRAGMA_DIRECTIVE_QUEUE_FOR_SERVICE_AVAILABILITY = "xn-queue";
    public static final String PRAGMA_DIRECTIVE_NO_FORWARDING = "xn-no-fwd";
    public static final String PRAGMA_DIRECTIVE_NOTIFICATION = "xn-nt";
    public static final String PRAGMA_DIRECTIVE_SKIPPED_NOTIFICATIONS = "xn-nt-skipped";
    public static final String PRAGMA_DIRECTIVE_VERSION_CHECK = "xn-check-version";
    public static final String PRAGMA_DIRECTIVE_INDEX_CHECK = "xn-check-index";
    public static final String PRAGMA_DIRECTIVE_FORCE_INDEX_UPDATE = "xn-force-index-update";
    public static final String PRAGMA_DIRECTIVE_NO_INDEX_UPDATE = "xn-no-index-update";
    public static final String PRAGMA_DIRECTIVE_CLEAR_AUTH_CACHE = "xn-clear-auth-cache";
    public static final String PRAGMA_DIRECTIVE_POST_TO_PUT = "xn-post-to-put";
    public static final String PRAGMA_DIRECTIVE_AUTHENTICATE = "xn-authn";
    public static final String PRAGMA_DIRECTIVE_VERIFY_TOKEN = "xn-verify-token";
    public static final String PRAGMA_DIRECTIVE_AUTHN_INVALIDATE = "xn-authn-invalidate";
    public static final String PRAGMA_DIRECTIVE_FROM_MIGRATION_TASK = "xn-from-migration";
    public static final String PRAGMA_DIRECTIVE_STATE_NOT_MODIFIED = "xn-state-not-modified";
    public static final String TX_ENSURE_COMMIT = "ensure-commit";
    public static final String TX_COMMIT = "commit";
    public static final String TX_ABORT = "abort";
    public static final String REPLICATION_PHASE_COMMIT = "commit";
    public static final String MEDIA_TYPE_APPLICATION_JSON = "application/json";
    public static final String MEDIA_TYPE_TEXT_YAML = "text/x-yaml";
    public static final String MEDIA_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MEDIA_TYPE_APPLICATION_KRYO_OCTET_STREAM = "application/kryo-octet-stream";
    public static final String MEDIA_TYPE_APPLICATION_X_WWW_FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String MEDIA_TYPE_TEXT_HTML = "text/html";
    public static final String MEDIA_TYPE_TEXT_PLAIN = "text/plain";
    public static final String MEDIA_TYPE_TEXT_CSS = "text/css";
    public static final String MEDIA_TYPE_APPLICATION_JAVASCRIPT = "application/javascript";
    public static final String MEDIA_TYPE_IMAGE_SVG_XML = "image/svg+xml";
    public static final String MEDIA_TYPE_APPLICATION_FONT_WOFF2 = "application/font-woff2";
    public static final String MEDIA_TYPE_TEXT_EVENT_STREAM = "text/event-stream";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final int STATUS_CODE_SERVER_FAILURE_THRESHOLD = 500;
    public static final int STATUS_CODE_FAILURE_THRESHOLD = 400;
    public static final int STATUS_CODE_UNAUTHORIZED = 401;
    public static final int STATUS_CODE_UNAVAILABLE = 503;
    public static final int STATUS_CODE_FORBIDDEN = 403;
    public static final int STATUS_CODE_TIMEOUT = 408;
    public static final int STATUS_CODE_CONFLICT = 409;
    public static final int STATUS_CODE_NOT_MODIFIED = 304;
    public static final int STATUS_CODE_NOT_FOUND = 404;
    public static final int STATUS_CODE_MOVED_PERM = 301;
    public static final int STATUS_CODE_MOVED_TEMP = 302;
    public static final int STATUS_CODE_OK = 200;
    public static final int STATUS_CODE_CREATED = 201;
    public static final int STATUS_CODE_ACCEPTED = 202;
    public static final int STATUS_CODE_BAD_REQUEST = 400;
    public static final int STATUS_CODE_BAD_METHOD = 405;
    public static final int STATUS_CODE_INTERNAL_ERROR = 500;
    public static final String MEDIA_TYPE_EVERYTHING_WILDCARDS = "*/*";
    public static final String EMPTY_JSON_BODY = "{}";
    public static final String HEADER_FIELD_VALUE_SEPARATOR = ":";
    public static final String CR_LF = "\r\n";
    private static final char DIRECTIVE_PRAGMA_VALUE_SEPARATOR_CHAR_CONST = ';';
    private static final char HEADER_FIELD_VALUE_SEPARATOR_CHAR_CONST = ':';
    private static final AtomicLong idCounter = new AtomicLong();
    private static final AtomicReferenceFieldUpdater<Operation, CompletionHandler> completionUpdater = AtomicReferenceFieldUpdater.newUpdater(Operation.class, CompletionHandler.class, "completion");
    private URI uri;
    private Object referer;
    private final long id = idCounter.incrementAndGet();
    private int statusCode = 200;
    private Service.Action action;
    private ServiceDocument linkedState;
    private byte[] linkedSerializedState;
    private volatile CompletionHandler completion;
    private String contextId;
    private String transactionId;
    private long expirationMicrosUtc;
    private Object body;
    private Object serializedBody;
    private String contentType = "application/json";
    private long contentLength;
    private RemoteContext remoteCtx;
    private AuthorizationContext authorizationCtx;
    private InstrumentationContext instrumentationCtx;
    private short retryCount;
    private short retriesRemaining;
    private EnumSet<OperationOption> options = EnumSet.of(OperationOption.KEEP_ALIVE);
    private volatile Consumer<ServerSentEvent> serverSentEventHandler;
    private volatile Consumer<Operation> headersReceivedHandler;

    public static void fail(Operation request, int statusCode, int errorCode, Throwable e) {
        request.setStatusCode(statusCode);
        ServiceErrorResponse r = Utils.toServiceErrorResponse(e);
        r.statusCode = statusCode;
        r.errorCode = errorCode;
        if (e instanceof ServiceHost.ServiceNotFoundException) {
            r.stackTrace = null;
        }
        request.setContentType(MEDIA_TYPE_APPLICATION_JSON).fail(e, r);
    }

    static void failOwnerMismatch(Operation op, String id, ServiceDocument body) {
        String owner = body != null ? body.documentOwner : "";
        op.setStatusCode(409);
        IllegalStateException e = new IllegalStateException(String.format("Owner in body: %s, computed locally: %s", owner, id));
        ServiceErrorResponse rsp = ServiceErrorResponse.create(e, op.getStatusCode(), EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY));
        rsp.setInternalErrorCode(-2147483643);
        op.fail(e, rsp);
    }

    public static void failActionNotSupported(Operation request) {
        request.setStatusCode(405).fail(new IllegalStateException("Action not supported: " + (Object)((Object)request.getAction())));
    }

    public static void failLimitExceeded(Operation request, int errorCode, String queueDescription) {
        request.addResponseHeader(RETRY_AFTER_HEADER, "1");
        Operation.fail(request, 503, errorCode, new CancellationException(String.format("queue limit exceeded (%s)", queueDescription)));
    }

    public static void failForwardedRequest(Operation op, Operation fo, Throwable fe) {
        op.setStatusCode(fo.getStatusCode());
        op.setBodyNoCloning(fo.getBodyRaw()).fail(fe);
    }

    public static void failServiceNotFound(Operation inboundOp) {
        Operation.failServiceNotFound(inboundOp, Integer.MIN_VALUE);
    }

    public static void failServiceNotFound(Operation inboundOp, int errorCode, String errorMsg) {
        Operation.fail(inboundOp, 404, errorCode, new ServiceHost.ServiceNotFoundException(inboundOp.getUri().toString(), errorMsg));
    }

    public static void failServiceNotFound(Operation inboundOp, int errorCode) {
        Operation.fail(inboundOp, 404, errorCode, new ServiceHost.ServiceNotFoundException(inboundOp.getUri().toString()));
    }

    static void failServiceMarkedDeleted(String documentSelfLink, Operation serviceStartPost) {
        Operation.fail(serviceStartPost, 409, -2147483646, new IllegalStateException("Service marked deleted: " + documentSelfLink));
    }

    public static Operation create(SerializedOperation ctx, ServiceHost host) {
        Operation op = new Operation();
        op.action = ctx.action;
        op.body = ctx.jsonBody;
        op.expirationMicrosUtc = ctx.documentExpirationTimeMicros;
        op.setContextId(ctx.id.toString());
        op.referer = ctx.referer;
        op.uri = UriUtils.buildUri(host, ctx.path, ctx.query, ctx.userInfo);
        op.transactionId = ctx.transactionId;
        return op;
    }

    public Operation() {
        OperationContext opCtx = OperationContext.getOperationContextNoCloning();
        this.authorizationCtx = opCtx.authContext;
        this.transactionId = opCtx.transactionId;
        this.contextId = opCtx.contextId;
    }

    static Operation createOperation(Service.Action action, URI uri) {
        Operation op = new Operation();
        op.uri = uri;
        op.action = action;
        return op;
    }

    public static Operation createPost(Service sender, String targetPath) {
        return Operation.createPost(sender.getHost(), targetPath);
    }

    public static Operation createPost(ServiceHost sender, String targetPath) {
        return Operation.createPost(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createPost(URI uri) {
        return Operation.createOperation(Service.Action.POST, uri);
    }

    public static Operation createPatch(Service sender, String targetPath) {
        return Operation.createPatch(sender.getHost(), targetPath);
    }

    public static Operation createPatch(ServiceHost sender, String targetPath) {
        return Operation.createPatch(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createPatch(URI uri) {
        return Operation.createOperation(Service.Action.PATCH, uri);
    }

    public static Operation createPut(Service sender, String targetPath) {
        return Operation.createPut(UriUtils.buildUri(sender.getHost(), targetPath));
    }

    public static Operation createPut(ServiceHost sender, String targetPath) {
        return Operation.createPut(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createPut(URI uri) {
        return Operation.createOperation(Service.Action.PUT, uri);
    }

    public static Operation createOptions(Service sender, String targetPath) {
        return Operation.createOptions(UriUtils.buildUri(sender.getHost(), targetPath));
    }

    public static Operation createOptions(ServiceHost sender, String targetPath) {
        return Operation.createOptions(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createOptions(URI uri) {
        return Operation.createOperation(Service.Action.OPTIONS, uri);
    }

    public static Operation createDelete(Service sender, String targetPath) {
        return Operation.createDelete(UriUtils.buildUri(sender.getHost(), targetPath));
    }

    public static Operation createDelete(ServiceHost sender, String targetPath) {
        return Operation.createDelete(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createDelete(URI uri) {
        return Operation.createOperation(Service.Action.DELETE, uri);
    }

    public static Operation createGet(Service sender, String targetPath) {
        return Operation.createGet(UriUtils.buildUri(sender.getHost(), targetPath));
    }

    public static Operation createGet(ServiceHost sender, String targetPath) {
        return Operation.createGet(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createGet(URI uri) {
        return Operation.createOperation(Service.Action.GET, uri);
    }

    public void sendWith(ServiceRequestSender sender) {
        sender.sendRequest(this);
    }

    public String toString() {
        SerializedOperation sop = SerializedOperation.create(this);
        if (sop.jsonBody != null && sop.jsonBody.length() > 256) {
            sop.jsonBody = sop.jsonBody.substring(0, 256);
        }
        return Utils.toJsonHtml(sop);
    }

    public String toLogString() {
        StringBuilder sb = Utils.getBuilder();
        sb.append(this.action.toString()).append(" ").append(this.getUri()).append(" ").append(this.id).append(" ").append(this.getRefererAsString()).append(" ");
        if (this.contextId != null) {
            sb.append("[ctxId] ").append(this.contextId);
        }
        if (this.transactionId != null) {
            sb.append("[txId] ").append(this.transactionId);
        }
        if (this.authorizationCtx != null && this.authorizationCtx.claims != null) {
            sb.append("[subject] ").append(this.authorizationCtx.claims.getSubject());
        }
        return sb.toString();
    }

    public Operation clone() {
        Operation clone;
        try {
            clone = (Operation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        clone.options = EnumSet.copyOf(this.options);
        if (this.remoteCtx != null) {
            clone.remoteCtx = new RemoteContext();
            if (this.remoteCtx.cookies != null) {
                clone.remoteCtx.cookies = new HashMap<String, String>(this.remoteCtx.cookies);
            }
            clone.remoteCtx.socketCtx = null;
            if (this.remoteCtx.requestHeaders != null && !this.remoteCtx.requestHeaders.isEmpty()) {
                clone.remoteCtx.requestHeaders = new HashMap<String, String>(this.remoteCtx.requestHeaders);
            }
            clone.remoteCtx.peerPrincipal = this.remoteCtx.peerPrincipal;
            if (this.remoteCtx.peerCertificateChain != null) {
                clone.remoteCtx.peerCertificateChain = Arrays.copyOf(this.remoteCtx.peerCertificateChain, this.remoteCtx.peerCertificateChain.length);
            }
            clone.remoteCtx.connectionTag = this.remoteCtx.connectionTag;
        }
        return clone;
    }

    private void allocateRemoteContext() {
        if (this.remoteCtx == null) {
            this.remoteCtx = new RemoteContext();
        }
    }

    private void allocateRequestHeaders() {
        if (this.remoteCtx.requestHeaders == null) {
            this.remoteCtx.requestHeaders = new HashMap<String, String>();
        }
    }

    private void allocateResponseHeaders() {
        if (this.remoteCtx.responseHeaders == null) {
            this.remoteCtx.responseHeaders = new HashMap<String, String>();
        }
    }

    public boolean isRemote() {
        return this.options.contains((Object)OperationOption.REMOTE) || this.remoteCtx != null && this.remoteCtx.socketCtx != null;
    }

    public Operation forceRemote() {
        return this.toggleOption(OperationOption.REMOTE, true);
    }

    public AuthorizationContext getAuthorizationContext() {
        return this.authorizationCtx;
    }

    public Operation setAuthorizationContext(AuthorizationContext ctx) {
        this.authorizationCtx = ctx;
        return this;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Operation setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public boolean isWithinTransaction() {
        return this.transactionId != null;
    }

    public String getContextId() {
        return this.contextId;
    }

    public Operation setContextId(String id) {
        this.contextId = id;
        return this;
    }

    public Operation setBody(Object body) {
        this.body = body != null ? (this.hasOption(OperationOption.CLONING_DISABLED) ? body : Utils.clone(body)) : null;
        return this;
    }

    public Operation setStatusCode(int code) {
        this.statusCode = code;
        return this;
    }

    public Operation setBodyNoCloning(Object body) {
        this.body = body;
        return this;
    }

    public ServiceErrorResponse getErrorResponseBody() {
        if (!this.hasBody()) {
            return null;
        }
        ServiceErrorResponse rsp = this.getBody(ServiceErrorResponse.class);
        if (rsp.message == null && rsp.statusCode == 0) {
            return null;
        }
        return rsp;
    }

    public <T> T getBody(Class<T> type) {
        if (this.body != null && this.body.getClass() == type) {
            return (T)this.body;
        }
        if (this.body != null && !(this.body instanceof String)) {
            if (this.contentType != null && Utils.isContentTypeKryoBinary(this.contentType) && this.body instanceof byte[]) {
                byte[] bytes = (byte[])this.body;
                this.body = KryoSerializers.deserializeDocument(bytes, 0, bytes.length);
                this.serializedBody = Utils.toJson(this.body);
                return (T)this.body;
            }
            if (this.contentType == null || !this.contentType.contains(MEDIA_TYPE_APPLICATION_JSON)) {
                throw new IllegalStateException("content type is not JSON: " + this.contentType);
            }
            if (this.serializedBody != null) {
                this.body = this.serializedBody;
            } else {
                String json = Utils.toJson(this.body);
                return Utils.fromJson(json, type);
            }
        }
        if (this.body != null) {
            if (this.body instanceof String) {
                this.serializedBody = this.body;
            }
            if (this.contentType != null && this.contentType.contains(MEDIA_TYPE_APPLICATION_JSON)) {
                try {
                    this.body = Utils.fromJson(this.body, type);
                }
                catch (JsonSyntaxException e) {
                    throw new IllegalArgumentException("Unparseable JSON body: " + e.getMessage(), e);
                }
            } else {
                throw new IllegalArgumentException("Unrecognized Content-Type for parsing request body: " + this.contentType);
            }
            return (T)this.body;
        }
        throw new IllegalStateException();
    }

    public Object getBodyRaw() {
        return this.body;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Operation setContentLength(long l) {
        this.contentLength = l;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Operation setContentType(String type) {
        this.contentType = type;
        return this;
    }

    public Operation setCookies(Map<String, String> cookies) {
        this.allocateRemoteContext();
        this.remoteCtx.cookies = cookies;
        return this;
    }

    public Map<String, String> getCookies() {
        if (this.remoteCtx == null) {
            return null;
        }
        return this.remoteCtx.cookies;
    }

    public int getRetriesRemaining() {
        return this.retriesRemaining;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int incrementRetryCount() {
        this.retryCount = (short)(this.retryCount + 1);
        return this.retryCount;
    }

    public Operation setRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("retryCount must be positive");
        }
        if (retryCount > Short.MAX_VALUE) {
            throw new IllegalArgumentException("retryCount must be less than 32767");
        }
        this.retryCount = (short)retryCount;
        this.retriesRemaining = (short)retryCount;
        return this;
    }

    public Operation setCompletion(CompletionHandler completion) {
        this.completion = completion;
        return this;
    }

    public Operation setCompletion(Consumer<Operation> successHandler, CompletionHandler failureHandler) {
        this.completion = (op, e) -> {
            if (e != null) {
                failureHandler.handle(op, e);
                return;
            }
            successHandler.accept(op);
        };
        return this;
    }

    public Operation setServerSentEventHandler(Consumer<ServerSentEvent> serverSentEventHandler) {
        this.serverSentEventHandler = serverSentEventHandler;
        return this;
    }

    public Operation nestServerSentEventHandler(Consumer<ServerSentEvent> serverSentEventHandler) {
        if (this.serverSentEventHandler != null) {
            serverSentEventHandler = serverSentEventHandler.andThen(this.serverSentEventHandler);
        }
        return this.setServerSentEventHandler(serverSentEventHandler);
    }

    public Operation setHeadersReceivedHandler(Consumer<Operation> handler) {
        this.headersReceivedHandler = handler;
        return this;
    }

    public Operation nestHeadersReceivedHandler(Consumer<Operation> handler) {
        if (this.headersReceivedHandler != null) {
            handler = handler.andThen(this.headersReceivedHandler);
        }
        return this.setHeadersReceivedHandler(handler);
    }

    public CompletionHandler getCompletion() {
        return this.completion;
    }

    public Operation setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    Operation linkState(ServiceDocument serviceDoc) {
        if (serviceDoc != null && this.linkedState != null && this.linkedState.documentKind != null) {
            serviceDoc.documentKind = this.linkedState.documentKind;
        }
        this.linkedState = serviceDoc;
        return this;
    }

    ServiceDocument getLinkedState() {
        return this.linkedState;
    }

    byte[] getLinkedSerializedState() {
        return this.linkedSerializedState;
    }

    boolean hasLinkedSerializedState() {
        return this.linkedSerializedState != null;
    }

    public Operation setReferer(URI uri) {
        this.referer = uri;
        return this;
    }

    public Operation setReferer(String uri) {
        this.referer = uri;
        return this;
    }

    public Operation transferRefererFrom(Operation op) {
        this.referer = op.referer;
        return this;
    }

    public boolean hasReferer() {
        return this.referer != null;
    }

    public URI getReferer() {
        if (this.referer instanceof String) {
            try {
                this.referer = new URI((String)this.referer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (URI)this.referer;
    }

    public String getRefererAsString() {
        if (this.referer == null) {
            return null;
        }
        return this.referer.toString();
    }

    public Operation setAction(Service.Action action) {
        this.action = action;
        return this;
    }

    public Service.Action getAction() {
        return this.action;
    }

    public long getId() {
        return this.id;
    }

    public Operation setSocketContext(SocketContext socketContext) {
        this.allocateRemoteContext();
        this.remoteCtx.socketCtx = socketContext;
        return this;
    }

    public SocketContext getSocketContext() {
        return this.remoteCtx == null ? null : this.remoteCtx.socketCtx;
    }

    public long getExpirationMicrosUtc() {
        return this.expirationMicrosUtc;
    }

    public Operation setExpiration(long futureMicrosUtc) {
        this.expirationMicrosUtc = futureMicrosUtc;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void complete() {
        this.completeOrFail(null);
    }

    public void fail(Throwable e) {
        this.fail(e, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendServerSentEvent(ServerSentEvent event) {
        if (this.serverSentEventHandler == null) {
            return;
        }
        OperationContext originalContext = OperationContext.getOperationContext();
        try {
            OperationContext.setFrom(this);
            this.serverSentEventHandler.accept(event);
        }
        catch (Exception outer) {
            Utils.logWarning("Uncaught failure inside serverSentEventHandler: %s", Utils.toString(outer));
        }
        finally {
            OperationContext.setFrom(originalContext);
        }
    }

    public void sendHeaders() {
        if (this.headersReceivedHandler == null) {
            return;
        }
        OperationContext originalContext = OperationContext.getOperationContext();
        try {
            OperationContext.setFrom(this);
            this.headersReceivedHandler.accept(this);
        }
        catch (Exception outer) {
            Utils.logWarning("Uncaught failure inside headersReceivedHandler: %s", Utils.toString(outer));
        }
        finally {
            OperationContext.setFrom(originalContext);
        }
    }

    public void startEventStream() {
        this.setContentType(MEDIA_TYPE_TEXT_EVENT_STREAM);
        this.sendHeaders();
    }

    public void fail(int statusCode) {
        this.setStatusCode(statusCode);
        switch (statusCode) {
            case 403: {
                this.fail(new IllegalAccessError("forbidden"));
                break;
            }
            case 408: {
                this.fail(new TimeoutException());
                break;
            }
            default: {
                this.fail(new Exception("request failed with " + statusCode + ", no additional details provided"));
            }
        }
    }

    public void fail(int statusCode, Throwable e, Object failureBody) {
        this.statusCode = statusCode;
        this.fail(e, failureBody);
    }

    public void fail(Throwable e, Object failureBody) {
        ServiceErrorResponse rsp;
        if (this.statusCode < 400) {
            this.statusCode = 500;
        }
        if (e instanceof TimeoutException) {
            this.statusCode = 408;
        }
        if (failureBody != null) {
            this.setBodyNoCloning(failureBody);
        }
        boolean hasErrorResponseBody = false;
        if (this.body != null && this.body instanceof String) {
            if (MEDIA_TYPE_APPLICATION_JSON.equals(this.contentType)) {
                try {
                    rsp = Utils.fromJson(this.body, ServiceErrorResponse.class);
                    if (rsp.message != null) {
                        hasErrorResponseBody = true;
                    }
                }
                catch (Exception rsp2) {}
            } else {
                hasErrorResponseBody = true;
            }
        }
        if (this.body != null && this.body instanceof byte[]) {
            hasErrorResponseBody = true;
        }
        if (this.body == null || !hasErrorResponseBody && !(this.body instanceof ServiceErrorResponse)) {
            if (Utils.isValidationError(e)) {
                this.statusCode = 400;
                rsp = Utils.toValidationErrorResponse(e, this);
            } else {
                rsp = Utils.toServiceErrorResponse(e);
            }
            rsp.statusCode = this.statusCode;
            this.setBodyNoCloning(rsp).setContentType(MEDIA_TYPE_APPLICATION_JSON);
        }
        this.completeOrFail(e);
    }

    private void completeOrFail(Throwable e) {
        CompletionHandler c = this.completion;
        if (c == null) {
            return;
        }
        if (!completionUpdater.compareAndSet(this, c, null)) {
            Utils.logWarning("%s:%s", Utils.toString(new IllegalStateException("double completion")), this.toString());
            return;
        }
        OperationContext originalContext = OperationContext.getOperationContext();
        try {
            OperationContext.setFrom(this);
            c.handle(this, e);
        }
        catch (Exception outer) {
            Utils.logWarning("Uncaught failure inside completion: %s", Utils.toString(outer));
        }
        OperationContext.setFrom(originalContext);
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public Operation nestCompletion(CompletionHandler h) {
        CompletionHandler existing = this.completion;
        this.completion = (o, e) -> {
            this.statusCode = o.statusCode;
            this.completion = existing;
            h.handle(o, e);
        };
        return this;
    }

    public void nestCompletion(Consumer<Operation> successHandler) {
        CompletionHandler existing = this.completion;
        this.completion = (o, e) -> {
            this.statusCode = o.statusCode;
            this.completion = existing;
            if (e != null) {
                this.fail(e);
                return;
            }
            try {
                successHandler.accept(o);
            }
            catch (Exception ex) {
                this.fail(ex);
            }
        };
    }

    public Operation appendCompletion(CompletionHandler h) {
        CompletionHandler existing = this.completion;
        this.completion = existing == null ? h : (o, e) -> {
            o.nestCompletion(h);
            existing.handle(o, e);
        };
        return this;
    }

    Operation addHeader(String headerLine, boolean isResponse) {
        if (headerLine == null) {
            throw new IllegalArgumentException("headerLine is required");
        }
        int idx = headerLine.indexOf(58);
        if (idx < 3) {
            throw new IllegalArgumentException("headerLine does not appear valid");
        }
        String name = headerLine.substring(0, idx);
        String value = headerLine.substring(idx + 1);
        if (isResponse) {
            this.addResponseHeader(name, value);
        } else {
            this.addRequestHeader(name, value);
        }
        return this;
    }

    public Operation addRequestHeader(String name, String value) {
        return this.addRequestHeader(name, value, true);
    }

    private Operation addRequestHeader(String name, String value, boolean normalize) {
        this.allocateRemoteContext();
        this.allocateRequestHeaders();
        if (normalize) {
            value = this.removeString(value, CR_LF).trim();
            name = name.toLowerCase();
        }
        this.remoteCtx.requestHeaders.put(name, value);
        return this;
    }

    public Operation addResponseHeader(String name, String value) {
        this.allocateRemoteContext();
        this.allocateResponseHeaders();
        value = this.removeString(value, CR_LF).trim();
        this.remoteCtx.responseHeaders.put(name.toLowerCase(), value);
        return this;
    }

    public Operation addResponseCookie(String key, String value) {
        this.addResponseHeader(SET_COOKIE_HEADER, key + '=' + value);
        return this;
    }

    private String removeString(String value, String delete) {
        int i = 0;
        while ((i = value.indexOf(delete, i)) != -1) {
            if (i == 0) {
                value = value.substring(i + delete.length());
                continue;
            }
            if (i + delete.length() == value.length()) {
                value = value.substring(0, i);
                continue;
            }
            value = value.substring(0, i) + value.substring(i + delete.length());
        }
        return value;
    }

    public Operation addPragmaDirective(String directive) {
        String existingDirectives = this.getRequestHeader(PRAGMA_HEADER, false);
        if (existingDirectives != null) {
            if (this.indexOfPragmaDirective(existingDirectives, directive) != -1) {
                return this;
            }
            directive = existingDirectives + ';' + directive;
        }
        directive = this.removeString(directive, CR_LF).trim();
        this.addRequestHeader(PRAGMA_HEADER, directive, false);
        return this;
    }

    public boolean hasPragmaDirective(String directive) {
        String existingDirectives = this.getRequestHeaderAsIs(PRAGMA_HEADER);
        return existingDirectives != null && this.indexOfPragmaDirective(existingDirectives, directive) != -1;
    }

    public boolean hasAnyPragmaDirective(List<String> directives) {
        String existingDirectives = this.getRequestHeaderAsIs(PRAGMA_HEADER);
        if (existingDirectives == null) {
            return false;
        }
        for (String directive : directives) {
            if (this.indexOfPragmaDirective(existingDirectives, directive) == -1) continue;
            return true;
        }
        return false;
    }

    public Operation removePragmaDirective(String directive) {
        String existingDirectives = this.getRequestHeaderAsIs(PRAGMA_HEADER);
        if (existingDirectives != null) {
            int i = this.indexOfPragmaDirective(existingDirectives, directive);
            if (i == -1) {
                return this;
            }
            existingDirectives = i == 0 ? existingDirectives.substring(i + directive.length()) : existingDirectives.substring(0, i - 1) + existingDirectives.substring(i + directive.length());
            this.addRequestHeader(PRAGMA_HEADER, existingDirectives, false);
        }
        return this;
    }

    int indexOfPragmaDirective(String existingDirectives, String directive) {
        int i = 0;
        while ((i = existingDirectives.indexOf(directive, i)) != -1) {
            if (i + directive.length() == existingDirectives.length() || existingDirectives.charAt(i + directive.length()) == ';') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isKeepAlive() {
        return this.remoteCtx != null && this.hasOption(OperationOption.KEEP_ALIVE);
    }

    public Operation setKeepAlive(boolean isKeepAlive) {
        this.allocateRemoteContext();
        this.toggleOption(OperationOption.KEEP_ALIVE, isKeepAlive);
        return this;
    }

    public Operation setConnectionTag(String tag) {
        this.allocateRemoteContext();
        this.remoteCtx.connectionTag = tag;
        return this;
    }

    public String getConnectionTag() {
        return this.remoteCtx == null ? null : this.remoteCtx.connectionTag;
    }

    public Operation toggleOption(OperationOption option, boolean enable) {
        if (enable) {
            this.options.add(option);
        } else {
            this.options.remove((Object)option);
        }
        return this;
    }

    public boolean hasOption(OperationOption option) {
        return this.options.contains((Object)option);
    }

    public EnumSet<OperationOption> getOptions() {
        return EnumSet.copyOf(this.options);
    }

    void setHandlerInvokeTime(long nowMicros) {
        this.allocateInstrumentationContext();
        this.instrumentationCtx.handleInvokeTimeMicros = nowMicros;
    }

    void setEnqueueTime(long nowMicros) {
        this.allocateInstrumentationContext();
        this.instrumentationCtx.enqueueTimeMicros = nowMicros;
    }

    void setHandlerCompletionTime(long nowMicros) {
        this.allocateInstrumentationContext();
        this.instrumentationCtx.handlerCompletionTimeMicros = nowMicros;
    }

    void setDocumentStoreCompletionTime(long nowMicros) {
        this.allocateInstrumentationContext();
        this.instrumentationCtx.documentStoreCompletionTimeMicros = nowMicros;
    }

    void setCompletionTime(long nowMicros) {
        this.allocateInstrumentationContext();
        this.instrumentationCtx.operationCompletionTimeMicros = nowMicros;
    }

    private void allocateInstrumentationContext() {
        if (this.instrumentationCtx != null) {
            return;
        }
        this.instrumentationCtx = new InstrumentationContext();
    }

    InstrumentationContext getInstrumentationContext() {
        return this.instrumentationCtx;
    }

    public Operation disableFailureLogging(boolean disable) {
        this.toggleOption(OperationOption.FAILURE_LOGGING_DISABLED, disable);
        return this;
    }

    public boolean isFailureLoggingDisabled() {
        return this.hasOption(OperationOption.FAILURE_LOGGING_DISABLED);
    }

    public Operation setReplicationDisabled(boolean disable) {
        this.toggleOption(OperationOption.REPLICATION_DISABLED, disable);
        return this;
    }

    public boolean isReplicationDisabled() {
        return this.hasOption(OperationOption.REPLICATION_DISABLED);
    }

    public Map<String, String> getRequestHeaders() {
        this.allocateRemoteContext();
        this.allocateRequestHeaders();
        return this.remoteCtx.requestHeaders;
    }

    public Map<String, String> getResponseHeaders() {
        this.allocateRemoteContext();
        this.allocateResponseHeaders();
        return this.remoteCtx.responseHeaders;
    }

    public boolean hasResponseHeaders() {
        return this.remoteCtx != null && this.remoteCtx.responseHeaders != null && !this.remoteCtx.responseHeaders.isEmpty();
    }

    public boolean hasRequestHeaders() {
        return this.remoteCtx != null && this.remoteCtx.requestHeaders != null && !this.remoteCtx.requestHeaders.isEmpty();
    }

    public String getRequestHeader(String headerName) {
        return this.getRequestHeader(headerName, true);
    }

    public String getRequestHeaderAsIs(String headerName) {
        return this.getRequestHeader(headerName, false);
    }

    public String getAndRemoveRequestHeaderAsIs(String headerName) {
        if (!this.hasRequestHeaders()) {
            return null;
        }
        return this.remoteCtx.requestHeaders.remove(headerName);
    }

    private String getRequestHeader(String headerName, boolean normalize) {
        if (!this.hasRequestHeaders()) {
            return null;
        }
        String value = this.remoteCtx.requestHeaders.get(headerName);
        if (!normalize) {
            return value;
        }
        if (value == null && (value = this.remoteCtx.requestHeaders.get(headerName.toLowerCase())) == null) {
            return null;
        }
        return this.removeString(value.trim(), CR_LF);
    }

    public String getResponseHeader(String headerName) {
        return this.getResponseHeader(headerName, true);
    }

    public String getResponseHeaderAsIs(String headerName) {
        return this.getResponseHeader(headerName, false);
    }

    public String getAndRemoveResponseHeaderAsIs(String headerName) {
        if (!this.hasResponseHeaders()) {
            return null;
        }
        return this.remoteCtx.responseHeaders.remove(headerName);
    }

    private String getResponseHeader(String headerName, boolean normalize) {
        if (!this.hasResponseHeaders()) {
            return null;
        }
        String value = this.remoteCtx.responseHeaders.get(headerName);
        if (!normalize) {
            return value;
        }
        if (value == null && (value = this.remoteCtx.responseHeaders.get(headerName.toLowerCase())) == null) {
            return null;
        }
        return this.removeString(value.trim(), CR_LF);
    }

    public Principal getPeerPrincipal() {
        return this.remoteCtx == null ? null : this.remoteCtx.peerPrincipal;
    }

    public X509Certificate[] getPeerCertificateChain() {
        return this.remoteCtx == null ? null : this.remoteCtx.peerCertificateChain;
    }

    public void setPeerCertificates(Principal peerPrincipal, X509Certificate[] certificates) {
        if (this.remoteCtx != null) {
            this.remoteCtx.peerPrincipal = peerPrincipal;
            this.remoteCtx.peerCertificateChain = certificates;
        }
    }

    public int decrementRetriesRemaining() {
        this.retriesRemaining = (short)(this.retriesRemaining - 1);
        return this.retriesRemaining;
    }

    public boolean isTargetReplicated() {
        return this.hasOption(OperationOption.REPLICATED_TARGET);
    }

    public Operation setFromReplication(boolean isFromReplication) {
        this.toggleOption(OperationOption.REPLICATED, isFromReplication);
        return this;
    }

    public boolean isFromReplication() {
        return this.hasOption(OperationOption.REPLICATED);
    }

    public Operation setConnectionSharing(boolean enable) {
        this.toggleOption(OperationOption.CONNECTION_SHARING, enable);
        return this;
    }

    public boolean isConnectionSharing() {
        return this.hasOption(OperationOption.CONNECTION_SHARING);
    }

    public boolean isForwarded() {
        return this.hasOption(OperationOption.FORWARDED);
    }

    public Operation transferResponseHeadersFrom(Operation op) {
        if (!op.hasResponseHeaders()) {
            return this;
        }
        this.allocateRemoteContext();
        this.allocateResponseHeaders();
        this.remoteCtx.responseHeaders.putAll(op.getResponseHeaders());
        return this;
    }

    public Operation transferRequestHeadersFrom(Operation op) {
        if (!op.hasRequestHeaders()) {
            return this;
        }
        this.allocateRemoteContext();
        this.allocateRequestHeaders();
        this.remoteCtx.requestHeaders.putAll(op.getRequestHeaders());
        return this;
    }

    public Operation transferResponseHeadersToRequestHeadersFrom(Operation op) {
        if (!op.hasResponseHeaders()) {
            return this;
        }
        this.allocateRemoteContext();
        this.allocateRequestHeaders();
        this.remoteCtx.requestHeaders.putAll(op.getResponseHeaders());
        return this;
    }

    public Operation transferRequestHeadersToResponseHeadersFrom(Operation op) {
        if (!op.hasRequestHeaders()) {
            return this;
        }
        this.allocateRemoteContext();
        this.allocateResponseHeaders();
        this.remoteCtx.responseHeaders.putAll(op.getRequestHeaders());
        return this;
    }

    public boolean isNotification() {
        return this.hasPragmaDirective(PRAGMA_DIRECTIVE_NOTIFICATION);
    }

    public Operation setNotificationDisabled(boolean disable) {
        this.toggleOption(OperationOption.NOTIFICATION_DISABLED, disable);
        return this;
    }

    public boolean isNotificationDisabled() {
        return this.hasOption(OperationOption.NOTIFICATION_DISABLED);
    }

    public boolean isForwardingDisabled() {
        return this.hasPragmaDirective(PRAGMA_DIRECTIVE_NO_FORWARDING);
    }

    public boolean isCommit() {
        String phase = this.getRequestHeader(REPLICATION_PHASE_HEADER, false);
        return "commit".equals(phase);
    }

    public boolean isSynchronize() {
        return this.isSynchronizeOwner() || this.isSynchronizePeer();
    }

    public boolean isSynchronizeOwner() {
        return this.hasPragmaDirective(PRAGMA_DIRECTIVE_SYNCH_OWNER);
    }

    public boolean isSynchronizePeer() {
        return this.hasPragmaDirective(PRAGMA_DIRECTIVE_SYNCH_PEER);
    }

    public boolean isUpdate() {
        return this.getAction() == Service.Action.PUT || this.getAction() == Service.Action.PATCH;
    }

    void linkSerializedState(byte[] data) {
        this.linkedSerializedState = data;
    }

    public static class SerializedOperation
    extends ServiceDocument {
        public Service.Action action;
        public String host;
        public int port;
        public String path;
        public String query;
        public Long id;
        public URI referer;
        public String jsonBody;
        public int statusCode;
        public EnumSet<OperationOption> options;
        public String contextId;
        public String transactionId;
        public String userInfo;
        public static final ServiceDocumentDescription DESCRIPTION = SerializedOperation.buildDescription();
        public static final String KIND = Utils.buildKind(SerializedOperation.class);

        public static SerializedOperation create(Operation op) {
            Object body;
            SerializedOperation ctx = new SerializedOperation();
            ctx.contextId = op.getContextId();
            ctx.action = op.action;
            ctx.referer = op.getReferer();
            ctx.id = op.id;
            ctx.statusCode = op.statusCode;
            ctx.options = op.options.clone();
            ctx.transactionId = op.getTransactionId();
            if (op.uri != null) {
                ctx.host = op.uri.getHost();
                ctx.port = op.uri.getPort();
                ctx.path = op.uri.getPath();
                ctx.query = op.uri.getQuery();
                ctx.userInfo = op.uri.getUserInfo();
            }
            ctx.jsonBody = (body = op.getBodyRaw()) instanceof String ? (String)body : Utils.toJson(body);
            ctx.documentKind = KIND;
            ctx.documentExpirationTimeMicros = op.expirationMicrosUtc;
            return ctx;
        }

        public static boolean isValid(SerializedOperation sop) {
            return sop.action != null && sop.id != null && sop.jsonBody != null && sop.path != null && sop.referer != null;
        }

        public static ServiceDocumentDescription buildDescription() {
            EnumSet<Service.ServiceOption> options = EnumSet.of(Service.ServiceOption.PERSISTENCE);
            return ServiceDocumentDescription.Builder.create().buildDescription(SerializedOperation.class, options);
        }
    }

    public static enum OperationOption {
        CONNECTION_SHARING,
        KEEP_ALIVE,
        REPLICATED,
        FORWARDED,
        REPLICATION_DISABLED,
        CLONING_DISABLED,
        NOTIFICATION_DISABLED,
        REPLICATED_TARGET,
        FAILURE_LOGGING_DISABLED,
        REMOTE,
        RATE_LIMITED,
        SOCKET_ACTIVE;

    }

    public static final class AuthorizationContext {
        private Claims claims;
        private String token;
        private boolean propagateToClient = false;
        private Map<Service.Action, QueryTask.Query> resourceQueryMap = null;
        private Map<Service.Action, QueryFilter> resourceQueryFiltersMap = null;

        public Claims getClaims() {
            return this.claims;
        }

        public String getToken() {
            return this.token;
        }

        public boolean shouldPropagateToClient() {
            return this.propagateToClient;
        }

        public QueryTask.Query getResourceQuery(Service.Action action) {
            if (this.resourceQueryMap == null) {
                return null;
            }
            return Utils.clone(this.resourceQueryMap.get((Object)action));
        }

        public QueryFilter getResourceQueryFilter(Service.Action action) {
            if (this.resourceQueryFiltersMap == null) {
                return null;
            }
            return this.resourceQueryFiltersMap.get((Object)action);
        }

        public boolean isSystemUser() {
            return this.isUserSubject(SystemUserService.SELF_LINK);
        }

        public boolean isGuestUser() {
            return this.isUserSubject(GuestUserService.SELF_LINK);
        }

        private boolean isUserSubject(String userLink) {
            Claims claims = this.getClaims();
            if (claims == null) {
                return false;
            }
            String subject = claims.getSubject();
            if (subject == null) {
                return false;
            }
            return subject.equals(userLink);
        }

        public static class Builder {
            private AuthorizationContext authorizationContext;

            public static Builder create() {
                return new Builder();
            }

            private Builder() {
                this.initialize();
            }

            protected void initialize() {
                this.authorizationContext = new AuthorizationContext();
            }

            public AuthorizationContext getResult() {
                AuthorizationContext result = this.authorizationContext;
                this.initialize();
                return result;
            }

            public Builder setClaims(Claims claims) {
                this.authorizationContext.claims = claims;
                return this;
            }

            public Builder setToken(String token) {
                this.authorizationContext.token = token;
                return this;
            }

            public Builder setPropagateToClient(boolean propagateToClient) {
                this.authorizationContext.propagateToClient = propagateToClient;
                return this;
            }

            public Builder setResourceQueryMap(Map<Service.Action, QueryTask.Query> resourceQueryMap) {
                this.authorizationContext.resourceQueryMap = resourceQueryMap;
                return this;
            }

            public Builder setResourceQueryFilterMap(Map<Service.Action, QueryFilter> resourceQueryFiltersMap) {
                this.authorizationContext.resourceQueryFiltersMap = resourceQueryFiltersMap;
                return this;
            }
        }
    }

    static class RemoteContext {
        SocketContext socketCtx;
        Map<String, String> requestHeaders;
        Map<String, String> responseHeaders;
        Principal peerPrincipal;
        X509Certificate[] peerCertificateChain;
        String connectionTag;
        Map<String, String> cookies;

        RemoteContext() {
        }
    }

    public static class TransactionContext {
        public Service.Action action;
        public Set<String> coordinatorLinks;
        public boolean isSuccessful;
    }

    static class InstrumentationContext {
        long handleInvokeTimeMicros;
        long enqueueTimeMicros;
        long documentStoreCompletionTimeMicros;
        long handlerCompletionTimeMicros;
        long operationCompletionTimeMicros;

        InstrumentationContext() {
        }
    }

    public static class SocketContext {
        private long lastUseTimeMicros;

        public long getLastUseTimeMicros() {
            return this.lastUseTimeMicros;
        }

        public void updateLastUseTime() {
            this.lastUseTimeMicros = Utils.getSystemNowMicrosUtc();
        }

        public void writeHttpRequest(Object request) {
            throw new IllegalStateException();
        }

        public void close() {
            throw new IllegalStateException();
        }
    }

    @FunctionalInterface
    public static interface CompletionHandler {
        public void handle(Operation var1, Throwable var2);
    }
}

