/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.LocalizableValidationException;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.SupportedLocales;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class LocalizationUtil {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String MESSAGES_BASE_FILENAME = "i18n/messages";

    private LocalizationUtil() {
    }

    public static String resolveMessage(LocalizableValidationException e, Operation op) {
        Locale requested;
        if (op == null) {
            Logger.getAnonymousLogger().fine("Request not provided for localization, using default locale.");
            requested = DEFAULT_LOCALE;
        } else {
            requested = LocalizationUtil.resolveLocale(op);
        }
        return LocalizationUtil.resolveMessage(e, requested);
    }

    private static String resolveMessage(LocalizableValidationException e, Locale locale) {
        String message;
        if (locale == null) {
            Logger.getAnonymousLogger().fine("Locale not provided for localization, using default locale.");
            locale = DEFAULT_LOCALE;
        }
        ResourceBundle messages = ResourceBundle.getBundle(MESSAGES_BASE_FILENAME, locale);
        try {
            message = messages.getString(e.getErrorMessageCode());
        }
        catch (MissingResourceException ex) {
            message = e.getMessage();
        }
        MessageFormat f = new MessageFormat(message, locale);
        message = f.format(e.getArguments());
        return message;
    }

    public static Locale resolveLocale(Operation op) {
        String requestedLangs = op.getRequestHeader("accept-language");
        if (requestedLangs == null) {
            return DEFAULT_LOCALE;
        }
        List locales = Locale.LanguageRange.parse(requestedLangs).stream().map(range -> Locale.forLanguageTag(range.getRange())).collect(Collectors.toList());
        for (Locale locale : locales) {
            if (!SupportedLocales.isSupported(locale)) continue;
            return locale;
        }
        return DEFAULT_LOCALE;
    }
}

