/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import java.util.EnumSet;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;

public class ForwardRequestFilter
implements OperationProcessingChain.Filter {
    @Override
    public OperationProcessingChain.FilterReturnCode processRequest(Operation op, OperationProcessingChain.OperationProcessingContext context) {
        if (op.isFromReplication() || op.isForwarded() || op.isForwardingDisabled()) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        if (op.getAction() == Service.Action.DELETE && op.hasPragmaDirective("xn-no-index-update")) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        String servicePath = op.getUri().getPath();
        if (servicePath == null) {
            Operation.failServiceNotFound(op);
            return OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING;
        }
        Service service = context.getHost().findService(servicePath, false);
        Service parent = null;
        EnumSet<Service.ServiceOption> options = null;
        if (service != null) {
            context.setService(service);
            options = service.getOptions();
            if (options != null && options.contains((Object)Service.ServiceOption.UTILITY)) {
                servicePath = UriUtils.getParentPath(servicePath);
                parent = context.getHost().findService(servicePath, true);
                if (parent != null) {
                    options = parent.getOptions();
                }
            }
        } else {
            String factoryPath;
            if (ServiceHost.isHelperServicePath(servicePath)) {
                servicePath = UriUtils.getParentPath(servicePath);
            }
            if ((factoryPath = UriUtils.getParentPath(servicePath)) != null && (parent = context.getHost().findService(factoryPath, true)) != null) {
                options = parent.getOptions();
                if (parent instanceof FactoryService) {
                    FactoryService factory = (FactoryService)parent;
                    if (factory.hasChildOption(Service.ServiceOption.OWNER_SELECTION)) {
                        options.add(Service.ServiceOption.OWNER_SELECTION);
                    }
                    if (factory.hasChildOption(Service.ServiceOption.REPLICATION)) {
                        options.add(Service.ServiceOption.REPLICATION);
                    }
                    if (factory.hasChildOption(Service.ServiceOption.PERSISTENCE)) {
                        options.add(Service.ServiceOption.PERSISTENCE);
                    }
                }
            }
        }
        if (options == null) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        if (service != null && (!options.contains((Object)Service.ServiceOption.OWNER_SELECTION) || options.contains((Object)Service.ServiceOption.FACTORY))) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        if (!(service != null || options.contains((Object)Service.ServiceOption.FACTORY) && (options.contains((Object)Service.ServiceOption.REPLICATION) || options.contains((Object)Service.ServiceOption.OWNER_SELECTION)))) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        String finalServicePath = servicePath;
        Service finalParent = parent;
        context.setSuspendConsumer(o -> this.selectAndForwardRequestToOwner(service, finalServicePath, op, finalParent, context));
        return OperationProcessingChain.FilterReturnCode.SUSPEND_PROCESSING;
    }

    private void selectAndForwardRequestToOwner(Service s, String path, Operation op, Service parent, OperationProcessingChain.OperationProcessingContext context) {
        String nodeSelectorPath = parent != null ? parent.getPeerNodeSelectorPath() : s.getPeerNodeSelectorPath();
        ServiceHost host = context.getHost();
        Operation.CompletionHandler ch = (o, e) -> {
            if (e != null) {
                host.log(Level.SEVERE, "Owner selection failed for service %s, op %d. Error: %s", op.getUri().getPath(), op.getId(), e.toString());
                context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, e);
                op.setRetryCount(0).fail(e);
                return;
            }
            NodeSelectorService.SelectOwnerResponse rsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            if (rsp.isLocalHostOwner) {
                context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING, null);
            } else {
                this.forwardRequestToOwner(op, rsp, context);
            }
        };
        Operation selectOwnerOp = Operation.createPost(null).setExpiration(op.getExpirationMicrosUtc()).setCompletion(ch);
        host.selectOwner(nodeSelectorPath, path, selectOwnerOp);
    }

    private void forwardRequestToOwner(Operation op, NodeSelectorService.SelectOwnerResponse rsp, OperationProcessingChain.OperationProcessingContext context) {
        Operation.CompletionHandler fc = (fo, fe) -> {
            if (fe != null) {
                this.retryOrFailRequest(op, fo, fe, context);
                return;
            }
            op.setStatusCode(fo.getStatusCode());
            op.setBodyNoCloning(fo.getBodyRaw());
            op.setContentType(fo.getContentType());
            op.setContentLength(fo.getContentLength());
            op.transferResponseHeadersFrom(fo);
            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.SUCCESS_STOP_PROCESSING, null);
            op.complete();
        };
        Operation forwardOp = op.clone().setCompletion(fc);
        ServiceHost host = context.getHost();
        forwardOp.setExpiration(Utils.fromNowMicrosUtc(host.getOperationTimeoutMicros() / 10L));
        forwardOp.setUri(NodeSelectorService.SelectOwnerResponse.buildUriToOwner(rsp, op));
        ForwardRequestFilter.prepareForwardRequest(forwardOp);
        host.sendRequest(forwardOp);
    }

    public static void prepareForwardRequest(Operation fwdOp) {
        fwdOp.toggleOption(Operation.OperationOption.FORWARDED, true);
        fwdOp.addPragmaDirective("xn-fwd");
        fwdOp.setConnectionTag("xn-cnx-tag-p2p-fwd");
        fwdOp.toggleOption(NodeSelectorService.FORWARDING_OPERATION_OPTION, true);
    }

    private void retryOrFailRequest(Operation op, Operation fo, Throwable fe, OperationProcessingChain.OperationProcessingContext context) {
        ServiceErrorResponse rsp;
        boolean shouldRetry = false;
        if (fo.hasBody() && (rsp = fo.clone().getBody(ServiceErrorResponse.class)) != null && rsp.details != null) {
            shouldRetry = rsp.details.contains((Object)ServiceErrorResponse.ErrorDetail.SHOULD_RETRY);
        }
        if (fo.getStatusCode() == 408) {
            shouldRetry = true;
        }
        if (op.hasPragmaDirective("xn-fwd")) {
            shouldRetry = false;
        }
        if (op.getExpirationMicrosUtc() < Utils.getSystemNowMicrosUtc()) {
            op.setBodyNoCloning(fo.getBodyRaw()).fail(new CancellationException("Expired at " + op.getExpirationMicrosUtc()));
            return;
        }
        if (!shouldRetry) {
            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, fe);
            Operation.failForwardedRequest(op, fo, fe);
            return;
        }
        context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, fe);
        context.getHost().getOperationTracker().trackOperationForRetry(Utils.getNowMicrosUtc(), fe, op);
    }
}

